/*	$NetBSD: rwlock_impl.h,v 1.1 2010/02/21 01:46:36 darran Exp $	*/

/*-
 * Copyright (c) 2010 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe and Andrew Doran.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _COMPAT_OPENSOLARIS_SYS_RWLOCK_IMPL_H
#define	_COMPAT_OPENSOLARIS_SYS_RWLOCK_IMPL_H

#define __RWLOCK_PRIVATE
#include <sys/rwlock.h>

#define _RW_READ_HELD(rw)	((((rw)->rw_owner & RW_WRITE_LOCKED) == 0) && \
				 (((rw)->rw_owner & RW_THREAD) != 0))
#define _RW_WRITE_HELD(rw)	\
		(((rw)->rw_owner & RW_THREAD) && \
		 ((rw)->rw_owner & RW_WRITE_LOCKED))
#define _RW_ISWRITER(rw)	\
		(((rw)->rw_owner & RW_WRITE_LOCKED) && \
		 (((rw)->rw_owner & RW_THREAD) == \
		 (uintptr_t)curlwp))

#endif
