.\"	Id: driver.man	
.\"	$NetBSD: driver.man,v 1.1.1.1 2016/02/09 20:29:12 plunky Exp $
.\"
.\" Copyright (c) 2007 Jeremy C. Reed <reed@reedmedia.net>
.\"
.\" Permission to use, copy, modify, and/or distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR AND CONTRIBUTORS DISCLAIM
.\" ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL AUTHOR AND
.\" CONTRIBUTORS BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
.\" DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
.\" PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
.\" ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
.\" THIS SOFTWARE.
.\"
.Dd September 12, 2014
.Dt PCC 1
.Os
.Sh NAME
.Nm pcc
.Nd front-end to the Portable C compiler
.Sh SYNOPSIS
.Nm
.Op Fl cEgkLMPStvX
.Op Fl B Ns Ar prefix
.Op Fl D Ar macro Ns Oo = Ns Ar value Oc
.Op Fl f Ns Ar feature
.Op Fl I Ar path
.Op Fl include Ar file
.Op Fl isystem Ar path
.Op Fl m Ns Ar option
.Op Fl nodefaultlibs
.Op Fl nostartfiles
.Op Fl nostdinc
.Op Fl nostdlib
.Op Fl O Ns Oo Ar level Oc
.Op Fl o Ar outfile
.Op Fl pg
.Op Fl pthread
.Op Fl shared
.Op Fl static
.Op Fl U Ar macro
.Op Fl Wa Ns , Ns Ar options
.Op Fl Wc Ns , Ns Ar options
.Op Fl Wl Ns , Ns Ar options
.Op Fl Wp Ns , Ns Ar options
.Op Fl x Ar language
.Op Ar
.Sh DESCRIPTION
The
.Nm
utility provides a front-end to the
.Dq Portable C compiler .
Multiple files may be given on the command line.
Unrecognized options are all sent directly to
.Xr ld 1 .
.Pp
.\" Brief description of its syntax:
Filenames that end with
.Sy \&.c
are passed via
.Xr cpp 1
\(->
.Xr ccom 1
\(->
.Xr as 1
\(->
.Xr ld 1 .
.Pp
Filenames that end with
.Sy \&.i
are passed via
.Xr ccom 1
\(->
.Xr as 1
\(->
.Xr ld 1 .
.Pp
Filenames that end with
.Sy \&.s
are passed via
.Xr as 1
\(->
.Xr ld 1 .
.Pp
Filenames that end with
.Sy \&.S
are passed via
.Xr cpp 1
\(->
.Xr as 1
\(->
.Xr ld 1 .
.Pp
Filenames that end with
.Sy \&.o
are passed directly to
.Xr ld 1 .
.Pp
.\"
The options are as follows:
.Bl -tag -width Ds
.It Fl B Ns Ar prefix
Define alternate prefix path for
.Xr cpp 1 ,
.Xr ccom 1 ,
.Xr as 1 ,
or
.Xr ld 1
executables.
.\" TODO: provide an example of -B
.It Fl C
Passed to the
.Xr cpp 1
preprocessor to not discard comments.
.It Fl c
Stop after generating object code with
.Xr as 1 .
Do not link.
The resulting object output is saved
as a filename with a
.Dq \&.o
suffix unless
.Fl o
option is used.
Note: cannot be combined with
.Fl o
if multiple files are given.
.It Fl D Ar macro Ns Oo = Ns Ar value Oc
Passed to the
.Xr cpp 1
preprocessor to define
.Ar macro
with an optional
.Ar value .
.It Fl E
Stop after preprocessing with
.Xr cpp 1 .
Do not compile, assemble, or link.
Output is sent to standard output unless the
.Fl o
option is used.
.It Fl ffreestanding
Assume a freestanding environment.
.It Fl fPIC
Generate PIC code.
.\" TODO: document about avoiding machine-specific maximum size?
.It Fl fpic
Tells C compiler to generate PIC code
and tells assembler that PIC code has been generated.
.\" TODO: document difference between PIC and pic
.\" other -f GCC compatibility flags are ignored for now
.It Fl g
Send
.Fl g
flag to
.Xr ccom 1
to create debug output.
Debug information output can be disabled with
.Fl g0 .
.It Fl I Ar path
Passed to the
.Xr cpp 1
preprocessor to add header search directory to override system defaults.
.It Fl include Ar file
Tells the
.Xr cpp 1
preprocessor to include the
.Ar file
during preprocessing.
.It Fl isystem Ar path
Defines
.Ar path
as a system header directory for the
.Xr cpp 1
preprocessor.
.It Fl k
Generate PIC code.
See
.Fl fpic
option.
.It Fl L
TODO
.It Fl M
Pass
.Fl M
flag to
.Xr cpp 1
to generate dependencies for
.Xr make 1 .
.It Fl m Ns Ar option
Target-dependent options.
Multiple
.Fl m
options can be given, the following are supported:
.Bl -tag -width PowerPC
.It ARM
\-mlittle-endian \-mbig-endian \-mfpe=fpa \-mfpe=vpf \-msoft-float \-march=armv1 \-march=armv2 \-march=armv2a \-march=armv3 \-march=armv4 \-march=armv4t \-march=armv4tej \-march=armv5 \-march=armv6 \-march=armv6t2 \-march=armv6kz \-march=armv6k \-march=armv7
.It HPPA
.It i386
.It MIPS
\-mlittle-endian \-mbig-endian \-mhard-float \-msoft-float
.It PDP-10
.It PowerPC
.It Sparc64
.It VAX
.El
.It Fl nodefaultlibs
Do not link with the system default libraries (libc, etc.)
.It Fl nostartfiles
Do not link with the system startup files (crt0.c, etc.)
.It Fl nostdinc
Do not use the system include paths (/usr/include, etc.)
.It Fl nostdlib
Do not link with the system default libraries or startup files.
.It Fl O Ns Oo Ar level Oc
Enable compiler optimizations.
Currently, for levels higher than zero,
this defines
.Dv __OPTIMIZE__
in the
.Xr cpp 1
preprocessor, and passes
.Fl xdce ,
.Fl xdeljumps ,
.Fl xtemps
and
.Fl xinline
to
.Xr ccom 1 .
If no level is given the optimization level is increased, or
optimizations can be disabled using
.Fl O0 .
.It Fl o Ar outfile
Save result to
.Ar outfile .
.It Fl P
TODO
.\" TODO: what is this?
.\" TODO: Looks like it does cpp only, but I couldn't get it to work for me.
.It Fl pg
Enable profiling on the generated executable.
.It Fl pthread
Defines the
.Dv _PTHREADS
preprocessor identifier for
.Xr cpp 1 , and
adds
.Fl lpthread
to the
.Xr ld 1
linker arguments.
.It Fl S
Stop after compilation by
.Xr ccom 1 .
Do not assemble and do not link.
The resulting assembler-language output is saved
as a filename with a
.Dq \&.s
suffix unless the
.Fl o
option is used.
Note: cannot be combined with
.Fl o
if multiple files are given.
.It Fl shared
Create a shared object of the result.
Tells the linker not to generate an executable.
.It Fl static
Do not use dynamic linkage.
By default, it will link using the dynamic linker options
and/or shared objects for the platform.
.It Fl t
Passed to
.Xr cpp 1
to suppress some default macro definitions and enable use
of traditional C preprocessor syntax.
.It Fl U Ar macro
Passes to the
.Xr cpp 1
preprocessor to remove the initial macro definition.
.It Fl v
Outputs the version of
.Nm
and shows what commands will be run with their command line arguments.
.It Fl Wa Ns , Ns Ar options
Comma separated list of options for the assembler.
.It Fl Wc Ns , Ns Ar options
Comma separated list of options for the compiler.
.It Fl Wl Ns , Ns Ar options
Comma separated list of options for the linker.
.It Fl Wp Ns , Ns Ar options
Comma separated list of options for the preprocessor.
.It Fl X
Don't remove temporary files on exit.
.It Fl x Ar language
GCC compatibility option; specify the language in use rather than
interpreting the filename extension.
Currently known language values are
.Sy c ,
.Sy c++ ,
.Sy assembler
and
.Sy assembler-with-cpp .
Any unknown
.Fl x
options are passed to
.Xr ccom 1 .
.El
.Ss Predefined Macros
A few
macros are predefined by
.Nm
when sent to
.Xr cpp 1 .
.Bl -diag
.It __PCC__
Set to the major version of the compiler.
.It __PCC_MINOR__
Set to the minor version.
.It __PCC_MINORMINOR__
Set to the minor-minor version \(em the number after the minor version.
.It _PTHREADS
Defined when
.Fl pthread
switch is used.
.El
.Pp
Also system- and/or machine-dependent macros may also be predefined;
for example:
.Dv __NetBSD__ ,
.Dv __ELF__ ,
and
.Dv __i386__ .
.Sh SEE ALSO
.Xr as 1 ,
.Xr ccom 1 ,
.Xr cpp 1 ,
.Xr ld 1
.Sh HISTORY
The
.Nm
command comes from the original Portable C Compiler by
.An "S. C. Johnson" ,
written in the late 70's.
.Pp
This product includes software developed or owned by Caldera
International, Inc.
