! An implementation of the stack datatype. By Fredrik Ramsberg, 15 Jan 2003.
! After each Stack.push() operation, Stack.failure or Stack.success will be
! returned. After each Stack.pop() operation, the value popped or
! Stack.failure will be returned. Stack.failure and Stack.success can both
! be changed by the application creating the Stack object. Also, you can
! choose to read Stack.status after each pop operation, in case there is
! no safe value to use for signaling a failure.
!
! Sample of how to set up a stack:
!
! Array stack1tab table 3; ! Last argument states max # of items on stack
!
! Stack stack1 "Stack 1"
!   with
!     stacktable stack1tab;

Class Stack
  private
    stacktable -1,
    top 0,
  with
    failure -2,
    success -1,
    status -1, 
    push [ element;
      self.status=self.success;
      if(self.top>=self.stacktable-->0)
        self.status=self.failure;
      else
        (self.stacktable)-->(++self.top)=element;
      return self.status;
    ],
    pop [;
      self.status=self.success;
      if(self.top<=0)
        self.status=self.failure;
      else
        return (self.stacktable)-->(self.top--);
      return self.status;
    ],
    size [;
      return self.stacktable-->0;
    ],
    element_count [;
      return self.top;
    ];
