#
# DO NOT MODIFY!!!!
# This file is automatically generated by rex 1.0.0
# from lexical definition file "bas2inf.rex".
#

require 'racc/parser'
# DecInf: DecBasic to Inform 6 compiler.
# Written January 2007 by Johan Berntsson (johan@microheaven.com)
#
# This code is in public domain, but it would be polite to credit my name
# in any derivate work.

class BasicParser < Racc::Parser
  require 'strscan'

  class ScanError < StandardError ; end

  attr_reader :lineno
  attr_reader :filename

  def scan_setup ; end

  def action &block
    yield
  end

  def scan_str( str )
    scan_evaluate  str
    do_parse
  end

  def load_file( filename )
    @filename = filename
    open(filename, "r") do |f|
      scan_evaluate  f.read
    end
  end

  def scan_file( filename )
    load_file  filename
    do_parse
  end

  def next_token
    @rex_tokens.shift
  end

  def scan_evaluate( str )
    scan_setup
    @rex_tokens = []
    @lineno  =  1
    ss = StringScanner.new(str)
    state = nil
    until ss.eos?
      text = ss.peek(1)
      @lineno  +=  1  if text == "\n"
      case state
      when nil
        case
        when (text = ss.scan(/\'/i))
           @rex_tokens.push action { state = :REM;	[:rem_in, text] } # '

        when (text = ss.scan(/REM/i))
           @rex_tokens.push action { state = :REM;	[:rem_in, text] }

        when (text = ss.scan(/\s+/i))
          ;

        when (text = ss.scan(/CRT/i))
           @rex_tokens.push action { [:crt_function, text ] }

        when (text = ss.scan(/CHR\$/i))
           @rex_tokens.push action { [:chr_function, text ] }

        when (text = ss.scan(/MID\$/i))
           @rex_tokens.push action { [:mid_function, text ] }

        when (text = ss.scan(/LEFT\$/i))
           @rex_tokens.push action { [:left_function, text ] }

        when (text = ss.scan(/RIGHT\$/i))
           @rex_tokens.push action { [:right_function, text ] }

        when (text = ss.scan(/SPACE\$/i))
           @rex_tokens.push action { [:space_function, text ] }

        when (text = ss.scan(/INT/i))
           @rex_tokens.push action { [:int_function, text ] }

        when (text = ss.scan(/VAL/i))
           @rex_tokens.push action { [:val_function, text ] }

        when (text = ss.scan(/RND/i))
           @rex_tokens.push action { [:rnd_function, text ]}

        when (text = ss.scan(/LEN/i))
           @rex_tokens.push action { [:len_function, text ]}

        when (text = ss.scan(/ASCII/i))
           @rex_tokens.push action { [:ascii_function, text ]}

        when (text = ss.scan(/INSTR/i))
           @rex_tokens.push action { [:instr_function, text ] }

        when (text = ss.scan(/TAB/i))
           @rex_tokens.push action { [:tab_function, text ]}

        when (text = ss.scan(/ABS/i))
           @rex_tokens.push action { [:abs_function, text ]}

        when (text = ss.scan(/DATE\$/i))
           @rex_tokens.push action { [:date_function, text ] }

        when (text = ss.scan(/TIME\$/i))
           @rex_tokens.push action { [:time_function, text ] }

        when (text = ss.scan(/STR\$/i))
           @rex_tokens.push action { [:str_function, text ] }

        when (text = ss.scan(/ECHO/i))
           @rex_tokens.push action { [:echo_function, text ] }

        when (text = ss.scan(/SLEEP/i))
           @rex_tokens.push action { [:sleep_function, text ] }

        when (text = ss.scan(/ERL/i))
           @rex_tokens.push action { [:erl_function, text ] }

        when (text = ss.scan(/PEEK/i))
           @rex_tokens.push action { [:peek_function, text ] }

        when (text = ss.scan(/POKE/i))
           @rex_tokens.push action { [:poke, text ] }

        when (text = ss.scan(/WAIT/i))
           @rex_tokens.push action { [:wait, text ] }

        when (text = ss.scan(/SYS/i))
           @rex_tokens.push action { [:sys, text ] }

        when (text = ss.scan(/GET/i))
           @rex_tokens.push action { [:get, text ] }

        when (text = ss.scan(/TI/i))
           @rex_tokens.push action { [:ti_function, text ] }

        when (text = ss.scan(/RUN/i))
           @rex_tokens.push action { [:run, text ] }

        when (text = ss.scan(/ASC/i))
           @rex_tokens.push action { [:ascii_function, text ]}

        when (text = ss.scan(/INFORMSAVEGAME/i))
           @rex_tokens.push action { [:inform_save_game, text] }

        when (text = ss.scan(/INFORMRESTOREGAME/i))
           @rex_tokens.push action { [:inform_restore_game, text] }

        when (text = ss.scan(/INFORMSAVEUNDO/i))
           @rex_tokens.push action { [:inform_save_undo, text] }

        when (text = ss.scan(/INFORMRESTOREUNDO/i))
           @rex_tokens.push action { [:inform_restore_undo, text] }

        when (text = ss.scan(/SET/i))
           @rex_tokens.push action { [:set, text] }

        when (text = ss.scan(/LOF/i))
           @rex_tokens.push action { [:lof, text ] }

        when (text = ss.scan(/DEF/i))
           @rex_tokens.push action { [:def, text] }

        when (text = ss.scan(/FNEND/i))
           @rex_tokens.push action { [:fnend, text] }

        when (text = ss.scan(/NOT/i))
           @rex_tokens.push action { [:not, text] }

        when (text = ss.scan(/DIM/i))
           @rex_tokens.push action { [:dim, text] }

        when (text = ss.scan(/FOR/i))
           @rex_tokens.push action { [:for, text] }

        when (text = ss.scan(/TO/i))
           @rex_tokens.push action { [:to, text] }

        when (text = ss.scan(/STEP/i))
           @rex_tokens.push action { [:step, text] }

        when (text = ss.scan(/NEXT/i))
           @rex_tokens.push action { [:next, text] }

        when (text = ss.scan(/IF/i))
           @rex_tokens.push action { [:if, text] }

        when (text = ss.scan(/THEN/i))
           @rex_tokens.push action { [:then, text] }

        when (text = ss.scan(/ELSE/i))
           @rex_tokens.push action { [:else, text] }

        when (text = ss.scan(/INPUT/i))
           @rex_tokens.push action { [:input, text] }

        when (text = ss.scan(/PRINT/i))
           @rex_tokens.push action { [:print, text] }

        when (text = ss.scan(/ON/i))
           @rex_tokens.push action { [:on, text ]}

        when (text = ss.scan(/GOTO/i))
           @rex_tokens.push action { [:goto, text] }

        when (text = ss.scan(/GOSUB/i))
           @rex_tokens.push action { [:gosub, text] }

        when (text = ss.scan(/RETURN/i))
           @rex_tokens.push action { [:return, text] }

        when (text = ss.scan(/END/i))
           @rex_tokens.push action { [:end_token, text] }

        when (text = ss.scan(/AND/i))
           @rex_tokens.push action { [:and, text] }

        when (text = ss.scan(/OR/i))
           @rex_tokens.push action { [:or, text] }

        when (text = ss.scan(/CLOSE/i))
           @rex_tokens.push action { [:close, text] }

        when (text = ss.scan(/LINE/i))
           @rex_tokens.push action { [:line, text] }

        when (text = ss.scan(/OPEN/i))
           @rex_tokens.push action { [:open, text] }

        when (text = ss.scan(/INPUT/i))
           @rex_tokens.push action { [:input, text] }

        when (text = ss.scan(/OUTPUT/i))
           @rex_tokens.push action { [:output, text] }

        when (text = ss.scan(/AS/i))
           @rex_tokens.push action { [:as, text] }

        when (text = ss.scan(/FILE/i))
           @rex_tokens.push action { [:file, text ]}

        when (text = ss.scan(/RESUME/i))
           @rex_tokens.push action { [:resume, text] }

        when (text = ss.scan(/ERROR/i))
           @rex_tokens.push action { [:error, text] }

        when (text = ss.scan(/MARGIN/i))
           @rex_tokens.push action { [:margin, text] }

        when (text = ss.scan(/QUOTE/i))
           @rex_tokens.push action { [:quote, text] }

        when (text = ss.scan(/STOP/i))
           @rex_tokens.push action { [:stop, text] }

        when (text = ss.scan(/READ/i))
           @rex_tokens.push action { [:read, text] }

        when (text = ss.scan(/WRITE/i))
           @rex_tokens.push action { [:write, text] }

        when (text = ss.scan(/DATA/i))
           @rex_tokens.push action { [:data, text] }

        when (text = ss.scan(/CHANGE/i))
           @rex_tokens.push action { [:change, text] }

        when (text = ss.scan(/ERR/i))
           @rex_tokens.push action { [:err_function, text ] }

        when (text = ss.scan(/<>/i))
           @rex_tokens.push action { [:NEQ, text ] }

        when (text = ss.scan(/>=/i))
           @rex_tokens.push action { [:GE, text ] }

        when (text = ss.scan(/<=/i))
           @rex_tokens.push action { [:LE, text ] }

        when (text = ss.scan(/[\\]/i))
           @rex_tokens.push action { [:separator, text ] }

        when (text = ss.scan(/:/i))
           @rex_tokens.push action { [:separator, text ] } # C64 Basic

        when (text = ss.scan(/\"[^"]*\"/i))
           @rex_tokens.push action { [:string, text] }

        when (text = ss.scan(/\d*\.\d*/i))
           @rex_tokens.push action { [:float, text.to_f] }

        when (text = ss.scan(/\d+%?/i))
           @rex_tokens.push action { [:int, text.to_i] }

        when (text = ss.scan(/FN[A-Z,0-9]\$/i))
           @rex_tokens.push action { [:sfnc_id, text] } # user defined function

        when (text = ss.scan(/[A-Z]\w*\d*\$/i))
           @rex_tokens.push action { [:svar_id, text] }

        when (text = ss.scan(/[A-Z]\w*\d*%?/i))
           @rex_tokens.push action { [:ivar_id, text] }

        when (text = ss.scan(/./i))
           @rex_tokens.push action { [text, text] }

        else
          text = ss.string[ss.pos .. -1]
          raise  ScanError, "can not match: '" + text + "'"
        end  # if

      when :REM
        case
        when (text = ss.scan(/\n/i))
           @rex_tokens.push action { state = nil;	[:rem_out, text] }

        when (text = ss.scan(/.*(?=$)/i))
           @rex_tokens.push action {                	[:remark, text] }

        else
          text = ss.string[ss.pos .. -1]
          raise  ScanError, "can not match: '" + text + "'"
        end  # if

      else
        raise  ScanError, "undefined state: '" + state.to_s + "'"
      end  # case state
    end  # until ss
  end  # def scan_evaluate

end # class

if __FILE__ == $0
  exit  if ARGV.size != 1
  filename = ARGV.shift
  rex = BasicParser.new
  begin
    rex.load_file  filename
    while  token = rex.next_token
      p token
    end
  rescue
    $stderr.printf  "%s:%d:%s\n", rex.filename, rex.lineno, $!.message
  end
end
