/*
** Arr_note.t contains the author's note which players may view at the
** end of the game.
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

authors_note: object
    give = {
        local headerOn, headerOff;

        if (global.isHTMLRuntime) {
            headerOn = '<center><h3>';
            headerOff = '</h3></center>';
        }
        else {
            headerOn = '\b\(';
            headerOff = '\)\b';
        }
"<<headerOn>>The Setup<<headerOff>>";

"The number one question people tend to ask is, <q>Where do you get your
ideas?</q> (Okay, they don&rsquo;t actually ask <i>me</i> that question,
but other writers/designers tell me it&rsquo;s a popular one.) You&rsquo;d
probably be better off asking Andrew, Adam C., or Christopher Huang that
question, because the idea for <b>Arrival</b> came from a pretty mundane
source: I can&rsquo;t draw.

\bSee, when I found out about HTML TADS, I thought, <q>This is really neat.
Boy, would I ever love to make a graphical game.</q> I put a blank sheet of
paper on my desk, titled it <q>My First HTML TADS Game,</q> and stared at
it.

\bI ended up staring at it on and off for about a week. Other than the
title, the page stayed blank. I didn&rsquo;t want to start planning a game
until I had decided what kind of graphics I was going to use since, if I
were going to make a game with graphics, I&rsquo;d have to come up with
said graphics. Somehow.

\bFor a while I thought of making black-and-white stick figures. Hey, I can
draw stick-figures like nobody&rsquo;s business. Unfortunately, no
stick-figure story suggested itself. At the end of the week, I had come to
the conclusion that I was permanently stymied by my inability to draw any
better than an eight-year-old.

\bIn hindsight, it seems glaringly obvious:\ make my protagonist match my
drawing skills. If only I had paid $70 for that time machine, I could have
saved myself a week&rsquo;s worth of brainstorming.

\bWhat kind of story would involve an eight-year-old?
I have a vivid recollection of me at age eight, daydreaming about what
would happen if aliens ever crashed in my backyard. In half of the
daydreams, the aliens were good and kind and, out of gratitude for the
help I gave them, anointed me President of the Universe. (The fact that
the office of President of the Universe was probably an elected one never
crossed my mind.) In the other half, I saved the world from the horrible
alien menace.

\bThis seemed like as good an idea as any, and better than some. I decided
that saving the world from aliens was much more fun than just helping them
out. To top it off, I decided to give myself some extra wiggle room by
deliberately setting out to make a B-grade sci fi game. Bad pictures?
Goofy special effects? It&rsquo;s...deliberate. Yeah, that&rsquo;s it.
Besides, I hadn&rsquo;t written a just-for-fun game in a while, and this
seemed like a good chance to create one.

\bI was most likely influenced by a strange mix of Mystery Science Theatre
3000, Calvin and Hobbes, and any film directed by Roger Corman. The only
event in <b>Arrival</b> taken more-or-less directly from my childhood was
the comment about knocking the mortar off of bricks. Ever done it? I
spent a summer doing just that for my dad in order to save up enough money
to buy one of those inflatable rafts. Despite saying <q>never again,</q> I
found myself <i>again</i> knocking mortar off of bricks this summer, only
for my own apartment instead of for my parents&rsquo; house.";

"<<headerOn>>Beginning Implementation<<headerOff>>";

"On the first day, I made my best and worst design decisions back-to-back.
The good decision:\ I decided to implement <b>Arrival</b> as a straight
text adventure before adding whiz-bang graphics. I didn&rsquo;t plan any
of the graphics or sounds when I started. As I went along, I noted down
objects, scenes, and events which I thought should be illustrated and then
got back to the writing and programming.

\bThe bad decision:\ I did very little initial planning and design. Hey,
it&rsquo;s a short demo, right? I&rsquo;m going to do this in two months
and release it long before the competition. I mean, I just want to slap
something together. Who needs serious planning for something like this?

\bDumb, dumb, dumb. Skipping the initial design steps didn&rsquo;t
permanently cripple <b>Arrival</b>, but it made my task much harder and
resulted in a game which wasn&rsquo;t quite what it could have been. You
can skimp on the design for a game this size and get by, but it&rsquo;s
more work overall. All I did before coding was make a rough layout of the
spaceship and plan the ending puzzle. Everything else was done
off-the-cuff.

\bThe only item of interest in the inital coding (to me, at least) was my
decision to break the fourth wall in order to keep the player from going
south in the living room. I didn&rsquo;t want the house just to consist of
a hallway, a kitchen, and a living room, but I also didn&rsquo;t want the
player wandering around the house&mdash;the action is supposed to center
on the aliens and the backyard. Since I was already going for over-the-top
silliness, why not throw in an occasional sarcastic narrator who
doesn&rsquo;t mind breaking the fourth wall?";

"<<headerOn>>NPC Interaction<<headerOff>>";

"I&rsquo;ve never felt comfortable with NPC design. Do I make them respond
to items and objects? Should I use a branching tree conversational system?
Should I keep the player from talking to them at all? This ambivalence
tends to manifest itself in strange ways in my games&mdash;people with no
mouths, people who are pets, people who are only a head, etc.

\bMy approach in <b>Arrival</b> was a bit uneven. Initially you only
interacted with Zigurt and Floban twice:\ once at the beginning, and then
again when you brought them the things they wanted. Mom and dad sat in the
living room doing nothing. It wasn&rsquo;t until one of my beta-testers
pointed it out that I realized that <b>Arrival</b> was lifeless.

\bSo I slapped on some more NPC interaction. Mom and dad became more
active once I introduced the <q>getting them out of the room</q>
puzzle&mdash;more on that in a moment. I added two key bits to Zigurt and
Floban. One, I let you watch them get the cap back off the tylenol bottle.
Originally they vanished into the aether, then returned with an open pill
bottle. Two, I gave them responses to every item in the ship&rsquo;s
hold.";

"<<headerOn>>Puzzles<<headerOff>>";

"Some of the <b>Arrival</b> puzzles I like. Some of them I don&rsquo;t.
Filling the gas tank with water is just this side of unreasonable. I
wanted the player to have to make a lateral shift&mdash;the aliens are
described as disliking water; they want rock salt to dehydrate; and, gee,
look at this, I have a garden hose and access to the fuel tank.
Unfortunately, most people just tried to wet the aliens down with the
hose.

\bClosing the pill bottle to get the translation book is, while not
well-motivated, the puzzle I am most satisfied with. There is no time
limit. You can experiment. You cannot get into an unwinnable state while
fiddling with it. The timing elements aren&rsquo;t too difficult and do not
require the use of restore or undo. Unfortunately, that puzzle is
completely unnecessary.

\bThe <q>get your parents out of the living room</q> puzzle is evil. It
was added in long after the rest of the game was nominally finished, and
it shows. In the initial version I released for the competition, mom
sent you directly to your room if you hung around the kitchen, and you
could only ask dad once about the lights. This made the puzzle appear to
be hard to time correctly. Although I haven&rsquo;t changed dad&rsquo;s
behavior, mom doesn&rsquo;t send you directly to your room until
she&rsquo;s done cleaning up the broken dishes, and she takes longer to
finish that chore. This change doesn&rsquo;t make the puzzle a good one,
but it does make it a passable one.";

"<<headerOn>>HTML Stuff<<headerOff>>";

"I don&rsquo;t do a lot of fancy HTML formatting in <b>Arrival</b>. The
two big flashy HTML things I did were the compass rose and the web page.
For the web page I looked around, found some pages which I thought were
goofy, and stole elements from several of them. The compass rose I did
using a table and a lot of trial and error. If you&rsquo;re interested
in how I implemented the compass rose, get ahold of the source code at
ftp://ftp.gmd.de/if-archive and look at compass.t.

\bI learned HTML by looking at people&rsquo;s web pages, so I can&rsquo;t
really recommend any books. If you&rsquo;re writing an HTML TADS game,
don&rsquo;t sweat it too much. Know how to use image tags and some of the
basic text mark-up tags and you should be set. HTML TADS games
aren&rsquo;t web pages, so don&rsquo;t go too crazy.";

"<<headerOn>>Organic Growth<<headerOff>>";

"A lot of <b>Arrival</b> grew like The Blob on speed. Since I didn&rsquo;t
do much initial design, I had to apply a lot of spackle and grout later.
Some of the cracks showed more than others. See which of the following you
caught:

\bThe obsession with cleaning items slowly grew over the course of writing
the game. First I had the player clean dishes. Then I needed a way to keep
the player from wanting to open the Weber grill. Then it blossomed from
there, until it seemed like all Kid thought about was cleaning stuff.

\bOriginally the exam room was just for fun. When I decided to let you see
how Zigurt and Floban opened the tylenol bottle, I decided that
they&rsquo;d most logically (!) use the exam room tools.

\bAt first, the aliens just asked for rock salt. Then I thought it&rsquo;d
be funny if one of the aliens (Floban, as it turned out) had a predilection
for processed snack cakes. Finally, I added the Precious Moments doll. The
knick-knacks had always been in the living room, and the aliens&rsquo;
hold had always been stuffed with kitsch, so it made sense that
they&rsquo;d want more. <q>Beauty is in the eye of the alien</q> and all
that.

\bWhile the map of the ship was planned from the beginning, the compass
rose in the status bar was added two days before the competition. I&rsquo;m
not sure I&rsquo;m pleased with it, and I&rsquo;d be interested in knowing
how many people made it go away ten seconds after they started playing.

\bAs mentioned, the <q>get your parents out of the living room</q> puzzle
was a latecomer to the party.";

"<<headerOn>>Random Thoughts<<headerOff>>";

"Zigurt and Floban look like they do because of the particular difficulty
of working with generic Play-Doh. I wanted the aliens to be strongly
associated with color. When deciding what they would look like, I asked
myself, <q>What shapes can I reasonably make with generic Play-Doh that
tends to dry out quickly?</q> The ball was my obvious first choice. Floban
almost looked like a giant snake (<q>Hey, these are easy!</q>), until I
decided that a snake with tentacles was way too Freudian for such a
light-hearted game.

\bThe graphics turned out better than I could have ever imagined. My
favorite is the picture of Zigurt and Floban shooting out the backyard
light. Every time I see Zigurt hefting that Han Solo blaster, I get the
giggles.

\bI&rsquo;m also extremely pleased with the opening conversation
involving Kid, Zigurt, and Floban. I rewrote that scene over and over,
occasionally pacing about the apartment and muttering bits of dialog to
myself.

\bI wanted the player to have a semi-specific personality, but not lock the
player into a specific gender. I toyed with giving the player an ambiguous
name, but finally decided that calling the player Kid all the time was a
reasonable solution and fit with the mood of the game.

\bHaving someone run around with two pie plates dangling from a string
while you take pictures is a lot of fun.

\bThe biggest disappointment of the game for me was mom and dad. They had
such promise, but I didn&rsquo;t do much with them. Bad author. Bad! Bad!

\bThe fact that I have now placed fourth in two competitions has not been
lost on me. What this fact signifies is open to interpretation.

\bOne of my beta-testers suggested that I discourage people from playing
<b>Arrival</b> unless they could see the pictures. I was tempted, but my
overweening need for everyone to play my game won out. This turned out
to be a good thing, as I have heard from several blind players who
enjoyed the game immensely.

\bSomething I had not expected was how Zigurt and Floban would become real
to me. At first they were fairly generic B-movie aliens. Then they started
developing separate personalities, until each of them had a distinctive
manner to them. Zigurt was the more stable, mature one, while Floban was
more flighty and easily upset. Floban was, of course, the Mission
Commander&mdash;alien bureaucracies are no more competent than human ones.

\bThat&rsquo;s it, really. For the most part, I was very happy with how
<b>Arrival</b> turned out.";
    }
;

