\ dwarf.f for advtr.f  Leo Wong 11 June 02003 fyj +
\ When we encounter the first dwarf, we kill 0, 1, or 2 of the 5
\ dwarfs.  If any of the survivors is at loc, replace him with the
\ alternate

\ IF saved <> -1, the adventurer bypassed the "start" call

: d6001  \ 6001
   db? IF ." d6001 " THEN
   saved -1 = 
   IF 3 1 DO  50 pct? IF 0 1 5 ran + dloc ! THEN LOOP THEN ;

: d6002  \ 6002
   db? IF ." d6002 " THEN
   6 1 DO I dloc @ loc = IF daltlc I dloc ! THEN
          I dloc @ I odloc ! LOOP
   3 rspeak axe loc drop-object ;

: d6012  ( I -- )  \ 6012 6014
   db? IF ." d6012 " THEN
   >R
   BEGIN
      k travel @ ABS 1000 / 1000 MOD TO newloc
      newloc 300 >  newloc 15 < OR  newloc R@ odloc @ = OR 
      jj 1 >  newloc jj 1- 1 MAX tk @ = AND OR  jj 20 < not OR  
      newloc R@ dloc @ = OR  newloc forced? OR
      R@ 6 =  newloc 3 bitset? AND OR
      k travel @ ABS 1000000 / 100 = OR not 
      IF newloc jj tk !  jj 1+ TO jj THEN
      k 1+ to k  \ 6014
      k 1- travel @ 0< UNTIL
      R> DROP ;

: d6016  ( I -- )  \ 6016
   db? IF ." d6016 " THEN
   >R
   R@ odloc @ jj tk !
   jj 1 > IF jj 1- TO jj THEN
   1 jj ran + TO jj
   R@ dloc @ R@ odloc !
   jj tk @ R> dloc ! ;

: d6024  \ 6024 ( goes to 6030 )
   db? IF ." d6024 " THEN
   chloc 6 dloc !  chloc 6 odloc !  FALSE 6 dseen ! ;

\ pirate takes treasures 6022-23
\ Don't steal chest back from troll
: pirate-takes-treasures  \ 6022
   db? IF ." pirate-takes-treasures " THEN
   128 rspeak
   \ Don't steal chest back from troll!
   messag place @ 0= IF chest chloc move-object THEN
   messag chloc2 move-object
   maxtrs 1+ 50  \ 6023
   DO I pyram = loc pyram plac @ = loc emerald plac @ = OR AND not
      IF  I at? I fixed @ 0= AND IF I loc carry-object THEN
          I toting? IF I chloc drop-object THEN
      THEN
   LOOP  d6024 ;

: spot-pirate \ 6025
   db? IF ." spot-pirate " THEN
   186 rspeak
   chest chloc move-object
   messag chloc2 move-object
   d6024 ;

: ?hear-pirate
   db? IF ." hear-pirate " THEN
   6 odloc @ 6 dloc @ <> 20 pct? AND IF 127 rspeak THEN ;

: dwarf-here ( I -- )  \ 6027
   db? IF ." dwarf-here " THEN
   \ Threatening little dwarf is in the room!
   dtotal 1+ TO dtotal
   DUP odloc @ SWAP dloc @ =
   IF attack 1+ TO attack
      knfloc 0< not IF loc TO knfloc THEN
      1000 ran 95 dflag 2 - * < IF stick 1+ TO stick THEN
   THEN ;

: pirate-stuff
   db? IF ." pirate-stuff " THEN
   \ The pirate's spotted the adventurer.  He leaves him
   \ alone once he's found chest.  k counts if a treasure
   \ is here.  If not, and tally=tally2 plus one for an
   \ unseen chest, let the pirate be spotted
   loc chloc <> chest prop @ 0< AND
   IF 0 TO k
      maxtrs 1+ 50
      DO 
      \ Pirate won't take pyramid from plover room or dark room
      \ (too easy!).
      I pyram =  loc pyram plac @ = loc emerald plac @ = OR AND not
      IF I toting?
         IF pirate-takes-treasures UNLOOP EXIT THEN THEN
      jj here? IF 1 TO k THEN
   LOOP
   tally tally2 1+ =  k 0= AND chest place @ 0= AND  lamp here? AND
   lamp prop @ 1 = AND
   db?
   IF ." tally=" tally . ." tally2+1=" tally2 1+ .
      ." k=" k .  ." chest place=" chest place @ .
      ." lamp here="  lamp here? .
      ." lamp prop=" lamp prop @ . THEN
   IF spot-pirate ELSE ?hear-pirate THEN 
 THEN ;

\ Things are in full swing.  Move each dwarf at random, except if he's
\ seen us he sticks with us.  Dwarfs never go to locs < 15.  If
\ wandering at random, they don't back up unless there's no
\ alternative.  If they don't have to move, they attack.  And, of
\ course, dead dwarfs don't do much of anything.
: d6010  \ 6010
   db? IF ." d6010 " THEN
   0 TO dtotal  0 TO attack  0 TO stick
   7 1
   DO I dloc @  db? IF  dup . THEN
      IF 1 TO jj
         I dloc @ TO k
         k key @ TO k
         k IF I d6012 THEN
         I d6016
         I dseen @  loc 14 > AND I dloc @ loc = OR  I odloc @ loc = OR
            I dseen !
         I dseen @
         IF loc I dloc ! I 6 <> IF I dwarf-here ELSE pirate-stuff THEN
      THEN
   THEN
   LOOP

   \ Now we know what's happening.  Let't tell it.
  dtotal 0= IF ( describe-loc ) EXIT THEN
  dtotal 1 =
  IF 4 rspeak
  ELSE CR ." There are " dtotal . ." threatening dwarfs in "
                 ." the room with you.  " THEN \ 67
  attack
  IF dflag 2 = IF 3 TO dflag THEN
     \ If saved<>-1, bypassed the "start" call. Dwarfs *very* mad!
     saved -1 <> IF 20 TO dflag THEN
     attack 1 =
     IF 5 rspeak  52 TO k
     ELSE attack . ." of them throw knives at you! "  6 TO k  THEN
     stick DUP 1 >
     IF . ." of them get you!"
     ELSE DUP k + rspeak 0= IF EXIT THEN THEN
     loc TO oldloc2  dead THEN ;

:NONAME \ 6000
    db? IF ." d6000 " THEN
  dflag 1 =
  IF loc 15 < 95 pct? OR not IF 2 TO dflag d6001 d6002 THEN
  ELSE d6010 THEN ; IS dwarf-stuff
