/*
 * substitute for BSD/SVR3 rename() system call, from
 * Janet Walz, walz@mimsy.umd.edu & Rich Salz, rsalz@pineapple.bbn.com
 */

int rename(oldname,newname)
char *oldname,*newname;
{
	(void)unlink(newname);
	if(link(oldname,newname))
		return(-1);
	return(unlink(oldname));
}
END_OF_FILE
if test 281 -ne `wc -c <'src/rename.c'`; then
    echo shar: \"'src/rename.c'\" unpacked with wrong size!
fi
# end of 'src/rename.c'
fi
if test -f 'src/stab.c' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'src/stab.c'\"
else
echo shar: Extracting \"'src/stab.c'\" \(2239 characters\)
sed "s/^X//" >'src/stab.c' <<'END_OF_FILE'
/*
**  Sendmail
**  Copyright (c) 1983  Eric P. Allman
**  Berkeley, California
**
**  Copyright (c) 1983 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
*/

#ifndef lint
static char	SccsId[] = "@(#)stab.c	5.2 (Berkeley) 6/7/85";
#endif not lint

# include "sendmail.h"

/*
**  STAB -- manage the symbol table
**
**	Parameters:
**		name -- the name to be looked up or inserted.
**		type -- the type of symbol.
**		op -- what to do:
**			ST_ENTER -- enter the name if not
**				already present.
**			ST_FIND -- find it only.
**
**	Returns:
**		pointer to a STAB entry for this name.
**		NULL if not found and not entered.
**
**	Side Effects:
**		can update the symbol table.
*/

# define STABSIZE	400

/* SymTab should be not be static on USG systems */
#ifndef USG
static 
#endif
STAB	*SymTab[STABSIZE];

STAB *
stab(name, type, op)
	char *name;
	int type;
	int op;
{
	register STAB *s;
	register STAB **ps;
	extern bool sameword();
	register int hfunc;
	register char *p;
	extern char lower();

# ifdef DEBUG
	if (tTd(36, 5))
		printf("STAB: %s %d ", name, type);
# endif DEBUG

	/*
	**  Compute the hashing function
	**
	**	We could probably do better....
	*/

	hfunc = type;
	for (p = name; *p != '\0'; p++)
		hfunc = (((hfunc << 7) | lower(*p)) & 077777) % STABSIZE;

# ifdef DEBUG
	if (tTd(36, 9))
		printf("(hfunc=%d) ", hfunc);
# endif DEBUG

	ps = &SymTab[hfunc];
	while ((s = *ps) != NULL && (!sameword(name, s->s_name) || s->s_type != type))
		ps = &s->s_next;

	/*
	**  Dispose of the entry.
	*/

	if (s != NULL || op == ST_FIND)
	{
# ifdef DEBUG
		if (tTd(36, 5))
		{
			if (s == NULL)
				printf("not found\n");
			else
			{
				long *lp = (long *) s->s_class;

				printf("type %d val %lx %lx %lx %lx\n",
					s->s_type, lp[0], lp[1], lp[2], lp[3]);
			}
		}
# endif DEBUG
		return (s);
	}

	/*
	**  Make a new entry and link it in.
	*/

# ifdef DEBUG
	if (tTd(36, 5))
		printf("entered\n");
# endif DEBUG

	/* make new entry */
	s = (STAB *) xalloc(sizeof *s);
	bzero((char *) s, sizeof *s);
	s->s_name = newstr(name);
	makelower(s->s_name);
	s->s_type = type;

	/* link it in */
	*ps = s;

	return (s);
}
