/* menu - print initial menu		Author:  Too many to enumerate */

/* Menu prints the initial menu and waits for directions.  To compile, link
 * menu.o with menu1.o instead of the usual crtso.o - see the makefile.
 */

#include <sys/types.h>
#include <minix/boot.h>

#if __STDC__
#define PROTO(func, args) func args
#else
#define PROTO(func, args) func ()
#endif

/* Although the code looks like it uses stdio, it does not. */
#define getchar getk
#define printf  printk
#define putchar putk

extern PROTO (int bios_getk, (void) );
extern PROTO (void bios_putk, (int) );
extern PROTO (void printf, (const char *fmt, ...) );
extern PROTO (int HD_read, (int drive, char *buf, long offset) );
extern PROTO (int dmaoverrun, (char *buf) );
extern PROTO (int p_memsize, (void) );
extern PROTO (void hdparam, (int drive) );

PROTO (int getk, (void) );
PROTO (void putk, (int ch) );
PROTO (int main, (int argc, char *argv[]) );
PROTO (void setparam, (int drive, int partition) );

static PROTO (int get_device, (char **pname, char *description,
			       int ram_allowed) );
static PROTO (void getnewline, (void) );
static PROTO (int get_ramsize, (void) );
static PROTO (int get_size, (void) );
static PROTO (int sort, (long *val, long org) );
static PROTO (void swap, (long *first, long *second) );

struct bparam_s boot_parameters =
	{DROOTDEV, DRAMIMAGEDEV, DRAMSIZE, DSCANCODE, DPROCESSOR};

char *ramimname = "/dev/fd0";
char *rootname = "/dev/ram";
char *diskbuf, buf1[1024], buf2[1024];
int ext_memsize, errors, auto_flag;
long part_offset;

static char *devname[] = {
			  "/dev/fd0",
			  "/dev/fd1",
			  "/dev/hd1",
			  "/dev/hd2",
			  "/dev/hd3",
			  "/dev/hd4",
			  "",
			  "/dev/hd6",
			  "/dev/hd7",
			  "/dev/hd8",
			  "/dev/hd9",
};


int getk()
{
/* Get an ASCII character from the keyboard. */

  return(bios_getk() & 0xFF);
}

/* Print the given character as required for printk.  Linefeeds have to be
 * expanded since the BIOS doesn't do it.  The null character says to flush
 * the buffer, but there is no buffer so it does nothing.
 */
void putk(ch)
int ch;
{
  if (ch == '\n') bios_putk('\r');
  if (ch != '\0') bios_putk(ch);
}

int main(argc, argv)
int argc;
char **argv;
{
  int command;
  int key;

  auto_flag = 0;
  printf("\n\n\n\n");
  for (;;) {
	printf("\nHit key as follows:\n\n");
	printf("    =  start MINIX, standard keyboard\n");
	printf("    u  start MINIX, U.S. extended keyboard\n");
	printf("    d  start MINIX, Dutch keyboard for PS/2\n\n");
	printf("    r  select root device (now %s)\n", rootname);
	if (boot_parameters.bp_rootdev == DEV_RAM)
	printf("    i  select RAM image device (now %s)\n", ramimname);
	printf("    s  set RAM disk size");
		if (boot_parameters.bp_rootdev == DEV_RAM) {
		    printf(" (real size is from RAM image)\n");
		} else {
		    if (boot_parameters.bp_ramsize != 0)
			printf(" (now %uK)\n", boot_parameters.bp_ramsize);
		    else
			printf(".\n");
		}
	printf("    p  toggle protected mode enable (now %sabled)\n",
	       boot_parameters.bp_processor >= 286 ? "en" : "dis" );
#ifdef _DBCS
	printf("    o  Optional menu.\n");
#endif
	printf("\n\n# ");
	key = bios_getk();	/* not getchar; we may want the scan code */
	command = key & 0xFF;
	printf("%c\n", command);

	switch (command) {

	    case '=':
	    case 'u':
	    case 'd':
		return(boot_parameters.bp_scancode = (key >> 8) & 0xFF);

	    case 'p':
		boot_parameters.bp_processor =
			boot_parameters.bp_processor >= 286 ? 88 : 286;
		printf("\n\n");
		continue;

	    case 'r':
		boot_parameters.bp_rootdev =
			get_device(&rootname, "root", 1);
		printf("\n\n");
		continue;

	    case 's':
		boot_parameters.bp_ramsize = get_ramsize();
		printf("\n\n");
		continue;
#ifdef _DBCS
	    case 'o':
		optional_menu();
		continue;
#endif
	    case 'i':
		if (boot_parameters.bp_rootdev == DEV_RAM) {
			boot_parameters.bp_ramimagedev =
				get_device(&ramimname, "ram image", 0);
			printf("\n\n");
			continue;
		} /* else ... 
			through down */
	    default:
		printf("Illegal command\n");
		continue;
	}
  }

}

static int get_device(pname, description, ram_allowed)
char **pname;
char *description;
int ram_allowed;
{
  int chr;

  printf("\nPlease enter (abbreviated) name of %s device.\n", description);
  printf("Floppy f0, f1, hard h1 to h4, h6 to h9");
  if (ram_allowed) printf(", RAM r");
  printf(".\nThen hit RETURN: ");
  while (1) {
	switch (chr = getchar()) {
	    case 'f':
		putchar(chr);
		while ((chr = getchar()) < '0' || chr > '1');
		putchar(chr);
		getnewline();
		*pname = devname[chr - '0'];
		return DEV_FD0 + chr - '0';
	    case 'h':
		putchar(chr);
		while (((chr = getchar()) < '1' || chr > '4') &&
		       (chr < '6' || chr > '9'));
		putchar(chr);
		getnewline();
		*pname = devname[chr + 1 - '0'];
		return DEV_HD0 + chr - '0';
	    case 'r':
		if (ram_allowed) {
			putchar(chr);
			getnewline();
			*pname = "/dev/ram";
			return DEV_RAM;
		}
	}
  }
}

static void getnewline()
{
  while (getchar() != '\r');
  putchar('\n');
}

static int get_ramsize()
{
  printf("\nPlease enter size of RAM disk. Then hit RETURN: ");
  return get_size();
}

static int get_size()
{
  int chr;
  long size;

  while ((chr = getchar()) < '0' || chr > '9');
  size = chr - '0';
  putchar(chr);
  while ((chr = getchar()) != '\r') {
	if (chr >= '0' && chr <= '9' && 10 * size + (chr - '0') < 0x10000) {
		putchar(chr);
		size = 10 * size + (chr - '0');
	}
  }
  putchar('\n');
  return size;
}

void setparam(drive, partition)
int drive, partition;
{
    int i, k;
    long save, val[4];

    auto_flag = 0;
    diskbuf = buf1;
    if (dmaoverrun(diskbuf)) diskbuf = buf2;
    ext_memsize = p_memsize();

    if (drive & 0x80) {
	hdparam(drive);
	HD_read(drive, diskbuf, 0L);
	for(i = 0, k = 0x1C6; i < 4; k += 16, i++) {
	    val[i] = *(long *)&diskbuf[k];
#ifdef DEBUG
		printf("Partition %d: %D\n", i, val[i]);
#endif
	}
	--partition;
	part_offset = *(long *)&diskbuf[0x1C6 + 16 * partition];
	partition = sort(val, val[partition]);
#ifdef DEBUG
		for(i=0; i<4; i++)
			printf(">>Partition %d: %D\n", i, val[i]);
#endif
	if (partition == 0) ++errors;
	else {
	    k = (drive & 1) * 5 + partition;
	    boot_parameters.bp_rootdev = DEV_HD0 + k;
	    rootname = devname[k + 1];
	    auto_flag = 1;
	}
#ifdef INTEL_32BITS
	boot_parameters.bp_ramsize = 0;
#else
	boot_parameters.bp_ramsize =
			(ext_memsize > DRAMSIZE) ? DRAMSIZE: ext_memsize;
#endif
    }
}

static int sort(val, org)
register long *val;
long org;
{
  register int i, j;

  for (i = 0; i < 4; i++) for (j = 0; j < 3; j++)
		if ((val[j] == 0) && (val[j + 1] != 0))
			swap(&val[j], &val[j + 1]);
		else if (val[j] > val[j + 1] && val[j + 1] != 0)
			swap(&val[j], &val[j + 1]);

  for(i = 0; i < 4; i++) {
	if (org == val[i]) return(i+1);
  }
  return(0);
}

static void swap(first, second)
register long *first, *second;
{
  register long tmp;

  tmp = *first;
  *first = *second;
  *second = tmp;
}
