#include "kernel.h"
#include <minix/com.h>
#include "ether.h"

#if (ETHERNET == ETH_NE1000) || \
    (ETHERNET == ETH_NE2000)

/* LOCAL VARIABLES */
PRIVATE char board_data[16];

/* LOCAL FUNCTIONS */
FORWARD void longpause();

/*===========================================================================*
 *				longpause				     * 
 *===========================================================================*/
PRIVATE void longpause()
{
  register int timeout=RESET_TIMEOUT;

  while(timeout--)
    ;
}

/*===========================================================================*
 *				ram_enable				     * 
 *===========================================================================*/
PUBLIC void ram_enable()
{}

/*===========================================================================*
 *				reset_8390				     * 
 *===========================================================================*/
PUBLIC void reset_8390()
{
  unsigned value;

  value=input(NE_RESET);
  longpause();
  output(NE_RESET, value);
  longpause();
}

/*===========================================================================*
 *				block_output				     * 
 *===========================================================================*/
PUBLIC int block_output(src_addr, sm_offset, count)
phys_bytes src_addr;		/* source buffer location */
vir_bytes sm_offset;		/* board shared memory offset */
vir_bytes count;		/* byte count */
{
  phys_bytes dst_addr;
  unsigned value;
  int timeout=TRANSMIT_TIMEOUT;

  dst_addr=numap(ETHER, (vir_bytes) &value, (vir_bytes) sizeof(value));

  count++;		/* make even */
  count &= 0xfffe;	/* ... */

  output(EN_CCMD, ENC_NODMA|ENC_START);		/* stop & clear the chip */
  output(EN0_RCNTLO, count & BYTE);		/* the count to be output */
  output(EN0_RCNTHI, (count>>8) & BYTE);	/* ... */
  output(EN0_RSARLO, sm_offset & BYTE);		/* the address to be output */
  output(EN0_RSARHI, (sm_offset>>8) & BYTE);	/* ... */
  output(EN_CCMD, ENC_RWRITE|ENC_START);	/* write and start */

#if (ETHERNET == ETH_NE1000)
  while(count--)
  {
    phys_copy(src_addr++, dst_addr, (phys_bytes) 1);	/* copy one byte */
    output(NE_DATAPORT, value);
  }
#endif

#if (ETHERNET == ETH_NE2000)
  count >>= 1;
  while(count--)
  {
    phys_copy(src_addr, dst_addr, (phys_bytes) 2);	/* copy one word */
    src_addr += 2;
    out_word(ETHER_PORT+NE_DATAPORT, value);
  }
#endif

  while( !(input(EN0_ISR)&ENISR_RDC) &&		/* dma done? */
	timeout--)
	;
  if (timeout == 0)
    return(-1);

  return OK;
}

/*===========================================================================*
 *				block_input				     * 
 *===========================================================================*/
PUBLIC void block_input(sm_offset, dst_addr, count)
vir_bytes sm_offset;		/* board shared memory offset */
phys_bytes dst_addr;		/* dest buffer location */
vir_bytes count;		/* byte count */
{
  phys_bytes src_addr;
  unsigned value;

  src_addr=numap(ETHER, (vir_bytes) &value, (vir_bytes) sizeof(value));

  output(EN_CCMD, ENC_NODMA|ENC_PAGE0|ENC_START);
  output(EN0_RCNTLO, count & BYTE);		/* the count to be output */
  output(EN0_RCNTHI, (count>>8) & BYTE);	/* ... */
  output(EN0_RSARLO, sm_offset & BYTE);		/* the address to be output */
  output(EN0_RSARHI, (sm_offset>>8) & BYTE);	/* ... */
  output(EN_CCMD, ENC_RREAD|ENC_START);		/* read and start */

#if (ETHERNET == ETH_NE1000)
  while(count--)
  {
    value=input(NE_DATAPORT);
    phys_copy(src_addr, dst_addr++, (phys_bytes) 1);	/* copy one byte */
  }
#endif

#if (ETHERNET == ETH_NE2000)
  count++;
  count >>= 1;
  while(count--)
  {
    value=in_word(ETHER_PORT+NE_DATAPORT);
    phys_copy(src_addr, dst_addr, (phys_bytes) 2);	/* copy one word */
    dst_addr += (phys_bytes) 2;
  }
#endif
}

/*===========================================================================*
 *				init_card				     * 
 *===========================================================================*/
PUBLIC void init_card()
{
  phys_bytes bd_phys;  
  int i;

/* Now get the board data. This is 16 bytes starting at remote
 * dma address 0. Put it in a buffer called board_data.
 */
#if (ETHERNET == ETH_NE1000)
  bd_phys=numap(ETHER, board_data, (vir_bytes) 16);
  block_input((vir_bytes) 0, bd_phys, (vir_bytes) 16);

  if ( board_data[0] & 1 )	/* did the fools pick their own id? */
    board_data[0] &= 0xfe;	/* reset the multicast bit */
#endif
#if (ETHERNET == ETH_NE2000)
  endcfg |= ENDCFG_WTS;
  output(EN0_DCFG, endcfg);
  output(EN_CCMD, ENC_NODMA|ENC_PAGE0|ENC_START);
  output(EN0_RCNTLO, (16*2) & BYTE);		/* the count to be output */
						/* it is actually doubled */
  output(EN0_RCNTHI, 0);			/* ... */
  output(EN0_RSARLO, 0);			/* the address to be output */
  output(EN0_RSARHI, 0);			/* ... */
  output(EN_CCMD, ENC_RREAD|ENC_START);		/* read and start */
  for(i=0 ; i<16 ; i++)
    board_data[i]=input(NE_DATAPORT);
#endif

  for (i=0 ; i<sizeof(Eth_addr) ; i++)	/* copy board address */
    curr_hw_addr.ea[i]=board_data[i];
}

#endif /* ETHERNET - no code after this line ! */
