/*	mcread: main.c
	Copyright (C) 1991, Mike Gleason Jr & NCEMRSoft.
	All Rights Reserved. See mcread.h for details. */


#include <stdio.h>
#include <signal.h>

#ifndef THINK_C
#ifndef applec
#ifdef BIG_ENDIAN
#include <sys/types.h>	/* need sys/types.h or stddef.h for size_t */
#endif
#endif
#endif							/* if unix */

#include "mcread.h"

extern short					tab, width, linecount, pager;
short							readFromStdin;


main (argc, argv)
	int argc;
	char **argv;
{
	register short i, filesToDo, filesDone;
	char crap[80];
	extern void on_interrupt();
		
#ifdef THINK_C
#include <console.h>
	argc = ccommand (&argv);
#endif
	if (argc < 2) {
usage:
		(void) fprintf (stderr, "usage: %s %s\n", argv[0], USAGE);
		exit (EXIT_FAILURE);
	}

	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		(void) signal(SIGINT, on_interrupt);

	readFromStdin = 0;

	/* preprocess options... */
	for (i=1,filesToDo=0; i<argc; i++)
		if (*argv[i] == '-')
			switch (argv[i][1]) {
				case 't': tab = atoi (argv[i] + 2); break;
				case 'w': width = atoi (argv[i] + 2); break;
				case 'p':
					if (argv[i][2])
						pager = atoi (argv[i] + 2);
					else
						pager = 23;
					break;
				/* case 's':
				case '\0': readFromStdin = 1; break; */
				default:
					goto usage;
			}
		else
			filesToDo++;

	/* ...now do the converting. */
	if (readFromStdin)
		(void) thrash ("stdin");
	else for (i=1,filesDone=0; i<argc; i++)
		if (*argv[i] != '-') {
			linecount = 0;
			if (filesToDo > 1)
			{
				(void) printf ("\n\nfile: %s\n", argv[i]);
				linecount = 1;
				(void) thrash (argv[i]);
				filesDone++;
				if (pager > 0 && filesDone < filesToDo) {
					(void) printf ("...end of file '%s'...hit return, q to cancel...", argv[i]);
					(void) fgets (crap, 78, stdin);
					if (*crap == 'q') exit (EXIT_SUCCESS);
				}
			} else (void) thrash (argv[i]);
		}
}	/* main */



void on_interrupt()
{
	(void) fprintf (stderr, "### mcread: aborted.\n");
	exit (EXIT_FAILURE);
}	/* on_interrupt */



int thrash (name)
	char					*name;
{
	char					typestr[8];
	long					dforklen;
	FILE					*in;
	int						result;
	
	if (readFromStdin)
		return (0);		/* not supported yet */
		
	if (!(in = fopen (name, READ_BINARY))) {
		(void) fprintf (stderr, "%s: could not open for reading.\n", name);
		return (1);
	}
	
	dforklen = CheckMBHeader(in, typestr);
	
	if (dforklen < 0L) {		/* no mb header.  gr.... */
		result = thrash_macwrite (in, name, dforklen);
		if (result) {		/* not macwrite, try text. */
			rewind (in);
			result = thrash_text (in, name, dforklen, TRUE);
		}
	}	
	else if (strcmp(MACWRITE_TYPE, typestr) == 0)
		result = thrash_macwrite (in, name, dforklen);
	else if (strcmp(TEXT_TYPE, typestr) == 0)
		result = thrash_text (in, name, dforklen, FALSE);
	else if (strcmp(TEACHTEXT_TYPE, typestr) == 0)
		result = thrash_text (in, name, dforklen, TRUE);
	else if (strcmp(WORD_TYPE, typestr) == 0) {
		(void) fprintf (stderr, "%s: cannot mcread MS Word documents (yet).\n",
		name);
	}
	else {
		(void) fprintf (stderr, "%s: unrecognized file type (%s)\n",
			name, typestr);
		(void) fclose (in);
		return (2);
	}
	
	(void) fclose (in);
	return (0);
}	/* thrash;  am I the only programmer who listens to thrash/speed metal? */



/* If you know for sure that the machine you are going to run this on had
	Big Endian byte-ordering, you can #define it and you'll get a mild
	speed increase/size decrease. */
	
#ifdef BIG_ENDIAN

MacWord Getw (in)
	FILE *in;
{
	MacWord aWord;	/* 2 bytes */
	fread (&aWord, (size_t) 2, (size_t) 1, in);
	return (aWord);
}

MacLongword Getl (in)
	FILE *in;
{
	MacLongword aLongword;	/* 4 bytes */
	fread (&aLongword, (size_t) 4, (size_t) 1, in);
	return (aLongword);
}

#else

MacWord Getw (in)
	FILE *in;
{
	register MacWord a, b;	
	register MacWord aWord;	/* 2 bytes */
	
	a = (MacWord) getc (in) << 8;
	b = (MacWord) getc (in);
	aWord = a + b;
	return (aWord);
}

MacLongword Getl (in)
	FILE *in;
{
	register MacLongword aLongword;	/* 4 bytes */
	register MacLongword a, b, c, d;	
	
	a = (long) getc (in) << 24;
	b = (long) getc (in) << 16;
	c = (long) getc (in) << 8;
	d = (long) getc (in);
	aLongword = a + b + c + d;
	return (aLongword);
}

#endif
/* eof */
