/*
 * $Author: djh $ $Date: 1991/07/10 16:40:04 $
 * $Header: /mac/src/cap60/applications/aufs/RCS/aufsicon.c,v 2.5 1991/07/10 16:40:04 djh Rel djh $
 * $Revision: 2.5 $
 */

/*
 * aufsicon.c - aufs icon.
 *
 * Display a CAP volume ICON, and where possible
 * represent the underlying hardware platform.
 *
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Copyright (c) 1986, 1987 by The Trustees of Columbia University in 
 * the City of New York.
 *
 * Edit History:
 *
 *  March 1987 	Schilit		Created.
 *  April 1987  CCKim           Clean up, put rep. of icon in
 *  Feb.  1991  Max Tardiveau	Added icons for NeXT and Sun
 *  May   1991  Rakesh Patel	Automatic ICN# selection
 *  May   1991  djh		Edit icons & masks, add IBM ICN#
 *  May   1991  Kim Holburn	New SUN, Pyramid Icons
 *  May   1991  Gavin Longmuir	New SUN SPARC ICN#
 *  May   1991  djh		Major revision & yet more ICN#s
 *  June  1991  Mike Moya	Added a Gould and "cleaner" Digital Icon
 *
 */

/*
 * The ICN#s in this file are intended for non-commercial CAP use,
 * they are provided to visually link the CAP server and host type.
 * Components of the images are copyright by the respective hardware
 * manufacturers.
 *
 * The "4.3BSD System Daemon" is Copyright (c) 1988 Kirk Mckusick, UC.
 *
 * In general, there are two version of each ICON. The first is the
 * normal "network platter" representation, the second the usual CAP
 * "network folder" version. Define PLATTER_ICON for the former. To
 * enable the automatic host ICON selection, define USE_HOST_ICON in
 * the m4.features file. To use the alternative set of contributed
 * ICONs, define USE_ALT_ICONS instead.
 *
 */

#include <netat/appletalk.h>

#define ICONSIZE	256

/*
#define PLATTER_ICON
*/

/* Automatic host/ICON selection */

#ifdef USE_HOST_ICON
#ifdef sun
#define INDEX	1
#endif sun
#ifdef pyr
#define INDEX	2
#endif pyr
#ifdef NeXT
#define INDEX	3
#endif NeXT
#ifdef AIX
#define INDEX	4
#endif AIX
#ifdef ultrix
#define INDEX	5
#endif ultrix
#ifdef vax
#define INDEX	5
#endif vax
#ifdef aux
#define INDEX	6
#endif aux
#ifdef sgi
#define INDEX	7
#endif sgi
#ifdef encore
#define INDEX	8
#endif encore
#ifdef gould
#define INDEX	12
#endif gould
#endif USE_HOST_ICON

/* Alternative host/ICONs */

#ifdef USE_ALT_ICONS
#ifdef sun
#ifdef sparc
#define INDEX	9
#else  sparc
#define INDEX	10
#endif sparc
#endif sun
#ifdef NeXT
#define INDEX	11
#endif NeXT
#ifdef vax
#define INDEX	13
#endif vax
#ifdef ultrix
#define INDEX	13
#endif ultrix
#endif USE_ALT_ICONS

#define NUM_ICONS	14

/* default "BSD Daemon" */

#ifndef INDEX
#define INDEX	0	/* default CAP BSD ICN# */
#endif  INDEX

export byte icons[NUM_ICONS][ICONSIZE] = {

  /* ICON 0, BSD default */
#ifdef PLATTER_ICON
  0x00, 0x0C, 0x01, 0x80,	/*            xx         xx       */
  0x00, 0x18, 0xF8, 0xC0,	/*           xx   xxxxx   xx      */
  0x00, 0x15, 0x05, 0x40,	/*           x x x     x x x      */
  0x00, 0x12, 0x72, 0x40,	/*           x  x  xxx  x  x      */
  0x00, 0x0D, 0xC9, 0x40,	/*            xx xxx  x  x x      */
  0x00, 0x13, 0x24, 0xC0,	/*           x  xx  x  x  xx      */
  0x00, 0x22, 0x14, 0x40,	/*          x   x    x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x22, 0x14, 0x40,	/*          x   x    x x   x      */
  0x00, 0x22, 0x24, 0x44,	/*          x   x   x  x   x   x  */
  0x00, 0x1F, 0xD8, 0x49,	/*           xxxxxxx xx    x  x  x*/
  0x00, 0x08, 0x80, 0x4A,	/*            x   x        x  x x */
  0x00, 0x08, 0x9C, 0x8C,	/*            x   x  xxx  x   xx  */
  0x00, 0x07, 0x08, 0x99,	/*             xxx    x   x  xx  x*/
  0x00, 0x02, 0x11, 0xE6,	/*              x    x   xxxx  xx */
  0x00, 0x01, 0xFE, 0x80,	/*               xxxxxxxx x       */
  0x00, 0x02, 0x08, 0x8E,	/*              x     x   x   xxx */
  0x00, 0x03, 0x90, 0x91,	/*              xxx  x    x  x   x*/
  0x0B, 0x04, 0x71, 0x95,	/*    x xx     x   xxx   xx  x x x*/
  0x0E, 0x8C, 0x4E, 0x96,	/*    xxx x   xx   x  xxx x  x xx */
  0x0A, 0xF6, 0x50, 0xA7,	/*    x x xxxx xx  x x    x x  xxx*/
  0x0A, 0x03, 0x80, 0xC0,	/*    x x       xxx       xx      */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x02, 0x00, 0x02,	/* x            x               x */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x08, 0x1F, 0x00,	/*            x      xxxxx        */
  0x00, 0x00, 0x1F, 0x00,	/*                   xxxxx        */
  0xFF, 0xFF, 0xE4, 0xFF,	/*xxxxxxxxxxxxxxxxxxx  x  xxxxxxxx*/
  0x00, 0x00, 0x0A, 0x00,	/*                    x x         */
  0xFF, 0xFF, 0xF1, 0xFF,	/*xxxxxxxxxxxxxxxxxxxx   xxxxxxxxx*/
  /* MASK */
  0x00, 0x0C, 0x01, 0x80,	/*            xx         xx       */
  0x00, 0x18, 0xF8, 0xC0,	/*           xx   xxxxx   xx      */
  0x00, 0x1D, 0xFD, 0xC0,	/*           xxx xxxxxxx xxx      */
  0x00, 0x1F, 0xFF, 0xC0,	/*           xxxxxxxxxxxxxxx      */
  0x00, 0x0F, 0xFF, 0xC0,	/*            xxxxxxxxxxxxxx      */
  0x00, 0x1F, 0xFF, 0xC0,	/*           xxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC4,	/*          xxxxxxxxxxxxxxxx   x  */
  0x00, 0x1F, 0xFF, 0xC9,	/*           xxxxxxxxxxxxxxx  x  x*/
  0x00, 0x0F, 0xFF, 0xCA,	/*            xxxxxxxxxxxxxx  x x */
  0x00, 0x0F, 0xFF, 0x8C,	/*            xxxxxxxxxxxxx   xx  */
  0x00, 0x0F, 0xFF, 0x99,	/*            xxxxxxxxxxxxx  xx  x*/
  0x00, 0x03, 0xFF, 0xE6,	/*              xxxxxxxxxxxxx  xx */
  0x00, 0x03, 0xFF, 0x80,	/*              xxxxxxxxxxx       */
  0x00, 0x03, 0xFF, 0x8E,	/*              xxxxxxxxxxx   xxx */
  0x00, 0x03, 0xFF, 0x91,	/*              xxxxxxxxxxx  x   x*/
  0x0B, 0x07, 0xFF, 0x95,	/*    x xx     xxxxxxxxxxxx  x x x*/
  0x0F, 0x8F, 0xFF, 0x96,	/*    xxxxx   xxxxxxxxxxxxx  x xx */
  0x0F, 0xFF, 0xFF, 0xA7,	/*    xxxxxxxxxxxxxxxxxxxxx x  xxx*/
  0x0F, 0xFF, 0xFF, 0xC0,	/*    xxxxxxxxxxxxxxxxxxxxxx      */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x08, 0x1F, 0x00,	/*            x      xxxxx        */
  0x00, 0x00, 0x1F, 0x00,	/*                   xxxxx        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFB, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx xxxxxxxxxx*/
  0xFF, 0xFF, 0xF1, 0xFF,	/*xxxxxxxxxxxxxxxxxxxx   xxxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x0C, 0x01, 0x80,	/*            xx         xx       */
  0x00, 0x18, 0xF8, 0xC0,	/*           xx   xxxxx   xx      */
  0x00, 0x15, 0x05, 0x40,	/*           x x x     x x x      */
  0x00, 0x12, 0x72, 0x40,	/*           x  x  xxx  x  x      */
  0x00, 0x0D, 0xC9, 0x40,	/*            xx xxx  x  x x      */
  0x00, 0x13, 0x24, 0xC0,	/*           x  xx  x  x  xx      */
  0x00, 0x22, 0x14, 0x40,	/*          x   x    x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x3B, 0x94, 0x40,	/*          xxx xxx  x x   x      */
  0x00, 0x22, 0x14, 0x40,	/*          x   x    x x   x      */
  0x00, 0x22, 0x24, 0x44,	/*          x   x   x  x   x   x  */
  0x00, 0x1F, 0xD8, 0x49,	/*           xxxxxxx xx    x  x  x*/
  0x78, 0x08, 0x80, 0x4A,	/* xxxx       x   x        x  x x */
  0x84, 0x08, 0x9C, 0x8C,	/*x    x      x   x  xxx  x   xx  */
  0xFF, 0xF7, 0x08, 0x99,	/*xxxxxxxxxxxx xxx    x   x  xx  x*/
  0x80, 0x12, 0x11, 0xE6,	/*x          x  x    x   xxxx  xx */
  0x81, 0x11, 0xFE, 0x80,	/*x      x   x   xxxxxxxx x       */
  0x82, 0x12, 0x08, 0x86,	/*x     x    x  x     x   x    xx */
  0x84, 0x13, 0x90, 0x89,	/*x    x     x  xxx  x    x   x  x*/
  0x88, 0x14, 0x71, 0x89,	/*x   x      x x   xxx   xx   x  x*/
  0x92, 0x94, 0x4E, 0x92,	/*x  x  x x  x x   x  xxx x  x  x */
  0x80, 0x16, 0x40, 0xA4,	/*x          x xx  x      x x  x  */
  0xFF, 0xF3, 0x90, 0xC4,	/*xxxxxxxxxxxx  xxx  x    xx   x  */
  0x05, 0x06, 0x01, 0x88,	/*     x x     xx        xx   x   */
  0x0F, 0x89, 0x01, 0x2A,	/*    xxxxx   x  x       x  x x x */
  0x08, 0x80, 0x91, 0x1C,	/*    x   x       x  x   x   xxx  */
  0x0F, 0x80, 0x91, 0x08,	/*    xxxxx       x  x   x    x   */
  0x0A, 0x80, 0x91, 0x00,	/*    x x x       x  x   x        */
  0xF2, 0x7F, 0xFF, 0xFF,	/*xxxx  x  xxxxxxxxxxxxxxxxxxxxxxx*/
  0x05, 0x00, 0x00, 0x00,	/*     x x                        */
  0xF8, 0xFF, 0xFF, 0xFF,	/*xxxxx   xxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x0C, 0x01, 0x80,	/*            xx         xx       */
  0x00, 0x18, 0xF8, 0xC0,	/*           xx   xxxxx   xx      */
  0x00, 0x1D, 0xFD, 0xC0,	/*           xxx xxxxxxx xxx      */
  0x00, 0x1F, 0xFF, 0xC0,	/*           xxxxxxxxxxxxxxx      */
  0x00, 0x0F, 0xFF, 0xC0,	/*            xxxxxxxxxxxxxx      */
  0x00, 0x1F, 0xFF, 0xC0,	/*           xxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC0,	/*          xxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xC4,	/*          xxxxxxxxxxxxxxxx   x  */
  0x00, 0x1F, 0xFF, 0xC9,	/*           xxxxxxxxxxxxxxx  x  x*/
  0x78, 0x0F, 0xFF, 0xCA,	/* xxxx       xxxxxxxxxxxxxx  x x */
  0xFC, 0x0F, 0xFF, 0x8C,	/*xxxxxx      xxxxxxxxxxxxx   xx  */
  0xFF, 0xFF, 0xFF, 0x99,	/*xxxxxxxxxxxxxxxxxxxxxxxxx  xx  x*/
  0xFF, 0xF3, 0xFF, 0xE6,	/*xxxxxxxxxxxx  xxxxxxxxxxxxx  xx */
  0xFF, 0xF3, 0xFF, 0x80,	/*xxxxxxxxxxxx  xxxxxxxxxxx       */
  0xFF, 0xF3, 0xFF, 0x86,	/*xxxxxxxxxxxx  xxxxxxxxxxx    xx */
  0xFF, 0xF3, 0xFF, 0x89,	/*xxxxxxxxxxxx  xxxxxxxxxxx   x  x*/
  0xFF, 0xF7, 0xFF, 0x89,	/*xxxxxxxxxxxx xxxxxxxxxxxx   x  x*/
  0xFF, 0xF7, 0xFF, 0x92,	/*xxxxxxxxxxxx xxxxxxxxxxxx  x  x */
  0xFF, 0xF7, 0xFF, 0xA4,	/*xxxxxxxxxxxx xxxxxxxxxxxx x  x  */
  0xFF, 0xF3, 0xFF, 0xC4,	/*xxxxxxxxxxxx  xxxxxxxxxxxx   x  */
  0x07, 0x07, 0xFF, 0x88,	/*     xxx     xxxxxxxxxxxx   x   */
  0x0F, 0x8B, 0xFF, 0x2A,	/*    xxxxx   x xxxxxxxxxx  x x x */
  0x0F, 0x80, 0xFF, 0x1C,	/*    xxxxx       xxxxxxxx   xxx  */
  0x0F, 0x80, 0xFF, 0x08,	/*    xxxxx       xxxxxxxx    x   */
  0x0F, 0x80, 0xFF, 0x00,	/*    xxxxx       xxxxxxxx        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFD, 0xFF, 0xFF, 0xFF,	/*xxxxxx xxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF8, 0xFF, 0xFF, 0xFF,	/*xxxxx   xxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 1, SUN */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x01, 0xC0, 0x00,	/*               xxx              */
  0x00, 0x03, 0xE0, 0x00,	/*              xxxxx             */
  0x00, 0x03, 0x70, 0x00,	/*              xx xxx            */
  0x00, 0x0B, 0xB8, 0x00,	/*            x xxx xxx           */
  0x00, 0x1D, 0xDC, 0x00,	/*           xxx xxx xxx          */
  0x00, 0x2E, 0xEE, 0x00,	/*          x xxx xxx xxx         */
  0x00, 0x77, 0x77, 0x00,	/*         xxx xxx xxx xxx        */
  0x00, 0xBB, 0xBA, 0x80,	/*        x xxx xxx xxx x x       */
  0x01, 0xDD, 0xDD, 0xC0,	/*       xxx xxx xxx xxx xxx      */
  0x03, 0xAE, 0xEB, 0xA0,	/*      xxx x xxx xxx x xxx x     */
  0x07, 0x77, 0x67, 0x70,	/*     xxx xxx xxx xx  xxx xxx    */
  0x0E, 0xE3, 0xEE, 0xE0,	/*    xxx xxx   xxxxx xxx xxx     */
  0x1D, 0xDD, 0xDD, 0xDC,	/*   xxx xxx xxx xxx xxx xxx xxx  */
  0x3B, 0xBE, 0x3B, 0xBE,	/*  xxx xxx xxxxx   xxx xxx xxxxx */
  0x37, 0x76, 0x37, 0x76,	/*  xx xxx xxx xx   xx xxx xxx xx */
  0x3E, 0xEE, 0x3E, 0xEE,	/*  xxxxx xxx xxx   xxxxx xxx xxx */
  0x1D, 0xDD, 0xDD, 0xDC,	/*   xxx xxx xxx xxx xxx xxx xxx  */
  0x03, 0xBB, 0xE3, 0xB8,	/*      xxx xxx xxxxx   xxx xxx   */
  0x07, 0x73, 0x77, 0x70,	/*     xxx xxx  xx xxx xxx xxx    */
  0x02, 0xEB, 0xBA, 0xE0,	/*      x xxx x xxx xxx x xxx     */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x20, 0x00, 0x00, 0x02,	/*  x                           x */
  0x1F, 0xFF, 0xFF, 0xFC,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x01, 0x40, 0x00,	/*               x x              */
  0x00, 0x03, 0xE0, 0x00,	/*              xxxxx             */
  0x00, 0x07, 0xF0, 0x00,	/*             xxxxxxx            */
  0x00, 0x0B, 0xF8, 0x00,	/*            x xxxxxxx           */
  0x00, 0x1F, 0xFC, 0x00,	/*           xxxxxxxxxxx          */
  0x00, 0x3F, 0xFE, 0x00,	/*          xxxxxxxxxxxxx         */
  0x00, 0x7F, 0xFF, 0x00,	/*         xxxxxxxxxxxxxxx        */
  0x00, 0xFF, 0xFF, 0x80,	/*        xxxxxxxxxxxxxxxxx       */
  0x01, 0xFF, 0xFF, 0xC0,	/*       xxxxxxxxxxxxxxxxxxx      */
  0x03, 0xFF, 0xFF, 0xE0,	/*      xxxxxxxxxxxxxxxxxxxxx     */
  0x07, 0xFF, 0xFF, 0xF0,	/*     xxxxxxxxxxxxxxxxxxxxxxx    */
  0x0F, 0xFF, 0xEF, 0xF8,	/*    xxxxxxxxxxxxxxx xxxxxxxxx   */
  0x1F, 0xF7, 0xFF, 0xF4,	/*   xxxxxxxxx xxxxxxxxxxxxxxx x  */
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x17, 0xFF, 0xF7, 0xFC,	/*   x xxxxxxxxxxxxxxx xxxxxxxxx  */
  0x0F, 0xFB, 0xFF, 0xF8,	/*    xxxxxxxxx xxxxxxxxxxxxxxx   */
  0x07, 0xFF, 0xFF, 0xF0,	/*     xxxxxxxxxxxxxxxxxxxxxxx    */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x1F, 0xFF, 0xFF, 0xFC,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x01, 0xC0, 0x00,	/*               xxx              */
  0x00, 0x03, 0xE0, 0x00,	/*              xxxxx             */
  0x00, 0x03, 0x70, 0x00,	/*              xx xxx            */
  0x00, 0x0B, 0xB8, 0x00,	/*            x xxx xxx           */
  0x00, 0x1D, 0xDC, 0x00,	/*           xxx xxx xxx          */
  0x00, 0x2E, 0xEE, 0x00,	/*          x xxx xxx xxx         */
  0x00, 0x77, 0x77, 0x00,	/*         xxx xxx xxx xxx        */
  0x00, 0xBB, 0xBA, 0x80,	/*        x xxx xxx xxx x x       */
  0x01, 0xDD, 0xDD, 0xC0,	/*       xxx xxx xxx xxx xxx      */
  0x03, 0xAE, 0xEB, 0xA0,	/*      xxx x xxx xxx x xxx x     */
  0x07, 0x77, 0x67, 0x70,	/*     xxx xxx xxx xx  xxx xxx    */
  0x0E, 0xE3, 0xEE, 0xE0,	/*    xxx xxx   xxxxx xxx xxx     */
  0x1D, 0xDD, 0xDD, 0xDC,	/*   xxx xxx xxx xxx xxx xxx xxx  */
  0x03, 0xBE, 0x3B, 0xBE,	/*      xxx xxxxx   xxx xxx xxxxx */
  0x7B, 0x76, 0x37, 0x76,	/* xxxx xx xxx xx   xx xxx xxx xx */
  0x84, 0x0E, 0x3E, 0xEE,	/*x    x      xxx   xxxxx xxx xxx */
  0xFF, 0xED, 0xDD, 0xDC,	/*xxxxxxxxxxx xx xxx xxx xxx xxx  */
  0x80, 0x2B, 0xE3, 0xB8,	/*x         x x xxxxx   xxx xxx   */
  0x88, 0x23, 0x77, 0x70,	/*x   x     x   xx xxx xxx xxx    */
  0x90, 0x2B, 0xBA, 0xE0,	/*x  x      x x xxx xxx x xxx     */
  0xA5, 0x2D, 0xDD, 0xC0,	/*x x  x x  x xx xxx xxx xxx      */
  0x80, 0x2E, 0xEE, 0x80,	/*x         x xxx xxx xxx x       */
  0xFF, 0xE7, 0x77, 0x00,	/*xxxxxxxxxxx  xxx xxx xxx        */
  0x0A, 0x0B, 0xBA, 0x00,	/*    x x     x xxx xxx x         */
  0x1F, 0x1D, 0xDC, 0x00,	/*   xxxxx   xxx xxx xxx          */
  0x11, 0x0E, 0xE8, 0x00,	/*   x   x    xxx xxx x           */
  0x1F, 0x07, 0x60, 0x00,	/*   xxxxx     xxx xx             */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x03, 0xE0, 0x00,	/*              xxxxx             */
  0x00, 0x07, 0xF0, 0x00,	/*             xxxxxxx            */
  0x00, 0x0B, 0xF8, 0x00,	/*            x xxxxxxx           */
  0x00, 0x1F, 0xFC, 0x00,	/*           xxxxxxxxxxx          */
  0x00, 0x3F, 0xFE, 0x00,	/*          xxxxxxxxxxxxx         */
  0x00, 0x7F, 0xFF, 0x00,	/*         xxxxxxxxxxxxxxx        */
  0x00, 0xFF, 0xFF, 0x80,	/*        xxxxxxxxxxxxxxxxx       */
  0x01, 0xFF, 0xFF, 0xC0,	/*       xxxxxxxxxxxxxxxxxxx      */
  0x03, 0xFF, 0xFF, 0xE0,	/*      xxxxxxxxxxxxxxxxxxxxx     */
  0x07, 0xFF, 0xFF, 0xF0,	/*     xxxxxxxxxxxxxxxxxxxxxxx    */
  0x0F, 0xFF, 0xEF, 0xF8,	/*    xxxxxxxxxxxxxxx xxxxxxxxx   */
  0x1F, 0xF7, 0xFF, 0xF4,	/*   xxxxxxxxx xxxxxxxxxxxxxxx x  */
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x03, 0xFF, 0xFF, 0xFE,	/*      xxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7B, 0xFF, 0xFF, 0xFE,	/* xxxx xxxxxxxxxxxxxxxxxxxxxxxxx */
  0xFC, 0x0F, 0xFF, 0xFE,	/*xxxxxx      xxxxxxxxxxxxxxxxxxx */
  0xFF, 0xEF, 0xFF, 0xFE,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxxxxx */
  0xFF, 0xEF, 0xF7, 0xFC,	/*xxxxxxxxxxx xxxxxxxx xxxxxxxxx  */
  0xFF, 0xEB, 0xFF, 0xF8,	/*xxxxxxxxxxx x xxxxxxxxxxxxxxx   */
  0xFF, 0xEF, 0xFF, 0xF0,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxx    */
  0xFF, 0xEF, 0xFF, 0xE0,	/*xxxxxxxxxxx xxxxxxxxxxxxxxx     */
  0xFF, 0xEF, 0xFF, 0xC0,	/*xxxxxxxxxxx xxxxxxxxxxxxxx      */
  0xFF, 0xEF, 0xFF, 0x80,	/*xxxxxxxxxxx xxxxxxxxxxxxx       */
  0x0E, 0x0F, 0xFF, 0x00,	/*    xxx     xxxxxxxxxxxx        */
  0x1F, 0x3F, 0xFE, 0x00,	/*   xxxxx  xxxxxxxxxxxxx         */
  0x1F, 0x1F, 0xFC, 0x00,	/*   xxxxx   xxxxxxxxxxx          */
  0x1F, 0x0F, 0xE8, 0x00,	/*   xxxxx    xxxxxxx x           */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 2, Pyramid */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x01, 0x00, 0x00,	/*               x                */
  0x00, 0x01, 0x80, 0x00,	/*               xx               */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x0F, 0xE0, 0x00,	/*            xxxxxxx             */
  0x00, 0x01, 0xF0, 0x00,	/*               xxxxx            */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x7F, 0xFC, 0x00,	/*         xxxxxxxxxxxxx          */
  0x00, 0x01, 0xFE, 0x00,	/*               xxxxxxxx         */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x03, 0xFF, 0xFF, 0x80,	/*      xxxxxxxxxxxxxxxxxxx       */
  0x00, 0x01, 0xFF, 0xC0,	/*               xxxxxxxxxxx      */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x1F, 0xFF, 0xFF, 0xF0,	/*   xxxxxxxxxxxxxxxxxxxxxxxxx    */
  0x00, 0x01, 0xFF, 0xF8,	/*               xxxxxxxxxxxxxx   */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFE,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x40, 0x00, 0x00, 0x04,	/* x                           x  */
  0x3F, 0xFF, 0xFF, 0xF8,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x01, 0x00, 0x00,	/*               x                */
  0x00, 0x03, 0x80, 0x00,	/*              xxx               */
  0x00, 0x07, 0xC0, 0x00,	/*             xxxxx              */
  0x00, 0x0F, 0xE0, 0x00,	/*            xxxxxxx             */
  0x00, 0x1F, 0xF0, 0x00,	/*           xxxxxxxxx            */
  0x00, 0x3F, 0xF8, 0x00,	/*          xxxxxxxxxxx           */
  0x00, 0x7F, 0xFC, 0x00,	/*         xxxxxxxxxxxxx          */
  0x00, 0xFF, 0xFE, 0x00,	/*        xxxxxxxxxxxxxxx         */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x03, 0xFF, 0xFF, 0x80,	/*      xxxxxxxxxxxxxxxxxxx       */
  0x07, 0xFF, 0xFF, 0xC0,	/*     xxxxxxxxxxxxxxxxxxxxx      */
  0x0F, 0xFF, 0xFF, 0xE0,	/*    xxxxxxxxxxxxxxxxxxxxxxx     */
  0x1F, 0xFF, 0xFF, 0xF0,	/*   xxxxxxxxxxxxxxxxxxxxxxxxx    */
  0x3F, 0xFF, 0xFF, 0xF8,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x7F, 0xFF, 0xFF, 0xFC,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0xFF, 0xFF, 0xFF, 0xFE,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0xFF, 0xFF, 0xFF, 0xFE,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFA,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxx x */
  0x3F, 0xFF, 0xFF, 0xF8,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x02, 0x00, 0x00,	/*              x                 */
  0x00, 0x03, 0x00, 0x00,	/*              xx                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x1F, 0xC0, 0x00,	/*           xxxxxxx              */
  0x00, 0x03, 0xE0, 0x00,	/*              xxxxx             */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0xFF, 0xF8, 0x00,	/*        xxxxxxxxxxxxx           */
  0x00, 0x03, 0xFC, 0x00,	/*              xxxxxxxx          */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x07, 0xFF, 0xFF, 0x00,	/*     xxxxxxxxxxxxxxxxxxx        */
  0x00, 0x03, 0xFF, 0x80,	/*              xxxxxxxxxxx       */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFF, 0xFF, 0xE0,	/* xxxx  xxxxxxxxxxxxxxxxxxxx     */
  0x84, 0x03, 0xFF, 0xF0,	/*x    x        xxxxxxxxxxxxxx    */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x80, 0x2F, 0xFF, 0xFC,	/*x         x xxxxxxxxxxxxxxxxxx  */
  0x88, 0x23, 0xFF, 0xFE,	/*x   x     x   xxxxxxxxxxxxxxxxx */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x02, 0x00, 0x00,	/*              x                 */
  0x00, 0x07, 0x00, 0x00,	/*             xxx                */
  0x00, 0x0F, 0x80, 0x00,	/*            xxxxx               */
  0x00, 0x1F, 0xC0, 0x00,	/*           xxxxxxx              */
  0x00, 0x3F, 0xE0, 0x00,	/*          xxxxxxxxx             */
  0x00, 0x7F, 0xF0, 0x00,	/*         xxxxxxxxxxx            */
  0x00, 0xFF, 0xF8, 0x00,	/*        xxxxxxxxxxxxx           */
  0x01, 0xFF, 0xFC, 0x00,	/*       xxxxxxxxxxxxxxx          */
  0x03, 0xFF, 0xFE, 0x00,	/*      xxxxxxxxxxxxxxxxx         */
  0x07, 0xFF, 0xFF, 0x00,	/*     xxxxxxxxxxxxxxxxxxx        */
  0x0F, 0xFF, 0xFF, 0x80,	/*    xxxxxxxxxxxxxxxxxxxxx       */
  0x1F, 0xFF, 0xFF, 0xC0,	/*   xxxxxxxxxxxxxxxxxxxxxxx      */
  0x2F, 0xFF, 0xFF, 0xE0,	/*  x xxxxxxxxxxxxxxxxxxxxxxx     */
  0x79, 0xFF, 0xFF, 0xF0,	/* xxxx  xxxxxxxxxxxxxxxxxxxxx    */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xEF, 0xFF, 0xFC,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxxxx  */
  0xFF, 0xEF, 0xFF, 0xFE,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxxxxx */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 3, NeXT */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x03, 0xF0, 0x00,	/*              xxxxxx            */
  0x00, 0x07, 0xE8, 0x00,	/*             xxxxxx x           */
  0x00, 0x0F, 0xDC, 0x00,	/*            xxxxxx xxx          */
  0x00, 0x1F, 0xBE, 0x00,	/*           xxxxxx xxxxx         */
  0x00, 0x3F, 0x7F, 0x00,	/*          xxxxxx xxxxxxx        */
  0x00, 0x7E, 0xFF, 0x80,	/*         xxxxxx xxxxxxxxx       */
  0x00, 0xFD, 0xFF, 0xC0,	/*        xxxxxx xxxxxxxxxxx      */
  0x01, 0xFB, 0xE3, 0xE0,	/*       xxxxxx xxxxx   xxxxx     */
  0x03, 0xF7, 0xE7, 0xF0,	/*      xxxxxx xxxxxx  xxxxxxx    */
  0x07, 0xEF, 0xED, 0xF8,	/*     xxxxxx xxxxxxx xx xxxxxx   */
  0x0F, 0xDF, 0x73, 0x7C,	/*    xxxxxx xxxxx xxx  xx xxxxx  */
  0x1F, 0xBF, 0xBE, 0xFE,	/*   xxxxxx xxxxxxx xxxxx xxxxxxx */
  0x3F, 0x7C, 0x1D, 0x7F,	/*  xxxxxx xxxxx     xxx x xxxxxxx*/
  0x1F, 0xBE, 0xFF, 0xBE,	/*   xxxxxx xxxxx xxxxxxxxx xxxxx */
  0x0F, 0xDF, 0x77, 0xFC,	/*    xxxxxx xxxxx xxx xxxxxxxxx  */
  0x07, 0xEF, 0xF7, 0xF8,	/*     xxxxxx xxxxxxxx xxxxxxxx   */
  0x03, 0xF7, 0xC1, 0xF0,	/*      xxxxxx xxxxx     xxxxx    */
  0x01, 0xFB, 0xF7, 0xE0,	/*       xxxxxx xxxxxx xxxxxx     */
  0x00, 0xFD, 0xF7, 0xC0,	/*        xxxxxx xxxxx xxxxx      */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x20, 0x00, 0x00, 0x02,	/*  x                           x */
  0x1F, 0xFF, 0xFF, 0xFC,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x03, 0xF0, 0x00,	/*              xxxxxx            */
  0x00, 0x07, 0xF8, 0x00,	/*             xxxxxxxx           */
  0x00, 0x0F, 0xFC, 0x00,	/*            xxxxxxxxxx          */
  0x00, 0x1F, 0xFE, 0x00,	/*           xxxxxxxxxxxx         */
  0x00, 0x3F, 0xFF, 0x00,	/*          xxxxxxxxxxxxxx        */
  0x00, 0x7F, 0xFF, 0x80,	/*         xxxxxxxxxxxxxxxx       */
  0x00, 0xFF, 0xFF, 0xC0,	/*        xxxxxxxxxxxxxxxxxx      */
  0x01, 0xFF, 0xFF, 0xE0,	/*       xxxxxxxxxxxxxxxxxxxx     */
  0x03, 0xFF, 0xFF, 0xF0,	/*      xxxxxxxxxxxxxxxxxxxxxx    */
  0x07, 0xFF, 0xFF, 0xF8,	/*     xxxxxxxxxxxxxxxxxxxxxxxx   */
  0x0F, 0xFF, 0xFF, 0xFC,	/*    xxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x1F, 0xFF, 0xFF, 0xFE,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFF,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x1F, 0xFF, 0xFF, 0xFE,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x0F, 0xFF, 0xFF, 0xFC,	/*    xxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x07, 0xFF, 0xFF, 0xF8,	/*     xxxxxxxxxxxxxxxxxxxxxxxx   */
  0x03, 0xFF, 0xFF, 0xF0,	/*      xxxxxxxxxxxxxxxxxxxxxx    */
  0x01, 0xFF, 0xFF, 0xE0,	/*       xxxxxxxxxxxxxxxxxxxx     */
  0x00, 0xFF, 0xFF, 0xC0,	/*        xxxxxxxxxxxxxxxxxx      */
  0x7F, 0xFF, 0xFF, 0xFF,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFE,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x1F, 0xFF, 0xFF, 0xFC,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x03, 0xF0, 0x00,	/*              xxxxxx            */
  0x00, 0x07, 0xE8, 0x00,	/*             xxxxxx x           */
  0x00, 0x0F, 0xDC, 0x00,	/*            xxxxxx xxx          */
  0x00, 0x1F, 0xBE, 0x00,	/*           xxxxxx xxxxx         */
  0x00, 0x3F, 0x7F, 0x00,	/*          xxxxxx xxxxxxx        */
  0x00, 0x7E, 0xFF, 0x80,	/*         xxxxxx xxxxxxxxx       */
  0x00, 0xFD, 0xFF, 0xC0,	/*        xxxxxx xxxxxxxxxxx      */
  0x01, 0xFB, 0xE3, 0xE0,	/*       xxxxxx xxxxx   xxxxx     */
  0x03, 0xF7, 0xE7, 0xF0,	/*      xxxxxx xxxxxx  xxxxxxx    */
  0x07, 0xEF, 0xED, 0xF8,	/*     xxxxxx xxxxxxx xx xxxxxx   */
  0x0F, 0xDF, 0x73, 0x7C,	/*    xxxxxx xxxxx xxx  xx xxxxx  */
  0x1F, 0xBF, 0xBE, 0xFE,	/*   xxxxxx xxxxxxx xxxxx xxxxxxx */
  0x1F, 0x7C, 0x1D, 0x7F,	/*   xxxxx xxxxx     xxx x xxxxxxx*/
  0x7F, 0xBE, 0xFF, 0xBE,	/* xxxxxxxx xxxxx xxxxxxxxx xxxxx */
  0x87, 0xDF, 0x77, 0xFC,	/*x    xxxxx xxxxx xxx xxxxxxxxx  */
  0xFF, 0xEF, 0xF7, 0xF8,	/*xxxxxxxxxxx xxxxxxxx xxxxxxxx   */
  0x80, 0x27, 0xC1, 0xF0,	/*x         x  xxxxx     xxxxx    */
  0x88, 0x2B, 0xF7, 0xE0,	/*x   x     x x xxxxxx xxxxxx     */
  0x90, 0x2D, 0xF7, 0xC0,	/*x  x      x xx xxxxx xxxxx      */
  0xA5, 0x2E, 0xFF, 0x80,	/*x x  x x  x xxx xxxxxxxxx       */
  0x80, 0x2F, 0x7F, 0x00,	/*x         x xxxx xxxxxxx        */
  0xFF, 0xEF, 0xBE, 0x00,	/*xxxxxxxxxxx xxxxx xxxxx         */
  0x0A, 0x0F, 0xDC, 0x00,	/*    x x     xxxxxx xxx          */
  0x1F, 0x07, 0xE8, 0x00,	/*   xxxxx     xxxxxx x           */
  0x11, 0x03, 0xF0, 0x00,	/*   x   x      xxxxxx            */
  0x1F, 0x01, 0xE0, 0x00,	/*   xxxxx       xxxx             */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x03, 0xF0, 0x00,	/*              xxxxxx            */
  0x00, 0x07, 0xF8, 0x00,	/*             xxxxxxxx           */
  0x00, 0x0F, 0xFC, 0x00,	/*            xxxxxxxxxx          */
  0x00, 0x1F, 0xFE, 0x00,	/*           xxxxxxxxxxxx         */
  0x00, 0x3F, 0xFF, 0x00,	/*          xxxxxxxxxxxxxx        */
  0x00, 0x7F, 0xFF, 0x80,	/*         xxxxxxxxxxxxxxxx       */
  0x00, 0xFF, 0xFF, 0xC0,	/*        xxxxxxxxxxxxxxxxxx      */
  0x01, 0xFF, 0xFF, 0xE0,	/*       xxxxxxxxxxxxxxxxxxxx     */
  0x03, 0xFF, 0xFF, 0xF0,	/*      xxxxxxxxxxxxxxxxxxxxxx    */
  0x07, 0xFF, 0xFF, 0xF8,	/*     xxxxxxxxxxxxxxxxxxxxxxxx   */
  0x0F, 0xFF, 0xFF, 0xFC,	/*    xxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x1F, 0xFF, 0xFF, 0xFE,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0xFF, 0xFF, 0xFF, 0xFC,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xEF, 0xFF, 0xF0,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxx    */
  0xFF, 0xFF, 0xFF, 0xE0,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxx     */
  0xFF, 0xEF, 0xFF, 0xC0,	/*xxxxxxxxxxx xxxxxxxxxxxxxx      */
  0xFF, 0xFF, 0xFF, 0x80,	/*xxxxxxxxxxxxxxxxxxxxxxxxx       */
  0xFF, 0xEF, 0xFF, 0x00,	/*xxxxxxxxxxx xxxxxxxxxxxx        */
  0xFF, 0xFF, 0xFE, 0x00,	/*xxxxxxxxxxxxxxxxxxxxxxx         */
  0x0E, 0x0F, 0xFC, 0x00,	/*    xxx     xxxxxxxxxx          */
  0x1F, 0x07, 0xF8, 0x00,	/*   xxxxx     xxxxxxxx           */
  0x1F, 0x03, 0xF0, 0x00,	/*   xxxxx      xxxxxx            */
  0x1F, 0x01, 0xE0, 0x00,	/*   xxxxx       xxxx             */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 4, IBM RISC 6000 */
#ifdef PLATTER_ICON
  0x79, 0xFC, 0x3E, 0x3E,	/* xxxx  xxxxxxx    xxxxx   xxxxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFF, 0x3E, 0x3E,	/* xxxx  xxxxxxxxx  xxxxx   xxxxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xC3, 0x9E, 0x3C,	/*  xx    xx    xxx  xxxx   xxxx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xFF, 0x1E, 0x3C,	/*  xx    xxxxxxxx   xxxx   xxxx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xFF, 0x1B, 0x6C,	/*  xx    xxxxxxxx   xx xx xx xx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xC3, 0x9B, 0x6C,	/*  xx    xx    xxx  xx xx xx xx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFF, 0x39, 0xCE,	/* xxxx  xxxxxxxxx  xxx  xxx  xxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFC, 0x38, 0x8E,	/* xxxx  xxxxxxx    xxx   x   xxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x20, 0x00, 0x00, 0x04,	/*  x                          x  */
  0x1F, 0xFF, 0xFF, 0xF8,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x1F, 0xFF, 0xFF, 0xF8,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x79, 0xFC, 0x3E, 0x3E,	/* xxxx  xxxxxxx    xxxxx   xxxxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFF, 0x3E, 0x3E,	/* xxxx  xxxxxxxxx  xxxxx   xxxxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xC3, 0x9E, 0x3C,	/*  xx    xx    xxx  xxxx   xxxx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xFF, 0x1E, 0x3C,	/*  xx    xxxxxxxx   xxxx   xxxx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xFF, 0x1B, 0x6C,	/*  xx    xxxxxxxx   xx xx xx xx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x30, 0xC3, 0x9B, 0x6C,	/*  xx    xx    xxx  xx xx xx xx  */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFF, 0x39, 0xCE,	/* xxxx  xxxxxxxxx  xxx  xxx  xxx */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x79, 0xFC, 0x38, 0x8E,	/* xxxx  xxxxxxx    xxx   x   xxx */
  0x78, 0x00, 0x00, 0x00,	/* xxxx                           */
  0x84, 0x00, 0x00, 0x00,	/*x    x                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFC, 0x00, 0x00, 0x00,	/*xxxxxx                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 5, Digital/VAX/ULTRIX */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xeb, 0xbe, 0xee, 0xf5,	/*xxx x xxx xxxxx xxx xxx xxxx x x*/
  0xea, 0xbe, 0xaa, 0xf5,	/*xxx x x x xxxxx x x x x xxxx x x*/
  0xeb, 0xbe, 0xea, 0x95,	/*xxx x xxx xxxxx xxx x x x  x x x*/
  0x8a, 0xa2, 0xa0, 0xe5,	/*x   x x x x   x x x     xxx  x x*/
  0xaa, 0xaa, 0xaa, 0x85,	/*x x x x x x x x x x x x x    x x*/
  0xaa, 0xaa, 0xaa, 0xa5,	/*x x x x x x x x x x x x x x  x x*/
  0x8a, 0xa2, 0xac, 0x85,	/*x   x x x x   x x x xx  x    x x*/
  0xfb, 0xba, 0xee, 0xf7,	/*xxxxx xxx xxx x xxx xxx xxxx xxx*/
  0xfb, 0xba, 0xee, 0xf7,	/*xxxxx xxx xxx x xxx xxx xxxx xxx*/
  0xfb, 0xa6, 0xee, 0xf7,	/*xxxxx xxx x  xx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x00, 0x00, 0x02,	/* x                            x */
  0x3f, 0xff, 0xff, 0xfc,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x02, 0x20,	/*                      x   x     */
  0x00, 0x00, 0x02, 0x20,	/*                      x   x     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x02, 0xa0,	/*                      x x x     */
  0xff, 0xff, 0xfc, 0x9f,	/*xxxxxxxxxxxxxxxxxxxxxx  x  xxxxx*/
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0xff, 0xff, 0xfe, 0x3f,	/*xxxxxxxxxxxxxxxxxxxxxxx   xxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7f, 0xff, 0xff, 0xfe,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3f, 0xff, 0xff, 0xfc,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xff, 0xff, 0xff, 0x7f,	/*xxxxxxxxxxxxxxxxxxxxxxxx xxxxxxx*/
  0xff, 0xff, 0xfe, 0x3f,	/*xxxxxxxxxxxxxxxxxxxxxxx   xxxxxx*/
#else PLATTER_ICON
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xeb, 0xbe, 0xee, 0xf5,	/*xxx x xxx xxxxx xxx xxx xxxx x x*/
  0xea, 0xbe, 0xaa, 0xf5,	/*xxx x x x xxxxx x x x x xxxx x x*/
  0xeb, 0xbe, 0xea, 0x95,	/*xxx x xxx xxxxx xxx x x x  x x x*/
  0x8a, 0xa2, 0xa0, 0xe5,	/*x   x x x x   x x x     xxx  x x*/
  0xaa, 0xaa, 0xaa, 0x85,	/*x x x x x x x x x x x x x    x x*/
  0xaa, 0xaa, 0xaa, 0xa5,	/*x x x x x x x x x x x x x x  x x*/
  0x8a, 0xa2, 0xac, 0x85,	/*x   x x x x   x x x xx  x    x x*/
  0xfb, 0xba, 0xee, 0xf7,	/*xxxxx xxx xxx x xxx xxx xxxx xxx*/
  0xfb, 0xba, 0xee, 0xf7,	/*xxxxx xxx xxx x xxx xxx xxxx xxx*/
  0xfb, 0xa6, 0xee, 0xf7,	/*xxxxx xxx x  xx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x78, 0x00, 0x00, 0x00,	/* xxxx                           */
  0x84, 0x00, 0x00, 0x00,	/*x    x                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0xfb, 0xbe, 0xee, 0xf7,	/*xxxxx xxx xxxxx xxx xxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x78, 0x00, 0x00, 0x00,	/* xxxx                           */
  0xFC, 0x00, 0x00, 0x00,	/*xxxxxx                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 6, Apple A/UX */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x06, 0x00,	/*                     xx         */
  0x00, 0x00, 0x0C, 0x00,	/*                    xx          */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x07, 0x99, 0xC0,	/*             xxxx  xx  xxx      */
  0x00, 0x0F, 0xDB, 0xE0,	/*            xxxxxx xx xxxxx     */
  0x00, 0x1F, 0xFF, 0xF0,	/*           xxxxxxxxxxxxxxxxx    */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x7F, 0xFF, 0xE0,	/*         xxxxxxxxxxxxxxxxxx     */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xE0,	/*          xxxxxxxxxxxxxxxxx     */
  0x00, 0x3F, 0xFF, 0xFC,	/*          xxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x1F, 0xFF, 0xFC,	/*           xxxxxxxxxxxxxxxxxxx  */
  0x00, 0x1F, 0xFF, 0xF8,	/*           xxxxxxxxxxxxxxxxxx   */
  0x00, 0x0F, 0xFF, 0xF0,	/*            xxxxxxxxxxxxxxxx    */
  0x00, 0x03, 0xFF, 0xE0,	/*              xxxxxxxxxxxxx     */
  0x00, 0x01, 0xEF, 0xC0,	/*               xxxx xxxxxx      */
  0x00, 0x00, 0xC7, 0x00,	/*                xx   xxx        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x00, 0x00, 0x02,	/* x                            x */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x06, 0x00,	/*                     xx         */
  0x00, 0x00, 0x0C, 0x00,	/*                    xx          */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x07, 0x99, 0xC0,	/*             xxxx  xx  xxx      */
  0x00, 0x0F, 0xDB, 0xE0,	/*            xxxxxx xx xxxxx     */
  0x00, 0x1F, 0xFF, 0xF0,	/*           xxxxxxxxxxxxxxxxx    */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x7F, 0xFF, 0xE0,	/*         xxxxxxxxxxxxxxxxxx     */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xE0,	/*          xxxxxxxxxxxxxxxxx     */
  0x00, 0x3F, 0xFF, 0xFC,	/*          xxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x1F, 0xFF, 0xFC,	/*           xxxxxxxxxxxxxxxxxxx  */
  0x00, 0x1F, 0xFF, 0xF8,	/*           xxxxxxxxxxxxxxxxxx   */
  0x00, 0x0F, 0xFF, 0xF0,	/*            xxxxxxxxxxxxxxxx    */
  0x00, 0x03, 0xFF, 0xE0,	/*              xxxxxxxxxxxxx     */
  0x00, 0x01, 0xEF, 0xC0,	/*               xxxx xxxxxx      */
  0x00, 0x00, 0xC7, 0x00,	/*                xx   xxx        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x06, 0x00,	/*                     xx         */
  0x00, 0x00, 0x0C, 0x00,	/*                    xx          */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x07, 0x99, 0xC0,	/*             xxxx  xx  xxx      */
  0x00, 0x0F, 0xDB, 0xE0,	/*            xxxxxx xx xxxxx     */
  0x00, 0x1F, 0xFF, 0xF0,	/*           xxxxxxxxxxxxxxxxx    */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x7F, 0xFF, 0xE0,	/*         xxxxxxxxxxxxxxxxxx     */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xE0,	/*          xxxxxxxxxxxxxxxxx     */
  0x00, 0x3F, 0xFF, 0xFC,	/*          xxxxxxxxxxxxxxxxxxxx  */
  0x78, 0x1F, 0xFF, 0xFC,	/* xxxx      xxxxxxxxxxxxxxxxxxx  */
  0x84, 0x1F, 0xFF, 0xF8,	/*x    x     xxxxxxxxxxxxxxxxxx   */
  0xFF, 0xEF, 0xFF, 0xF0,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxx    */
  0x80, 0x23, 0xFF, 0xE0,	/*x         x   xxxxxxxxxxxxx     */
  0x88, 0x21, 0xEF, 0xC0,	/*x   x     x    xxxx xxxxxx      */
  0x90, 0x20, 0xC7, 0x00,	/*x  x      x     xx   xxx        */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x06, 0x00,	/*                     xx         */
  0x00, 0x00, 0x0C, 0x00,	/*                    xx          */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x07, 0x99, 0xC0,	/*             xxxx  xx  xxx      */
  0x00, 0x0F, 0xDB, 0xE0,	/*            xxxxxx xx xxxxx     */
  0x00, 0x1F, 0xFF, 0xF0,	/*           xxxxxxxxxxxxxxxxx    */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x3F, 0xFF, 0xF8,	/*          xxxxxxxxxxxxxxxxxxx   */
  0x00, 0x7F, 0xFF, 0xE0,	/*         xxxxxxxxxxxxxxxxxx     */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x7F, 0xFF, 0xC0,	/*         xxxxxxxxxxxxxxxxx      */
  0x00, 0x3F, 0xFF, 0xE0,	/*          xxxxxxxxxxxxxxxxx     */
  0x00, 0x3F, 0xFF, 0xFC,	/*          xxxxxxxxxxxxxxxxxxxx  */
  0x78, 0x1F, 0xFF, 0xFC,	/* xxxx      xxxxxxxxxxxxxxxxxxx  */
  0xFC, 0x0F, 0xFF, 0xF8,	/*xxxxxx      xxxxxxxxxxxxxxxxx   */
  0xFF, 0xE7, 0xFF, 0xF0,	/*xxxxxxxxxxx  xxxxxxxxxxxxxxx    */
  0xFF, 0xE3, 0xFF, 0xE0,	/*xxxxxxxxxxx   xxxxxxxxxxxxx     */
  0xFF, 0xE1, 0xEF, 0xC0,	/*xxxxxxxxxxx    xxxx xxxxxx      */
  0xFF, 0xE0, 0xC7, 0x00,	/*xxxxxxxxxxx     xx   xxx        */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 7, Silicon Graphics/IRIX */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x06, 0xC1, 0xCE,	/*             xx xx     xxx  xxx */
  0x00, 0x0E, 0xE2, 0x10,	/*            xxx xxx   x    x    */
  0x00, 0x1A, 0xB1, 0xD6,	/*           xx x x xx   xxx x xx */
  0x00, 0x32, 0x98, 0x52,	/*          xx  x x  xx    x x  x */
  0x00, 0x32, 0x9B, 0x8E,	/*          xx  x x  xx xxx   xxx */
  0x00, 0xDA, 0xB6, 0x00,	/*        xx xx x x xx xx         */
  0x01, 0xEE, 0xEF, 0x00,	/*       xxxx xxx xxx xxxx        */
  0x01, 0xB7, 0xDB, 0x00,	/*       xx xx xxxxx xx xx        */
  0x01, 0x9F, 0xF3, 0x00,	/*       xx  xxxxxxxxx  xx        */
  0x01, 0x9F, 0xF3, 0x00,	/*       xx  xxxxxxxxx  xx        */
  0x01, 0xB7, 0xDB, 0x00,	/*       xx xx xxxxx xx xx        */
  0x01, 0xEE, 0xEF, 0x00,	/*       xxxx xxx xxx xxxx        */
  0x00, 0xDA, 0xB6, 0x00,	/*        xx xx x x xx xx         */
  0x00, 0x32, 0x98, 0x00,	/*          xx  x x  xx           */
  0x00, 0x32, 0x98, 0x00,	/*          xx  x x  xx           */
  0x00, 0x1A, 0xB0, 0x00,	/*           xx x x xx            */
  0x00, 0x0E, 0xE0, 0x00,	/*            xxx xxx             */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x00, 0x00, 0x02,	/* x                            x */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x0F, 0xFF,	/*                    xxxxxxxxxxxx*/
  0x00, 0x07, 0xCF, 0xFF,	/*             xxxxx  xxxxxxxxxxxx*/
  0x00, 0x0F, 0xEF, 0xFF,	/*            xxxxxxx xxxxxxxxxxxx*/
  0x00, 0x1F, 0xF7, 0xFF,	/*           xxxxxxxxx xxxxxxxxxxx*/
  0x00, 0x3F, 0xFB, 0xFF,	/*          xxxxxxxxxxx xxxxxxxxxx*/
  0x00, 0x7F, 0xFD, 0xFF,	/*         xxxxxxxxxxxxx xxxxxxxxx*/
  0x00, 0xFF, 0xFE, 0xFF,	/*        xxxxxxxxxxxxxxx xxxxxxxx*/
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x00, 0xFF, 0xFE, 0x00,	/*        xxxxxxxxxxxxxxx         */
  0x00, 0x7F, 0xFC, 0x00,	/*         xxxxxxxxxxxxx          */
  0x00, 0x3F, 0xF8, 0x00,	/*          xxxxxxxxxxx           */
  0x00, 0x1F, 0xF0, 0x00,	/*           xxxxxxxxx            */
  0x00, 0x0F, 0xE0, 0x00,	/*            xxxxxxx             */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x06, 0xC1, 0xCE,	/*             xx xx     xxx  xxx */
  0x00, 0x0E, 0xE2, 0x10,	/*            xxx xxx   x    x    */
  0x00, 0x1A, 0xB1, 0xD6,	/*           xx x x xx   xxx x xx */
  0x00, 0x32, 0x98, 0x52,	/*          xx  x x  xx    x x  x */
  0x00, 0x32, 0x9B, 0x8E,	/*          xx  x x  xx xxx   xxx */
  0x00, 0xDA, 0xB6, 0x00,	/*        xx xx x x xx xx         */
  0x01, 0xEE, 0xEF, 0x00,	/*       xxxx xxx xxx xxxx        */
  0x01, 0xB7, 0xDB, 0x00,	/*       xx xx xxxxx xx xx        */
  0x01, 0x9F, 0xF3, 0x00,	/*       xx  xxxxxxxxx  xx        */
  0x01, 0x9F, 0xF3, 0x00,	/*       xx  xxxxxxxxx  xx        */
  0x01, 0xB7, 0xDB, 0x00,	/*       xx xx xxxxx xx xx        */
  0x01, 0xEE, 0xEF, 0x00,	/*       xxxx xxx xxx xxxx        */
  0x00, 0xDA, 0xB6, 0x00,	/*        xx xx x x xx xx         */
  0x00, 0x32, 0x98, 0x00,	/*          xx  x x  xx           */
  0x78, 0x32, 0x98, 0x00,	/* xxxx     xx  x x  xx           */
  0x84, 0x1A, 0xB0, 0x00,	/*x    x     xx x x xx            */
  0xFF, 0xEE, 0xE0, 0x00,	/*xxxxxxxxxxx xxx xxx             */
  0x80, 0x26, 0xC0, 0x00,	/*x         x  xx xx              */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x0F, 0xFF,	/*                    xxxxxxxxxxxx*/
  0x00, 0x07, 0xCF, 0xFF,	/*             xxxxx  xxxxxxxxxxxx*/
  0x00, 0x0F, 0xEF, 0xFF,	/*            xxxxxxx xxxxxxxxxxxx*/
  0x00, 0x1F, 0xF7, 0xFF,	/*           xxxxxxxxx xxxxxxxxxxx*/
  0x00, 0x3F, 0xFB, 0xFF,	/*          xxxxxxxxxxx xxxxxxxxxx*/
  0x00, 0x7F, 0xFD, 0xFF,	/*         xxxxxxxxxxxxx xxxxxxxxx*/
  0x00, 0xFF, 0xFE, 0xFF,	/*        xxxxxxxxxxxxxxx xxxxxxxx*/
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x01, 0xFF, 0xFF, 0x00,	/*       xxxxxxxxxxxxxxxxx        */
  0x00, 0xFF, 0xFE, 0x00,	/*        xxxxxxxxxxxxxxx         */
  0x00, 0x7F, 0xFC, 0x00,	/*         xxxxxxxxxxxxx          */
  0x78, 0x3F, 0xF8, 0x00,	/* xxxx     xxxxxxxxxxx           */
  0xFC, 0x1F, 0xF0, 0x00,	/*xxxxxx     xxxxxxxxx            */
  0xFF, 0xEF, 0xE0, 0x00,	/*xxxxxxxxxxx xxxxxxx             */
  0xFF, 0xE7, 0xC0, 0x00,	/*xxxxxxxxxxx  xxxxx              */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 8, Encore MultiMax */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x00, 0x00, 0x03,	/*                              xx*/
  0xDF, 0xFF, 0xFF, 0xFB,	/*xx xxxxxxxxxxxxxxxxxxxxxxxxxx xx*/
  0xD1, 0x68, 0x88, 0x8B,	/*xx x   x xx x   x   x   x   x xx*/
  0xD7, 0x2B, 0xAA, 0xBB,	/*xx x xxx  x x xxx x x x x xxx xx*/
  0xD1, 0x0B, 0xA8, 0x8B,	/*xx x   x    x xxx x x   x   x xx*/
  0xD7, 0x4B, 0xAA, 0xBB,	/*xx x xxx x  x xxx x x x x xxx xx*/
  0xD1, 0x68, 0x8A, 0x8B,	/*xx x   x xx x   x   x x x   x xx*/
  0xDF, 0xFF, 0xFF, 0xFB,	/*xx xxxxxxxxxxxxxxxxxxxxxxxxxx xx*/
  0xC0, 0x00, 0x00, 0x00,	/*xx                              */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x00, 0x00, 0x02,	/* x                            x */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x08, 0x80,	/*                    x   x       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0A, 0x80,	/*                    x x x       */
  0xFF, 0xFF, 0xF2, 0x7F,	/*xxxxxxxxxxxxxxxxxxxx  x  xxxxxxx*/
  0x00, 0x00, 0x05, 0x00,	/*                     x x        */
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFF,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFC,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x07, 0x00,	/*                     xxx        */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0x00, 0x00, 0x0F, 0x80,	/*                    xxxxx       */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFD, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxx*/
  0xFF, 0xFF, 0xF8, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxx   xxxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x00, 0x00, 0x03,	/*                              xx*/
  0xDF, 0xFF, 0xFF, 0xFB,	/*xx xxxxxxxxxxxxxxxxxxxxxxxxxx xx*/
  0xD1, 0x68, 0x88, 0x8B,	/*xx x   x xx x   x   x   x   x xx*/
  0xD7, 0x2B, 0xAA, 0xBB,	/*xx x xxx  x x xxx x x x x xxx xx*/
  0xD1, 0x0B, 0xA8, 0x8B,	/*xx x   x    x xxx x x   x   x xx*/
  0xD7, 0x4B, 0xAA, 0xBB,	/*xx x xxx x  x xxx x x x x xxx xx*/
  0xD1, 0x68, 0x8A, 0x8B,	/*xx x   x xx x   x   x x x   x xx*/
  0xDF, 0xFF, 0xFF, 0xFB,	/*xx xxxxxxxxxxxxxxxxxxxxxxxxxx xx*/
  0xC0, 0x00, 0x00, 0x00,	/*xx                              */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x7C, 0x00, 0x00, 0x00,	/* xxxxx                          */
  0x82, 0x00, 0x00, 0x00,	/*x     x                         */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x1F, 0xFF, 0xFF, 0xFF,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3F, 0xFF, 0xFF, 0xFF,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFC,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0xFF, 0xFF, 0xFF, 0xF8,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxx   */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x7C, 0x00, 0x00, 0x00,	/* xxxxx                          */
  0xFE, 0x00, 0x00, 0x00,	/*xxxxxxx                         */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

/* Start of contributed ICN# range */

  /* ICON 9, SPARCStation */
  0x00, 0x00, 0x00, 0xc0,	/*                        xx      */
  0x00, 0x00, 0x01, 0x80,	/*                       xx       */
  0x00, 0x00, 0x03, 0x04,	/*                      xx     x  */
  0x00, 0x00, 0x06, 0x1c,	/*                     xx    xxx  */
  0x00, 0x00, 0x0c, 0x98,	/*                    xx  x  xx   */
  0x00, 0x00, 0x19, 0xeb,	/*                   xx  xxxx x xx*/
  0x00, 0x00, 0x13, 0xfa,	/*                   x  xxxxxxx x */
  0x00, 0x00, 0x27, 0x9e,	/*                  x  xxxx  xxxx */
  0x00, 0x00, 0x2c, 0x00,	/*                  x xx          */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x80, 0x00,	/*                x               */
  0x00, 0x01, 0x00, 0x00,	/*               x                */
  0x00, 0x03, 0x80, 0x00,	/*              xxx               */
  0x00, 0x01, 0x3f, 0x52,	/*               x  xxxxxx x x  x */
  0x78, 0x02, 0x40, 0x55,	/* xxxx         x  x       x x x x*/
  0x84, 0x04, 0x3f, 0x55,	/*x    x       x    xxxxxx x x x x*/
  0xff, 0xe0, 0x00, 0x55,	/*xxxxxxxxxxx              x x x x*/
  0x80, 0x20, 0x7e, 0x55,	/*x         x      xxxxxx  x x x x*/
  0x88, 0x20, 0x01, 0x25,	/*x   x     x            x  x  x x*/
  0x90, 0x20, 0x7e, 0x00,	/*x  x      x      xxxxxx         */
  0xa5, 0x20, 0x00, 0x3f,	/*x x  x x  x               xxxxxx*/
  0x80, 0x20, 0x52, 0x40,	/*x         x      x x  x  x      */
  0xff, 0xe0, 0x55, 0x3f,	/*xxxxxxxxxxx      x x x x  xxxxxx*/
  0x0a, 0x00, 0x55, 0x00,	/*    x x          x x x x        */
  0x1f, 0x00, 0x55, 0x7e,	/*   xxxxx         x x x x xxxxxx */
  0x11, 0x00, 0x55, 0x01,	/*   x   x         x x x x       x*/
  0x1f, 0x00, 0x25, 0x7e,	/*   xxxxx          x  x x xxxxxx */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xe4, 0xff, 0xff, 0xff,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0a, 0x00, 0x00, 0x00,	/*    x x                         */
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* Mask */
  0x00, 0x00, 0x00, 0xff,	/*                        xxxxxxxx*/
  0x00, 0x00, 0x01, 0xff,	/*                       xxxxxxxxx*/
  0x00, 0x00, 0x03, 0xff,	/*                      xxxxxxxxxx*/
  0x00, 0x00, 0x07, 0xff,	/*                     xxxxxxxxxxx*/
  0x00, 0x00, 0x0f, 0xff,	/*                    xxxxxxxxxxxx*/
  0x00, 0x00, 0x1f, 0xff,	/*                   xxxxxxxxxxxxx*/
  0x00, 0x00, 0x1f, 0xfe,	/*                   xxxxxxxxxxxx */
  0x00, 0x00, 0x3f, 0x9e,	/*                  xxxxxxx  xxxx */
  0x00, 0x00, 0x3c, 0x00,	/*                  xxxx          */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0xc0, 0x00,	/*                xx              */
  0x00, 0x01, 0xc0, 0x00,	/*               xxx              */
  0x00, 0x03, 0xc0, 0x00,	/*              xxxx              */
  0x00, 0x07, 0xc0, 0x00,	/*             xxxxx              */
  0x00, 0x07, 0xbf, 0xfe,	/*             xxxx xxxxxxxxxxxxx */
  0x78, 0x07, 0x7f, 0xff,	/* xxxx        xxx xxxxxxxxxxxxxxx*/
  0xfc, 0x0e, 0x7f, 0xff,	/*xxxxxx      xxx  xxxxxxxxxxxxxxx*/
  0xff, 0xec, 0x7f, 0xff,	/*xxxxxxxxxxx xx   xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0xff, 0xe0, 0x7f, 0xff,	/*xxxxxxxxxxx      xxxxxxxxxxxxxxx*/
  0x0e, 0x00, 0x7f, 0xff,	/*    xxx          xxxxxxxxxxxxxxx*/
  0x1f, 0x00, 0x7f, 0xff,	/*   xxxxx         xxxxxxxxxxxxxxx*/
  0x1f, 0x00, 0x7f, 0xff,	/*   xxxxx         xxxxxxxxxxxxxxx*/
  0x1f, 0x00, 0x3f, 0xfe,	/*   xxxxx          xxxxxxxxxxxxx */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xfb, 0xff, 0xff, 0xff,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/

  /* ICON 10, original SUN */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x0a, 0x40,	/*                    x x  x      */
  0x00, 0x00, 0x29, 0x40,	/*                  x x  x x      */
  0x00, 0x01, 0xa5, 0x20,	/*               xx x  x x  x     */
  0x00, 0x06, 0x14, 0xa0,	/*             xx    x x  x x     */
  0x00, 0x18, 0x52, 0x90,	/*           xx    x x  x x  x    */
  0x00, 0x61, 0x8a, 0x40,	/*         xx    xx   x x  x      */
  0x00, 0x86, 0x09, 0x08,	/*        x    xx     x  x    x   */
  0x00, 0x98, 0xe6, 0x30,	/*        x  xx   xxx  xx   xx    */
  0x00, 0x63, 0x10, 0xc0,	/*         xx   xx   x    xx      */
  0x00, 0x0c, 0x63, 0x0c,	/*            xx   xx   xx    xx  */
  0x00, 0x31, 0x8c, 0x30,	/*          xx   xx   xx    xx    */
  0x00, 0x06, 0x08, 0xc6,	/*             xx     x   xx   xx */
  0x00, 0x18, 0xe7, 0x1a,	/*           xx   xxx  xxx   xx x */
  0x78, 0x02, 0x90, 0x62,	/* xxxx         x x  x     xx   x */
  0x84, 0x0a, 0x51, 0x84,	/*x    x      x x  x x   xx    x  */
  0xff, 0xe9, 0x4a, 0x18,	/*xxxxxxxxxxx x  x x  x x    xx   */
  0x80, 0x45, 0x28, 0x60,	/*x         x  x x  x x    xx     */
  0x88, 0x44, 0xa5, 0x80,	/*x   x     x  x  x x  x xx       */
  0x90, 0x42, 0x94, 0x00,	/*x  x      x   x x  x x          */
  0xa5, 0x42, 0x50, 0x00,	/*x x  x x  x   x  x x            */
  0x80, 0x41, 0xc0, 0x00,	/*x         x    xxx              */
  0xff, 0xe0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0a, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xe4, 0xff, 0xff, 0xff,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0a, 0x00, 0x00, 0x00,	/*    x x                         */
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* Mask */
  0x00, 0x00, 0x07, 0xc0,	/*                     xxxxx      */
  0x00, 0x00, 0x1f, 0xc0,	/*                   xxxxxxx      */
  0x00, 0x00, 0x7f, 0xe0,	/*                 xxxxxxxxxx     */
  0x00, 0x01, 0xff, 0xf0,	/*               xxxxxxxxxxxxx    */
  0x00, 0x07, 0xff, 0xf0,	/*             xxxxxxxxxxxxxxx    */
  0x00, 0x1f, 0xff, 0xf8,	/*           xxxxxxxxxxxxxxxxxx   */
  0x00, 0x7f, 0xff, 0xf8,	/*         xxxxxxxxxxxxxxxxxxxx   */
  0x01, 0xff, 0xff, 0xfc,	/*       xxxxxxxxxxxxxxxxxxxxxxx  */
  0x01, 0xff, 0xff, 0xfc,	/*       xxxxxxxxxxxxxxxxxxxxxxx  */
  0x01, 0xff, 0xff, 0xfe,	/*       xxxxxxxxxxxxxxxxxxxxxxxx */
  0x00, 0xff, 0xff, 0xfe,	/*        xxxxxxxxxxxxxxxxxxxxxxx */
  0x00, 0xff, 0xff, 0xfe,	/*        xxxxxxxxxxxxxxxxxxxxxxx */
  0x00, 0x7f, 0xff, 0xff,	/*         xxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x7f, 0xff, 0xff,	/*         xxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x3f, 0xff, 0xff,	/*          xxxxxxxxxxxxxxxxxxxxxx*/
  0x78, 0x3f, 0xff, 0xff,	/* xxxx     xxxxxxxxxxxxxxxxxxxxxx*/
  0xfc, 0x1f, 0xff, 0xff,	/*xxxxxx     xxxxxxxxxxxxxxxxxxxxx*/
  0xff, 0xff, 0xff, 0xfe,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0xff, 0xef, 0xff, 0xf8,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxxx   */
  0xff, 0xef, 0xff, 0xe0,	/*xxxxxxxxxxx xxxxxxxxxxxxxxx     */
  0xff, 0xef, 0xff, 0x80,	/*xxxxxxxxxxx xxxxxxxxxxxxx       */
  0xff, 0xe7, 0xfc, 0x00,	/*xxxxxxxxxxx  xxxxxxxxx          */
  0xff, 0xe7, 0xf0, 0x00,	/*xxxxxxxxxxx  xxxxxxx            */
  0xff, 0xe3, 0xc0, 0x00,	/*xxxxxxxxxxx   xxxx              */
  0x0e, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xfb, 0xff, 0xff, 0xff,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/

  /* ICON 11, original NeXT */
  0x00, 0x00, 0x00, 0xc0,	/*                        xx      */
  0x00, 0x00, 0x03, 0xc0,	/*                      xxxx      */
  0x00, 0x00, 0x0f, 0xe0,	/*                    xxxxxxx     */
  0x00, 0x00, 0x3c, 0xe0,	/*                  xxxx  xxx     */
  0x00, 0x00, 0xfa, 0x70,	/*                xxxxx x  xxx    */
  0x00, 0x03, 0xd8, 0xf0,	/*              xxx xxx   xxxx    */
  0x00, 0x0f, 0xcb, 0xd8,	/*            xxxxx x x  xx xxx   */
  0x00, 0x0e, 0x6c, 0x38,	/*            xxx  xx xx    xxx   */
  0x00, 0x1b, 0x07, 0xec,	/*           xx xx     xxxxxx xx  */
  0x00, 0x1b, 0xb7, 0x8c,	/*           xx xxx xx xxxx   xx  */
  0x00, 0x3d, 0x9d, 0x1e,	/*          xxxx xx  xxx x   xxxx */
  0x00, 0x3d, 0xfd, 0xce,	/*          xxxx xxxxxxx xxx  xxx */
  0x00, 0x1e, 0xc1, 0xef,	/*           xxxx xx     xxxx xxxx*/
  0x00, 0x1e, 0xf0, 0xfd,	/*           xxxx xxxx    xxxxxx x*/
  0x00, 0x0f, 0x77, 0xf3,	/*            xxxx xxx xxxxxxx  xx*/
  0x78, 0x0f, 0x77, 0xce,	/* xxxx       xxxx xxx xxxxx  xxx */
  0x84, 0x07, 0xbf, 0x3e,	/*x    x       xxxx xxxxxx  xxxxx */
  0xff, 0xe7, 0xbc, 0xfc,	/*xxxxxxxxxxx  xxxx xxxx  xxxxxx  */
  0x80, 0x23, 0xd3, 0xf0,	/*x         x   xxxx x  xxxxxx    */
  0x88, 0x23, 0xcf, 0xc0,	/*x   x     x   xxxx  xxxxxx      */
  0x90, 0x21, 0xdf, 0x00,	/*x  x      x    xxx xxxxx        */
  0xa5, 0x21, 0xbc, 0x00,	/*x x  x x  x    xx xxxx          */
  0x80, 0x20, 0xb0, 0x00,	/*x         x     x xx            */
  0xff, 0xe0, 0xc0, 0x00,	/*xxxxxxxxxxx     xx              */
  0x0a, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xe4, 0xff, 0xff, 0xff,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0a, 0x00, 0x00, 0x00,	/*    x x                         */
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* Mask */
  0x00, 0x00, 0x01, 0xe0,	/*                       xxxx     */
  0x00, 0x00, 0x07, 0xe0,	/*                     xxxxxx     */
  0x00, 0x00, 0x1f, 0xf0,	/*                   xxxxxxxxx    */
  0x00, 0x00, 0x7f, 0xf0,	/*                 xxxxxxxxxxx    */
  0x00, 0x01, 0xff, 0xf8,	/*               xxxxxxxxxxxxxx   */
  0x00, 0x07, 0xff, 0xf8,	/*             xxxxxxxxxxxxxxxx   */
  0x00, 0x1f, 0xff, 0xfc,	/*           xxxxxxxxxxxxxxxxxxx  */
  0x00, 0x1f, 0xff, 0xfc,	/*           xxxxxxxxxxxxxxxxxxx  */
  0x00, 0x3f, 0xff, 0xfe,	/*          xxxxxxxxxxxxxxxxxxxxx */
  0x00, 0x3f, 0xff, 0xfe,	/*          xxxxxxxxxxxxxxxxxxxxx */
  0x00, 0x7f, 0xff, 0xff,	/*         xxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x7f, 0xff, 0xff,	/*         xxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x3f, 0xff, 0xff,	/*          xxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x3f, 0xff, 0xff,	/*          xxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x1f, 0xff, 0xff,	/*           xxxxxxxxxxxxxxxxxxxxx*/
  0x78, 0x1f, 0xff, 0xff,	/* xxxx      xxxxxxxxxxxxxxxxxxxxx*/
  0xfc, 0x0f, 0xff, 0xff,	/*xxxxxx      xxxxxxxxxxxxxxxxxxxx*/
  0xff, 0xef, 0xff, 0xfe,	/*xxxxxxxxxxx xxxxxxxxxxxxxxxxxxx */
  0xff, 0xe7, 0xff, 0xf8,	/*xxxxxxxxxxx  xxxxxxxxxxxxxxxx   */
  0xff, 0xe7, 0xff, 0xc8,	/*xxxxxxxxxxx  xxxxxxxxxxxxxx     */
  0xff, 0xe3, 0xff, 0x80,	/*xxxxxxxxxxx   xxxxxxxxxxx       */
  0xff, 0xe3, 0xfe, 0x00,	/*xxxxxxxxxxx   xxxxxxxxx         */
  0xff, 0xe1, 0xf8, 0x00,	/*xxxxxxxxxxx    xxxxxx           */
  0xff, 0xe1, 0xe0, 0x00,	/*xxxxxxxxxxx    xxxx             */
  0x0e, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1f, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xfb, 0xff, 0xff, 0xff,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xf1, 0xff, 0xff, 0xff,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/

  /* ICON 12, gould */
#ifdef PLATTER_ICON
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc1, 0xf0,	/*     xxxxxxxxxxxxx     xxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x7f, 0xff, 0xff, 0xff,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x20, 0x00, 0x00, 0x02,	/*  x                           x */
  0x1f, 0xff, 0xff, 0xfc,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x02, 0x20,	/*                      x   x     */
  0x00, 0x00, 0x02, 0x20,	/*                      x   x     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x02, 0xa0,	/*                      x x x     */
  0xff, 0xff, 0xfc, 0x9f,	/*xxxxxxxxxxxxxxxxxxxxxx  x  xxxxx*/
  0x00, 0x00, 0x01, 0x40,	/*                       x x      */
  0xff, 0xff, 0xfe, 0x3f,	/*xxxxxxxxxxxxxxxxxxxxxxx   xxxxxx*/
  /* Mask */
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc1, 0xf0,	/*     xxxxxxxxxxxxx     xxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x7f, 0xff, 0xff, 0xff,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x3f, 0xff, 0xff, 0xfe,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x1f, 0xff, 0xff, 0xfc,	/*   xxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x01, 0xc0,	/*                       xxx      */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0x00, 0x00, 0x03, 0xe0,	/*                      xxxxx     */
  0xff, 0xff, 0xff, 0xff,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xff, 0xff, 0xff, 0x7f,	/*xxxxxxxxxxxxxxxxxxxxxxxx xxxxxxx*/
  0xff, 0xff, 0xfe, 0x3f,	/*xxxxxxxxxxxxxxxxxxxxxxx   xxxxxx*/
#else  PLATTER_ICON
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc1, 0xf0,	/*     xxxxxxxxxxxxx     xxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x78, 0x00, 0x78, 0x00,	/* xxxx            xxxx           */
  0x84, 0x00, 0xf8, 0x00,	/*x    x          xxxxx           */
  0xff, 0xe1, 0xf8, 0x00,	/*xxxxxxxxxxx    xxxxxx           */
  0x80, 0x23, 0xf8, 0x00,	/*x         x   xxxxxxx           */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* Mask */
  0x00, 0x03, 0xf8, 0x00,	/*              xxxxxxx           */
  0x00, 0x01, 0xf8, 0x00,	/*               xxxxxx           */
  0x00, 0x00, 0xf8, 0x00,	/*                xxxxx           */
  0x00, 0x00, 0x78, 0x00,	/*                 xxxx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc1, 0xf0,	/*     xxxxxxxxxxxxx     xxxxx    */
  0x07, 0xff, 0xc3, 0xf0,	/*     xxxxxxxxxxxxx    xxxxxx    */
  0x07, 0xff, 0xc7, 0xf0,	/*     xxxxxxxxxxxxx   xxxxxxx    */
  0x07, 0xff, 0xcf, 0xf0,	/*     xxxxxxxxxxxxx  xxxxxxxx    */
  0x00, 0x00, 0x18, 0x00,	/*                   xx           */
  0x00, 0x00, 0x38, 0x00,	/*                  xxx           */
  0x78, 0x00, 0x78, 0x00,	/* xxxx            xxxx           */
  0xfc, 0x00, 0xf8, 0x00,	/*xxxxxx          xxxxx           */
  0xff, 0xe1, 0xf8, 0x00,	/*xxxxxxxxxxx    xxxxxx           */
  0xff, 0xe3, 0xf8, 0x00,	/*xxxxxxxxxxx   xxxxxxx           */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

  /* ICON 13, original Digital/ULTRIX */
#ifdef PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xEA, 0xBD, 0x56, 0xF5,	/*xxx x x x xxxx x x x xx xxxx x x*/
  0xEB, 0xBD, 0xD2, 0xF5,	/*xxx x xxx xxxx xxx x  x xxxx x x*/
  0xCA, 0xA5, 0x56, 0xD5,	/*xx  x x x x  x x x x xx xx x x x*/
  0xAA, 0xA5, 0x56, 0x95,	/*x x x x x x  x x x x xx x  x x x*/
  0x8A, 0xB5, 0x56, 0x95,	/*x   x x x xx x x x x xx x  x x x*/
  0xFB, 0xA5, 0xDE, 0xF7,	/*xxxxx xxx x  x xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x40, 0x00, 0x00, 0x02,	/* x                            x */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0x00, 0x00, 0x04, 0x40,	/*                     x   x      */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0x00, 0x00, 0x05, 0x40,	/*                     x x x      */
  0xFF, 0xFF, 0xF9, 0x3F,	/*xxxxxxxxxxxxxxxxxxxxx  x  xxxxxx*/
  0x00, 0x00, 0x02, 0x80,	/*                      x x       */
  0xFF, 0xFF, 0xFC, 0x7F,	/*xxxxxxxxxxxxxxxxxxxxxx   xxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x7F, 0xFF, 0xFF, 0xFE,	/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx */
  0x3F, 0xFF, 0xFF, 0xFC,	/*  xxxxxxxxxxxxxxxxxxxxxxxxxxxx  */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x03, 0x80,	/*                      xxx       */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0x00, 0x00, 0x07, 0xC0,	/*                     xxxxx      */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFE, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxx xxxxxxxx*/
  0xFF, 0xFF, 0xFC, 0x7F,	/*xxxxxxxxxxxxxxxxxxxxxx   xxxxxxx*/
#else PLATTER_ICON
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xEA, 0xBD, 0x56, 0xF5,	/*xxx x x x xxxx x x x xx xxxx x x*/
  0xEB, 0xBD, 0xD2, 0xF5,	/*xxx x xxx xxxx xxx x  x xxxx x x*/
  0xCA, 0xA5, 0x56, 0xD5,	/*xx  x x x x  x x x x xx xx x x x*/
  0xAA, 0xA5, 0x56, 0x95,	/*x x x x x x  x x x x xx x  x x x*/
  0x8A, 0xB5, 0x56, 0x95,	/*x   x x x xx x x x x xx x  x x x*/
  0xFB, 0xA5, 0xDE, 0xF7,	/*xxxxx xxx x  x xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0xFB, 0xBD, 0xDE, 0xF7,	/*xxxxx xxx xxxx xxx xxxx xxxx xxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x78, 0x00, 0x00, 0x00,	/* xxxx                           */
  0x84, 0x00, 0x00, 0x00,	/*x    x                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0x88, 0x20, 0x00, 0x00,	/*x   x     x                     */
  0x90, 0x20, 0x00, 0x00,	/*x  x      x                     */
  0xA5, 0x20, 0x00, 0x00,	/*x x  x x  x                     */
  0x80, 0x20, 0x00, 0x00,	/*x         x                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x11, 0x00, 0x00, 0x00,	/*   x   x                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x15, 0x00, 0x00, 0x00,	/*   x x x                        */
  0xE4, 0xFF, 0xFF, 0xFF,	/*xxx  x  xxxxxxxxxxxxxxxxxxxxxxxx*/
  0x0A, 0x00, 0x00, 0x00,	/*    x x                         */
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
  /* MASK */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0x00, 0x00, 0x00, 0x00,	/*                                */
  0x78, 0x00, 0x00, 0x00,	/* xxxx                           */
  0xFC, 0x00, 0x00, 0x00,	/*xxxxxx                          */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0xFF, 0xE0, 0x00, 0x00,	/*xxxxxxxxxxx                     */
  0x0E, 0x00, 0x00, 0x00,	/*    xxx                         */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0x1F, 0x00, 0x00, 0x00,	/*   xxxxx                        */
  0xFF, 0xFF, 0xFF, 0xFF,	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xFB, 0xFF, 0xFF, 0xFF,	/*xxxxx xxxxxxxxxxxxxxxxxxxxxxxxxx*/
  0xF1, 0xFF, 0xFF, 0xFF,	/*xxxx   xxxxxxxxxxxxxxxxxxxxxxxxx*/
#endif PLATTER_ICON

};

export int aufsiconsize = ICONSIZE;
export byte *aufsicon = icons[INDEX];

