/* --------------------------------- mswin.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* general system-specific stuff for Microsoft WINDOWS.
 * Windows support by Michael Taylor miket@canb.auug.org.au
*/

#define STRICT
#include <windows.h>
#include <toolhelp.h>

#include "fly.h"

/* define USETOOLHELP if MS ever fox WinG to work with it! */

HANDLE		Fly8Instance;
char		FAR Fly8AppName[10]  = "Fly8";
char		FAR Fly8Message[15]  = "Fly8";

static FARPROC	procInst;
static char	_Gbuf[1024];

#if USETOOLHELP
WORD __export _cdecl
FaultHandler(WORD wES, WORD wDS, WORD wDI, WORD wSI, 
        WORD wBP, WORD wSP, WORD wBX, WORD wDX, WORD wCX, WORD wOldAX, 
        WORD wOldBP, WORD wRetIP, WORD wRetCS, WORD wRealAX,
        WORD wNumber, WORD wHandle, WORD wIP, WORD wCS, WORD wFlags)
{
	static WORD wReentry;

/* See if we're already here.  If so, tell routine to chain on
*/
	if (wReentry)
		return 2;
	wReentry = 1;

/* If this was a CtlAltSysRq interrupt, just restart the instr.
*/
	if (wNumber == INT_CTLALTSYSRQ) {
		wsprintf(_Gbuf, "CtlAltSysRq at %04X:%04X\r\n", wCS, wIP);
		LogPrintf (_Gbuf);
		wReentry = 0;
		return 1;
	}
	if (wNumber == INT_DIV0) {
		wsprintf (_Gbuf, "integer divide by zero at %04X:%04X\n", 
						wCS, wIP);
		LogPrintf (_Gbuf);
	} else {
		wsprintf (_Gbuf, "Interrupt %d at %04X:%04X\n", 
						wNumber, wCS, wIP);
		LogPrintf (_Gbuf);
	}
	LogPrintf ("Fly8 terminating...\n");

/* We're getting out now, so undo reentry flag
*/
	wReentry = 0;
#if 0
	TerminateApp (NULL, NO_UAE_BOX);
#endif
	die ();	 /* do as it says ... exits gracefully */
	return (0);
}
#endif

static int FAR
init (void)
{
#if USETOOLHELP
	procInst = MakeProcInstance ((FARPROC)FaultHandler, Fly8Instance);
	if (!InterruptRegister (NULL, procInst))
		MessageBox((HWND)NULL, (LPCSTR)"Unable to set div by zero trap",
				       (LPCSTR)"Fly8 Message", MB_OK);
	SetErrorMode (SEM_FAILCRITICALERRORS);
#endif

	return (0);
}

static void FAR
term (void)
{
#if USETOOLHELP
	InterruptUnRegister (NULL);
	FreeProcInstance (procInst);
#endif
}

static void FAR
poll (void)
{}

static Ulong FAR
disable (void)
{return (0);}

static void FAR
enable (Ulong flags)
{flags=flags;}

static void FAR
shell (void)
{
	MsgWPrintf (20, "shell not implemented");
}

/* Build file name from parts.
 * path is NULL for "current directory".
 * path is ""   for "root directory".
*/
static void FAR
BuildFileName (char *FullName, char *path, char *name, char *ext)
{
	FullName[0] = '\0';

	if (path) {
		strcat (FullName, path);
		strcat (FullName, "\\");
	}
	strcat (FullName, name);
	if (ext && ext[0]) {
		strcat (FullName, ".");
		strcat (FullName, ext);
	}
}

struct SysDriver NEAR SysDriver = {
	"WINDOWS",
	0,
	NULL,	/* extra */
	init,
	term,
	poll,
	disable,
	enable,
	shell,
	BuildFileName
};

extern long FAR PASCAL Fly8WndProc (HWND, Uint, WORD, LONG);
extern int C_MAIN (int argc, char *argv[]);

static void
baderr (char *msg)
{
	FILE	*errs;

	errs = fopen ("c:\\temp\\fly8w.err", ATMODE);
	if (errs) {
		fprintf (errs, msg);
		fclose (errs);
	}
}

/* Procedure called when the application is loaded for the first time
*/
static BOOL
WinInit ( HANDLE hInstance, LPSTR  lpszAppName, LPSTR  lpszMessage)
{
	WNDCLASS   pFly8Class;

#if 0
/* Check pointer values
*/
	if (lpszAppName[0] != '\0'  || lpszMessage != '\0')
		return (FALSE);

/* Load strings from resource
*/
	LoadString ( hInstance, IDSTR_NAME, (LPSTR)lpszAppName, 10 );
	LoadString ( hInstance, IDSTR_TITLE, (LPSTR)lpszMessage, 15 );
#endif
/* define aspects common to both classes
*/
	pFly8Class.style	  = CS_OWNDC |
				    CS_BYTEALIGNWINDOW;
	pFly8Class.hCursor	= LoadCursor ( (HINSTANCE)NULL, IDC_ICON );
	pFly8Class.hIcon	  = (HICON)NULL;
	pFly8Class.lpszMenuName   = (LPSTR)NULL;
	pFly8Class.hInstance      = hInstance;
	
	pFly8Class.lpszClassName  = (LPSTR)Fly8AppName;
	pFly8Class.hbrBackground  = (HBRUSH) GetStockObject ( BLACK_BRUSH );
	pFly8Class.lpfnWndProc    = (WNDPROC)Fly8WndProc;

	if ( !RegisterClass ( &pFly8Class ) ) {
baderr ("Fly8 failed 1\n");

/* Initialization failed.
 * Windows will automatically deallocate all allocated memory.
*/
		return FALSE;
	}

	return TRUE;	/* Initialization succeeded */
}

static char	args[1024], *argv[30];

int PASCAL
WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine,
	int nCmdShow)
{
	MSG    	msg;
	HMENU  	hMenu  = NULL;
	char	*p, *q;
	int	i;

#if 0
baderr ("Fly8 starting\n");
#endif
	if (!hPrevInstance) {

/* Call initialization procedure if this is the first instance
*/
		if (!WinInit (hInstance, (LPSTR)Fly8AppName,
						(LPSTR)Fly8Message)) {
baderr ("Fly8 failed 3\n");
			return FALSE;
		}
	} else {

/* Copy data from previous instance
*/
		GetInstanceData (hPrevInstance, (BYTE *)Fly8AppName, 10);
		GetInstanceData (hPrevInstance, (BYTE *)Fly8Message, 15);
	}
	
	Fly8Instance = hInstance;

	for (i = 0; i < 30; ++i)
		argv[i] = NULL;
	argv[0] = Fly8AppName;
	strcpy (args, lpszCmdLine);
	q = args + strlen (args);
	for ( i = 1, p = args; p < q && *p && i < 30; ++p ) {
		if (*p != ' ') {
			argv[i] = p;
			++i;
			for (; p < q && *p && i < 30; ++p)
				if (*p == ' ') {
					*p = '\0';
					break;
				}
		}
	}

	C_MAIN (i, argv);	/* pass control to Fly8 */	

	return ((int)msg.wParam);
}
