
# versions.py - versioning of return values

from .utility import max_version

# Dict versions
_DICT_VERSION_APPLICATION = "2.7.2"
_DICT_VERSION_MENTION = "1.0.0"
_DICT_VERSION_MEDIA = "3.2.0"
_DICT_VERSION_ACCOUNT = "3.3.0"
_DICT_VERSION_POLL = "2.8.0"
_DICT_VERSION_STATUS = max_version("3.1.0", _DICT_VERSION_MEDIA, _DICT_VERSION_ACCOUNT, _DICT_VERSION_APPLICATION, _DICT_VERSION_MENTION, _DICT_VERSION_POLL)
_DICT_VERSION_INSTANCE = max_version("3.4.0", _DICT_VERSION_ACCOUNT)
_DICT_VERSION_HASHTAG = "2.3.4"
_DICT_VERSION_EMOJI = "3.0.0"
_DICT_VERSION_RELATIONSHIP = "3.3.0"
_DICT_VERSION_NOTIFICATION = max_version("3.5.0",  _DICT_VERSION_ACCOUNT, _DICT_VERSION_STATUS)
_DICT_VERSION_CONTEXT = max_version("1.0.0",  _DICT_VERSION_STATUS)
_DICT_VERSION_LIST = "2.1.0"
_DICT_VERSION_CARD = "3.2.0"
_DICT_VERSION_SEARCHRESULT = max_version("1.0.0", _DICT_VERSION_ACCOUNT, _DICT_VERSION_STATUS, _DICT_VERSION_HASHTAG)
_DICT_VERSION_ACTIVITY = "2.1.2"
_DICT_VERSION_REPORT = "2.9.1"
_DICT_VERSION_PUSH = "2.4.0"
_DICT_VERSION_PUSH_NOTIF = "2.4.0"
_DICT_VERSION_FILTER = "2.4.3"
_DICT_VERSION_CONVERSATION = max_version("2.6.0", _DICT_VERSION_ACCOUNT, _DICT_VERSION_STATUS)
_DICT_VERSION_SCHEDULED_STATUS = max_version("2.7.0", _DICT_VERSION_STATUS)
_DICT_VERSION_PREFERENCES = "2.8.0"
_DICT_VERSION_ADMIN_ACCOUNT = max_version("4.0.0", _DICT_VERSION_ACCOUNT)
_DICT_VERSION_FEATURED_TAG = "3.0.0"
_DICT_VERSION_MARKER = "3.0.0"
_DICT_VERSION_REACTION = "3.1.0"
_DICT_VERSION_ANNOUNCEMENT = max_version("3.1.0", _DICT_VERSION_REACTION)
_DICT_VERSION_STATUS_EDIT = "3.5.0"
_DICT_VERSION_FAMILIAR_FOLLOWERS = max_version("3.5.0", _DICT_VERSION_ACCOUNT)
_DICT_VERSION_ADMIN_DOMAIN_BLOCK = "4.0.0"
_DICT_VERSION_ADMIN_MEASURE = "3.5.0"
_DICT_VERSION_ADMIN_DIMENSION = "3.5.0"
_DICT_VERSION_ADMIN_RETENTION = "3.5.0"