# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ActionResult(msrest.serialization.Model):
    """ActionResult.

    :ivar is_up_to_date:
    :vartype is_up_to_date: bool
    :ivar is_up_to_date_error:
    :vartype is_up_to_date_error: str
    :ivar result_artifact_ids:
    :vartype result_artifact_ids: list[str]
    :ivar in_progress_action_id:
    :vartype in_progress_action_id: str
    :ivar run_id:
    :vartype run_id: str
    :ivar experiment_name:
    :vartype experiment_name: str
    :ivar datastore_name:
    :vartype datastore_name: str
    """

    _attribute_map = {
        'is_up_to_date': {'key': 'isUpToDate', 'type': 'bool'},
        'is_up_to_date_error': {'key': 'isUpToDateError', 'type': 'str'},
        'result_artifact_ids': {'key': 'resultArtifactIds', 'type': '[str]'},
        'in_progress_action_id': {'key': 'inProgressActionId', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'datastore_name': {'key': 'datastoreName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword is_up_to_date:
        :paramtype is_up_to_date: bool
        :keyword is_up_to_date_error:
        :paramtype is_up_to_date_error: str
        :keyword result_artifact_ids:
        :paramtype result_artifact_ids: list[str]
        :keyword in_progress_action_id:
        :paramtype in_progress_action_id: str
        :keyword run_id:
        :paramtype run_id: str
        :keyword experiment_name:
        :paramtype experiment_name: str
        :keyword datastore_name:
        :paramtype datastore_name: str
        """
        super(ActionResult, self).__init__(**kwargs)
        self.is_up_to_date = kwargs.get('is_up_to_date', None)
        self.is_up_to_date_error = kwargs.get('is_up_to_date_error', None)
        self.result_artifact_ids = kwargs.get('result_artifact_ids', None)
        self.in_progress_action_id = kwargs.get('in_progress_action_id', None)
        self.run_id = kwargs.get('run_id', None)
        self.experiment_name = kwargs.get('experiment_name', None)
        self.datastore_name = kwargs.get('datastore_name', None)


class AssetId(msrest.serialization.Model):
    """AssetId.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required.
        :paramtype value: str
        """
        super(AssetId, self).__init__(**kwargs)
        self.value = kwargs['value']


class BatchDataUriResponse(msrest.serialization.Model):
    """BatchDataUriResponse.

    :ivar values: Dictionary of :code:`<DataUriV2Response>`.
    :vartype values: dict[str, ~azure.mgmt.machinelearningservices.models.DataUriV2Response]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '{DataUriV2Response}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword values: Dictionary of :code:`<DataUriV2Response>`.
        :paramtype values: dict[str, ~azure.mgmt.machinelearningservices.models.DataUriV2Response]
        """
        super(BatchDataUriResponse, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)


class BatchGetResolvedURIs(msrest.serialization.Model):
    """BatchGetResolvedURIs.

    All required parameters must be populated in order to send to Azure.

    :ivar values: Required.
    :vartype values: list[str]
    """

    _validation = {
        'values': {'required': True},
    }

    _attribute_map = {
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword values: Required.
        :paramtype values: list[str]
        """
        super(BatchGetResolvedURIs, self).__init__(**kwargs)
        self.values = kwargs['values']


class ColumnDefinition(msrest.serialization.Model):
    """ColumnDefinition.

    :ivar id:
    :vartype id: str
    :ivar type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
     "Unknown", "Error", "Null", "DataRow", "List", "Stream".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
         "Unknown", "Error", "Null", "DataRow", "List", "Stream".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
        """
        super(ColumnDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)


class CreateUnregisteredInputData(msrest.serialization.Model):
    """CreateUnregisteredInputData.

    All required parameters must be populated in order to send to Azure.

    :ivar run_id: Required.
    :vartype run_id: str
    :ivar input_name: Required.
    :vartype input_name: str
    :ivar uri: Required.
    :vartype uri: str
    :ivar type: Required.
    :vartype type: str
    """

    _validation = {
        'run_id': {'required': True},
        'input_name': {'required': True},
        'uri': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'input_name': {'key': 'inputName', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword run_id: Required.
        :paramtype run_id: str
        :keyword input_name: Required.
        :paramtype input_name: str
        :keyword uri: Required.
        :paramtype uri: str
        :keyword type: Required.
        :paramtype type: str
        """
        super(CreateUnregisteredInputData, self).__init__(**kwargs)
        self.run_id = kwargs['run_id']
        self.input_name = kwargs['input_name']
        self.uri = kwargs['uri']
        self.type = kwargs['type']


class CreateUnregisteredOutputData(msrest.serialization.Model):
    """CreateUnregisteredOutputData.

    All required parameters must be populated in order to send to Azure.

    :ivar run_id: Required.
    :vartype run_id: str
    :ivar output_name: Required.
    :vartype output_name: str
    :ivar uri: Required.
    :vartype uri: str
    :ivar type: Required.
    :vartype type: str
    """

    _validation = {
        'run_id': {'required': True},
        'output_name': {'required': True},
        'uri': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'output_name': {'key': 'outputName', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword run_id: Required.
        :paramtype run_id: str
        :keyword output_name: Required.
        :paramtype output_name: str
        :keyword uri: Required.
        :paramtype uri: str
        :keyword type: Required.
        :paramtype type: str
        """
        super(CreateUnregisteredOutputData, self).__init__(**kwargs)
        self.run_id = kwargs['run_id']
        self.output_name = kwargs['output_name']
        self.uri = kwargs['uri']
        self.type = kwargs['type']


class DataCallRequest(msrest.serialization.Model):
    """DataCallRequest.

    :ivar data_uri:
    :vartype data_uri: str
    :ivar data_type:
    :vartype data_type: str
    :ivar asset_id:
    :vartype asset_id: str
    :ivar data_container_name:
    :vartype data_container_name: str
    :ivar version_id:
    :vartype version_id: str
    """

    _attribute_map = {
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'data_container_name': {'key': 'dataContainerName', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_uri:
        :paramtype data_uri: str
        :keyword data_type:
        :paramtype data_type: str
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword data_container_name:
        :paramtype data_container_name: str
        :keyword version_id:
        :paramtype version_id: str
        """
        super(DataCallRequest, self).__init__(**kwargs)
        self.data_uri = kwargs.get('data_uri', None)
        self.data_type = kwargs.get('data_type', None)
        self.asset_id = kwargs.get('asset_id', None)
        self.data_container_name = kwargs.get('data_container_name', None)
        self.version_id = kwargs.get('version_id', None)


class DataContainer(msrest.serialization.Model):
    """DataContainer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar data_type: Required.
    :vartype data_type: str
    :ivar mutable_props:
    :vartype mutable_props: ~azure.mgmt.machinelearningservices.models.DataContainerMutable
    :ivar is_registered:
    :vartype is_registered: bool
    """

    _validation = {
        'name': {'required': True},
        'data_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'mutable_props': {'key': 'mutableProps', 'type': 'DataContainerMutable'},
        'is_registered': {'key': 'isRegistered', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword data_type: Required.
        :paramtype data_type: str
        :keyword mutable_props:
        :paramtype mutable_props: ~azure.mgmt.machinelearningservices.models.DataContainerMutable
        :keyword is_registered:
        :paramtype is_registered: bool
        """
        super(DataContainer, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.data_type = kwargs['data_type']
        self.mutable_props = kwargs.get('mutable_props', None)
        self.is_registered = kwargs.get('is_registered', None)


class DataContainerEntity(msrest.serialization.Model):
    """DataContainerEntity.

    :ivar data_container:
    :vartype data_container: ~azure.mgmt.machinelearningservices.models.DataContainer
    :ivar entity_metadata:
    :vartype entity_metadata: ~azure.mgmt.machinelearningservices.models.EntityMetadata
    :ivar latest_version:
    :vartype latest_version: ~azure.mgmt.machinelearningservices.models.DataVersionEntity
    :ivar next_version_id:
    :vartype next_version_id: str
    :ivar legacy_dataset_type:
    :vartype legacy_dataset_type: str
    """

    _attribute_map = {
        'data_container': {'key': 'dataContainer', 'type': 'DataContainer'},
        'entity_metadata': {'key': 'entityMetadata', 'type': 'EntityMetadata'},
        'latest_version': {'key': 'latestVersion', 'type': 'DataVersionEntity'},
        'next_version_id': {'key': 'nextVersionId', 'type': 'str'},
        'legacy_dataset_type': {'key': 'legacyDatasetType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_container:
        :paramtype data_container: ~azure.mgmt.machinelearningservices.models.DataContainer
        :keyword entity_metadata:
        :paramtype entity_metadata: ~azure.mgmt.machinelearningservices.models.EntityMetadata
        :keyword latest_version:
        :paramtype latest_version: ~azure.mgmt.machinelearningservices.models.DataVersionEntity
        :keyword next_version_id:
        :paramtype next_version_id: str
        :keyword legacy_dataset_type:
        :paramtype legacy_dataset_type: str
        """
        super(DataContainerEntity, self).__init__(**kwargs)
        self.data_container = kwargs.get('data_container', None)
        self.entity_metadata = kwargs.get('entity_metadata', None)
        self.latest_version = kwargs.get('latest_version', None)
        self.next_version_id = kwargs.get('next_version_id', None)
        self.legacy_dataset_type = kwargs.get('legacy_dataset_type', None)


class DataContainerMutable(msrest.serialization.Model):
    """DataContainerMutable.

    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar is_archived:
    :vartype is_archived: bool
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword is_archived:
        :paramtype is_archived: bool
        """
        super(DataContainerMutable, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)
        self.is_archived = kwargs.get('is_archived', None)


class DataField(msrest.serialization.Model):
    """DataField.

    :ivar type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
     "Unknown", "Error", "Null", "DataRow", "List", "Stream".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
    :ivar value: Anything.
    :vartype value: any
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
         "Unknown", "Error", "Null", "DataRow", "List", "Stream".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
        :keyword value: Anything.
        :paramtype value: any
        """
        super(DataField, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.value = kwargs.get('value', None)


class Dataset(msrest.serialization.Model):
    """Dataset.

    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar dataset_state:
    :vartype dataset_state: ~azure.mgmt.machinelearningservices.models.DatasetState
    :ivar latest:
    :vartype latest: ~azure.mgmt.machinelearningservices.models.DatasetDefinition
    :ivar next_version_id:
    :vartype next_version_id: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar etag:
    :vartype etag: str
    :ivar name:
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar is_visible:
    :vartype is_visible: bool
    :ivar default_compute:
    :vartype default_compute: str
    :ivar dataset_type:
    :vartype dataset_type: str
    """

    _attribute_map = {
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'dataset_state': {'key': 'datasetState', 'type': 'DatasetState'},
        'latest': {'key': 'latest', 'type': 'DatasetDefinition'},
        'next_version_id': {'key': 'nextVersionId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'etag': {'key': 'etag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_visible': {'key': 'isVisible', 'type': 'bool'},
        'default_compute': {'key': 'defaultCompute', 'type': 'str'},
        'dataset_type': {'key': 'datasetType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword dataset_state:
        :paramtype dataset_state: ~azure.mgmt.machinelearningservices.models.DatasetState
        :keyword latest:
        :paramtype latest: ~azure.mgmt.machinelearningservices.models.DatasetDefinition
        :keyword next_version_id:
        :paramtype next_version_id: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword etag:
        :paramtype etag: str
        :keyword name:
        :paramtype name: str
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword is_visible:
        :paramtype is_visible: bool
        :keyword default_compute:
        :paramtype default_compute: str
        :keyword dataset_type:
        :paramtype dataset_type: str
        """
        super(Dataset, self).__init__(**kwargs)
        self.dataset_id = kwargs.get('dataset_id', None)
        self.dataset_state = kwargs.get('dataset_state', None)
        self.latest = kwargs.get('latest', None)
        self.next_version_id = kwargs.get('next_version_id', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.etag = kwargs.get('etag', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)
        self.is_visible = kwargs.get('is_visible', None)
        self.default_compute = kwargs.get('default_compute', None)
        self.dataset_type = kwargs.get('dataset_type', None)


class DatasetDefinition(msrest.serialization.Model):
    """DatasetDefinition.

    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar version_id:
    :vartype version_id: str
    :ivar dataset_definition_state:
    :vartype dataset_definition_state: ~azure.mgmt.machinelearningservices.models.DatasetState
    :ivar dataflow:
    :vartype dataflow: str
    :ivar dataflow_type: Possible values include: "Json", "Yaml".
    :vartype dataflow_type: str or ~azure.mgmt.machinelearningservices.models.DataflowType
    :ivar data_path:
    :vartype data_path: ~azure.mgmt.machinelearningservices.models.DatasetPath
    :ivar partition_format_in_path:
    :vartype partition_format_in_path: str
    :ivar profile_action_result:
    :vartype profile_action_result: ~azure.mgmt.machinelearningservices.models.ProfileActionResult
    :ivar notes:
    :vartype notes: str
    :ivar etag:
    :vartype etag: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar data_expiry_time:
    :vartype data_expiry_time: ~datetime.datetime
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar modified_by:
    :vartype modified_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar file_type:
    :vartype file_type: str
    :ivar properties: Dictionary of :code:`<any>`.
    :vartype properties: dict[str, any]
    :ivar saved_dataset_id:
    :vartype saved_dataset_id: str
    :ivar telemetry_info: Dictionary of :code:`<string>`.
    :vartype telemetry_info: dict[str, str]
    :ivar use_description_tags_from_definition:
    :vartype use_description_tags_from_definition: bool
    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
        'dataset_definition_state': {'key': 'datasetDefinitionState', 'type': 'DatasetState'},
        'dataflow': {'key': 'dataflow', 'type': 'str'},
        'dataflow_type': {'key': 'dataflowType', 'type': 'str'},
        'data_path': {'key': 'dataPath', 'type': 'DatasetPath'},
        'partition_format_in_path': {'key': 'partitionFormatInPath', 'type': 'str'},
        'profile_action_result': {'key': 'profileActionResult', 'type': 'ProfileActionResult'},
        'notes': {'key': 'notes', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'data_expiry_time': {'key': 'dataExpiryTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'modified_by': {'key': 'modifiedBy', 'type': 'User'},
        'file_type': {'key': 'fileType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
        'saved_dataset_id': {'key': 'savedDatasetId', 'type': 'str'},
        'telemetry_info': {'key': 'telemetryInfo', 'type': '{str}'},
        'use_description_tags_from_definition': {'key': 'useDescriptionTagsFromDefinition', 'type': 'bool'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword version_id:
        :paramtype version_id: str
        :keyword dataset_definition_state:
        :paramtype dataset_definition_state: ~azure.mgmt.machinelearningservices.models.DatasetState
        :keyword dataflow:
        :paramtype dataflow: str
        :keyword dataflow_type: Possible values include: "Json", "Yaml".
        :paramtype dataflow_type: str or ~azure.mgmt.machinelearningservices.models.DataflowType
        :keyword data_path:
        :paramtype data_path: ~azure.mgmt.machinelearningservices.models.DatasetPath
        :keyword partition_format_in_path:
        :paramtype partition_format_in_path: str
        :keyword profile_action_result:
        :paramtype profile_action_result:
         ~azure.mgmt.machinelearningservices.models.ProfileActionResult
        :keyword notes:
        :paramtype notes: str
        :keyword etag:
        :paramtype etag: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword data_expiry_time:
        :paramtype data_expiry_time: ~datetime.datetime
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword modified_by:
        :paramtype modified_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword file_type:
        :paramtype file_type: str
        :keyword properties: Dictionary of :code:`<any>`.
        :paramtype properties: dict[str, any]
        :keyword saved_dataset_id:
        :paramtype saved_dataset_id: str
        :keyword telemetry_info: Dictionary of :code:`<string>`.
        :paramtype telemetry_info: dict[str, str]
        :keyword use_description_tags_from_definition:
        :paramtype use_description_tags_from_definition: bool
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super(DatasetDefinition, self).__init__(**kwargs)
        self.dataset_id = kwargs.get('dataset_id', None)
        self.version_id = kwargs.get('version_id', None)
        self.dataset_definition_state = kwargs.get('dataset_definition_state', None)
        self.dataflow = kwargs.get('dataflow', None)
        self.dataflow_type = kwargs.get('dataflow_type', None)
        self.data_path = kwargs.get('data_path', None)
        self.partition_format_in_path = kwargs.get('partition_format_in_path', None)
        self.profile_action_result = kwargs.get('profile_action_result', None)
        self.notes = kwargs.get('notes', None)
        self.etag = kwargs.get('etag', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.data_expiry_time = kwargs.get('data_expiry_time', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.file_type = kwargs.get('file_type', None)
        self.properties = kwargs.get('properties', None)
        self.saved_dataset_id = kwargs.get('saved_dataset_id', None)
        self.telemetry_info = kwargs.get('telemetry_info', None)
        self.use_description_tags_from_definition = kwargs.get('use_description_tags_from_definition', None)
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)


class DatasetDefinitionReference(msrest.serialization.Model):
    """DatasetDefinitionReference.

    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar definition_version:
    :vartype definition_version: str
    """

    _attribute_map = {
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'definition_version': {'key': 'definitionVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword definition_version:
        :paramtype definition_version: str
        """
        super(DatasetDefinitionReference, self).__init__(**kwargs)
        self.dataset_id = kwargs.get('dataset_id', None)
        self.definition_version = kwargs.get('definition_version', None)


class DatasetPath(msrest.serialization.Model):
    """DatasetPath.

    :ivar datastore_name:
    :vartype datastore_name: str
    :ivar relative_path:
    :vartype relative_path: str
    :ivar azure_file_path:
    :vartype azure_file_path: str
    :ivar paths:
    :vartype paths: list[str]
    :ivar sql_data_path:
    :vartype sql_data_path: ~azure.mgmt.machinelearningservices.models.SqlDataPath
    :ivar http_url:
    :vartype http_url: str
    :ivar additional_properties: Dictionary of :code:`<any>`.
    :vartype additional_properties: dict[str, any]
    :ivar partition_format:
    :vartype partition_format: str
    :ivar partition_format_ignore_error:
    :vartype partition_format_ignore_error: bool
    """

    _attribute_map = {
        'datastore_name': {'key': 'datastoreName', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'azure_file_path': {'key': 'azureFilePath', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[str]'},
        'sql_data_path': {'key': 'sqlDataPath', 'type': 'SqlDataPath'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'additional_properties': {'key': 'additionalProperties', 'type': '{object}'},
        'partition_format': {'key': 'partitionFormat', 'type': 'str'},
        'partition_format_ignore_error': {'key': 'partitionFormatIgnoreError', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword datastore_name:
        :paramtype datastore_name: str
        :keyword relative_path:
        :paramtype relative_path: str
        :keyword azure_file_path:
        :paramtype azure_file_path: str
        :keyword paths:
        :paramtype paths: list[str]
        :keyword sql_data_path:
        :paramtype sql_data_path: ~azure.mgmt.machinelearningservices.models.SqlDataPath
        :keyword http_url:
        :paramtype http_url: str
        :keyword additional_properties: Dictionary of :code:`<any>`.
        :paramtype additional_properties: dict[str, any]
        :keyword partition_format:
        :paramtype partition_format: str
        :keyword partition_format_ignore_error:
        :paramtype partition_format_ignore_error: bool
        """
        super(DatasetPath, self).__init__(**kwargs)
        self.datastore_name = kwargs.get('datastore_name', None)
        self.relative_path = kwargs.get('relative_path', None)
        self.azure_file_path = kwargs.get('azure_file_path', None)
        self.paths = kwargs.get('paths', None)
        self.sql_data_path = kwargs.get('sql_data_path', None)
        self.http_url = kwargs.get('http_url', None)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.partition_format = kwargs.get('partition_format', None)
        self.partition_format_ignore_error = kwargs.get('partition_format_ignore_error', None)


class DatasetState(msrest.serialization.Model):
    """DatasetState.

    :ivar state:
    :vartype state: str
    :ivar deprecated_by:
    :vartype deprecated_by: ~azure.mgmt.machinelearningservices.models.DatasetDefinitionReference
    :ivar etag:
    :vartype etag: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'deprecated_by': {'key': 'deprecatedBy', 'type': 'DatasetDefinitionReference'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword state:
        :paramtype state: str
        :keyword deprecated_by:
        :paramtype deprecated_by: ~azure.mgmt.machinelearningservices.models.DatasetDefinitionReference
        :keyword etag:
        :paramtype etag: str
        """
        super(DatasetState, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.deprecated_by = kwargs.get('deprecated_by', None)
        self.etag = kwargs.get('etag', None)


class DatasetV2(msrest.serialization.Model):
    """DatasetV2.

    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar name:
    :vartype name: str
    :ivar version_id:
    :vartype version_id: str
    :ivar dataflow:
    :vartype dataflow: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar modified_by:
    :vartype modified_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar telemetry_info: Dictionary of :code:`<string>`.
    :vartype telemetry_info: dict[str, str]
    :ivar description:
    :vartype description: str
    :ivar is_anonymous:
    :vartype is_anonymous: bool
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar legacy_properties: Dictionary of :code:`<any>`.
    :vartype legacy_properties: dict[str, any]
    :ivar data_expiry_time:
    :vartype data_expiry_time: ~datetime.datetime
    :ivar legacy: Dictionary of :code:`<any>`.
    :vartype legacy: dict[str, any]
    """

    _attribute_map = {
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
        'dataflow': {'key': 'dataflow', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'modified_by': {'key': 'modifiedBy', 'type': 'User'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'telemetry_info': {'key': 'telemetryInfo', 'type': '{str}'},
        'description': {'key': 'description', 'type': 'str'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'legacy_properties': {'key': 'legacyProperties', 'type': '{object}'},
        'data_expiry_time': {'key': 'dataExpiryTime', 'type': 'iso-8601'},
        'legacy': {'key': 'legacy', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword name:
        :paramtype name: str
        :keyword version_id:
        :paramtype version_id: str
        :keyword dataflow:
        :paramtype dataflow: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword modified_by:
        :paramtype modified_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword telemetry_info: Dictionary of :code:`<string>`.
        :paramtype telemetry_info: dict[str, str]
        :keyword description:
        :paramtype description: str
        :keyword is_anonymous:
        :paramtype is_anonymous: bool
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword legacy_properties: Dictionary of :code:`<any>`.
        :paramtype legacy_properties: dict[str, any]
        :keyword data_expiry_time:
        :paramtype data_expiry_time: ~datetime.datetime
        :keyword legacy: Dictionary of :code:`<any>`.
        :paramtype legacy: dict[str, any]
        """
        super(DatasetV2, self).__init__(**kwargs)
        self.dataset_id = kwargs.get('dataset_id', None)
        self.name = kwargs.get('name', None)
        self.version_id = kwargs.get('version_id', None)
        self.dataflow = kwargs.get('dataflow', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.properties = kwargs.get('properties', None)
        self.telemetry_info = kwargs.get('telemetry_info', None)
        self.description = kwargs.get('description', None)
        self.is_anonymous = kwargs.get('is_anonymous', None)
        self.tags = kwargs.get('tags', None)
        self.legacy_properties = kwargs.get('legacy_properties', None)
        self.data_expiry_time = kwargs.get('data_expiry_time', None)
        self.legacy = kwargs.get('legacy', None)


class DataUriV2Response(msrest.serialization.Model):
    """DataUriV2Response.

    :ivar uri:
    :vartype uri: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword uri:
        :paramtype uri: str
        :keyword type:
        :paramtype type: str
        """
        super(DataUriV2Response, self).__init__(**kwargs)
        self.uri = kwargs.get('uri', None)
        self.type = kwargs.get('type', None)


class DataVersion(msrest.serialization.Model):
    """DataVersion.

    All required parameters must be populated in order to send to Azure.

    :ivar asset_id:
    :vartype asset_id: str
    :ivar data_container_name: Required.
    :vartype data_container_name: str
    :ivar data_type: Required.
    :vartype data_type: str
    :ivar data_uri: Required.
    :vartype data_uri: str
    :ivar version_id: Required.
    :vartype version_id: str
    :ivar mutable_props:
    :vartype mutable_props: ~azure.mgmt.machinelearningservices.models.DataVersionMutable
    :ivar referenced_data_uris:
    :vartype referenced_data_uris: list[str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'data_container_name': {'required': True},
        'data_type': {'required': True},
        'data_uri': {'required': True},
        'version_id': {'required': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'data_container_name': {'key': 'dataContainerName', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
        'mutable_props': {'key': 'mutableProps', 'type': 'DataVersionMutable'},
        'referenced_data_uris': {'key': 'referencedDataUris', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword data_container_name: Required.
        :paramtype data_container_name: str
        :keyword data_type: Required.
        :paramtype data_type: str
        :keyword data_uri: Required.
        :paramtype data_uri: str
        :keyword version_id: Required.
        :paramtype version_id: str
        :keyword mutable_props:
        :paramtype mutable_props: ~azure.mgmt.machinelearningservices.models.DataVersionMutable
        :keyword referenced_data_uris:
        :paramtype referenced_data_uris: list[str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        """
        super(DataVersion, self).__init__(**kwargs)
        self.asset_id = kwargs.get('asset_id', None)
        self.data_container_name = kwargs['data_container_name']
        self.data_type = kwargs['data_type']
        self.data_uri = kwargs['data_uri']
        self.version_id = kwargs['version_id']
        self.mutable_props = kwargs.get('mutable_props', None)
        self.referenced_data_uris = kwargs.get('referenced_data_uris', None)
        self.properties = kwargs.get('properties', None)


class DataVersionEntity(msrest.serialization.Model):
    """DataVersionEntity.

    :ivar data_version:
    :vartype data_version: ~azure.mgmt.machinelearningservices.models.DataVersion
    :ivar entity_metadata:
    :vartype entity_metadata: ~azure.mgmt.machinelearningservices.models.EntityMetadata
    """

    _attribute_map = {
        'data_version': {'key': 'dataVersion', 'type': 'DataVersion'},
        'entity_metadata': {'key': 'entityMetadata', 'type': 'EntityMetadata'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_version:
        :paramtype data_version: ~azure.mgmt.machinelearningservices.models.DataVersion
        :keyword entity_metadata:
        :paramtype entity_metadata: ~azure.mgmt.machinelearningservices.models.EntityMetadata
        """
        super(DataVersionEntity, self).__init__(**kwargs)
        self.data_version = kwargs.get('data_version', None)
        self.entity_metadata = kwargs.get('entity_metadata', None)


class DataVersionMutable(msrest.serialization.Model):
    """DataVersionMutable.

    :ivar data_expiry_time:
    :vartype data_expiry_time: ~datetime.datetime
    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar is_archived:
    :vartype is_archived: bool
    """

    _attribute_map = {
        'data_expiry_time': {'key': 'dataExpiryTime', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_expiry_time:
        :paramtype data_expiry_time: ~datetime.datetime
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword is_archived:
        :paramtype is_archived: bool
        """
        super(DataVersionMutable, self).__init__(**kwargs)
        self.data_expiry_time = kwargs.get('data_expiry_time', None)
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)
        self.is_archived = kwargs.get('is_archived', None)


class DataViewSetResult(msrest.serialization.Model):
    """DataViewSetResult.

    :ivar schema:
    :vartype schema: list[~azure.mgmt.machinelearningservices.models.ColumnDefinition]
    :ivar rows:
    :vartype rows: list[list[~azure.mgmt.machinelearningservices.models.DataField]]
    """

    _attribute_map = {
        'schema': {'key': 'schema', 'type': '[ColumnDefinition]'},
        'rows': {'key': 'rows', 'type': '[[DataField]]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword schema:
        :paramtype schema: list[~azure.mgmt.machinelearningservices.models.ColumnDefinition]
        :keyword rows:
        :paramtype rows: list[list[~azure.mgmt.machinelearningservices.models.DataField]]
        """
        super(DataViewSetResult, self).__init__(**kwargs)
        self.schema = kwargs.get('schema', None)
        self.rows = kwargs.get('rows', None)


class EntityMetadata(msrest.serialization.Model):
    """EntityMetadata.

    :ivar etag:
    :vartype etag: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar modified_by:
    :vartype modified_by: ~azure.mgmt.machinelearningservices.models.User
    """

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'modified_by': {'key': 'modifiedBy', 'type': 'User'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword etag:
        :paramtype etag: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword modified_by:
        :paramtype modified_by: ~azure.mgmt.machinelearningservices.models.User
        """
        super(EntityMetadata, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified_by = kwargs.get('modified_by', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: The additional info type.
        :paramtype type: str
        :keyword info: The additional info.
        :paramtype info: any
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.info = kwargs.get('info', None)


class ErrorResponse(msrest.serialization.Model):
    """The error response.

    :ivar error: The root error.
    :vartype error: ~azure.mgmt.machinelearningservices.models.RootError
    :ivar correlation: Dictionary containing correlation details for the error.
    :vartype correlation: dict[str, str]
    :ivar environment: The hosting environment.
    :vartype environment: str
    :ivar location: The Azure region.
    :vartype location: str
    :ivar time: The time in UTC.
    :vartype time: ~datetime.datetime
    :ivar component_name: Component name where error originated/encountered.
    :vartype component_name: str
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'RootError'},
        'correlation': {'key': 'correlation', 'type': '{str}'},
        'environment': {'key': 'environment', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'component_name': {'key': 'componentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: The root error.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.RootError
        :keyword correlation: Dictionary containing correlation details for the error.
        :paramtype correlation: dict[str, str]
        :keyword environment: The hosting environment.
        :paramtype environment: str
        :keyword location: The Azure region.
        :paramtype location: str
        :keyword time: The time in UTC.
        :paramtype time: ~datetime.datetime
        :keyword component_name: Component name where error originated/encountered.
        :paramtype component_name: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)
        self.correlation = kwargs.get('correlation', None)
        self.environment = kwargs.get('environment', None)
        self.location = kwargs.get('location', None)
        self.time = kwargs.get('time', None)
        self.component_name = kwargs.get('component_name', None)


class HistogramBin(msrest.serialization.Model):
    """HistogramBin.

    :ivar lower_bound:
    :vartype lower_bound: float
    :ivar upper_bound:
    :vartype upper_bound: float
    :ivar count:
    :vartype count: float
    """

    _attribute_map = {
        'lower_bound': {'key': 'lowerBound', 'type': 'float'},
        'upper_bound': {'key': 'upperBound', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword lower_bound:
        :paramtype lower_bound: float
        :keyword upper_bound:
        :paramtype upper_bound: float
        :keyword count:
        :paramtype count: float
        """
        super(HistogramBin, self).__init__(**kwargs)
        self.lower_bound = kwargs.get('lower_bound', None)
        self.upper_bound = kwargs.get('upper_bound', None)
        self.count = kwargs.get('count', None)


class HttpContent(msrest.serialization.Model):
    """HttpContent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar headers:
    :vartype headers:
     list[~azure.mgmt.machinelearningservices.models.KeyValuePairStringIEnumerable1]
    """

    _validation = {
        'headers': {'readonly': True},
    }

    _attribute_map = {
        'headers': {'key': 'headers', 'type': '[KeyValuePairStringIEnumerable1]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(HttpContent, self).__init__(**kwargs)
        self.headers = None


class HttpMethod(msrest.serialization.Model):
    """HttpMethod.

    :ivar method:
    :vartype method: str
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword method:
        :paramtype method: str
        """
        super(HttpMethod, self).__init__(**kwargs)
        self.method = kwargs.get('method', None)


class HttpRequestMessage(msrest.serialization.Model):
    """HttpRequestMessage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version:
    :vartype version: str
    :ivar version_policy: Possible values include: "RequestVersionOrLower",
     "RequestVersionOrHigher", "RequestVersionExact".
    :vartype version_policy: str or ~azure.mgmt.machinelearningservices.models.HttpVersionPolicy
    :ivar content:
    :vartype content: ~azure.mgmt.machinelearningservices.models.HttpContent
    :ivar method:
    :vartype method: ~azure.mgmt.machinelearningservices.models.HttpMethod
    :ivar request_uri:
    :vartype request_uri: str
    :ivar headers:
    :vartype headers:
     list[~azure.mgmt.machinelearningservices.models.KeyValuePairStringIEnumerable1]
    :ivar options: Dictionary of :code:`<any>`.
    :vartype options: dict[str, any]
    """

    _validation = {
        'headers': {'readonly': True},
        'options': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'version_policy': {'key': 'versionPolicy', 'type': 'str'},
        'content': {'key': 'content', 'type': 'HttpContent'},
        'method': {'key': 'method', 'type': 'HttpMethod'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '[KeyValuePairStringIEnumerable1]'},
        'options': {'key': 'options', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version:
        :paramtype version: str
        :keyword version_policy: Possible values include: "RequestVersionOrLower",
         "RequestVersionOrHigher", "RequestVersionExact".
        :paramtype version_policy: str or ~azure.mgmt.machinelearningservices.models.HttpVersionPolicy
        :keyword content:
        :paramtype content: ~azure.mgmt.machinelearningservices.models.HttpContent
        :keyword method:
        :paramtype method: ~azure.mgmt.machinelearningservices.models.HttpMethod
        :keyword request_uri:
        :paramtype request_uri: str
        """
        super(HttpRequestMessage, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.version_policy = kwargs.get('version_policy', None)
        self.content = kwargs.get('content', None)
        self.method = kwargs.get('method', None)
        self.request_uri = kwargs.get('request_uri', None)
        self.headers = None
        self.options = None


class HttpResponseMessage(msrest.serialization.Model):
    """HttpResponseMessage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version:
    :vartype version: str
    :ivar content:
    :vartype content: ~azure.mgmt.machinelearningservices.models.HttpContent
    :ivar status_code: Possible values include: "Continue", "SwitchingProtocols", "Processing",
     "EarlyHints", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
     "ResetContent", "PartialContent", "MultiStatus", "AlreadyReported", "IMUsed", "Ambiguous",
     "Moved", "Redirect", "RedirectMethod", "NotModified", "UseProxy", "Unused",
     "TemporaryRedirect", "PermanentRedirect", "BadRequest", "Unauthorized", "PaymentRequired",
     "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
     "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
     "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
     "RequestedRangeNotSatisfiable", "ExpectationFailed", "MisdirectedRequest",
     "UnprocessableEntity", "Locked", "FailedDependency", "UpgradeRequired", "PreconditionRequired",
     "TooManyRequests", "RequestHeaderFieldsTooLarge", "UnavailableForLegalReasons",
     "InternalServerError", "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
     "HttpVersionNotSupported", "VariantAlsoNegotiates", "InsufficientStorage", "LoopDetected",
     "NotExtended", "NetworkAuthenticationRequired".
    :vartype status_code: str or ~azure.mgmt.machinelearningservices.models.HttpStatusCode
    :ivar reason_phrase:
    :vartype reason_phrase: str
    :ivar headers:
    :vartype headers:
     list[~azure.mgmt.machinelearningservices.models.KeyValuePairStringIEnumerable1]
    :ivar trailing_headers:
    :vartype trailing_headers:
     list[~azure.mgmt.machinelearningservices.models.KeyValuePairStringIEnumerable1]
    :ivar request_message:
    :vartype request_message: ~azure.mgmt.machinelearningservices.models.HttpRequestMessage
    :ivar is_success_status_code:
    :vartype is_success_status_code: bool
    """

    _validation = {
        'headers': {'readonly': True},
        'trailing_headers': {'readonly': True},
        'is_success_status_code': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'content': {'key': 'content', 'type': 'HttpContent'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '[KeyValuePairStringIEnumerable1]'},
        'trailing_headers': {'key': 'trailingHeaders', 'type': '[KeyValuePairStringIEnumerable1]'},
        'request_message': {'key': 'requestMessage', 'type': 'HttpRequestMessage'},
        'is_success_status_code': {'key': 'isSuccessStatusCode', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version:
        :paramtype version: str
        :keyword content:
        :paramtype content: ~azure.mgmt.machinelearningservices.models.HttpContent
        :keyword status_code: Possible values include: "Continue", "SwitchingProtocols", "Processing",
         "EarlyHints", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
         "ResetContent", "PartialContent", "MultiStatus", "AlreadyReported", "IMUsed", "Ambiguous",
         "Moved", "Redirect", "RedirectMethod", "NotModified", "UseProxy", "Unused",
         "TemporaryRedirect", "PermanentRedirect", "BadRequest", "Unauthorized", "PaymentRequired",
         "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
         "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
         "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
         "RequestedRangeNotSatisfiable", "ExpectationFailed", "MisdirectedRequest",
         "UnprocessableEntity", "Locked", "FailedDependency", "UpgradeRequired", "PreconditionRequired",
         "TooManyRequests", "RequestHeaderFieldsTooLarge", "UnavailableForLegalReasons",
         "InternalServerError", "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
         "HttpVersionNotSupported", "VariantAlsoNegotiates", "InsufficientStorage", "LoopDetected",
         "NotExtended", "NetworkAuthenticationRequired".
        :paramtype status_code: str or ~azure.mgmt.machinelearningservices.models.HttpStatusCode
        :keyword reason_phrase:
        :paramtype reason_phrase: str
        :keyword request_message:
        :paramtype request_message: ~azure.mgmt.machinelearningservices.models.HttpRequestMessage
        """
        super(HttpResponseMessage, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.content = kwargs.get('content', None)
        self.status_code = kwargs.get('status_code', None)
        self.reason_phrase = kwargs.get('reason_phrase', None)
        self.headers = None
        self.trailing_headers = None
        self.request_message = kwargs.get('request_message', None)
        self.is_success_status_code = None


class InnerErrorResponse(msrest.serialization.Model):
    """A nested structure of errors.

    :ivar code: The error code.
    :vartype code: str
    :ivar inner_error: A nested structure of errors.
    :vartype inner_error: ~azure.mgmt.machinelearningservices.models.InnerErrorResponse
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'InnerErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword inner_error: A nested structure of errors.
        :paramtype inner_error: ~azure.mgmt.machinelearningservices.models.InnerErrorResponse
        """
        super(InnerErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.inner_error = kwargs.get('inner_error', None)


class KeyValuePairStringIEnumerable1(msrest.serialization.Model):
    """KeyValuePairStringIEnumerable1.

    :ivar key:
    :vartype key: str
    :ivar value:
    :vartype value: list[str]
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key:
        :paramtype key: str
        :keyword value:
        :paramtype value: list[str]
        """
        super(KeyValuePairStringIEnumerable1, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class LongRunningOperationResponse1LongRunningOperationResponseObject(msrest.serialization.Model):
    """LongRunningOperationResponse1LongRunningOperationResponseObject.

    :ivar completion_result: Anything.
    :vartype completion_result: any
    :ivar location:
    :vartype location: str
    :ivar operation_result:
    :vartype operation_result: str
    """

    _attribute_map = {
        'completion_result': {'key': 'completionResult', 'type': 'object'},
        'location': {'key': 'location', 'type': 'str'},
        'operation_result': {'key': 'operationResult', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword completion_result: Anything.
        :paramtype completion_result: any
        :keyword location:
        :paramtype location: str
        :keyword operation_result:
        :paramtype operation_result: str
        """
        super(LongRunningOperationResponse1LongRunningOperationResponseObject, self).__init__(**kwargs)
        self.completion_result = kwargs.get('completion_result', None)
        self.location = kwargs.get('location', None)
        self.operation_result = kwargs.get('operation_result', None)


class Moments(msrest.serialization.Model):
    """Moments.

    :ivar mean:
    :vartype mean: float
    :ivar standard_deviation:
    :vartype standard_deviation: float
    :ivar variance:
    :vartype variance: float
    :ivar skewness:
    :vartype skewness: float
    :ivar kurtosis:
    :vartype kurtosis: float
    """

    _attribute_map = {
        'mean': {'key': 'mean', 'type': 'float'},
        'standard_deviation': {'key': 'standardDeviation', 'type': 'float'},
        'variance': {'key': 'variance', 'type': 'float'},
        'skewness': {'key': 'skewness', 'type': 'float'},
        'kurtosis': {'key': 'kurtosis', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mean:
        :paramtype mean: float
        :keyword standard_deviation:
        :paramtype standard_deviation: float
        :keyword variance:
        :paramtype variance: float
        :keyword skewness:
        :paramtype skewness: float
        :keyword kurtosis:
        :paramtype kurtosis: float
        """
        super(Moments, self).__init__(**kwargs)
        self.mean = kwargs.get('mean', None)
        self.standard_deviation = kwargs.get('standard_deviation', None)
        self.variance = kwargs.get('variance', None)
        self.skewness = kwargs.get('skewness', None)
        self.kurtosis = kwargs.get('kurtosis', None)


class PaginatedDataContainerEntityList(msrest.serialization.Model):
    """A paginated list of DataContainerEntitys.

    :ivar value: An array of objects of type DataContainerEntity.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainerEntity]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataContainerEntity]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type DataContainerEntity.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainerEntity]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedDataContainerEntityList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedDatasetDefinitionList(msrest.serialization.Model):
    """A paginated list of DatasetDefinitions.

    :ivar value: An array of objects of type DatasetDefinition.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DatasetDefinition]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetDefinition]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type DatasetDefinition.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DatasetDefinition]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedDatasetDefinitionList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedDatasetList(msrest.serialization.Model):
    """A paginated list of Datasets.

    :ivar value: An array of objects of type Dataset.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Dataset]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Dataset]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type Dataset.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Dataset]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedDatasetList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedDatasetV2List(msrest.serialization.Model):
    """A paginated list of DatasetV2s.

    :ivar value: An array of objects of type DatasetV2.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DatasetV2]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetV2]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type DatasetV2.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DatasetV2]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedDatasetV2List, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedDataVersionEntityList(msrest.serialization.Model):
    """A paginated list of DataVersionEntitys.

    :ivar value: An array of objects of type DataVersionEntity.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionEntity]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataVersionEntity]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type DataVersionEntity.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionEntity]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedDataVersionEntityList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedStringList(msrest.serialization.Model):
    """A paginated list of Strings.

    :ivar value: An array of objects of type String.
    :vartype value: list[str]
    :ivar continuation_token: The token used in retrieving the next page. If null, there are no
     additional pages.
    :vartype continuation_token: str
    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: An array of objects of type String.
        :paramtype value: list[str]
        :keyword continuation_token: The token used in retrieving the next page. If null, there are no
         additional pages.
        :paramtype continuation_token: str
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        """
        super(PaginatedStringList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class ProfileActionResult(msrest.serialization.Model):
    """ProfileActionResult.

    :ivar profile_action_id:
    :vartype profile_action_id: str
    :ivar status:
    :vartype status: str
    :ivar completed_on_utc:
    :vartype completed_on_utc: ~datetime.datetime
    :ivar action_result:
    :vartype action_result: ~azure.mgmt.machinelearningservices.models.ActionResult
    """

    _attribute_map = {
        'profile_action_id': {'key': 'profileActionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'completed_on_utc': {'key': 'completedOnUtc', 'type': 'iso-8601'},
        'action_result': {'key': 'actionResult', 'type': 'ActionResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword profile_action_id:
        :paramtype profile_action_id: str
        :keyword status:
        :paramtype status: str
        :keyword completed_on_utc:
        :paramtype completed_on_utc: ~datetime.datetime
        :keyword action_result:
        :paramtype action_result: ~azure.mgmt.machinelearningservices.models.ActionResult
        """
        super(ProfileActionResult, self).__init__(**kwargs)
        self.profile_action_id = kwargs.get('profile_action_id', None)
        self.status = kwargs.get('status', None)
        self.completed_on_utc = kwargs.get('completed_on_utc', None)
        self.action_result = kwargs.get('action_result', None)


class ProfileResult(msrest.serialization.Model):
    """ProfileResult.

    :ivar column_name:
    :vartype column_name: str
    :ivar type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
     "Unknown", "Error", "Null", "DataRow", "List", "Stream".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
    :ivar min:
    :vartype min: ~azure.mgmt.machinelearningservices.models.DataField
    :ivar max:
    :vartype max: ~azure.mgmt.machinelearningservices.models.DataField
    :ivar count:
    :vartype count: long
    :ivar missing_count:
    :vartype missing_count: long
    :ivar not_missing_count:
    :vartype not_missing_count: long
    :ivar percent_missing:
    :vartype percent_missing: float
    :ivar error_count:
    :vartype error_count: long
    :ivar empty_count:
    :vartype empty_count: long
    :ivar quantiles:
    :vartype quantiles: ~azure.mgmt.machinelearningservices.models.Quantiles
    :ivar whisker_top:
    :vartype whisker_top: float
    :ivar whisker_bottom:
    :vartype whisker_bottom: float
    :ivar moments:
    :vartype moments: ~azure.mgmt.machinelearningservices.models.Moments
    :ivar type_counts:
    :vartype type_counts: list[~azure.mgmt.machinelearningservices.models.TypeCount]
    :ivar value_counts:
    :vartype value_counts: list[~azure.mgmt.machinelearningservices.models.ValueCount]
    :ivar unique_values:
    :vartype unique_values: long
    :ivar histogram:
    :vartype histogram: list[~azure.mgmt.machinelearningservices.models.HistogramBin]
    :ivar s_type_counts:
    :vartype s_type_counts: list[~azure.mgmt.machinelearningservices.models.STypeCount]
    :ivar average_spaces_count:
    :vartype average_spaces_count: float
    :ivar string_lengths:
    :vartype string_lengths: list[~azure.mgmt.machinelearningservices.models.StringLengthCount]
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'min': {'key': 'min', 'type': 'DataField'},
        'max': {'key': 'max', 'type': 'DataField'},
        'count': {'key': 'count', 'type': 'long'},
        'missing_count': {'key': 'missingCount', 'type': 'long'},
        'not_missing_count': {'key': 'notMissingCount', 'type': 'long'},
        'percent_missing': {'key': 'percentMissing', 'type': 'float'},
        'error_count': {'key': 'errorCount', 'type': 'long'},
        'empty_count': {'key': 'emptyCount', 'type': 'long'},
        'quantiles': {'key': 'quantiles', 'type': 'Quantiles'},
        'whisker_top': {'key': 'whiskerTop', 'type': 'float'},
        'whisker_bottom': {'key': 'whiskerBottom', 'type': 'float'},
        'moments': {'key': 'moments', 'type': 'Moments'},
        'type_counts': {'key': 'typeCounts', 'type': '[TypeCount]'},
        'value_counts': {'key': 'valueCounts', 'type': '[ValueCount]'},
        'unique_values': {'key': 'uniqueValues', 'type': 'long'},
        'histogram': {'key': 'histogram', 'type': '[HistogramBin]'},
        's_type_counts': {'key': 'sTypeCounts', 'type': '[STypeCount]'},
        'average_spaces_count': {'key': 'averageSpacesCount', 'type': 'float'},
        'string_lengths': {'key': 'stringLengths', 'type': '[StringLengthCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword column_name:
        :paramtype column_name: str
        :keyword type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
         "Unknown", "Error", "Null", "DataRow", "List", "Stream".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
        :keyword min:
        :paramtype min: ~azure.mgmt.machinelearningservices.models.DataField
        :keyword max:
        :paramtype max: ~azure.mgmt.machinelearningservices.models.DataField
        :keyword count:
        :paramtype count: long
        :keyword missing_count:
        :paramtype missing_count: long
        :keyword not_missing_count:
        :paramtype not_missing_count: long
        :keyword percent_missing:
        :paramtype percent_missing: float
        :keyword error_count:
        :paramtype error_count: long
        :keyword empty_count:
        :paramtype empty_count: long
        :keyword quantiles:
        :paramtype quantiles: ~azure.mgmt.machinelearningservices.models.Quantiles
        :keyword whisker_top:
        :paramtype whisker_top: float
        :keyword whisker_bottom:
        :paramtype whisker_bottom: float
        :keyword moments:
        :paramtype moments: ~azure.mgmt.machinelearningservices.models.Moments
        :keyword type_counts:
        :paramtype type_counts: list[~azure.mgmt.machinelearningservices.models.TypeCount]
        :keyword value_counts:
        :paramtype value_counts: list[~azure.mgmt.machinelearningservices.models.ValueCount]
        :keyword unique_values:
        :paramtype unique_values: long
        :keyword histogram:
        :paramtype histogram: list[~azure.mgmt.machinelearningservices.models.HistogramBin]
        :keyword s_type_counts:
        :paramtype s_type_counts: list[~azure.mgmt.machinelearningservices.models.STypeCount]
        :keyword average_spaces_count:
        :paramtype average_spaces_count: float
        :keyword string_lengths:
        :paramtype string_lengths: list[~azure.mgmt.machinelearningservices.models.StringLengthCount]
        """
        super(ProfileResult, self).__init__(**kwargs)
        self.column_name = kwargs.get('column_name', None)
        self.type = kwargs.get('type', None)
        self.min = kwargs.get('min', None)
        self.max = kwargs.get('max', None)
        self.count = kwargs.get('count', None)
        self.missing_count = kwargs.get('missing_count', None)
        self.not_missing_count = kwargs.get('not_missing_count', None)
        self.percent_missing = kwargs.get('percent_missing', None)
        self.error_count = kwargs.get('error_count', None)
        self.empty_count = kwargs.get('empty_count', None)
        self.quantiles = kwargs.get('quantiles', None)
        self.whisker_top = kwargs.get('whisker_top', None)
        self.whisker_bottom = kwargs.get('whisker_bottom', None)
        self.moments = kwargs.get('moments', None)
        self.type_counts = kwargs.get('type_counts', None)
        self.value_counts = kwargs.get('value_counts', None)
        self.unique_values = kwargs.get('unique_values', None)
        self.histogram = kwargs.get('histogram', None)
        self.s_type_counts = kwargs.get('s_type_counts', None)
        self.average_spaces_count = kwargs.get('average_spaces_count', None)
        self.string_lengths = kwargs.get('string_lengths', None)


class Quantiles(msrest.serialization.Model):
    """Quantiles.

    :ivar p0_d1:
    :vartype p0_d1: float
    :ivar p1:
    :vartype p1: float
    :ivar p5:
    :vartype p5: float
    :ivar p25:
    :vartype p25: float
    :ivar p50:
    :vartype p50: float
    :ivar p75:
    :vartype p75: float
    :ivar p95:
    :vartype p95: float
    :ivar p99:
    :vartype p99: float
    :ivar p99_d9:
    :vartype p99_d9: float
    """

    _attribute_map = {
        'p0_d1': {'key': 'p0D1', 'type': 'float'},
        'p1': {'key': 'p1', 'type': 'float'},
        'p5': {'key': 'p5', 'type': 'float'},
        'p25': {'key': 'p25', 'type': 'float'},
        'p50': {'key': 'p50', 'type': 'float'},
        'p75': {'key': 'p75', 'type': 'float'},
        'p95': {'key': 'p95', 'type': 'float'},
        'p99': {'key': 'p99', 'type': 'float'},
        'p99_d9': {'key': 'p99D9', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword p0_d1:
        :paramtype p0_d1: float
        :keyword p1:
        :paramtype p1: float
        :keyword p5:
        :paramtype p5: float
        :keyword p25:
        :paramtype p25: float
        :keyword p50:
        :paramtype p50: float
        :keyword p75:
        :paramtype p75: float
        :keyword p95:
        :paramtype p95: float
        :keyword p99:
        :paramtype p99: float
        :keyword p99_d9:
        :paramtype p99_d9: float
        """
        super(Quantiles, self).__init__(**kwargs)
        self.p0_d1 = kwargs.get('p0_d1', None)
        self.p1 = kwargs.get('p1', None)
        self.p5 = kwargs.get('p5', None)
        self.p25 = kwargs.get('p25', None)
        self.p50 = kwargs.get('p50', None)
        self.p75 = kwargs.get('p75', None)
        self.p95 = kwargs.get('p95', None)
        self.p99 = kwargs.get('p99', None)
        self.p99_d9 = kwargs.get('p99_d9', None)


class RegisterExistingData(msrest.serialization.Model):
    """RegisterExistingData.

    All required parameters must be populated in order to send to Azure.

    :ivar existing_unregistered_asset_id: Required.
    :vartype existing_unregistered_asset_id: str
    :ivar name: Required.
    :vartype name: str
    :ivar version:
    :vartype version: str
    """

    _validation = {
        'existing_unregistered_asset_id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'existing_unregistered_asset_id': {'key': 'existingUnregisteredAssetId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword existing_unregistered_asset_id: Required.
        :paramtype existing_unregistered_asset_id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword version:
        :paramtype version: str
        """
        super(RegisterExistingData, self).__init__(**kwargs)
        self.existing_unregistered_asset_id = kwargs['existing_unregistered_asset_id']
        self.name = kwargs['name']
        self.version = kwargs.get('version', None)


class RootError(msrest.serialization.Model):
    """The root error.

    :ivar code: The service-defined error code. Supported error codes: ServiceError, UserError,
     ValidationError, AzureStorageError, TransientError, RequestThrottled.
    :vartype code: str
    :ivar severity: The Severity of error.
    :vartype severity: int
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    :ivar message_format: An unformatted version of the message with no variable substitution.
    :vartype message_format: str
    :ivar message_parameters: Value substitutions corresponding to the contents of MessageFormat.
    :vartype message_parameters: dict[str, str]
    :ivar reference_code: This code can optionally be set by the system generating the error.
     It should be used to classify the problem and identify the module and code area where the
     failure occured.
    :vartype reference_code: str
    :ivar details_uri: A URI which points to more details about the context of the error.
    :vartype details_uri: str
    :ivar target: The target of the error (e.g., the name of the property in error).
    :vartype target: str
    :ivar details: The related errors that occurred during the request.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.RootError]
    :ivar inner_error: A nested structure of errors.
    :vartype inner_error: ~azure.mgmt.machinelearningservices.models.InnerErrorResponse
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'int'},
        'message': {'key': 'message', 'type': 'str'},
        'message_format': {'key': 'messageFormat', 'type': 'str'},
        'message_parameters': {'key': 'messageParameters', 'type': '{str}'},
        'reference_code': {'key': 'referenceCode', 'type': 'str'},
        'details_uri': {'key': 'detailsUri', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[RootError]'},
        'inner_error': {'key': 'innerError', 'type': 'InnerErrorResponse'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: The service-defined error code. Supported error codes: ServiceError, UserError,
         ValidationError, AzureStorageError, TransientError, RequestThrottled.
        :paramtype code: str
        :keyword severity: The Severity of error.
        :paramtype severity: int
        :keyword message: A human-readable representation of the error.
        :paramtype message: str
        :keyword message_format: An unformatted version of the message with no variable substitution.
        :paramtype message_format: str
        :keyword message_parameters: Value substitutions corresponding to the contents of
         MessageFormat.
        :paramtype message_parameters: dict[str, str]
        :keyword reference_code: This code can optionally be set by the system generating the error.
         It should be used to classify the problem and identify the module and code area where the
         failure occured.
        :paramtype reference_code: str
        :keyword details_uri: A URI which points to more details about the context of the error.
        :paramtype details_uri: str
        :keyword target: The target of the error (e.g., the name of the property in error).
        :paramtype target: str
        :keyword details: The related errors that occurred during the request.
        :paramtype details: list[~azure.mgmt.machinelearningservices.models.RootError]
        :keyword inner_error: A nested structure of errors.
        :paramtype inner_error: ~azure.mgmt.machinelearningservices.models.InnerErrorResponse
        :keyword additional_info: The error additional info.
        :paramtype additional_info:
         list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
        """
        super(RootError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.severity = kwargs.get('severity', None)
        self.message = kwargs.get('message', None)
        self.message_format = kwargs.get('message_format', None)
        self.message_parameters = kwargs.get('message_parameters', None)
        self.reference_code = kwargs.get('reference_code', None)
        self.details_uri = kwargs.get('details_uri', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)
        self.additional_info = kwargs.get('additional_info', None)


class SqlDataPath(msrest.serialization.Model):
    """SqlDataPath.

    :ivar sql_table_name:
    :vartype sql_table_name: str
    :ivar sql_query:
    :vartype sql_query: str
    :ivar sql_stored_procedure_name:
    :vartype sql_stored_procedure_name: str
    :ivar sql_stored_procedure_params:
    :vartype sql_stored_procedure_params:
     list[~azure.mgmt.machinelearningservices.models.StoredProcedureParameter]
    :ivar query_timeout:
    :vartype query_timeout: long
    """

    _attribute_map = {
        'sql_table_name': {'key': 'sqlTableName', 'type': 'str'},
        'sql_query': {'key': 'sqlQuery', 'type': 'str'},
        'sql_stored_procedure_name': {'key': 'sqlStoredProcedureName', 'type': 'str'},
        'sql_stored_procedure_params': {'key': 'sqlStoredProcedureParams', 'type': '[StoredProcedureParameter]'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sql_table_name:
        :paramtype sql_table_name: str
        :keyword sql_query:
        :paramtype sql_query: str
        :keyword sql_stored_procedure_name:
        :paramtype sql_stored_procedure_name: str
        :keyword sql_stored_procedure_params:
        :paramtype sql_stored_procedure_params:
         list[~azure.mgmt.machinelearningservices.models.StoredProcedureParameter]
        :keyword query_timeout:
        :paramtype query_timeout: long
        """
        super(SqlDataPath, self).__init__(**kwargs)
        self.sql_table_name = kwargs.get('sql_table_name', None)
        self.sql_query = kwargs.get('sql_query', None)
        self.sql_stored_procedure_name = kwargs.get('sql_stored_procedure_name', None)
        self.sql_stored_procedure_params = kwargs.get('sql_stored_procedure_params', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class StoredProcedureParameter(msrest.serialization.Model):
    """StoredProcedureParameter.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    :ivar type: Possible values include: "String", "Int", "Decimal", "Guid", "Boolean", "Date".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.StoredProcedureParameterType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword value:
        :paramtype value: str
        :keyword type: Possible values include: "String", "Int", "Decimal", "Guid", "Boolean", "Date".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.StoredProcedureParameterType
        """
        super(StoredProcedureParameter, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.type = kwargs.get('type', None)


class StringLengthCount(msrest.serialization.Model):
    """StringLengthCount.

    :ivar length:
    :vartype length: long
    :ivar count:
    :vartype count: long
    """

    _attribute_map = {
        'length': {'key': 'length', 'type': 'long'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword length:
        :paramtype length: long
        :keyword count:
        :paramtype count: long
        """
        super(StringLengthCount, self).__init__(**kwargs)
        self.length = kwargs.get('length', None)
        self.count = kwargs.get('count', None)


class STypeCount(msrest.serialization.Model):
    """STypeCount.

    :ivar s_type: Possible values include: "EmailAddress", "GeographicCoordinate", "Ipv4Address",
     "Ipv6Address", "UsPhoneNumber", "ZipCode".
    :vartype s_type: str or ~azure.mgmt.machinelearningservices.models.SType
    :ivar count:
    :vartype count: long
    """

    _attribute_map = {
        's_type': {'key': 'sType', 'type': 'str'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword s_type: Possible values include: "EmailAddress", "GeographicCoordinate",
         "Ipv4Address", "Ipv6Address", "UsPhoneNumber", "ZipCode".
        :paramtype s_type: str or ~azure.mgmt.machinelearningservices.models.SType
        :keyword count:
        :paramtype count: long
        """
        super(STypeCount, self).__init__(**kwargs)
        self.s_type = kwargs.get('s_type', None)
        self.count = kwargs.get('count', None)


class TypeCount(msrest.serialization.Model):
    """TypeCount.

    :ivar type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
     "Unknown", "Error", "Null", "DataRow", "List", "Stream".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
    :ivar count:
    :vartype count: long
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Possible values include: "String", "Boolean", "Integer", "Decimal", "Date",
         "Unknown", "Error", "Null", "DataRow", "List", "Stream".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.FieldType
        :keyword count:
        :paramtype count: long
        """
        super(TypeCount, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.count = kwargs.get('count', None)


class User(msrest.serialization.Model):
    """User.

    :ivar user_object_id: A user or service principal's object ID.
     This is EUPI and may only be logged to warm path telemetry.
    :vartype user_object_id: str
    :ivar user_pu_id: A user or service principal's PuID.
     This is PII and should never be logged.
    :vartype user_pu_id: str
    :ivar user_idp: A user identity provider. Eg live.com
     This is PII and should never be logged.
    :vartype user_idp: str
    :ivar user_alt_sec_id: A user alternate sec id. This represents the user in a different
     identity provider system Eg.1:live.com:puid
     This is PII and should never be logged.
    :vartype user_alt_sec_id: str
    :ivar user_iss: The issuer which issed the token for this user.
     This is PII and should never be logged.
    :vartype user_iss: str
    :ivar user_tenant_id: A user or service principal's tenant ID.
    :vartype user_tenant_id: str
    :ivar user_name: A user's full name or a service principal's app ID.
     This is PII and should never be logged.
    :vartype user_name: str
    :ivar upn: A user's Principal name (upn)
     This is PII andshould never be logged.
    :vartype upn: str
    """

    _attribute_map = {
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
        'user_pu_id': {'key': 'userPuId', 'type': 'str'},
        'user_idp': {'key': 'userIdp', 'type': 'str'},
        'user_alt_sec_id': {'key': 'userAltSecId', 'type': 'str'},
        'user_iss': {'key': 'userIss', 'type': 'str'},
        'user_tenant_id': {'key': 'userTenantId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_object_id: A user or service principal's object ID.
         This is EUPI and may only be logged to warm path telemetry.
        :paramtype user_object_id: str
        :keyword user_pu_id: A user or service principal's PuID.
         This is PII and should never be logged.
        :paramtype user_pu_id: str
        :keyword user_idp: A user identity provider. Eg live.com
         This is PII and should never be logged.
        :paramtype user_idp: str
        :keyword user_alt_sec_id: A user alternate sec id. This represents the user in a different
         identity provider system Eg.1:live.com:puid
         This is PII and should never be logged.
        :paramtype user_alt_sec_id: str
        :keyword user_iss: The issuer which issed the token for this user.
         This is PII and should never be logged.
        :paramtype user_iss: str
        :keyword user_tenant_id: A user or service principal's tenant ID.
        :paramtype user_tenant_id: str
        :keyword user_name: A user's full name or a service principal's app ID.
         This is PII and should never be logged.
        :paramtype user_name: str
        :keyword upn: A user's Principal name (upn)
         This is PII andshould never be logged.
        :paramtype upn: str
        """
        super(User, self).__init__(**kwargs)
        self.user_object_id = kwargs.get('user_object_id', None)
        self.user_pu_id = kwargs.get('user_pu_id', None)
        self.user_idp = kwargs.get('user_idp', None)
        self.user_alt_sec_id = kwargs.get('user_alt_sec_id', None)
        self.user_iss = kwargs.get('user_iss', None)
        self.user_tenant_id = kwargs.get('user_tenant_id', None)
        self.user_name = kwargs.get('user_name', None)
        self.upn = kwargs.get('upn', None)


class ValueCount(msrest.serialization.Model):
    """ValueCount.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DataField
    :ivar count:
    :vartype count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DataField'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DataField
        :keyword count:
        :paramtype count: long
        """
        super(ValueCount, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
