/*
 * JSplashTester.java - Test application for JSplash
 *
 * Copyright (c) 2004-2011 Gregory Kotsaftis
 * gregkotsaftis@yahoo.com
 * http://zeus-jscl.sourceforge.net/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package gr.zeus.tests;

import gr.zeus.ui.JSplash;
import gr.zeus.util.GUIUtils;
import java.awt.Color;
import java.awt.Font;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JSplashTester extends JFrame {


    public JSplashTester()
    {
        init_lnf();

        initComponents();

        GUIUtils.centerOnScreen( this );
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        javax.swing.JButton exitButton = new javax.swing.JButton();
        javax.swing.JTextArea jTextArea1 = new javax.swing.JTextArea();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Sample Application to demonstrate JSplash");

        exitButton.setText("Exit");
        exitButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                exitButtonActionPerformed(evt);
            }
        });
        getContentPane().add(exitButton, java.awt.BorderLayout.NORTH);

        jTextArea1.setColumns(60);
        jTextArea1.setRows(10);
        jTextArea1.setText("Hello world!\n");
        getContentPane().add(jTextArea1, java.awt.BorderLayout.CENTER);

        jLabel1.setText("application loaded");
        getContentPane().add(jLabel1, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed

        System.exit( 0 );

    }//GEN-LAST:event_exitButtonActionPerformed


    /**
     * setup our look and feel
     */
    private void init_lnf()
    {
        try
        {
            UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName() );
        }
        catch( Exception e )
        {
            System.err.println("Cannot initialize the look & feel");

            e.printStackTrace();
        }
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        String[] loadingMessages = {
            null, // at first, don't display a message
            "Initializing", "Loading libraries", "Applying configuration",
            "Setting up logger", "Applying license", "Connecting to db",
            "Quering customers", "Quering products & catalogs",
            "Starting up GUI",
            null // at the end don't display a message,
                 // keep last message longer on display
        };

        int res = JOptionPane.showConfirmDialog(
            new JFrame(),
            "YES=custom messages, NO=no messages, CANCEL=display percent",
            "Loading Messages Option", JOptionPane.YES_NO_CANCEL_OPTION,
            JOptionPane.INFORMATION_MESSAGE, null);
        boolean displayMessages = (res==0);
        boolean displayPercent = (res==2);

        // load and prepare the splash screen,
        // could be done with 'static final' as well...
        JSplash m_splash = new JSplash(
            JSplashTester.class.getResource(
                "/gr/zeus/tests/res/splash.jpg"), // the image
            true, // do we want a progress bar?
            displayMessages, // do we want messages displayed during loading?
            displayPercent, // do we want percent displayed instead of messages?
            "v1.00 build 35", // do we want to display a text message at the
                              // bottom-right corner e.g. version number
            new Font("Tahoma", 0, 11), // do we want another font?
            Color.RED ); // do we need another color other than black?

        // when we start our main() method, we invoke:
        m_splash.splashOn();

        // in several points in our code we invoke m_splash.setProgress()
        // in order to increase the progress bar...
        // e.g. m_splash.setProgress( 10 );
        //      (call some methods);
        //      m_splash.setProgress( 30 );
        //      (call some methods);
        //      m_splash.setProgress( 100 ); // finished!
        //
        // Here we will do just a simulation
        //
        Random r = new Random();
        for(int i=0, j=0; i<=100; i+=10, j++)
        {
            int millis = (r.nextInt( 10 ) + 1) * 100;

            if( displayMessages && !displayPercent )
            {
                m_splash.setProgress(i, loadingMessages[j]);
            }
            else
            {
                m_splash.setProgress( i );
            }

            try
            {
                Thread.sleep( millis );
            }
            catch(Exception e)
            {
                // do nothing
            }
        }

        // give the user a sec to see the complete splash screen 100%
        try
        {
            Thread.sleep( 1000 );
        }
        catch(Exception e)
        {
            // do nothing
        }

        // finished loading our application, hide splash
        m_splash.splashOff();

        // ...finally display your application GUI...
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JSplashTester().setVisible(true);
            }
        });
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
