/*************************************************************
 *                                                           *
 *    ths  Filesystem                  04.08.94      V0.1    *
 *                                                           *
 *    Thomas Scheuermann     ths@ai-lab.fh-furtwangen.de     *
 *                                                           *
 *************************************************************/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/locks.h>
#include <linux/fs.h>
#include <linux/malloc.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/bitops.h>

#include "ths.h"
#include "ths_i.h"
#include "version.h"

extern int printk( const char* fmt, ...);

/*
 * Struktur fuer die Uebergabe an den Kern zur
 * Registrierung des Filesystems
 */

static struct file_system_type ths_type = {
        ths_read_super,
        "ths",
        1
};

/*
 * Funktion zum Einbinden des Moduls in den Kern
 */

int init_module(void)
{       int res;

        res = register_filesystem(&ths_type);
        return res;
}

/*
 * Funktion zum Loeschen des Moduls aus dem Kern
 */

void cleanup_module(void)
{       int res;

        if (MOD_IN_USE)
                printk("ths: filesystem in use, removal delayed\n");

        res = unregister_filesystem(&ths_type);
        if (res < 0) {
                printk("ths: cannot unregister file system type\n");
        }
}

