#include <stdio.h>
#include "smbfs.h"
#include "errlog.h"
#include "unistd.h"

/*****************************************************************************/
/*                                                                           */
/*  errlog                                                                   */
/*                                                                           */
/*****************************************************************************/
void
errlog(const char *s)
{
  fprintf(stderr, s);
}

/*****************************************************************************/
/*                                                                           */
/*  main                                                                     */
/*                                                                           */
/*****************************************************************************/
void
main(int argc, char **argv)
{
#if DEBUG > 0
  ErrLogInit(errlog, ERR_ALL);
  /* so you can attach to the process by gdb */
  printf("If you want to attach gdb to me, type 'gdb smbfs %d'.\n", getpid());
  printf("And type return.\n");
  getchar();
#else
  ErrLogInit(errlog, ERR_FAILURE);
#endif
  userfs(argc, argv, smb_fscalls());
}

