#ifndef _INODE_H_
#define _INODE_H_

#include "basic.h"
#include "fslib.h"
#include "smblib.h"
#include "pstr.h"

enum i_state {
  INODE_VALID = 19,             /* We won't hit this by accident,
                                 I hope. */
  INODE_LOOKED_UP,
  INODE_CACHED,
  INODE_INVALID
};

struct f_inode {

  Bool       opened;
  sfid_t     fid;
  int        access;            /* O_RDONLY, O_WRONLY or O_RDWR */

  enum i_state    state;
  Inode      i;
  struct f_inode *dir;         /* Where are we? */
  int        nused;             /* for dirs: References */
  struct f_inode *next, *prev;
  pstr       path;
};

void
inodes_init(void);

struct f_inode *
new_f_inode(struct smb_conn *conn, struct f_inode *dir, const char *fname);

Bool
no_more_inodes(void);

struct f_inode *
find_f_inode(struct smb_conn *conn, struct f_inode *dir, const char *fname);

void
free_f_inode(struct f_inode *i);

struct f_inode *
make_root(struct smb_conn *conn);

pstr
dir_next_name(struct smb_conn *conn, struct f_inode *dir, off_t off);

void 
invalidate_dir_cache(struct f_inode *dir);

void
rename_f_inode(struct f_inode *f, pstr newname);

pstr
make_path(pstr dir, pstr name);

void
smb_finfo2inode(struct smb_conn *conn, struct smb_finfo *finfo, Inode *i);

#if DEBUG > 0
void
_AssertInode(const char *f, int l, struct f_inode *i);
#define AssertInode(i) _AssertInode( __FILE__, __LINE__, i)
#else
#define AssertInode(i)
#endif /* DEBUG > 0 */

#endif /* _INODE_H_ */
