/*
 * Misc functions, for command execution and so on
 */
#include <stdlib.h>
#include <string.h>
#include "misc.h"

struct cmdarg *add_cmdarg(struct cmdarg *l, const char *str)
{
	struct cmdarg *lp, *new;

	new = malloc(sizeof(*new));
	new->n = NULL;
	new->str = strdup(str);

	if (l == NULL)
		return new;

	for(lp = l; lp->n != NULL; lp = lp->n)
		;
	lp->n = new;

	return l;
}

char *cat_args(struct cmdarg *l)
{
	int len;
	struct cmdarg *lp;
	char *str, *cp;
	
	for(len = 0, lp = l; lp != NULL; len += strlen(l->str)+1, lp = lp->n)
		;

	str = malloc(len);

	for(cp = str, lp = l; lp != NULL; lp = lp->n, *cp++ = ' ')
	{
		strcpy(cp, lp->str);
		cp += strlen(lp->str);
	}

	cp[-1] = 0;
	return str;
}
