/*
 * ps_subr.c -	functions shared by ps and top
 *
 * Copyright (c) 1993 Branko Lankester
 *
 */

#include <linux/sched.h>
#include <linux/mm.h>
#include "ps.h"


unsigned long nr_pages;
unsigned long jiffies;
unsigned long startup_time;
unsigned short *memmap;


char *
status(task, stack)
struct task_struct *task;
reg_t * stack;
{
    static char buf[5] = "    ";

    buf[0] = "RSDZTP" [task->state];
    buf[1] = (task->rss == 0 && task->state != TASK_ZOMBIE ? 'W' : ' ');
    if (task->priority > PZERO)
	buf[2] = '<';
    else if (task->priority < PZERO)
	buf[2] = 'N';
    else
	buf[2] = ' ';
    return(buf);
}


char *
wchan(ebp, stack, numeric)
reg_t ebp;
reg_t *stack;
{
    reg_t eip;
    int bp;
    static char buf[16], *p;

    bp = (ebp & PAGE_MASK) >> 2;
    eip = stack[bp + 1];
    p = find_func(eip);
    if (strcmp(p, "sleep_on") == 0 ||
		strcmp(p, "interruptible_sleep_on") == 0)
	return(wchan(stack[bp], stack, numeric));
    
    if (numeric) {
	sprintf(buf, "%x", eip);
	return(buf);
    }
    if (strncmp(p, "sys_", 4) == 0)
	p += 4;
    while (*p == '_' && *p)
	++p;
    return(p);
}

get_memmap()
{
#ifdef USE_MMAP
    if (memmap == NULL)
	memmap = KPTR(KWORD(k_addr("_mem_map")));
#else
    static unsigned long _mem_map;

    if (memmap == NULL) {
	_mem_map = get_kword(k_addr("_mem_map"));
	memmap = (unsigned short *) xmalloc(nr_pages * sizeof *memmap);
    }
    kmemread(memmap, _mem_map, nr_pages * sizeof *memmap);
#endif
}

read_globals()
{

    nr_pages = get_kword(k_addr("_high_memory")) / 4096;
    startup_time = get_kword(k_addr("_startup_time"));
    jiffies = get_kword(k_addr("_jiffies"));
}

struct mem_info *
get_mem_info(task)
struct task_struct *task;
{
    int i;
#ifdef USE_MMAP
    unsigned long *pagetbl, *pte, *pagedir;
#else
    unsigned long pagetbl[PAGE_SIZE/4], *pte;
    unsigned long pagedir[0x300];
#endif
    unsigned long ptbl;
    int size=0;
    int tpag = task->end_code / PAGE_SIZE;
    unsigned map_nr;
    static struct mem_info mi;

    memset(&mi, 0, sizeof(struct mem_info));
    if (task->state == TASK_ZOMBIE)
	return &mi;
    if (!memmap)
	get_memmap();

#ifdef USE_MMAP
    if (mmap_page(task->tss.cr3) < 0)
	return &mi;
    pagedir = KPTR(task->tss.cr3);
#else
    if (kmemread(pagedir, task->tss.cr3 + (task->start_code >> 20),
	    sizeof pagedir) < 0)
	return &mi;
#endif

    for (i = 0; i < 0x300; ++i) {
	if ((ptbl = pagedir[i]) == 0) {
	    tpag -= 1024;
	    continue;
	}
#ifdef USE_MMAP
	if (mmap_page(ptbl) < 0)
	    break;
	pagetbl = KPTR(ptbl & 0xfffff000);
#else
	if (kmemread(pagetbl, ptbl & 0xfffff000, sizeof pagetbl) < 0)
	    break;
#endif
	for (pte = pagetbl; pte < &pagetbl[1024]; ++pte) {
	    if (*pte != 0) {
		++size;
		if (*pte & PAGE_PRESENT) {
		    ++mi.rss;
		    if (tpag > 0)
			++mi.trs;
		    else
			++mi.drs;
		    if (i >= 15 && i < 0x2f0) {
			++mi.lrs;
			if (*pte & 0x40)
			    ++mi.dt;
			else
			    --mi.drs;
		    }
		    map_nr = MAP_NR(*pte);
		    if (map_nr < nr_pages && memmap[map_nr] > 1) {
			++mi.share;
			mi.pmem += 1000 / memmap[MAP_NR(*pte)];
		    } else
			mi.pmem += 1000;

		    if ((*pte & PAGE_RW) == 0) ++mi.wp;
		    if (*pte & PAGE_DIRTY) ++mi.dirt;
		    if (*pte & PAGE_ACCESSED) ++mi.acc;
		}
	    }
	    --tpag;
	}
    }
    mi.pmem /= nr_pages;
    mi.size = size;
    mi.swap = size - mi.rss;
    return &mi;
}
