/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.BackReferenceReplacer;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.ConditionMatch;
import org.tuckey.web.filters.urlrewrite.RuleExecutionOutput;
import org.tuckey.web.filters.urlrewrite.Run;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.VariableReplacer;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class RuleBase {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$RuleBase == null ? (class$org$tuckey$web$filters$urlrewrite$RuleBase = RuleBase.class$("org.tuckey.web.filters.urlrewrite.RuleBase")) : class$org$tuckey$web$filters$urlrewrite$RuleBase);
    protected int id;
    private boolean enabled = true;
    private boolean fromCaseSensitive;
    protected boolean initialised;
    protected boolean valid;
    protected String name;
    private String note;
    protected String from;
    protected String to;
    private boolean toEmpty;
    private boolean last = false;
    protected boolean encodeToUrl;
    private int conditionIdCounter;
    private int runIdCounter;
    private Pattern pattern;
    protected final List errors = new ArrayList(5);
    private final List conditions = new ArrayList(5);
    private final List runs = new ArrayList(2);
    protected final List setAttributes = new ArrayList(2);
    private boolean stopFilterChainOnMatch = false;
    protected static final String STOP_FILTER_CHANGE_MATCH_VALUE = "__STOP_FILTER_CHANGE_MATCH_VALUE__";
    private boolean toContainsVariable = false;
    private boolean toContainsBackReference = false;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$RuleBase;

    protected RuleExecutionOutput executeBase(String url, HttpServletRequest hsRequest, HttpServletResponse hsResponse) throws IOException, ServletException {
        int runsSize;
        if (log.isDebugEnabled()) {
            String displayName = this.getDisplayName();
            log.debug(displayName + " run called with " + url);
        }
        if (!this.initialised) {
            log.debug("not initialised, skipping");
            return null;
        }
        if (!this.valid) {
            log.debug("not valid, skipping");
            return null;
        }
        if (!this.enabled) {
            log.debug("not enabled, skipping");
            return null;
        }
        Matcher matcher = this.pattern.matcher(url);
        boolean performToReplacement = false;
        if (this.toEmpty || this.stopFilterChainOnMatch) {
            if (!matcher.find()) {
                if (log.isTraceEnabled()) {
                    log.trace("no match on \"from\" (to is empty)");
                }
                return null;
            }
        } else {
            if (!matcher.find()) {
                if (log.isTraceEnabled()) {
                    log.trace("no match on \"from\" for " + this.from + " and " + url);
                }
                return null;
            }
            if (!this.toEmpty) {
                performToReplacement = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("matched \"from\"");
        }
        int conditionsSize = this.conditions.size();
        ConditionMatch lastConditionMatch = null;
        if (conditionsSize > 0) {
            boolean processNextOr = false;
            boolean currentResult = true;
            for (int i = 0; i < conditionsSize; ++i) {
                boolean conditionMatches;
                Condition condition = (Condition)this.conditions.get(i);
                ConditionMatch conditionMatch = condition.getConditionMatch(hsRequest);
                if (conditionMatch != null) {
                    lastConditionMatch = conditionMatch;
                }
                boolean bl = conditionMatches = conditionMatch != null;
                currentResult = processNextOr ? (currentResult |= conditionMatches) : (currentResult &= conditionMatches);
                processNextOr = condition.isProcessNextOr();
            }
            if (!currentResult) {
                log.debug("conditions do not match");
                return null;
            }
            log.debug("conditions match");
        }
        String replacedTo = null;
        if (performToReplacement) {
            replacedTo = this.to;
            if (replacedTo != null) {
                if (this.toContainsVariable) {
                    replacedTo = VariableReplacer.replace(replacedTo, hsRequest);
                }
                if (this.toContainsBackReference) {
                    replacedTo = BackReferenceReplacer.replace(lastConditionMatch, replacedTo);
                }
            }
            replacedTo = matcher.replaceAll(replacedTo);
        }
        RuleExecutionOutput ruleExecutionOutput = new RuleExecutionOutput(replacedTo, true);
        int setAttributesSize = this.setAttributes.size();
        if (setAttributesSize > 0) {
            log.trace("setting sttributes");
            for (int i = 0; i < setAttributesSize; ++i) {
                SetAttribute setAttribute = (SetAttribute)this.setAttributes.get(i);
                setAttribute.execute(lastConditionMatch, matcher, hsRequest, hsResponse);
            }
        }
        if ((runsSize = this.runs.size()) > 0) {
            log.trace("performing runs");
            for (int i = 0; i < runsSize; ++i) {
                Run run = (Run)this.runs.get(i);
                run.execute(hsRequest, hsResponse);
            }
        }
        if (this.toEmpty) {
            log.debug("'to' is empty, no rewrite, only 'set' and or 'run'");
            return null;
        }
        if (this.stopFilterChainOnMatch) {
            ruleExecutionOutput.setStopFilterMatch(true);
            ruleExecutionOutput.setReplacedUrl(null);
        }
        return ruleExecutionOutput;
    }

    public String getDisplayName() {
        return null;
    }

    public boolean initialise(ServletContext context) {
        int i;
        this.initialised = true;
        boolean ok = true;
        for (i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (condition.initialise()) continue;
            ok = false;
        }
        for (i = 0; i < this.runs.size(); ++i) {
            Run run = (Run)this.runs.get(i);
            if (run.initialise(context)) continue;
            ok = false;
        }
        for (i = 0; i < this.setAttributes.size(); ++i) {
            SetAttribute setAttribute = (SetAttribute)this.setAttributes.get(i);
            if (setAttribute.initialise()) continue;
            ok = false;
        }
        if (StringUtils.isBlank(this.from)) {
            this.addError("from is not valid because it is blank");
        } else {
            try {
                this.pattern = this.fromCaseSensitive ? Pattern.compile(this.from) : Pattern.compile(this.from, 2);
            }
            catch (PatternSyntaxException e) {
                this.addError("from (" + this.from + ") is an invalid regular expression - " + e.getMessage());
            }
        }
        if (StringUtils.isBlank(this.to) && this.setAttributes.size() == 0 && this.runs.size() == 0) {
            this.addError("to is not valid because it is blank");
        } else if ("null".equalsIgnoreCase(this.to)) {
            this.stopFilterChainOnMatch = true;
        } else if (StringUtils.isBlank(this.to)) {
            this.toEmpty = true;
        } else if (!StringUtils.isBlank(this.to)) {
            if (BackReferenceReplacer.containsBackRef(this.to)) {
                this.toContainsBackReference = true;
            }
            if (VariableReplacer.containsVariable(this.to)) {
                this.toContainsVariable = true;
            }
        }
        if (ok) {
            log.debug("loaded rule " + this.getFullDisplayName());
        } else {
            log.debug("failed to load rule");
        }
        if (this.errors.size() > 0) {
            ok = false;
        }
        this.valid = ok;
        return ok;
    }

    public boolean isToContainsBackReference() {
        return this.toContainsBackReference;
    }

    public boolean isToContainsVariable() {
        return this.toContainsVariable;
    }

    public String getFullDisplayName() {
        return null;
    }

    protected void addError(String s) {
        this.errors.add(s);
        log.error(s);
    }

    public void destroy() {
        for (int i = 0; i < this.runs.size(); ++i) {
            Run run = (Run)this.runs.get(i);
            run.destroy();
        }
    }

    public String getFrom() {
        return this.from;
    }

    protected boolean isReadyToProcess() {
        if (!this.valid) {
            log.debug("not valid, skipping");
            return false;
        }
        if (!this.initialised) {
            log.debug("not initialised, skipping");
            return false;
        }
        if (!this.enabled) {
            log.debug("not enabled, skipping");
            return false;
        }
        return true;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        if (!StringUtils.isBlank(to)) {
            this.to = to;
        }
    }

    public void setToLast(String lastStr) {
        this.last = "true".equalsIgnoreCase(lastStr);
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isStopFilterChainOnMatch() {
        return this.stopFilterChainOnMatch;
    }

    public String getTo() {
        return this.to;
    }

    public int getId() {
        return this.id;
    }

    public List getErrors() {
        return this.errors;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        condition.setId(this.conditionIdCounter++);
    }

    public void addRun(Run run) {
        this.runs.add(run);
        run.setId(this.runIdCounter++);
    }

    public void addSetAttribute(SetAttribute setAttribute) {
        this.setAttributes.add(setAttribute);
    }

    public List getSetAttributes() {
        return this.setAttributes;
    }

    public List getConditions() {
        return this.conditions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isFromCaseSensitive() {
        return this.fromCaseSensitive;
    }

    public void setFromCaseSensitive(boolean fromCaseSensitive) {
        this.fromCaseSensitive = fromCaseSensitive;
    }

    public List getRuns() {
        return this.runs;
    }

    public boolean isValid() {
        return this.valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

