static char SCCSID[] = "@(#)stiprects.c	1.2 89/02/22";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"
#include "stipple1.bit"
#include "stipple2.bit"

static GC myGC1, myGC2;
static Pixmap stipple1, stipple2;
static XRectangle *rectangles;
#define NRECT   64

/*
 * stippled rectangles
 *
 */
stippledrects_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int depth;
	int i;
	XRectangle *rp;

	depth = DefaultDepth(dpy, screen);
	myGC1 = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC1) return 1;
	myGC2 = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC2) return 1;
	XSetForeground(dpy, myGC1, BlackPixel(dpy, screen));
	XSetBackground(dpy, myGC1, WhitePixel(dpy, screen));
	XSetForeground(dpy, myGC2, BlackPixel(dpy, screen));
	XSetBackground(dpy, myGC2, WhitePixel(dpy, screen));

	stipple1 = XCreateBitmapFromData(dpy, win,
						stipple1_bits,
						stipple1_width,
						stipple1_height);
	if (!stipple1) return 1;

	stipple2 = XCreateBitmapFromData(dpy, win,
						stipple2_bits,
						stipple2_width,
						stipple2_height);
	if (!stipple2) return 1;

	XSetStipple(dpy, myGC1, stipple1);
	XSetFillStyle(dpy, myGC1, FillOpaqueStippled);
	XSetStipple(dpy, myGC2, stipple2);
	XSetFillStyle(dpy, myGC2, FillOpaqueStippled);

	rectangles = (XRectangle *)malloc(sizeof(XRectangle) * NRECT);
	if (rectangles == (XRectangle *)0)
	    return 1;

	rp = rectangles;
	for (i=0; i<NRECT; i++) {
	    rp->x = i; rp->y = i;
	    rp->width = len; rp->height = len;
	    rp++;
	}
	return 0;
}

stippledrects_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC1);
	XFreePixmap(dpy, stipple1);
	XFreeGC(dpy, myGC2);
	XFreePixmap(dpy, stipple2);
	free(rectangles);
}

stippledrects_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int nrects;

	nrects = 0;
	while (benchRunning) {
	    XFillRectangles(dpy, win, myGC1, rectangles, NRECT);
	    XFillRectangles(dpy, win, myGC2, rectangles, NRECT);
	    if (sync) XSync(dpy, 0);
	    nrects += NRECT*2;
	}
	return nrects;
}

stippledrects_msg(deltaT, nrects, len, rate)
double rate;
{
	printf("STIPPLE-FILLED RECTANGLES\n");
	printf("\n");
	printf("%d rectangles with %d pixel sides in %d secs\n",
				nrects, len, deltaT);
	printf("rate = %8.2f rectangles/sec (%d Pixels/sec)\n",
				rate, (nrects*len*len)/deltaT);
}
