static char SCCSID[] = "@(#)invrects.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawInv;

/*
 * invert rectangles
 *
 * used mainly in plaid -:)
 */
invrects_setup(dpy, win, dummy)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int black, white;

	white = WhitePixel(dpy, screen);
	black = BlackPixel(dpy, screen);

	drawInv = XCreateGC(dpy, win, 0L, NULL);
	if (! drawInv) return 1;
	XSetForeground(dpy, drawInv, black^white);
	XSetFunction(dpy, drawInv, GXxor);

	return 0;
}

invrects_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawInv);
}

invrects_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int x, y;
	int nrects;

	y = 0; x = 0;
	nrects = 0;
	while (benchRunning) {
	    XFillRectangle(dpy, win, drawInv, x, y, len, len);
	    y = (y + 1) & 0x0F;
	    x = (x + 1) & 0x0F;
	    if (sync) XSync(dpy, 0);
	    nrects++;
	}
	return nrects;
}

invrects_msg(deltaT, nrects, len, rate)
double rate;
{
	printf("INVERTED RECTANGLES\n");
	printf("\n");
	printf("%d rectangles with %d pixel sides in %d secs\n",
				nrects, len, deltaT);
	printf("rate = %8.2f rectangles/sec (%d Pixels/sec)\n",
				rate, (nrects*len*len)/deltaT);
}
