/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.FuncSig;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class ArraySig
extends InternalRep {
    Class componentType;
    int dimensions;

    ArraySig(Class clazz, int n) {
        this.componentType = clazz;
        this.dimensions = n;
    }

    protected InternalRep duplicate() {
        return new ArraySig(this.componentType, this.dimensions);
    }

    static ArraySig get(Interp interp, TclObject tclObject) throws TclException {
        String string;
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof ArraySig) {
            return (ArraySig)internalRep;
        }
        if (TclList.getLength((Interp)interp, (TclObject)tclObject) == 1 && ((string = TclList.index((Interp)interp, (TclObject)tclObject, (int)0).toString()).endsWith("[]") || string.startsWith("["))) {
            Object object;
            Class clazz = JavaInvoke.getClassByName(interp, string);
            int n = 0;
            if (string.charAt(0) == '[') {
                object = string;
                while (((String)object).charAt(++n) == '[') {
                }
            } else {
                object = string;
                while (((String)object).endsWith("[]")) {
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                    ++n;
                }
            }
            object = new ArraySig(clazz, n);
            tclObject.setInternalRep((InternalRep)object);
            return object;
        }
        throw new TclException(interp, "bad array signature \"" + tclObject + "\"");
    }

    static boolean looksLikeArraySig(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof FuncSig) {
            return false;
        }
        if (internalRep instanceof ArraySig) {
            return true;
        }
        if (TclList.getLength((Interp)interp, (TclObject)tclObject) < 1) {
            return false;
        }
        String string = TclList.index((Interp)interp, (TclObject)tclObject, (int)0).toString();
        return string.endsWith("[]") || string.startsWith("[");
    }
}

