/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Array;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class ArrayObject
extends ReflectObject {
    private static final String[] validCmds = new String[]{"length", "get", "getrange", "set", "setrange"};
    private static final int OPT_LENGTH = 0;
    private static final int OPT_GET = 1;
    private static final int OPT_GETRANGE = 2;
    private static final int OPT_SET = 3;
    private static final int OPT_SETRANGE = 4;

    ArrayObject() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? option ?arg arg ...?");
        }
        String string = tclObjectArray[1].toString();
        if (string.length() >= 2 && "-noconvert".startsWith(string)) {
            bl = false;
            n3 = 2;
            n2 = tclObjectArray.length - 3;
        } else {
            bl = true;
            n3 = 1;
            n2 = tclObjectArray.length - 2;
        }
        if (n2 < 0) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? option ?arg arg ...?");
        }
        try {
            n = TclIndex.get(interp, tclObjectArray[n3], validCmds, "option", 1);
        }
        catch (TclException tclException) {
            try {
                int n4 = n3 + 1;
                FuncSig.get(interp, this.javaClass, tclObjectArray[n3], tclObjectArray, n4, tclObjectArray.length - n4);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "bad option \"" + tclObjectArray[n3] + "\": must be length, get, getrange, " + "set, setrange, or a valid method signature");
            }
            super.cmdProc(interp, tclObjectArray);
            return;
        }
        switch (n) {
            case 0: {
                if (n2 != 0) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"length\" sub-command");
                }
                interp.setResult(Array.getLength(this.javaObj));
                return;
            }
            case 1: {
                int n5;
                Class clazz;
                Object object;
                if (n2 != 1) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "indexList");
                }
                TclObject tclObject = tclObjectArray[n3 + 1];
                int n6 = TclList.getLength((Interp)interp, (TclObject)tclObject);
                if (n6 == 0) {
                    object = this.javaObj;
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                    n5 = 0;
                } else {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n6, tclObject);
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, n6);
                    n5 = TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)(n6 - 1)));
                }
                interp.setResult(ArrayObject.getArrayElt(interp, object, clazz, n5, bl));
                return;
            }
            case 3: {
                int n7;
                Class clazz;
                Object object;
                if (n2 != 2) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "indexList value");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"set\" sub-command");
                }
                TclObject tclObject = tclObjectArray[n3 + 1];
                int n8 = TclList.getLength((Interp)interp, (TclObject)tclObject);
                if (n8 == 0) {
                    object = this.javaObj;
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                    n7 = 0;
                } else {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n8, tclObject);
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, n8);
                    n7 = TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)(n8 - 1)));
                }
                ArrayObject.setArrayElt(interp, object, clazz, n7, tclObjectArray[n3 + 2]);
                interp.resetResult();
                return;
            }
            case 2: {
                TclObject tclObject;
                int n9;
                if (n2 > 2) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "?indexList ?count??");
                }
                Object object = this.javaObj;
                Class clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                int n10 = 0;
                if (n2 > 0 && (n9 = TclList.getLength((Interp)interp, (TclObject)(tclObject = tclObjectArray[n3 + 1]))) > 0) {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n9, tclObject);
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, n9);
                    n10 = TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)(n9 - 1)));
                }
                int n11 = Array.getLength(object) - n10;
                if (n2 > 1) {
                    n11 = Math.min(n11, TclInteger.get(interp, tclObjectArray[n3 + 2]));
                }
                interp.setResult(ArrayObject.getArrayElts(interp, object, clazz, n10, n11, bl));
                return;
            }
            case 4: {
                TclObject tclObject;
                int n12;
                if (n2 < 1 || n2 > 3) {
                    throw new TclNumArgsException(interp, n3 + 1, tclObjectArray, "?indexList ?count?? valueList");
                }
                if (!bl) {
                    throw new TclException(interp, "-noconvert flag not allowed for the \"setrange\" sub-command");
                }
                TclObject tclObject2 = tclObjectArray[tclObjectArray.length - 1];
                Object object = this.javaObj;
                Class clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, 1);
                int n13 = 0;
                if (n2 > 1 && (n12 = TclList.getLength((Interp)interp, (TclObject)(tclObject = tclObjectArray[n3 + 1]))) > 0) {
                    object = ArrayObject.dereferenceArrayDims(interp, this.javaObj, n12, tclObject);
                    clazz = ArrayObject.dereferenceClassDims(interp, this.javaClass, n12);
                    n13 = TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)(n12 - 1)));
                }
                int n14 = Math.min(TclList.getLength((Interp)interp, (TclObject)tclObject2), Array.getLength(object) - n13);
                if (n2 > 2) {
                    n14 = Math.min(n14, TclInteger.get(interp, tclObjectArray[n3 + 2]));
                }
                ArrayObject.setArrayElts(interp, object, clazz, n13, n14, tclObject2);
                interp.resetResult();
                return;
            }
        }
    }

    private static Object dereferenceArrayDims(Interp interp, Object object, int n, TclObject tclObject) throws TclException {
        int n2 = JavaInfoCmd.getNumDimsFromClass(object.getClass());
        if (n2 < n) {
            throw new TclException(interp, "bad indexList \"" + tclObject.toString() + "\": javaObj only has " + n2 + " dimension(s)");
        }
        Object object2 = object;
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)n3));
            try {
                object2 = Array.get(object2, n4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int n5 = Array.getLength(object2) - 1;
                throw new TclException(interp, "array index \"" + n4 + "\" is out of bounds: must be between 0 and " + n5);
            }
            if (object2 == null) {
                throw new TclException(interp, "null value in dimension " + n3 + ": can't dereference " + n2 + " dimensions");
            }
            ++n3;
        }
        return object2;
    }

    private static Class dereferenceClassDims(Interp interp, Class clazz, int n) throws TclException {
        int n2 = JavaInfoCmd.getNumDimsFromClass(clazz);
        if (n2 < n) {
            throw new TclException(interp, "bad class dereference class only has " + n2 + " dimension(s)");
        }
        Class<?> clazz2 = clazz;
        int n3 = 0;
        while (n3 < n) {
            clazz2 = clazz2.getComponentType();
            ++n3;
        }
        return clazz2;
    }

    static TclObject getArrayElt(Interp interp, Object object, Class clazz, int n, boolean bl) throws TclException {
        Object object2;
        try {
            object2 = Array.get(object, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = Array.getLength(object) - 1;
            throw new TclException(interp, "array index \"" + n + "\" is out of bounds: must be between 0 and " + n2);
        }
        if (bl) {
            return JavaInvoke.convertJavaObject(interp, clazz, object2);
        }
        return ReflectObject.newInstance(interp, clazz, object2);
    }

    static TclObject getArrayElts(Interp interp, Object object, Class clazz, int n, int n2, boolean bl) throws TclException {
        TclObject tclObject = TclList.newInstance();
        try {
            int n3 = 0;
            while (n3 < n2) {
                TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)ArrayObject.getArrayElt(interp, object, clazz, n, bl));
                ++n3;
                ++n;
            }
        }
        catch (TclException tclException) {
            tclObject.release();
            throw tclException;
        }
        return tclObject;
    }

    static String getBaseName(String string) {
        if (string.endsWith("[]")) {
            int n = string.indexOf(91);
            return string.substring(0, n);
        }
        if (string.charAt(0) == '[') {
            if (string.endsWith("[")) {
                return string;
            }
            String string2 = string.substring(1);
            while (string2.charAt(0) == '[') {
                string2 = string2.substring(1);
            }
            if (string2.charAt(0) == 'L' && string2.endsWith(";")) {
                return string2.substring(1, string2.length() - 1);
            }
            if (string2.charAt(0) == 'I') {
                return "int";
            }
            if (string2.charAt(0) == 'Z') {
                return "boolean";
            }
            if (string2.charAt(0) == 'J') {
                return "long";
            }
            if (string2.charAt(0) == 'F') {
                return "float";
            }
            if (string2.charAt(0) == 'D') {
                return "double";
            }
            if (string2.charAt(0) == 'B') {
                return "byte";
            }
            if (string2.charAt(0) == 'S') {
                return "short";
            }
            if (string2.charAt(0) == 'C') {
                return "char";
            }
        }
        return string;
    }

    static Object initArray(Interp interp, TclObject tclObject, int n, int n2, int n3, Class clazz, TclObject tclObject2) throws TclException {
        Object object;
        int n4;
        Class<?> clazz2 = clazz.getComponentType();
        int n5 = 0;
        if (tclObject2 != null) {
            n5 = TclList.getLength((Interp)interp, (TclObject)tclObject2);
        }
        if ((n4 = n2 < n ? TclInteger.get(interp, TclList.index((Interp)interp, (TclObject)tclObject, (int)n2)) : n5) == 0 && n2 < n3 - 1) {
            throw new TclException(interp, "cannot initialize a " + n3 + " dimensional array with zero size in dimension " + n2);
        }
        try {
            object = Array.newInstance(clazz2, n4);
        }
        catch (Exception exception) {
            throw new ReflectException(interp, (Throwable)exception);
        }
        if (clazz2.isArray()) {
            int n6 = n2 + 1;
            int n7 = 0;
            while (n7 < n4) {
                TclObject tclObject3 = null;
                if (n7 < n5) {
                    tclObject3 = TclList.index((Interp)interp, (TclObject)tclObject2, (int)n7);
                }
                Object object2 = ArrayObject.initArray(interp, tclObject, n, n6, n3, clazz2, tclObject3);
                Array.set(object, n7, object2);
                ++n7;
            }
        } else if (n5 > 0) {
            int n8 = Math.min(n4, n5);
            ArrayObject.setArrayElts(interp, object, clazz2, 0, n8, tclObject2);
        }
        return object;
    }

    static void setArrayElt(Interp interp, Object object, Class clazz, int n, TclObject tclObject) throws TclException {
        Class clazz2 = clazz;
        Object object2 = JavaInvoke.convertTclObject(interp, clazz2, tclObject);
        try {
            Array.set(object, n, object2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = Array.getLength(object) - 1;
            throw new TclException(interp, "array index \"" + n + "\" is out of bounds: must be between 0 and " + n2);
        }
    }

    static void setArrayElts(Interp interp, Object object, Class clazz, int n, int n2, TclObject tclObject) throws TclException {
        int n3 = 0;
        while (n3 < n2) {
            ArrayObject.setArrayElt(interp, object, clazz, n, TclList.index((Interp)interp, (TclObject)tclObject, (int)n3));
            ++n3;
            ++n;
        }
    }
}

