# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc useredit_group_create {w} \
{
catch \
{
	upvar #0 tmp_gid($w) tmp_gid
	upvar #0 tmp_gid_list($w) tmp_gid_list
	toplevel $w.gid
	wm title $w.gid "GROUP [wm title $w]"
	useredit_group_lists_create $w.gid $tmp_gid $tmp_gid_list
	useredit_group_control_create $w.gid $w
	pack append $w.gid $w.gid.gid {top expand fillx} $w.gid.control {bottom expand fillx}
	bind $w.gid.gid.left.list_full <Double-Button-1> "useredit_group_list_full_add_include $w.gid.gid"
	bind $w.gid.gid.right.list_include <Double-Button-1> "useredit_group_list_include_delete_selection $w.gid.gid"
}
}

proc useredit_group_control_create {w win} \
{
	global BACKGROUND_COLOR_ADD_EDIT

	button $w.gid.left.add -text "Add Group(S)" -relief raised -command "useredit_group_list_full_add_include $w.gid"
	pack before $w.gid.left.scroll_full $w.gid.left.add {bottom fillx}

	button $w.gid.right.remove -text "Remove Group(s)" -relief raised -command "useredit_group_list_include_delete_selection $w.gid"
	pack before $w.gid.right.scroll_include $w.gid.right.remove {bottom fillx} \

	button $w.gid.set_main_group -relief raised -text "Set Main Group" -command "useredit_group_set_main_group $w.gid"
	pack before $w.gid.left $w.gid.set_main_group {bottom fillx}

	frame $w.control -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	button $w.control.apply -relief raised -text "Apply Changes" -command "useredit_group_apply $w.gid $win"
	button $w.control.cancel -relief raised -text "Cancel" -width 13 -command "useredit_group_destroy $w"
	pack append $w.control \
		$w.control.apply {left} \
		$w.control.cancel {right}
}

proc useredit_group_lists_create {w gid gid_list} \
{
	global group_text
	global BACKGROUND_COLOR_ADD_EDIT
	upvar #0 tmp_group($w.gid) tmp_group

	frame $w.gid -border 5 -background $BACKGROUND_COLOR_ADD_EDIT

	frame $w.gid.left
	label $w.gid.left.label -text "Group List" -relief raised
	scrollbar $w.gid.left.scroll_full -command "$w.gid.left.list_full yview"
	listbox $w.gid.left.list_full -yscroll "$w.gid.left.scroll_full set" -relief raised -geometry 17x10
	pack append $w.gid.left \
		$w.gid.left.label {top fillx} \
		$w.gid.left.scroll_full {right expand filly} \
		$w.gid.left.list_full {left expand fillx}

	frame $w.gid.right
	label $w.gid.right.label -text "Group(s) JOINED" -relief raised
	scrollbar $w.gid.right.scroll_include -command "$w.gid.right.list_include yview"
	listbox $w.gid.right.list_include -yscroll "$w.gid.right.scroll_include set" -relief raised -geometry 17x10
	pack append $w.gid.right \
		$w.gid.right.label {top fillx} \
		$w.gid.right.scroll_include {right expand filly} \
		$w.gid.right.list_include {left expand fillx}

	set tmp_group [group_get_groupname_gid_translate $group_text $gid]
	frame $w.gid.main
	label $w.gid.main.label -text "Main Group (GID):" -anchor e -relief flat
	label $w.gid.main.main -text $tmp_group -width 20 -anchor w -relief sunken
	pack append $w.gid.main \
		$w.gid.main.label {left expand fillx} \
		$w.gid.main.main {right fillx}

	pack append $w.gid \
		$w.gid.main {top fillx} \
		$w.gid.left {left expand fill} \
		$w.gid.right {right expand fill}

	set group_list {}
	foreach group_entry $group_text \
	{
		lappend group_list [group_get_groupname_gid [file_to_normal $group_entry]]
	}
	set group_list [lsort $group_list]
	eval "$w.gid.left.list_full insert end $group_list"

	set group_list {}
	foreach tmp_gid $gid_list \
	{
		lappend group_list [group_get_groupname_gid_translate $group_text $tmp_gid]
	}
	set group_list [lsort $group_list]
	eval "$w.gid.right.list_include insert end $group_list"
}

proc useredit_group_list_full_add_include {w} \
{
	foreach group [selection get] \
	{
		useredit_group_list_include_add $w $group
	}
}

proc useredit_group_list_include_add {w group} \
{
	set size [$w.right.list_include size]
	for {set i 0} {$i < $size} {incr i} \
	{
		if { $group == [$w.right.list_include get $i] } return
	}
	upvar #0 tmp_group($w) tmp_group
	$w.main.main config -text $group
	set tmp_group $group
	$w.right.list_include insert end $group
}

proc useredit_group_list_include_delete_selection {w} \
{
	upvar #0 tmp_group($w) tmp_group
	foreach i [lreverse [lnumsort [$w.right.list_include curselection]]] \
	{
		if {[$w.right.list_include get $i] != $tmp_group} \
		{
			$w.right.list_include delete $i
		}
	}
}

proc useredit_group_set_main_group {w} \
{
	upvar #0 tmp_group($w) tmp_group
	set group [lindex [selection get] 0]
	if {$group == {}} return

	$w.main.main config -text $group
	useredit_group_list_include_add $w $group
	set tmp_group $group
}

proc useredit_group_apply {w win} \
{
	upvar #0 tmp_group($w) tmp_group
	upvar #0 tmp_gid($win) tmp_gid
	upvar #0 tmp_gid_list($win) tmp_gid_list
	set tmp_gid [group_get_gid_from_groupname_gid $tmp_group]
	$win.useredit.entry.gid config -text $tmp_group
	set tmp_gid_list {}
	set size [$w.right.list_include size]
	for {set i 0} {$i < $size} {incr i} \
	{
		lappend tmp_gid_list [group_get_gid_from_groupname_gid [$w.right.list_include get $i]]
	}
	useredit_group_destroy $win.gid
}

proc useredit_group_destroy {w} \
{
	upvar #0 tmp_group($w.gid) tmp_group
	unset tmp_group
	destroy $w
}
