#  Tests for WebTk
# Copyright (c) 1996 by Sun Microsystems
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
proc Test_Menu {m win} {
    global testmenub
    set testmenub($win) [winfo parent $m]

    $m add command -label "Init" -underline 0 \
	-command "catch {source test.tcl} ; test_init $win" 
    global TestColor$win; set TestColor$win 0
    $m add check -label "Colorize" -variable TestColor$win \
	-command "test_color $win \[set TestColor$win\]"
    $m add separator
    $m add cascade -label "0  Edit" -underline 0 -menu $m.edit
    set subm [menu $m.edit -font fixed]
    $subm add command -label "Null to H1" -underline 0 -command testE1 
    $subm add command -label "H2 to Null" -underline 0 -command testE2
    $subm add command -label "H2 -> Null -> H3" -underline 0 -command testE3 
    $subm add command -label "Headings to Null" -underline 0 -command testE4

    $m add cascade -label "1  Headings" -underline 0 -menu $m.head
    set subm [menu $m.head -font fixed]
    $subm add command -label "Return" -underline 0 -command testH1 
    $subm add command -label "Tab/Untab" -underline 0 -command testH2
    $subm add command -label "Join/Unjoin" -underline 0 -command testH3 
    $subm add command -label "Break/Unbreak" -underline 0 -command testH4

    $m add command -label "2  New pp" -underline 0 -command test2

    $m add cascade -label "3  Lists" -underline 0 -menu $m.list
    set subm [menu $m.list -font fixed]
    $subm add command -label "Ordered, mid line" -underline 0 -command "test3 ol"
    $subm add command -label "Basic, null line" -underline 0 -command "test3b ul"
    $subm add command -label "Directory, end line" -underline 0 -command "test3c dir"
    $subm add command -label "Menu" -underline 0 -command "test3 menu"
    $subm add command -label "Definition" -underline 0 -command "test3 dl"

    $m add cascade -label "4  Complex List" -underline 0 -menu $m.list2
    set subm [menu $m.list2 -font fixed]
    $subm add command -label "One sublist" -underline 0 -command "test4 ol"
    $subm add command -label "Sublist & Tab" -underline 0 -command "test5"
    $subm add command -label "Tab & Untab" -underline 0 -command "test6"
    $subm add command -label "Tab & Insert" -underline 0 -command "test7"

    $m add cascade -label "5  Forms" -underline 0 -menu $m.form
    set subm [menu $m.form -font fixed]
    $subm add command -label "Form init" -underline 0 -command "testF1"

    $m add cascade -label "6  Paste" -underline 0 -menu $m.paste
    set subm [menu $m.paste -font fixed]

    $subm add cascade -label "No nodes" -underline 0 -menu $subm.sub1
    set s [menu $subm.sub1]
    $s add command -label "mid node" -underline 0 -command "testP1.0"
    $s add command -label "begin node" -underline 0 -command "testP1.1"
    $s add command -label "end node" -underline 0 -command "testP1.2"
    $s add command -label "null node" -underline 0 -command "testP1.3"

    $subm add cascade -label "Partial leader" -underline 0 -menu $subm.sub2
    set s [menu $subm.sub2]
    $s add command -label "mid node" -underline 0 -command "testP2.0"
    $s add command -label "begin node" -underline 0 -command "testP2.1"
    $s add command -label "end node" -underline 0 -command "testP2.2"
    $s add command -label "null node" -underline 0 -command "testP2.3"

    $subm add cascade -label "Partial trailer" -underline 0 -menu $subm.sub3
    set s [menu $subm.sub3]
    $s add command -label "mid node" -underline 0 -command "testP3.0"
    $s add command -label "begin node" -underline 0 -command "testP3.1"
    $s add command -label "end node" -underline 0 -command "testP3.2"
    $s add command -label "null node" -underline 0 -command "testP3.3"

    $subm add cascade -label "Whole nodes" -underline 0 -menu $subm.sub4
    set s [menu $subm.sub4]
    $s add command -label "mid node" -underline 0 -command "testP4.0"
    $s add command -label "begin node" -underline 0 -command "testP4.1"
    $s add command -label "end node" -underline 0 -command "testP4.2"
    $s add command -label "null node" -underline 0 -command "testP4.3"

    $subm add cascade -label "Lists" -underline 0 -menu $subm.sub5
    set s [menu $subm.sub5]
    $s add command -label "Whole <p>" -underline 0 -command "testPL.0"
    $s add command -label "List at <li>" -underline 0 -command "testPL.1"
    $s add command -label "List at </li>" -underline 0 -command "testPL.2"
    $s add command -label "List mid <li>" -underline 0 -command "testPL.3"
}
proc test_enable {win} {
    global testmenub teston
    if $teston($win) {
	$testmenub($win) config -state normal
    } else {
	$testmenub($win) config -state disabled
    }
}
proc test_all {} {
    global Win
    foreach test [lsort [info commands test*]] {
	if {![string match test_* $test]} {
	    set f [frame $Win.tst -bd 4 -relief ridge]
	    message $f.msg -text $test
	    button $f.ok -text OK -command "destroy $Win.tst"
	    pack $f.msg
	    place $f -in $Win -relx 0.5 -rely 0.8 -anchor center
	    $test
	    pack $f.ok
	    tkwait window $Win.tst
	}
    }
}
proc test_color {win {on 1}} {
    # For debugging:
    if {$on} {
	$win tag configure space -background #e9e9e9
	$win tag configure mark -foreground "violet red" -background white
	$win tag configure node_select -underline true
    } else {
	$win tag configure space -background {}
	$win tag configure mark -foreground "violet red" -background ""
	$win tag configure node_select -underline false
    }
}
proc test_init { win {file {}} } {
    global TestDoc Win
    set Win $win
    Doff
    if {$file == {}} {
	set file $TestDoc
    }
    Mark_HideHtml $Win
    Input_Clean $win
    Url_Display $Win file:$file
    saveInner $Win /tmp/test.html
    update
    Don
}
proc test_set_insert {win index} {
    set bbox [$win bbox $index]
    tkTextButton1 $win [lindex $bbox 0] [lindex $bbox 1]
    Input_Adjust $win
    InputSetTags $win
}
# Change a leading nil node to a <h1> node
proc testE1 { } {
    global Win WebTk
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 1.0
    Input_Tag $Win h1
}
# Change a H2 Node back to a nil node
proc testE2 { } {
    global Win
    testE1
    update
    test_set_insert $Win 3.0
    Input_Tag $Win h2
    update
    Input_NoParagraph $Win
}
# H2 -> nil -> H3
proc testE3 { } {
    global Win
    testE2
    update
    Input_Tag $Win h3
}
proc testE4 { } {
    global Win
    testE1
    update
    test_set_insert $Win 3.end
    Input_Tag $Win h2
    update
    test_set_insert $Win 4.0
    Input_Tag $Win h4
    update
    Input_NoParagraph $Win
    update
    test_set_insert $Win 3.2
    Input_NoParagraph $Win
    update
    test_set_insert $Win 2.0
    Input_NoParagraph $Win
}
# Break the h1 with a <Return>
proc testH1 {  } {
    global Win
    test_init $Win
    test_set_insert $Win 2.12
    Input_Return $Win
}
# Demote an h1 with a <Tab>
proc testH2 {  } {
    global Win
    test_init $Win
    test_set_insert $Win 2.12
    Input_Tab $Win	;# to H2
    update
    Input_Tab $Win	;# to H3
    update
    Input_Tab $Win	;# to H4
    update
    Input_Tab $Win	;# to H5
    update
    Input_Tab $Win	;# to H6
    update
    Input_Tab $Win	;# still H6
    update
    Input_ShiftTab $Win	;# to H5
    update
    Input_ShiftTab $Win	;# to H4
    update
    Input_ShiftTab $Win	;# to H3
    update
    Input_ShiftTab $Win	;# to H2
    update
    Input_ShiftTab $Win	;# to H1
    update
    Input_ShiftTab $Win	;# still H1
    update
}
# Merge header and next paragraph
proc testH3 {  } {
    global Win
    test_init $Win
    test_set_insert $Win 2.end
    Edit_Delete $Win
    update
    Input_Return $Win
    update
    Input_Tag $Win p
    update

    Edit_Backspace $Win
    update
    Input_Return $Win
    update
    Input_Tag $Win p
}
# Break and rejoin a header
proc testH4 {  } {
    global Win
    test_init $Win
    test_set_insert $Win 2.12
    Input_Return $Win
    update
    Edit_Backspace $Win
}
# Start a <p> after the <h1>
proc test2 {  } {
    global Win
    test_init $Win
    test_set_insert $Win 2.end
    Input_Return $Win
    Input_Tag  $Win p
    Input $Win "This is a new paragraph."
}
# Start a list after a <p>
proc test3 { {ltag ol} } {
    global Win WebTk
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 2.2
    Input_Tag  $Win $ltag
    test_set_insert $Win 2.end
    Input_Return $Win
    Input $Win "Item 2."
}
proc test3b { {ltag ol} } {
    global Win WebTk
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 2.end
    Input_Return $Win
    Input_Tag  $Win $ltag
    Input $Win "Item 1."
    Input_Return $Win
    Input $Win "Item 2."
}
proc test3c { {ltag ol} } {
    global Win WebTk
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 3.end
    Input_Tag  $Win $ltag
    test_set_insert $Win "insert lineend"
    Input_Return $Win
    Input $Win "Item 2."
}
# Complex lists
proc test4 { {ltag ol} } {
    global Win WebTk
#    Doff
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 1.end
    Input_Return $Win
    Input_Tag  $Win $ltag
    Input $Win "Alpha"
    Input_Return $Win
    Input $Win "Bet"
    Input_Tab $Win
    Input $Win "a"
    Input_Return $Win
    Input $Win "Gamma"
    Input_Return $Win
    Input $Win "Delta"
    Input_Return $Win
    Input $Win "Epsilon"
##    Don
}
proc test4b { {ltag ol} } {
    global Win
    test4
    Input_ShiftTab $Win
    List_Refresh $Win
    test_set_insert $Win "insert -1c"
    Input_ShiftTab $Win
    Input $Win " after epsilon."
}
proc test4c { {ltag ol} } {
    global Win WebTk
#    Doff
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 2.end
    Input_Tag  $Win $ltag
    Input_Return $Win
    Input $Win "New Item"
    Input $Win "."
    test_set_insert $Win 4.2
    Input_Tag  $Win $ltag
##    Don
}
proc test4d { {ltag ol} } {
    global Win WebTk
#    Doff
    test_init $Win [file join $WebTk(html) three.htm]
    test_set_insert $Win 2.end
    Input_Tag  $Win $ltag
    Input_Return $Win
    Input $Win "New Item"
    Input_Tab $Win
    Input $Win "."
    test_set_insert $Win 4.2
    Input_Tag  $Win $ltag
##    Don
}
proc test5 {  } {
    global Win
    Doff
    test3 ol
    Don
    Input_Return $Win
    Input $Win "Sublist"
    update
    Input_Tab $Win
    update
    Input_Return $Win
    Input $Win "Sub2"
    Input_Return $Win
    Input $Win "Sub3"
    update
    return
    test_set_insert $Win 8.5
    puts stderr "\nInput_Tab"
    Input_Tab $Win
}
proc test6 {} {
    global Win
    test4 ol
    update
    test_set_insert $Win insert
    Input_ShiftTab $Win
}
proc test7 {} {
    global Win
    test3 ol
    update
    Input_Return $Win
    Input $Win "Inner List"
    update
    Input_Tab $Win
    test_set_insert $Win "10.end -1c"
    update
    Input_Return $Win
    Input $Win "Outer List"
}
proc testF1 {} {
    global Win
    test_init $Win
    test_set_insert $Win 6.end
    Input_Tag  $Win form
    Input_Return $Win
    Input $Win "This is a form.  Checkbox1: ."
    Input_Tag  $Win {input type=checkbox name=! checked= value=!}
}
set Win .text

# Paste tests

proc testP1.0 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.107	;# Middle of bold lib|rary
    Edit_PasteHtml $Win "  There are <i>zero</i> nodes here."
}

proc testP1.1 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.0	;# Begining of node
    Edit_PasteHtml $Win "  There are <i>zero</i> nodes here."
}

proc testP1.2 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Edit_PasteHtml $Win "  There are <i>zero</i> nodes here."
}

proc testP1.3 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Input_Return $Win		;# Create null node
    Edit_PasteHtml $Win "  There are <i>zero</i> nodes here."
}

proc testP2.0 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.107	;# Middle of bold lib|rary
    Edit_PasteHtml $Win "...heading</i></h1><p>A simple paragraph.</p>"
}

proc testP2.1 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.0	;# Begining of node
    Edit_PasteHtml $Win "...heading</i></h1><p>A simple paragraph.</p>"
}

proc testP2.2 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Edit_PasteHtml $Win "...heading</i></h1><p>A simple paragraph.</p>"
}

proc testP2.3 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Input_Return $Win		;# Create null node
    Edit_PasteHtml $Win "...heading</i></h1><p>A simple paragraph.</p>"
}

proc testP3.0 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.107	;# Middle of bold lib|rary
    Edit_PasteHtml $Win "<p>A simple paragraph.</p><h1><i>heading..."
}

proc testP3.1 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.0	;# Begining of node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p><h1><i>heading..."
}

proc testP3.2 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p><h1><i>heading..."
}

proc testP3.3 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Input_Return $Win		;# Create null node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p><h1><i>heading..."
}

proc testP4.0 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.107	;# Middle of bold lib|rary
    Edit_PasteHtml $Win "<p>A simple paragraph.</p>"
}

proc testP4.1 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.0	;# Begining of node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p>"
}

proc testP4.2 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p>"
}

proc testP4.3 { } {
    global Win
    test_init $Win
    test_set_insert $Win 6.end	;# End of node
    Input_Return $Win		;# Create null node
    Edit_PasteHtml $Win "<p>A simple paragraph.</p>"
}

