 # Copyright (C) 1992, International Business Machines Corp.
 # All rights reserved.
 #
 # Last modified on Tue Feb 11 15:05:06 PST 1992 by muller
 #      modified on Mon Feb 10 17:57:47 PST 1992 by orgass
 #
 #
 #	Save/restore context subroutines
 #
 #	setjmp(jmpbuf);			/* save registers (including stack */
 #		 r3			/* pointer) and return zero */
 #
 #	longjmp(jmpbuf, value);		/* restore registers (including stack */
 #		  r3	 r4		/* pointer) and return value to the */
 #					/* last caller of setjmp */
 #
 #	where jmpbuf is an array of 24 32-bit words used as follows:
 #
 #	----------------------------
 #	| sigmask at time of setjmp| 0x00  (restored during longjump)
 #	----------------------------
 #	| value of lr from setjmp  | 0x04
 #	----------------------------
 #	| value of cs from setjmp  | 0x08
 #	----------------------------
 #	| value of r1 from setjmp  | 0x0C  (stack pointer from setjmp)
 #	----------------------------
 #	| value of r2 from setjmp  | 0x10
 #	----------------------------
 #	| value of r13 from setjmp | 0x14
 #	----------------------------
 #	| value of r14 from setjmp | 0x18
 #	----------------------------
 #	| value of r15 from setjmp | 0x1C
 #	----------------------------
 #	| value of r16 from setjmp | 0x20
 #	----------------------------
 #	| value of r17 from setjmp | 0x24
 #	----------------------------
 #	| value of r18 from setjmp | 0x28
 #	----------------------------
 #	| value of r19 from setjmp | 0x2C
 #	----------------------------
 #	| value of r20 from setjmp | 0x30
 #	----------------------------
 #	| value of r21 from setjmp | 0x34
 #	----------------------------
 #	| value of r22 from setjmp | 0x38
 #	----------------------------
 #	| value of r23 from setjmp | 0x3C
 #	----------------------------
 #	| value of r24 from setjmp | 0x40
 #	----------------------------
 #	| value of r25 from setjmp | 0x44
 #	----------------------------
 #	| value of r26 from setjmp | 0x48
 #	----------------------------
 #	| value of r27 from setjmp | 0x4C
 #	----------------------------
 #	| value of r28 from setjmp | 0x50
 #	----------------------------
 #	| value of r29 from setjmp | 0x54
 #	----------------------------
 #	| value of r30 from setjmp | 0x58
 #	----------------------------
 #	| value of r31 from setjmp | 0x5C
 #	----------------------------

	S_PROLOG(_setjmp)
	mfspr	r9,lr
	mfcr	r10
	mr	r11,r1
	mr	r12,r2
	stm	r9,4(r3)		# store all but sigmask
	cal	r3,0(r0)		# return 0
	S_EPILOG
	FCNDES(_setjmp)

	S_PROLOG(_longjmp)
	mr	r7,r4			# save 2nd arg
	lm	r9,4(r3)		# get everything
	mtspr	lr,r9			# link register
	mtcr	   r10			# condition register
	mr	r1,r11			# stack pointer
	mr	r2,r12			# toc pointer
	mr	r3,r7			# and return 2nd parameter
	S_EPILOG
	FCNDES(_longjmp)
