(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: BlockStmt.i3                                          *)
(* Last Modified On Mon Jun 29 10:02:31 PDT 1992 By kalsow     *)

INTERFACE BlockStmt;

IMPORT M3, Token, Stmt, Tracer;

PROCEDURE Parse (READONLY fail: Token.Set;  needScope := TRUE): Stmt.T;

PROCEDURE ExtractFails (t: Stmt.T): M3.ExSet;

PROCEDURE BodyOffset (t: Stmt.T): INTEGER;

PROCEDURE ParseTrace (READONLY fail: Token.Set): Tracer.T;
PROCEDURE CheckTrace (t: Tracer.T;  VAR cs: Stmt.CheckState);

END BlockStmt.
