signature User =
sig

(* USER INPUT FUNCTIONS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        24 Mar 1990

   Maintenance: Author


   DESCRIPTION

   These functions prompt the user for some input, and return an
   appropriate value.


   SEE ALSO

   StreamPair


   NOTES

   When using an ASCII terminal, these routines are the same as those in
   StreamPair, but always use the standard streams.

   A window system should provide an implementation of this signature that
   uses real menus and dialog boxes.
*)

  val version: real
   (* version = 0.1 *)


(* MANIPULATORS *)

  val prompt: string -> string
   (* prompt s; displays s to the user and reads an answer input line. *)

  val ask: string -> (InStream -> ('a, 'a Option) Result) -> 'a
   (* ask s p; repeatedly prompts for an answer using s as the prompt;
      reads an answer using p until p succeeds; returns the value read by p. *)

  val confirm: string -> bool
   (* confirm s; checks for confirmation with message s.  Returns true or
      false depending on the input.  When using an ASCII terminal,
      true might be indicated by typing "y" and false by typing "n", with
      other characters being ignored. *)

  val menu: string -> string list -> int
   (* menu title entries; displays a menu using title as a title
      and the elements of entries as entries.  Returns an integer that
      corresponds to the position of the chosen element in the list
      (0 to (size entries - 1)). *)
end
