signature Ref =
sig

(* REFERENCES

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:        3 Oct 1989

   Maintenance:	Author


   DESCRIPTION

   Standard functions on the built-in type "ref".

   The usual comparison operators are omitted because it's just as easy to
   write (X.lt !x !y) as (lt X.lt x y), and for numbers it's even easier
   to write (!x < !y).

   The usual conversion functions are also omitted, partly because they
   won't be needed very often and partly because there's no way to preserve
   sharing.
*)

  val version: real
   (* version = 0.1 *)


(* PERVASIVES *)

  (* imperative type variables here are a temporary hack for Poly *)
  val ! : '_a ref -> '_a
  val := : 'a ref * 'a -> unit


(* OBSERVERS *)

  val eq: 'a ref -> 'a ref -> bool
  val ne: 'a ref -> 'a ref -> bool


(* MANIPULATORS *)

  val inc: int ref -> unit
   (* inc r; increment the contents of r. *)

  val dec: int ref -> unit
   (* dec r; decrement the contents of r. *)

  val mkRandom: int -> int -> int
   (* mkRandom seed; Given a seed, mkRandom returns a psuedo-random number
      generator which takes an integer argument of one more than the
      maximum return value required if it is positive, or one less if it
      is negative.  *) 
end
