(*$Ref *)

loadSig "Ref";

structure Ref: Ref =
struct

(* REFERENCES

   Created by:  Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:        3 Oct 1989

   Maintenance: Author
*)

  val version = 0.1


(* PERVASIVES *)

  val ! = !
  val (op :=) = (op :=)


(* OBSERVERS *)

  fun eq x y = (x = y)
  fun ne x y = (x <> y)


(* MANIPULATORS *)

  fun inc r = (r := !r + 1)

  fun dec r = (r := !r - 1)

  (* Given a seed, mkRandom returns a psuedo-random number generator
     which takes an integer argument of one more than the maximum
     return value required. ( Linear Congruential, after Sedgewick,
     "Algorithms", Addison-Wesley, 1983, Chapter 3 pp 37-38.) *)
  fun mkRandom seed = 
        let val r = ref seed
	    val a = 31415821
	    val m = 100000000;

	    fun f n =
	      let val rand = (r := (a * !r + 1) mod m ; !r * n div m)
	      in if n < 0 then rand + 1 else rand
	      end
         in f
        end;
end
