(*$Combinator : GeneralTypes *)

loadSig "Combinator";

structure Combinator: Combinator =

(* COMBINATOR FUNCTIONS

   Author:      Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        15 Nov 1989

   Maintenance: Author
*)

struct

  val version = 0.1


(* PERVASIVES *)

  val op o = op o


(* NEW COMBINATORS *)

   fun S f g x = f x (g x)
   and K x y   = x
   and I x     = x
   and B f g x = f(g x)
   and C f x y = f y x
   and CK x y  = y
   and W f x   = f x x
   and Y f     = f (Y f)
   and B' k f g x = k f (g x)
   and C' k f g x = k (f x) g
   and S' k f g x = k (f x) (g x)
   and cond true x y = x |
       cond false x y = y;

   infix 3 oo;
   fun (f oo g) x y = f (g x y);

   infix 3 co;
   fun (f co g) x y = f (g y) x;

   fun can f x = ((f x) ; true) handle _ => false;

   infix 3 fby;
   fun (f fby g) x =  ((can f x);(g x));

   infix 3 over;
   fun (g over f) x =  (g x) handle _ => f x;

   val curry = General.curry

   val uncurry = General.uncurry
end;     
