(*$ListPair *)

loadSig "ListPair";

structure ListPair: ListPair =
struct

  val version = 0.1

  exception Zip
  fun zip ([], []) = []
  |   zip (x::xs, y::ys) = (x,y) :: zip (xs, ys)
  |   zip (_, _) = raise Zip

  fun unzip []           = ([] ,[])
  |   unzip ((x,y)::xys) =
         let val (xs, ys) = unzip xys in
            (x :: xs, y :: ys)
         end

  (* fun unzip = (map fst l, map snd l) *)
  local
     fun from1  ([], l2)    = l2
     |   from1  (x::xs, l2) = x :: from2 (xs, l2)
     and from2  (l1, [])    = l1
     |   from2  (l1, y::ys) = y :: from1 (l1, ys)
  in
     val interleave = from1
  end

  fun unravel []  = ([] ,[])
  |   unravel [x] = ([x],[])
  |   unravel (x::y::xys) =
         let val (xs, ys) = unravel xys in
            (x::xs, y::ys)
         end

  fun merge p (l, []) = l
  |   merge p ([], l) = l
  |   merge p (l1 as (x::xs), l2 as (y::ys)) =
         if p x y then x :: merge p (xs, l2)
                      else y :: merge p (l1, ys)
end
