functor MLLrValsFun(structure Token : TOKEN)
 = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Copyright 1989,1992 by AT&T Bell Laboratories *)
open Ast ErrorMsg Symbol FastSymbol AstUtil Fixity 

type env = parseEnv
type raw_symbol = FastSymbol.raw_symbol

fun markexp (e as MarkExp _, _, _) = e
  | markexp(e,a,b) = MarkExp(e,a,b)
fun markdec((d as MarkDec _, e), _,_) = (d,e)
  | markdec((d,e),a,b) = (MarkDec(d,a,b),e)

fun identity x = x

fun sequence (do1,do2) env =
  let val r1 = do1 env
    val r2 = do2 env
  in r1 @ r2 end

fun seqdec dcl env = let val (d,e) = dcl env in ([d],e) end

val asteriskHash = StrgHash.hashString "*"
val asteriskString = "*"
val equalHash = StrgHash.hashString "="
val equalString = "="
val bogusHash = StrgHash.hashString "BOGUS"
val bogusString = "BOGUS"
val quotedBogusHash = StrgHash.hashString "'BOGUS"
val quotedBogusString = "'BOGUS"
val quotedBogusHash = StrgHash.hashString "'BOGUS"
val quotedBogusString = "'BOGUS"


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\002\000\000\000\000\000\
\\001\000\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\009\000\045\000\010\000\044\000\015\000\043\000\
\\016\000\042\000\020\000\041\000\022\000\040\000\026\000\039\000\
\\027\000\038\000\028\000\037\000\030\000\036\000\031\000\035\000\
\\034\000\034\000\035\000\033\000\036\000\032\000\037\000\031\000\
\\038\000\030\000\040\000\029\000\041\000\028\000\042\000\027\000\
\\043\000\026\000\047\000\025\000\049\000\024\000\051\000\023\000\
\\052\000\022\000\053\000\021\000\057\000\020\000\060\000\019\000\
\\061\000\018\000\062\000\017\000\068\000\016\000\069\000\015\000\
\\070\000\014\000\073\000\013\000\000\000\
\\001\000\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\015\000\043\000\020\000\041\000\026\000\039\000\
\\030\000\036\000\031\000\035\000\036\000\032\000\040\000\029\000\
\\043\000\026\000\053\000\021\000\057\000\020\000\060\000\019\000\
\\061\000\018\000\062\000\017\000\064\000\066\000\069\000\015\000\
\\070\000\014\000\073\000\013\000\000\000\
\\001\000\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\015\000\043\000\020\000\041\000\026\000\039\000\
\\030\000\036\000\031\000\035\000\036\000\032\000\040\000\029\000\
\\043\000\026\000\053\000\021\000\057\000\020\000\060\000\019\000\
\\061\000\018\000\062\000\017\000\064\000\074\000\069\000\015\000\
\\070\000\014\000\073\000\013\000\000\000\
\\001\000\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\015\000\043\000\020\000\041\000\026\000\039\000\
\\030\000\036\000\031\000\035\000\036\000\032\000\040\000\029\000\
\\043\000\026\000\053\000\021\000\057\000\020\000\060\000\019\000\
\\061\000\018\000\062\000\017\000\065\000\072\000\069\000\015\000\
\\070\000\014\000\073\000\013\000\000\000\
\\001\000\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\015\000\043\000\020\000\041\000\026\000\039\000\
\\030\000\036\000\031\000\035\000\036\000\032\000\040\000\029\000\
\\043\000\026\000\053\000\021\000\057\000\020\000\060\000\019\000\
\\061\000\018\000\062\000\017\000\069\000\015\000\070\000\014\000\
\\073\000\013\000\000\000\
\\001\000\003\000\054\000\020\000\041\000\057\000\020\000\000\000\
\\001\000\003\000\082\000\005\000\081\000\057\000\080\000\000\000\
\\001\000\003\000\082\000\005\000\081\000\057\000\080\000\063\000\079\000\000\000\
\\001\000\003\000\082\000\005\000\081\000\057\000\080\000\063\000\254\000\000\000\
\\001\000\003\000\082\000\040\000\200\000\057\000\080\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\044\000\098\000\054\000\097\000\
\\057\000\080\000\060\000\096\000\061\000\095\000\062\000\094\000\
\\069\000\093\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\094\000\064\000\186\000\
\\069\000\093\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\094\000\064\000\190\000\
\\069\000\093\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\094\000\065\000\188\000\
\\069\000\093\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\094\000\069\000\093\000\000\000\
\\001\000\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\136\000\069\000\093\000\000\000\
\\001\000\003\000\116\000\020\000\041\000\036\000\136\001\048\000\135\001\
\\057\000\020\000\000\000\
\\001\000\003\000\116\000\020\000\041\000\036\000\146\001\057\000\020\000\000\000\
\\001\000\003\000\116\000\020\000\041\000\051\000\109\001\057\000\020\000\000\000\
\\001\000\003\000\116\000\020\000\041\000\057\000\020\000\000\000\
\\001\000\003\000\159\000\000\000\
\\001\000\003\000\159\000\004\000\158\000\060\000\157\000\062\000\156\000\000\000\
\\001\000\003\000\163\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\030\000\036\000\036\000\032\000\040\000\029\000\
\\060\000\019\000\061\000\018\000\062\000\017\000\069\000\015\000\
\\070\000\014\000\073\000\013\000\000\000\
\\001\000\003\000\196\000\005\000\081\000\017\000\195\000\057\000\080\000\000\000\
\\001\000\003\000\196\000\005\000\081\000\017\000\195\000\057\000\080\000\
\\063\000\194\000\000\000\
\\001\000\003\000\203\000\000\000\
\\001\000\003\000\056\001\046\000\055\001\000\000\
\\001\000\003\000\068\001\000\000\
\\001\000\003\000\166\001\000\000\
\\001\000\003\000\211\001\000\000\
\\001\000\004\000\206\000\000\000\
\\001\000\011\000\204\000\055\000\155\001\000\000\
\\001\000\011\000\240\000\055\000\244\000\056\000\243\000\000\000\
\\001\000\012\000\246\000\013\000\138\001\000\000\
\\001\000\012\000\246\000\059\000\091\001\065\000\090\001\000\000\
\\001\000\013\000\183\000\020\000\182\000\000\000\
\\001\000\013\000\183\000\025\000\235\000\000\000\
\\001\000\013\000\183\000\059\000\037\001\000\000\
\\001\000\013\000\183\000\059\000\037\001\065\000\036\001\000\000\
\\001\000\013\000\043\001\020\000\242\001\058\000\042\001\059\000\091\002\
\\063\000\091\002\000\000\
\\001\000\018\000\142\001\029\000\060\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\001\000\019\000\139\001\000\000\
\\001\000\019\000\140\001\000\000\
\\001\000\019\000\156\001\000\000\
\\001\000\019\000\188\001\000\000\
\\001\000\019\000\191\001\000\000\
\\001\000\019\000\218\001\000\000\
\\001\000\019\000\225\001\000\000\
\\001\000\019\000\227\001\000\000\
\\001\000\019\000\237\001\000\000\
\\001\000\019\000\238\001\000\000\
\\001\000\020\000\176\000\000\000\
\\001\000\020\000\211\000\000\000\
\\001\000\020\000\003\001\000\000\
\\001\000\020\000\041\001\000\000\
\\001\000\020\000\048\001\000\000\
\\001\000\020\000\053\001\000\000\
\\001\000\020\000\067\001\000\000\
\\001\000\020\000\070\001\000\000\
\\001\000\020\000\082\001\000\000\
\\001\000\020\000\130\001\000\000\
\\001\000\020\000\143\001\000\000\
\\001\000\020\000\170\001\000\000\
\\001\000\023\000\177\000\029\000\060\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\001\000\024\000\148\000\000\000\
\\001\000\026\000\183\001\000\000\
\\001\000\029\000\060\000\039\000\242\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\001\000\029\000\060\000\050\000\222\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\001\000\032\000\216\000\000\000\
\\001\000\032\000\218\000\000\000\
\\001\000\032\000\063\001\000\000\
\\001\000\032\000\172\001\000\000\
\\001\000\032\000\219\001\000\000\
\\001\000\032\000\222\001\000\000\
\\001\000\058\000\212\000\000\000\
\\001\000\058\000\094\001\000\000\
\\001\000\058\000\120\001\000\000\
\\001\000\058\000\168\001\000\000\
\\001\000\058\000\177\001\062\000\168\000\000\000\
\\001\000\058\000\201\001\000\000\
\\001\000\058\000\210\001\000\000\
\\001\000\062\000\168\000\000\000\
\\001\000\063\000\174\000\000\000\
\\001\000\063\000\039\001\000\000\
\\001\000\063\000\092\001\000\000\
\\001\000\064\000\164\000\000\000\
\\001\000\064\000\173\000\000\000\
\\001\000\064\000\034\001\000\000\
\\001\000\064\000\038\001\000\000\
\\001\000\065\000\169\000\000\000\
\\001\000\065\000\172\000\000\000\
\\001\000\065\000\050\001\000\000\
\\001\000\065\000\089\001\000\000\
\\001\000\065\000\097\001\000\000\
\\001\000\065\000\181\001\000\000\
\\001\000\065\000\229\001\000\000\
\\001\000\065\000\230\001\000\000\
\\001\000\071\000\063\000\072\000\062\000\000\000\
\\001\000\071\000\161\000\000\000\
\\240\001\000\000\
\\241\001\000\000\
\\242\001\000\000\
\\242\001\024\000\202\000\000\000\
\\243\001\000\000\
\\244\001\000\000\
\\244\001\024\000\148\000\000\000\
\\244\001\024\000\214\000\000\000\
\\245\001\000\000\
\\246\001\000\000\
\\247\001\000\000\
\\248\001\040\000\142\000\000\000\
\\249\001\000\000\
\\250\001\000\000\
\\251\001\000\000\
\\252\001\000\000\
\\253\001\000\000\
\\254\001\000\000\
\\255\001\000\000\
\\000\002\024\000\255\000\000\000\
\\001\002\012\000\246\000\000\000\
\\002\002\000\000\
\\003\002\059\000\093\001\000\000\
\\004\002\000\000\
\\005\002\000\000\
\\006\002\000\000\
\\007\002\000\000\
\\008\002\000\000\
\\009\002\000\000\
\\010\002\000\000\
\\011\002\000\000\
\\012\002\003\000\159\000\057\000\248\000\000\000\
\\013\002\000\000\
\\014\002\012\000\246\000\000\000\
\\015\002\003\000\159\000\057\000\248\000\000\000\
\\016\002\012\000\246\000\059\000\091\001\000\000\
\\017\002\000\000\
\\018\002\014\000\236\000\000\000\
\\019\002\000\000\
\\020\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\021\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\022\002\000\000\
\\023\002\059\000\175\000\000\000\
\\024\002\002\000\171\000\029\000\060\000\058\000\059\000\059\000\170\000\
\\066\000\058\000\067\000\057\000\000\000\
\\024\002\002\000\171\000\029\000\060\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\025\002\000\000\
\\026\002\000\000\
\\027\002\058\000\059\000\067\000\057\000\000\000\
\\028\002\058\000\059\000\000\000\
\\029\002\012\000\246\000\000\000\
\\030\002\003\000\050\000\005\000\049\000\006\000\048\000\007\000\047\000\
\\008\000\046\000\020\000\041\000\030\000\036\000\036\000\032\000\
\\040\000\029\000\057\000\020\000\060\000\019\000\061\000\018\000\
\\062\000\017\000\069\000\015\000\070\000\014\000\073\000\013\000\000\000\
\\031\002\000\000\
\\032\002\000\000\
\\033\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\034\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\035\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\036\002\000\000\
\\037\002\000\000\
\\038\002\000\000\
\\039\002\000\000\
\\040\002\000\000\
\\041\002\000\000\
\\042\002\000\000\
\\043\002\000\000\
\\044\002\000\000\
\\045\002\000\000\
\\046\002\000\000\
\\047\002\000\000\
\\048\002\000\000\
\\049\002\000\000\
\\050\002\000\000\
\\051\002\000\000\
\\052\002\000\000\
\\053\002\000\000\
\\054\002\000\000\
\\055\002\000\000\
\\056\002\000\000\
\\057\002\000\000\
\\058\002\000\000\
\\059\002\000\000\
\\060\002\072\000\062\000\000\000\
\\061\002\000\000\
\\062\002\000\000\
\\063\002\029\000\060\000\058\000\059\000\059\000\170\000\066\000\058\000\
\\067\000\057\000\000\000\
\\064\002\029\000\060\000\058\000\059\000\059\000\165\000\066\000\058\000\
\\067\000\057\000\000\000\
\\065\002\000\000\
\\066\002\000\000\
\\066\002\065\000\074\001\000\000\
\\067\002\058\000\029\001\000\000\
\\067\002\058\000\029\001\065\000\148\001\000\000\
\\068\002\013\000\183\000\000\000\
\\069\002\058\000\181\000\000\000\
\\070\002\012\000\246\000\000\000\
\\071\002\012\000\246\000\000\000\
\\072\002\000\000\
\\073\002\000\000\
\\074\002\000\000\
\\075\002\000\000\
\\076\002\000\000\
\\077\002\000\000\
\\078\002\000\000\
\\079\002\000\000\
\\080\002\000\000\
\\081\002\000\000\
\\082\002\000\000\
\\083\002\000\000\
\\084\002\000\000\
\\085\002\000\000\
\\086\002\000\000\
\\087\002\000\000\
\\088\002\000\000\
\\089\002\000\000\
\\090\002\013\000\183\000\000\000\
\\092\002\013\000\183\000\000\000\
\\093\002\012\000\246\000\013\000\182\001\000\000\
\\094\002\013\000\183\000\000\000\
\\095\002\000\000\
\\096\002\059\000\040\001\000\000\
\\097\002\000\000\
\\098\002\013\000\183\000\059\000\035\001\000\000\
\\099\002\000\000\
\\100\002\011\000\178\000\000\000\
\\101\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\102\002\058\000\229\000\000\000\
\\103\002\012\000\246\000\000\000\
\\104\002\000\000\
\\105\002\011\000\044\001\000\000\
\\106\002\014\000\227\000\000\000\
\\107\002\000\000\
\\108\002\011\000\230\000\000\000\
\\109\002\000\000\
\\110\002\000\000\
\\111\002\000\000\
\\112\002\000\000\
\\113\002\003\000\102\000\005\000\049\000\006\000\048\000\007\000\101\000\
\\008\000\100\000\040\000\099\000\054\000\097\000\057\000\080\000\
\\060\000\096\000\061\000\095\000\062\000\094\000\069\000\093\000\000\000\
\\114\002\000\000\
\\115\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\\116\002\012\000\246\000\000\000\
\\117\002\011\000\204\000\000\000\
\\118\002\000\000\
\\119\002\000\000\
\\120\002\004\000\106\000\062\000\105\000\000\000\
\\121\002\059\000\051\001\000\000\
\\122\002\000\000\
\\123\002\011\000\240\000\000\000\
\\124\002\000\000\
\\125\002\014\000\197\001\000\000\
\\126\002\000\000\
\\127\002\039\000\224\001\000\000\
\\128\002\012\000\246\000\000\000\
\\129\002\020\000\079\001\039\000\078\001\000\000\
\\130\002\012\000\246\000\000\000\
\\131\002\000\000\
\\132\002\011\000\237\000\000\000\
\\133\002\003\000\116\000\020\000\041\000\057\000\020\000\000\000\
\\134\002\000\000\
\\135\002\005\000\049\000\006\000\048\000\000\000\
\\136\002\000\000\
\\137\002\005\000\049\000\006\000\048\000\000\000\
\\138\002\000\000\
\\139\002\000\000\
\\140\002\011\000\178\000\000\000\
\\141\002\011\000\044\001\000\000\
\\142\002\000\000\
\\143\002\011\000\204\000\000\000\
\\144\002\011\000\240\000\056\000\239\000\000\000\
\\145\002\011\000\204\000\000\000\
\\146\002\000\000\
\\147\002\000\000\
\\148\002\011\000\237\000\000\000\
\\149\002\000\000\
\\150\002\000\000\
\\151\002\000\000\
\\152\002\011\000\220\001\029\000\060\000\058\000\059\000\066\000\058\000\
\\067\000\057\000\000\000\
\\153\002\000\000\
\\154\002\002\000\124\000\010\000\044\000\016\000\042\000\022\000\040\000\
\\027\000\038\000\034\000\034\000\035\000\033\000\037\000\123\000\
\\038\000\030\000\041\000\028\000\042\000\027\000\051\000\023\000\
\\052\000\022\000\000\000\
\\155\002\000\000\
\\156\002\000\000\
\\157\002\000\000\
\\158\002\003\000\054\000\020\000\041\000\057\000\020\000\000\000\
\\159\002\000\000\
\\160\002\002\000\020\001\003\000\019\001\016\000\018\001\021\000\017\001\
\\022\000\016\001\028\000\015\001\033\000\014\001\034\000\034\000\
\\035\000\033\000\037\000\013\001\038\000\030\000\041\000\012\001\
\\045\000\011\001\049\000\010\001\051\000\009\001\052\000\008\001\000\000\
\\160\002\002\000\020\001\016\000\018\001\021\000\017\001\022\000\016\001\
\\028\000\015\001\033\000\014\001\034\000\034\000\035\000\033\000\
\\037\000\013\001\038\000\030\000\041\000\012\001\045\000\011\001\
\\049\000\010\001\051\000\009\001\052\000\008\001\000\000\
\\161\002\000\000\
\\162\002\000\000\
\\163\002\011\000\167\001\000\000\
\\164\002\011\000\174\001\000\000\
\\165\002\011\000\240\000\000\000\
\\166\002\011\000\165\001\000\000\
\\167\002\011\000\165\001\000\000\
\\168\002\011\000\163\001\000\000\
\\169\002\011\000\178\001\000\000\
\\170\002\000\000\
\\171\002\011\000\169\001\000\000\
\\172\002\000\000\
\\173\002\000\000\
\\174\002\000\000\
\\175\002\003\000\054\000\020\000\041\000\057\000\020\000\000\000\
\\176\002\000\000\
\\177\002\011\000\167\001\000\000\
\\178\002\000\000\
\\179\002\011\000\174\001\000\000\
\\180\002\000\000\
\\181\002\011\000\165\001\000\000\
\\182\002\000\000\
\\183\002\011\000\163\001\000\000\
\\184\002\012\000\246\000\000\000\
\\185\002\011\000\178\001\000\000\
\\186\002\039\000\179\001\000\000\
\\187\002\012\000\246\000\000\000\
\\188\002\011\000\169\001\000\000\
\\189\002\000\000\
\\190\002\000\000\
\\191\002\020\000\170\001\000\000\
\\192\002\000\000\
\\193\002\000\000\
\\194\002\000\000\
\\195\002\058\000\209\000\000\000\
\\196\002\000\000\
\\197\002\058\000\226\000\062\000\168\000\000\000\
\\198\002\000\000\
\\199\002\011\000\210\000\000\000\
\\200\002\000\000\
\\201\002\011\000\166\000\000\000\
\\202\002\000\000\
\\203\002\000\000\
\\204\002\000\000\
\\205\002\062\000\185\001\000\000\
\\206\002\000\000\
\\207\002\000\000\
\\208\002\000\000\
\\209\002\000\000\
\\210\002\000\000\
\\211\002\062\000\185\001\000\000\
\\212\002\062\000\185\001\000\000\
\\213\002\000\000\
\\214\002\000\000\
\\215\002\002\000\120\000\003\000\116\000\009\000\045\000\010\000\044\000\
\\016\000\042\000\020\000\041\000\022\000\040\000\027\000\038\000\
\\028\000\037\000\034\000\034\000\035\000\033\000\036\000\136\001\
\\037\000\031\000\038\000\030\000\041\000\028\000\042\000\027\000\
\\047\000\025\000\048\000\135\001\049\000\024\000\051\000\023\000\
\\052\000\022\000\057\000\020\000\068\000\016\000\000\000\
\\215\002\002\000\120\000\009\000\045\000\010\000\044\000\016\000\042\000\
\\022\000\040\000\027\000\038\000\028\000\037\000\034\000\034\000\
\\035\000\033\000\037\000\031\000\038\000\030\000\041\000\028\000\
\\042\000\027\000\047\000\025\000\049\000\024\000\051\000\023\000\
\\052\000\022\000\068\000\016\000\000\000\
\\216\002\000\000\
\\217\002\009\000\045\000\010\000\044\000\016\000\042\000\022\000\040\000\
\\027\000\038\000\028\000\037\000\034\000\034\000\035\000\033\000\
\\037\000\031\000\038\000\030\000\041\000\028\000\042\000\027\000\
\\047\000\025\000\049\000\024\000\051\000\023\000\052\000\022\000\
\\068\000\016\000\000\000\
\\218\002\011\000\207\000\000\000\
\\219\002\011\000\207\000\000\000\
\\220\002\011\000\210\000\000\000\
\\221\002\011\000\166\000\000\000\
\\222\002\011\000\223\000\000\000\
\\223\002\000\000\
\\224\002\000\000\
\\225\002\000\000\
\\226\002\011\000\207\000\000\000\
\\227\002\000\000\
\\228\002\000\000\
\\229\002\062\000\168\000\000\000\
\\230\002\000\000\
\\231\002\000\000\
\\232\002\000\000\
\\233\002\011\000\223\000\000\000\
\\234\002\062\000\185\001\000\000\
\\235\002\000\000\
\\236\002\000\000\
\\237\002\000\000\
\\238\002\029\000\060\000\058\000\059\000\066\000\058\000\067\000\057\000\000\000\
\"
val actionRowNumbers =
"\001\000\084\001\104\001\091\001\
\\006\000\177\000\156\000\150\000\
\\105\001\162\000\157\000\176\000\
\\098\000\002\000\006\000\004\000\
\\003\000\008\000\108\000\005\000\
\\011\000\241\000\006\000\006\000\
\\005\000\006\000\020\000\006\000\
\\004\001\082\001\019\001\002\001\
\\000\001\005\000\007\000\006\000\
\\016\000\015\000\111\000\109\000\
\\241\000\005\000\241\000\006\000\
\\164\000\163\000\101\000\100\000\
\\106\000\083\001\015\001\023\001\
\\105\000\158\000\159\000\005\000\
\\005\000\022\000\015\000\099\000\
\\023\000\178\000\086\000\184\000\
\\174\000\088\001\082\000\090\000\
\\143\000\091\000\168\000\087\000\
\\172\000\083\000\142\000\052\000\
\\116\000\167\000\104\000\117\000\
\\102\000\064\000\005\001\196\000\
\\194\000\234\000\191\000\186\000\
\\036\000\202\000\197\000\012\000\
\\014\000\013\000\025\000\205\000\
\\010\000\006\000\204\000\203\000\
\\103\000\026\000\008\001\031\000\
\\239\000\085\001\061\001\087\001\
\\053\000\155\000\075\000\014\001\
\\254\000\115\000\107\000\160\000\
\\082\001\069\000\082\001\070\000\
\\019\001\019\001\019\001\003\001\
\\001\001\068\000\165\000\089\001\
\\063\001\227\000\223\000\007\001\
\\229\000\234\000\014\000\037\000\
\\137\000\151\000\013\001\006\000\
\\110\000\009\001\006\000\067\000\
\\033\000\086\001\020\000\024\001\
\\148\000\147\000\149\000\132\000\
\\134\000\129\000\022\000\009\000\
\\123\000\119\000\146\000\179\000\
\\180\000\065\000\173\000\005\000\
\\006\000\054\000\025\001\170\000\
\\005\000\005\000\169\000\171\000\
\\166\000\007\000\005\000\005\000\
\\015\000\188\000\234\000\022\000\
\\005\000\015\000\088\000\219\000\
\\208\000\039\000\198\000\089\000\
\\206\000\084\000\217\000\055\000\
\\210\000\218\000\040\000\006\001\
\\223\000\112\000\006\000\200\000\
\\020\000\056\000\241\000\092\000\
\\242\000\006\000\057\000\027\000\
\\006\000\027\000\022\000\255\000\
\\020\000\079\001\082\001\080\001\
\\005\000\020\001\071\000\021\001\
\\005\000\006\000\061\001\058\000\
\\028\000\016\000\059\000\022\000\
\\016\000\233\000\234\000\187\000\
\\038\000\005\000\015\000\111\000\
\\250\000\241\000\241\000\060\000\
\\015\000\241\000\019\001\161\000\
\\022\000\128\000\022\000\093\000\
\\035\000\085\000\122\000\076\000\
\\125\000\021\000\181\000\185\000\
\\067\001\027\000\094\000\026\001\
\\095\001\006\000\111\000\241\000\
\\006\000\019\000\020\000\026\001\
\\006\000\006\000\006\000\241\000\
\\241\000\077\000\026\001\182\000\
\\183\000\144\000\145\000\141\000\
\\140\000\153\000\221\000\022\000\
\\235\000\193\000\222\000\190\000\
\\209\000\015\000\195\000\015\000\
\\207\000\211\000\024\000\015\000\
\\022\000\015\000\010\000\061\000\
\\113\000\201\000\022\000\238\000\
\\240\000\031\000\093\001\017\000\
\\062\001\026\001\059\001\065\001\
\\066\001\034\000\114\000\042\000\
\\043\000\019\001\041\000\100\001\
\\062\000\018\000\064\001\228\000\
\\005\000\224\000\230\000\189\000\
\\234\000\139\000\138\000\253\000\
\\022\000\020\000\010\001\244\000\
\\111\000\152\000\032\000\044\000\
\\133\000\130\000\131\000\021\000\
\\127\000\022\000\124\000\007\000\
\\022\000\118\000\068\001\096\001\
\\027\001\036\001\034\001\006\000\
\\032\001\029\000\029\001\078\000\
\\056\001\037\001\063\000\020\000\
\\038\001\072\000\040\001\041\001\
\\030\001\079\000\035\001\052\001\
\\033\001\031\001\027\000\028\001\
\\192\000\220\000\095\000\216\000\
\\212\000\214\000\213\000\226\000\
\\066\000\237\000\243\000\092\001\
\\071\001\082\001\082\001\045\000\
\\005\000\090\001\175\000\046\000\
\\005\000\017\000\099\001\101\001\
\\082\001\236\000\234\000\232\000\
\\251\000\252\000\246\000\245\000\
\\006\000\019\001\011\001\126\000\
\\136\000\135\000\121\000\120\000\
\\097\001\111\000\080\000\241\000\
\\048\001\006\000\027\000\019\000\
\\020\000\055\001\026\001\042\001\
\\006\000\081\000\046\001\030\000\
\\006\000\022\000\094\001\199\000\
\\015\000\015\000\073\001\081\001\
\\047\000\073\000\060\001\016\001\
\\017\001\019\001\154\000\098\001\
\\102\001\074\000\231\000\111\000\
\\248\000\048\000\049\001\022\000\
\\047\001\043\001\044\001\054\001\
\\058\001\057\001\049\000\045\001\
\\027\000\069\001\051\001\053\001\
\\215\000\225\000\096\000\097\000\
\\072\001\017\000\005\000\022\001\
\\018\000\247\000\022\000\012\001\
\\050\001\039\001\070\001\078\001\
\\077\001\050\000\018\001\051\000\
\\249\000\075\001\076\001\074\001\
\\103\001\000\000"
val gotoT =
"\
\\001\000\010\000\003\000\009\000\020\000\008\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\053\000\004\000\054\000\003\000\
\\077\000\002\000\078\000\001\000\084\000\237\001\000\000\
\\053\000\004\000\054\000\003\000\077\000\049\000\078\000\001\000\000\000\
\\000\000\
\\000\000\
\\001\000\051\000\057\000\050\000\000\000\
\\000\000\
\\000\000\
\\001\000\054\000\003\000\009\000\022\000\053\000\025\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\026\000\059\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\063\000\021\000\007\000\
\\022\000\006\000\023\000\062\000\025\000\005\000\000\000\
\\001\000\066\000\072\000\065\000\000\000\
\\001\000\010\000\003\000\009\000\019\000\069\000\020\000\068\000\
\\021\000\007\000\022\000\006\000\024\000\067\000\025\000\005\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\063\000\021\000\007\000\
\\022\000\006\000\023\000\071\000\025\000\005\000\000\000\
\\002\000\076\000\007\000\075\000\017\000\074\000\018\000\073\000\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\081\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\088\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\037\000\082\000\000\000\
\\045\000\102\000\046\000\101\000\000\000\
\\001\000\106\000\079\000\105\000\000\000\
\\001\000\108\000\071\000\107\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\109\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\001\000\110\000\000\000\
\\001\000\113\000\006\000\112\000\052\000\111\000\000\000\
\\001\000\115\000\000\000\
\\000\000\
\\053\000\004\000\054\000\003\000\076\000\117\000\078\000\116\000\000\000\
\\053\000\004\000\054\000\120\000\056\000\119\000\000\000\
\\003\000\123\000\000\000\
\\003\000\124\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\125\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\002\000\076\000\007\000\126\000\000\000\
\\001\000\128\000\082\000\127\000\000\000\
\\002\000\090\000\003\000\089\000\031\000\133\000\032\000\083\000\
\\040\000\132\000\041\000\131\000\043\000\130\000\044\000\129\000\000\000\
\\002\000\090\000\003\000\089\000\015\000\137\000\016\000\136\000\
\\027\000\135\000\028\000\087\000\029\000\086\000\030\000\085\000\
\\031\000\084\000\032\000\083\000\000\000\
\\004\000\139\000\051\000\138\000\000\000\
\\000\000\
\\046\000\142\000\048\000\141\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\143\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\046\000\142\000\048\000\144\000\000\000\
\\001\000\106\000\079\000\145\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\051\000\057\000\147\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\148\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\149\000\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\150\000\000\000\
\\002\000\090\000\003\000\089\000\015\000\158\000\016\000\136\000\
\\027\000\135\000\028\000\087\000\029\000\086\000\030\000\085\000\
\\031\000\084\000\032\000\083\000\000\000\
\\000\000\
\\003\000\009\000\022\000\160\000\025\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\081\000\165\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\177\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\027\000\183\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\036\000\182\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\185\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\183\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\036\000\187\000\000\000\
\\002\000\076\000\007\000\191\000\033\000\190\000\034\000\189\000\000\000\
\\000\000\
\\002\000\197\000\005\000\196\000\039\000\195\000\000\000\
\\001\000\199\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\047\000\203\000\000\000\
\\000\000\
\\000\000\
\\069\000\206\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\113\000\006\000\112\000\052\000\211\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\053\000\004\000\054\000\003\000\076\000\213\000\078\000\116\000\000\000\
\\000\000\
\\053\000\004\000\054\000\003\000\076\000\215\000\078\000\116\000\000\000\
\\000\000\
\\053\000\004\000\054\000\120\000\056\000\217\000\000\000\
\\053\000\004\000\054\000\120\000\056\000\218\000\000\000\
\\053\000\004\000\054\000\120\000\056\000\219\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\070\000\223\000\081\000\222\000\000\000\
\\000\000\
\\038\000\226\000\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\229\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\232\000\028\000\231\000\
\\029\000\086\000\030\000\230\000\031\000\084\000\032\000\083\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\236\000\000\000\
\\000\000\
\\000\000\
\\001\000\239\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\113\000\006\000\243\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\245\000\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\248\000\
\\014\000\247\000\000\000\
\\002\000\076\000\007\000\251\000\009\000\250\000\010\000\249\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\026\000\254\000\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\063\000\021\000\007\000\
\\022\000\006\000\023\000\255\000\025\000\005\000\000\000\
\\001\000\066\000\072\000\000\001\000\000\
\\000\000\
\\053\000\005\001\058\000\004\001\059\000\003\001\080\000\002\001\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\020\001\021\000\007\000\
\\022\000\006\000\024\000\019\001\025\000\005\000\000\000\
\\001\000\010\000\003\000\009\000\019\000\022\001\020\000\021\001\
\\021\000\007\000\022\000\006\000\025\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\076\000\007\000\075\000\017\000\074\000\018\000\023\001\000\000\
\\001\000\010\000\003\000\009\000\020\000\024\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\001\000\010\000\003\000\009\000\020\000\025\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\088\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\037\000\026\001\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\028\001\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\029\001\000\000\
\\001\000\010\000\003\000\009\000\020\000\030\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\002\000\090\000\003\000\089\000\027\000\031\001\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\038\000\043\001\000\000\
\\000\000\
\\001\000\044\001\000\000\
\\000\000\
\\001\000\113\000\006\000\045\001\000\000\
\\000\000\
\\045\000\047\001\046\000\101\000\000\000\
\\000\000\
\\000\000\
\\001\000\106\000\079\000\050\001\000\000\
\\000\000\
\\068\000\052\001\000\000\
\\001\000\108\000\071\000\055\001\000\000\
\\068\000\056\001\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\057\001\000\000\
\\000\000\
\\001\000\113\000\006\000\058\001\000\000\
\\000\000\
\\053\000\004\000\054\000\003\000\076\000\059\001\078\000\116\000\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\019\000\060\001\020\000\021\001\
\\021\000\007\000\022\000\006\000\025\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\062\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\001\000\128\000\082\000\063\001\000\000\
\\069\000\064\001\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\031\000\133\000\032\000\083\000\
\\040\000\067\001\043\000\130\000\044\000\129\000\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\069\001\000\000\
\\002\000\090\000\003\000\089\000\031\000\133\000\032\000\083\000\
\\040\000\132\000\041\000\070\001\043\000\130\000\044\000\129\000\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\071\001\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\073\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\002\000\090\000\003\000\089\000\015\000\074\001\016\000\136\000\
\\027\000\135\000\028\000\087\000\029\000\086\000\030\000\085\000\
\\031\000\084\000\032\000\083\000\000\000\
\\004\000\139\000\051\000\075\001\000\000\
\\000\000\
\\045\000\078\001\046\000\101\000\000\000\
\\046\000\142\000\048\000\079\001\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\015\000\081\001\016\000\136\000\
\\027\000\135\000\028\000\087\000\029\000\086\000\030\000\085\000\
\\031\000\084\000\032\000\083\000\000\000\
\\045\000\082\001\046\000\101\000\000\000\
\\053\000\004\000\054\000\120\000\056\000\083\001\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\084\001\000\000\
\\000\000\
\\008\000\153\000\011\000\086\001\012\000\085\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\093\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\094\001\000\000\
\\000\000\
\\053\000\005\001\058\000\096\001\059\000\003\001\000\000\
\\000\000\
\\001\000\051\000\057\000\097\001\000\000\
\\004\000\099\001\064\000\098\001\000\000\
\\046\000\101\001\063\000\100\001\000\000\
\\001\000\103\001\061\000\102\001\000\000\
\\001\000\113\000\006\000\106\001\066\000\105\001\067\000\104\001\000\000\
\\001\000\113\000\006\000\112\000\052\000\108\001\000\000\
\\053\000\005\001\058\000\109\001\059\000\003\001\000\000\
\\001\000\111\001\060\000\110\001\000\000\
\\001\000\113\001\062\000\112\001\000\000\
\\001\000\115\001\065\000\114\001\000\000\
\\046\000\101\001\063\000\116\001\000\000\
\\046\000\142\000\048\000\117\001\000\000\
\\000\000\
\\053\000\005\001\058\000\119\001\059\000\003\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\120\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\027\000\183\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\036\000\121\001\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\027\000\183\000\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\
\\036\000\122\001\000\000\
\\000\000\
\\000\000\
\\002\000\076\000\007\000\191\000\033\000\190\000\034\000\123\001\000\000\
\\002\000\090\000\003\000\089\000\027\000\124\001\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\125\001\000\000\
\\002\000\090\000\003\000\089\000\027\000\126\001\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\000\000\
\\002\000\197\000\005\000\196\000\039\000\127\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\129\001\000\000\
\\000\000\
\\000\000\
\\047\000\130\001\000\000\
\\000\000\
\\001\000\113\000\006\000\132\001\074\000\131\001\000\000\
\\000\000\
\\053\000\005\001\058\000\135\001\059\000\003\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\053\000\004\000\054\000\120\000\056\000\139\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\113\000\006\000\143\001\083\000\142\001\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\145\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\147\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\148\001\000\000\
\\001\000\113\000\006\000\149\001\000\000\
\\000\000\
\\000\000\
\\004\000\152\001\049\000\151\001\050\000\150\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\245\000\000\000\
\\008\000\155\001\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\157\001\
\\014\000\156\001\000\000\
\\000\000\
\\002\000\076\000\007\000\251\000\009\000\250\000\010\000\158\001\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\159\001\000\000\
\\000\000\
\\000\000\
\\081\000\160\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\162\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\113\000\006\000\106\001\067\000\169\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\111\001\060\000\171\001\000\000\
\\000\000\
\\073\000\174\001\081\000\173\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\178\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\075\000\182\001\000\000\
\\053\000\004\000\054\000\003\000\076\000\184\001\078\000\116\000\000\000\
\\053\000\004\000\054\000\003\000\076\000\185\001\078\000\116\000\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\188\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\055\000\187\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\010\000\003\000\009\000\020\000\190\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\000\000\
\\001\000\113\000\006\000\132\001\074\000\191\001\000\000\
\\000\000\
\\075\000\192\001\000\000\
\\053\000\004\000\054\000\003\000\076\000\193\001\078\000\116\000\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\030\000\178\000\031\000\084\000\
\\032\000\083\000\042\000\194\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\196\001\000\000\
\\053\000\004\000\054\000\120\000\056\000\197\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\004\000\099\001\064\000\198\001\000\000\
\\000\000\
\\046\000\101\001\063\000\200\001\000\000\
\\000\000\
\\001\000\103\001\061\000\201\001\000\000\
\\068\000\202\001\000\000\
\\001\000\113\000\006\000\106\001\066\000\203\001\067\000\104\001\000\000\
\\001\000\113\000\006\000\205\001\067\000\204\001\000\000\
\\000\000\
\\053\000\005\001\058\000\206\001\059\000\003\001\000\000\
\\000\000\
\\001\000\113\001\062\000\207\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\115\001\065\000\210\001\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\211\001\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\003\000\089\000\027\000\212\001\028\000\087\000\
\\029\000\086\000\030\000\085\000\031\000\084\000\032\000\083\000\000\000\
\\002\000\090\000\003\000\089\000\015\000\213\001\016\000\136\000\
\\027\000\135\000\028\000\087\000\029\000\086\000\030\000\085\000\
\\031\000\084\000\032\000\083\000\000\000\
\\000\000\
\\001\000\113\000\006\000\132\001\053\000\004\000\054\000\003\000\
\\074\000\215\001\076\000\214\001\078\000\116\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\053\000\004\000\054\000\120\000\056\000\219\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\004\000\152\001\049\000\221\001\050\000\150\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\224\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\226\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\113\000\006\000\132\001\074\000\229\001\000\000\
\\001\000\010\000\003\000\009\000\020\000\188\001\021\000\007\000\
\\022\000\006\000\025\000\005\000\055\000\230\001\000\000\
\\000\000\
\\001\000\113\000\006\000\143\001\083\000\231\001\000\000\
\\000\000\
\\008\000\153\000\011\000\152\000\012\000\151\000\013\000\232\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\075\000\233\001\000\000\
\\075\000\234\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 494
val numrules = 255
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.arrayoflist(actionRows) in fn i=>Array.sub(a,i) end
in Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = pos*pos -> ErrorMsg.complainer
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit
 | AQID of  (FastSymbol.raw_symbol) | OBJL of  (string)
 | ENDQ of  (string) | STRING of  (string) | REAL of  (string)
 | INT0 of  (int) | INT of  (int) | TYVAR of  (FastSymbol.raw_symbol)
 | ID of  (FastSymbol.raw_symbol) | interdec of  (env -> dec*env)
 | fct_exp of  (env*fsigexp option -> fctexp)
 | fctb of  (env -> fctb list)
 | fparamList of  ( ( symbol option * sigexp )  list)
 | fparam of  (symbol option*sigexp) | strb of  (env -> strb list)
 | sdec of  (env -> dec* ( env -> env ) )
 | sdecs' of  (env -> dec* ( env -> env ) )
 | sdecs of  (env -> dec* ( env -> env ) )
 | arg_fct of  (env ->  ( strexp * bool )  list)
 | str of  (env -> strexp) | fsig of  (fsigexp)
 | fsigb of  (fsigb list) | sigb of  (sigb list)
 | fsigconstraint_op of  (fsigexp option)
 | sigconstraint_op of  (sigexp option) | sign of  (sigexp)
 | patheqn of  ( ( FastSymbol.raw_symbol ->symbol )  -> symbol list list)
 | sharespec of  (spec list)
 | exnspec of  ( ( symbol * ty option )  list)
 | valspec of  ( ( symbol * ty )  list)
 | tyspec of  ( ( symbol * tyvar list )  list)
 | fctspec of  ( ( symbol * fsigexp )  list)
 | strspec of  ( ( symbol * sigexp )  list) | idents of  (spec list)
 | spec of  (spec list) | spec_s of  (spec list)
 | ops of  (symbol list) | ldecs of  (env -> dec* ( env -> env ) )
 | exp_pa of  (env -> exp list)
 | ldec of  (env -> dec* ( env -> env ) )
 | fixity of  (unit -> fixity) | qid_p of  (Symbol.symbol list list)
 | eb of  (eb list) | constr of  (symbol*ty option)
 | constrs of  ( ( symbol * ty option )  list) | db of  (db list)
 | tyvar_pc of  (tyvar list) | tyvars of  (tyvar list)
 | tb of  (tb list) | clause of  (env -> rawclause)
 | clause' of  (env ->  ( symbol * pat list ) )
 | apats of  (env ->  ( pat * fixity * complainer )  list)
 | fb of  (env ->  ( rawclause list * linenum * linenum )  list)
 | fb' of  (env -> rawclause list) | rvb of  (env -> rvb list)
 | constraint of  (ty option) | vb of  (env -> vb list)
 | pat_list of  (env -> pat list) | pat_2c of  (env -> pat list)
 | plabels of  (env ->  ( (symbol * pat) list * bool ) )
 | plabel of  (env ->  ( symbol * pat ) ) | apat'' of  (env -> pat)
 | apat' of  (env ->  ( pat * fixity * complainer ) )
 | apat of  (env ->  ( pat * fixity * complainer ) )
 | pat'' of  (env -> pat) | pat' of  (env -> pat)
 | pat of  (env -> pat) | ot_list of  (env -> exp list)
 | quote of  (env -> exp list) | exp_2c of  (env -> exp list)
 | exp_list of  (env -> exp list) | aexp of  (env -> exp)
 | app_exp of  (env -> exp precStack) | exp of  (env -> exp)
 | exp_ps of  (env -> exp list)
 | elabels of  (env ->  ( symbol * exp )  list)
 | elabel of  (env ->  ( symbol * exp ) ) | rule of  (env -> rule)
 | match of  (env -> rule list) | ty0_pc of  (ty list) | ty of  (ty)
 | tuple_ty of  (ty list) | ty' of  (ty)
 | tlabels of  ( ( symbol * ty )  list)
 | tlabel of  ( ( symbol * ty ) ) | tycon of  (symbol list)
 | selector of  (symbol)
 | qid of  ( ( FastSymbol.raw_symbol ->symbol )  -> symbol list)
 | opid of  (env -> symbol) | op_op of  (unit -> unit) | int of  (int)
 | id of  (FastSymbol.raw_symbol) | ident of  (FastSymbol.raw_symbol)
end
type svalue = MlyValue.svalue
type result = env -> dec*env
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 66) => true | (T 65) => true | (T 55) => true | (T 54) => true
 | (T 52) => true | (T 51) => true | (T 50) => true | (T 49) => true
 | (T 48) => true | (T 47) => true | (T 46) => true | (T 45) => true
 | (T 44) => true | (T 43) => true | (T 42) => true | (T 41) => true
 | (T 40) => true | (T 39) => true | (T 38) => true | (T 37) => true
 | (T 36) => true | (T 35) => true | (T 34) => true | (T 33) => true
 | (T 32) => true | (T 31) => true | (T 30) => true | (T 28) => true
 | (T 27) => true | (T 26) => true | (T 25) => true | (T 24) => true
 | (T 22) => true | (T 21) => true | (T 20) => true | (T 18) => true
 | (T 17) => true | (T 16) => true | (T 15) => true | (T 14) => true
 | (T 12) => true | (T 10) => true | (T 9) => true | (T 8) => true | _ => false
val preferred_insert =
fn (T 61) => true | (T 17) => true | (T 49) => true | (T 51) => true
 | _ => false
val preferred_subst =
fn (T 1) =>(T 58)::nil
|(T 10) =>(T 66)::nil
|(T 19) =>(T 24)::nil
|(T 24) =>(T 19)::nil
|(T 57) =>(T 38)::nil
|(T 58) =>(T 1)::nil
| _ => nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "SEMICOLON"
  | (T 2) => "ID"
  | (T 3) => "TYVAR"
  | (T 4) => "INT"
  | (T 5) => "INT0"
  | (T 6) => "REAL"
  | (T 7) => "STRING"
  | (T 8) => "ABSTRACTION"
  | (T 9) => "ABSTYPE"
  | (T 10) => "AND"
  | (T 11) => "ARROW"
  | (T 12) => "AS"
  | (T 13) => "BAR"
  | (T 14) => "CASE"
  | (T 15) => "DATATYPE"
  | (T 16) => "DOTDOTDOT"
  | (T 17) => "ELSE"
  | (T 18) => "END"
  | (T 19) => "EQUAL"
  | (T 20) => "EQTYPE"
  | (T 21) => "EXCEPTION"
  | (T 22) => "DO"
  | (T 23) => "DOT"
  | (T 24) => "DARROW"
  | (T 25) => "FN"
  | (T 26) => "FUN"
  | (T 27) => "FUNCTOR"
  | (T 28) => "HANDLE"
  | (T 29) => "HASH"
  | (T 30) => "IF"
  | (T 31) => "IN"
  | (T 32) => "INCLUDE"
  | (T 33) => "INFIX"
  | (T 34) => "INFIXR"
  | (T 35) => "LET"
  | (T 36) => "LOCAL"
  | (T 37) => "NONFIX"
  | (T 38) => "OF"
  | (T 39) => "OP"
  | (T 40) => "OPEN"
  | (T 41) => "OVERLOAD"
  | (T 42) => "RAISE"
  | (T 43) => "REC"
  | (T 44) => "SHARING"
  | (T 45) => "SIG"
  | (T 46) => "SIGNATURE"
  | (T 47) => "STRUCT"
  | (T 48) => "STRUCTURE"
  | (T 49) => "THEN"
  | (T 50) => "TYPE"
  | (T 51) => "VAL"
  | (T 52) => "WHILE"
  | (T 53) => "WILD"
  | (T 54) => "WITH"
  | (T 55) => "WITHTYPE"
  | (T 56) => "ASTERISK"
  | (T 57) => "COLON"
  | (T 58) => "COMMA"
  | (T 59) => "LBRACE"
  | (T 60) => "LBRACKET"
  | (T 61) => "LPAREN"
  | (T 62) => "RBRACE"
  | (T 63) => "RBRACKET"
  | (T 64) => "RPAREN"
  | (T 65) => "ORELSE"
  | (T 66) => "ANDALSO"
  | (T 67) => "FUNSIG"
  | (T 68) => "VECTORSTART"
  | (T 69) => "BEGINQ"
  | (T 70) => "ENDQ"
  | (T 71) => "OBJL"
  | (T 72) => "AQID"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 2) => MlyValue.ID((rawSymbol(bogusHash,bogusString))) | 
(T 3) => MlyValue.TYVAR((rawSymbol(quotedBogusHash,quotedBogusString)
)) | 
(T 4) => MlyValue.INT((1)) | 
(T 5) => MlyValue.INT0((0)) | 
(T 6) => MlyValue.REAL(("0.0")) | 
(T 7) => MlyValue.STRING(("")) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: 
(T 12) :: (T 13) :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 18) :: 
(T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: 
(T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 32) :: 
(T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37) :: (T 38) :: (T 39) :: 
(T 40) :: (T 41) :: (T 42) :: (T 43) :: (T 44) :: (T 45) :: (T 46) :: 
(T 47) :: (T 48) :: (T 49) :: (T 50) :: (T 51) :: (T 52) :: (T 53) :: 
(T 54) :: (T 55) :: (T 56) :: (T 57) :: (T 58) :: (T 59) :: (T 60) :: 
(T 61) :: (T 62) :: (T 63) :: (T 64) :: (T 65) :: (T 66) :: (T 67) :: 
(T 68) :: (T 69) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (error):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.INT INT,INT1left,INT1right))::rest671) => let val 
result=MlyValue.int((INT))
 in (LrTable.NT 2,(result,INT1left,INT1right),rest671) end
| (1,(_,(MlyValue.INT0 INT0,INT01left,INT01right))::rest671) => let 
val result=MlyValue.int((INT0))
 in (LrTable.NT 2,(result,INT01left,INT01right),rest671) end
| (2,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.id((ID))
 in (LrTable.NT 1,(result,ID1left,ID1right),rest671) end
| (3,(_,(_,ASTERISK1left,ASTERISK1right))::rest671) => let val result=
MlyValue.id((rawSymbol (asteriskHash,asteriskString)))
 in (LrTable.NT 1,(result,ASTERISK1left,ASTERISK1right),rest671) end
| (4,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.ident((ID))
 in (LrTable.NT 0,(result,ID1left,ID1right),rest671) end
| (5,(_,(_,ASTERISK1left,ASTERISK1right))::rest671) => let val result=
MlyValue.ident((rawSymbol (asteriskHash,asteriskString)))
 in (LrTable.NT 0,(result,ASTERISK1left,ASTERISK1right),rest671) end
| (6,(_,(_,EQUAL1left,EQUAL1right))::rest671) => let val result=
MlyValue.ident((rawSymbol (equalHash,equalString)))
 in (LrTable.NT 0,(result,EQUAL1left,EQUAL1right),rest671) end
| (7,(_,(_,OPleft as OP1left,OPright as OP1right))::rest671) => let 
val result=MlyValue.op_op((
fn()=> error (OPleft,OPright) WARN "unnecessary `op'"
				      nullErrorBody
))
 in (LrTable.NT 3,(result,OP1left,OP1right),rest671) end
| (8,rest671) => let val result=MlyValue.op_op((fn()=>()))
 in (LrTable.NT 3,(result,defaultPos,defaultPos),rest671) end
| (9,(_,(MlyValue.id id,idleft as id1left,idright as id1right))::
rest671) => let val result=MlyValue.opid((
fn env => let val (v,f) = var'n'fix id
				   in case lookFIX (env,f) of NONfix => ()
				      | _ => error (idleft,idright) COMPLAIN
						"nonfix identifier required"
						nullErrorBody;
				      v
				   end
))
 in (LrTable.NT 4,(result,id1left,id1right),rest671) end
| (10,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.opid((fn _ => varSymbol ident))
 in (LrTable.NT 4,(result,OP1left,ident1right),rest671) end
| (11,(_,(MlyValue.qid qid,_,qid1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.qid((
fn kind => strSymbol ID :: qid kind))
 in (LrTable.NT 5,(result,ID1left,qid1right),rest671) end
| (12,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.qid((fn kind => [kind ident]))
 in (LrTable.NT 5,(result,ident1left,ident1right),rest671) end
| (13,(_,(MlyValue.id id,id1left,id1right))::rest671) => let val 
result=MlyValue.selector((labSymbol id))
 in (LrTable.NT 6,(result,id1left,id1right),rest671) end
| (14,(_,(MlyValue.INT INT,INT1left,INT1right))::rest671) => let val 
result=MlyValue.selector((Symbol.labSymbol(makestring INT)))
 in (LrTable.NT 6,(result,INT1left,INT1right),rest671) end
| (15,(_,(MlyValue.tycon tycon,_,tycon1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.tycon((
strSymbol ID :: tycon))
 in (LrTable.NT 7,(result,ID1left,tycon1right),rest671) end
| (16,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.tycon(([tycSymbol ID]))
 in (LrTable.NT 7,(result,ID1left,ID1right),rest671) end
| (17,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.tlabel
((selector, ty ))
 in (LrTable.NT 8,(result,selector1left,ty1right),rest671) end
| (18,(_,(MlyValue.tlabels tlabels,_,tlabels1right))::_::(_,(
MlyValue.tlabel tlabel,tlabel1left,_))::rest671) => let val result=
MlyValue.tlabels((tlabel :: tlabels))
 in (LrTable.NT 9,(result,tlabel1left,tlabels1right),rest671) end
| (19,(_,(MlyValue.tlabel tlabel,tlabel1left,tlabel1right))::rest671)
 => let val result=MlyValue.tlabels(([tlabel]))
 in (LrTable.NT 9,(result,tlabel1left,tlabel1right),rest671) end
| (20,(_,(MlyValue.TYVAR TYVAR,TYVARleft as TYVAR1left,TYVARright as 
TYVAR1right))::rest671) => let val result=MlyValue.ty'((
MarkTy (VarTy(Tyv(tyvSymbol TYVAR)),
				 TYVARleft,TYVARright)))
 in (LrTable.NT 10,(result,TYVAR1left,TYVAR1right),rest671) end
| (21,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.tlabels 
tlabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.ty'((
MarkTy(RecordTy tlabels,LBRACEleft,RBRACEright)))
 in (LrTable.NT 10,(result,LBRACE1left,RBRACE1right),rest671) end
| (22,(_,(_,_,RBRACE1right))::(_,(_,LBRACE1left,_))::rest671) => let 
val result=MlyValue.ty'((RecordTy []))
 in (LrTable.NT 10,(result,LBRACE1left,RBRACE1right),rest671) end
| (23,(_,(MlyValue.tycon tycon,tyconleft,tyconright as tycon1right))::
_::(_,(MlyValue.ty0_pc ty0_pc,_,_))::(_,(_,LPAREN1left,_))::rest671)
 => let val result=MlyValue.ty'((
MarkTy(ConTy(tycon,ty0_pc),tyconleft,tyconright)))
 in (LrTable.NT 10,(result,LPAREN1left,tycon1right),rest671) end
| (24,(_,(_,_,RPAREN1right))::(_,(MlyValue.ty ty,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.ty'((ty))
 in (LrTable.NT 10,(result,LPAREN1left,RPAREN1right),rest671) end
| (25,(_,(MlyValue.tycon tycon,tyconleft,tyconright as tycon1right))::
(_,(MlyValue.ty' ty',ty'1left,_))::rest671) => let val result=
MlyValue.ty'((MarkTy(ConTy(tycon,[ty']),tyconleft,tyconright)))
 in (LrTable.NT 10,(result,ty'1left,tycon1right),rest671) end
| (26,(_,(MlyValue.tycon tycon,tyconleft as tycon1left,tyconright as 
tycon1right))::rest671) => let val result=MlyValue.ty'((
MarkTy(ConTy(tycon,[]),tyconleft,tyconright)))
 in (LrTable.NT 10,(result,tycon1left,tycon1right),rest671) end
| (27,(_,(MlyValue.tuple_ty tuple_ty,_,tuple_ty1right))::_::(_,(
MlyValue.ty' ty',ty'1left,_))::rest671) => let val result=
MlyValue.tuple_ty((ty' :: tuple_ty))
 in (LrTable.NT 11,(result,ty'1left,tuple_ty1right),rest671) end
| (28,(_,(MlyValue.ty' ty'2,_,ty'2right))::_::(_,(MlyValue.ty' ty'1,
ty'1left,_))::rest671) => let val result=MlyValue.tuple_ty((
[ty'1,ty'2]))
 in (LrTable.NT 11,(result,ty'1left,ty'2right),rest671) end
| (29,(_,(MlyValue.tuple_ty tuple_ty,tuple_ty1left,tuple_ty1right))::
rest671) => let val result=MlyValue.ty((TupleTy(tuple_ty)))
 in (LrTable.NT 12,(result,tuple_ty1left,tuple_ty1right),rest671) end
| (30,(_,(MlyValue.ty ty2,_,ty2right))::_::(_,(MlyValue.ty ty1,ty1left
,_))::rest671) => let val result=MlyValue.ty((
ConTy([arrowTycon], [ty1,ty2])))
 in (LrTable.NT 12,(result,ty1left,ty2right),rest671) end
| (31,(_,(MlyValue.ty' ty',ty'1left,ty'1right))::rest671) => let val 
result=MlyValue.ty((ty'))
 in (LrTable.NT 12,(result,ty'1left,ty'1right),rest671) end
| (32,(_,(MlyValue.ty ty2,_,ty2right))::_::(_,(MlyValue.ty ty1,ty1left
,_))::rest671) => let val result=MlyValue.ty0_pc(([ty1,ty2]))
 in (LrTable.NT 13,(result,ty1left,ty2right),rest671) end
| (33,(_,(MlyValue.ty0_pc ty0_pc,_,ty0_pc1right))::_::(_,(MlyValue.ty 
ty,ty1left,_))::rest671) => let val result=MlyValue.ty0_pc((
ty :: ty0_pc))
 in (LrTable.NT 13,(result,ty1left,ty0_pc1right),rest671) end
| (34,(_,(MlyValue.rule rule,rule1left,rule1right))::rest671) => let 
val result=MlyValue.match((fn env => [rule env]))
 in (LrTable.NT 14,(result,rule1left,rule1right),rest671) end
| (35,(_,(MlyValue.match match,_,match1right))::_::(_,(MlyValue.rule 
rule,rule1left,_))::rest671) => let val result=MlyValue.match((
fn env => rule env :: match env))
 in (LrTable.NT 14,(result,rule1left,match1right),rest671) end
| (36,(_,(MlyValue.exp exp,expleft,expright as exp1right))::_::(_,(
MlyValue.pat pat,pat1left,_))::rest671) => let val result=
MlyValue.rule((
fn env => Rule{pat=pat env,
				exp=markexp(exp env,expleft,expright)}
))
 in (LrTable.NT 15,(result,pat1left,exp1right),rest671) end
| (37,(_,(MlyValue.exp exp,_,exp1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.elabel
((fn env => (selector,exp env)))
 in (LrTable.NT 16,(result,selector1left,exp1right),rest671) end
| (38,(_,(MlyValue.elabels elabels,_,elabels1right))::_::(_,(
MlyValue.elabel elabel,elabel1left,_))::rest671) => let val result=
MlyValue.elabels((fn env => (elabel env :: elabels env)))
 in (LrTable.NT 17,(result,elabel1left,elabels1right),rest671) end
| (39,(_,(MlyValue.elabel elabel,elabel1left,elabel1right))::rest671)
 => let val result=MlyValue.elabels((fn env => [elabel env]))
 in (LrTable.NT 17,(result,elabel1left,elabel1right),rest671) end
| (40,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_ps((fn env => [exp env]))
 in (LrTable.NT 18,(result,exp1left,exp1right),rest671) end
| (41,(_,(MlyValue.exp_ps exp_ps,_,exp_ps1right))::_::(_,(MlyValue.exp
 exp,exp1left,_))::rest671) => let val result=MlyValue.exp_ps((
fn env => exp env :: exp_ps env))
 in (LrTable.NT 18,(result,exp1left,exp_ps1right),rest671) end
| (42,(_,(MlyValue.match match,_,match1right))::_::(_,(MlyValue.exp 
exp,exp1left,_))::rest671) => let val result=MlyValue.exp((
fn env => HandleExp{expr=exp env,rules=match env}))
 in (LrTable.NT 19,(result,exp1left,match1right),rest671) end
| (43,(_,(MlyValue.exp exp2,exp2left,exp2right))::_::(_,(MlyValue.exp 
exp1,exp1left,exp1right))::rest671) => let val result=MlyValue.exp((
fn env => OrelseExp
				      (markexp(exp1 env,exp1left,exp1right),
				       markexp(exp2 env,exp2left,exp2right))
))
 in (LrTable.NT 19,(result,exp1left,exp2right),rest671) end
| (44,(_,(MlyValue.exp exp2,exp2left,exp2right))::_::(_,(MlyValue.exp 
exp1,exp1left,exp1right))::rest671) => let val result=MlyValue.exp((
fn env=> AndalsoExp
				      (markexp(exp1 env,exp1left,exp1right),
				       markexp(exp2 env,exp2left,exp2right))
))
 in (LrTable.NT 19,(result,exp1left,exp2right),rest671) end
| (45,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.exp exp,
exp1left,_))::rest671) => let val result=MlyValue.exp((
fn env => ConstraintExp{expr=exp env,constraint=ty}))
 in (LrTable.NT 19,(result,exp1left,ty1right),rest671) end
| (46,(_,(MlyValue.app_exp app_exp,app_exp1left,app_expright as 
app_exp1right))::rest671) => let val result=MlyValue.exp((
fn env => 
			   exp_finish(app_exp env,
				      error(app_expright,app_expright))
))
 in (LrTable.NT 19,(result,app_exp1left,app_exp1right),rest671) end
| (47,(_,(MlyValue.match match,_,matchright as match1right))::(_,(_,
FNleft as FN1left,_))::rest671) => let val result=MlyValue.exp((
fn env=> markexp(FnExp(match env),FNleft,matchright)))
 in (LrTable.NT 19,(result,FN1left,match1right),rest671) end
| (48,(_,(MlyValue.match match,_,matchright as match1right))::_::(_,(
MlyValue.exp exp,_,_))::(_,(_,CASEleft as CASE1left,_))::rest671) => 
let val result=MlyValue.exp((
fn env=>markexp(CaseExp{expr=exp env,rules=match env},
			         CASEleft,matchright)
))
 in (LrTable.NT 19,(result,CASE1left,match1right),rest671) end
| (49,(_,(MlyValue.exp exp2,exp2left,exp2right))::_::(_,(MlyValue.exp 
exp1,exp1left,exp1right))::(_,(_,WHILE1left,_))::rest671) => let val 
result=MlyValue.exp((
fn env=> WhileExp{test=markexp(exp1 env,exp1left, exp1right),
				   expr=markexp(exp2 env,exp2left, exp2right)}
))
 in (LrTable.NT 19,(result,WHILE1left,exp2right),rest671) end
| (50,(_,(MlyValue.exp exp3,exp3left,exp3right))::_::(_,(MlyValue.exp 
exp2,exp2left,exp2right))::_::(_,(MlyValue.exp exp1,_,_))::(_,(_,
IF1left,_))::rest671) => let val result=MlyValue.exp((
fn env=>IfExp{test=exp1 env,
			       thenCase=markexp(exp2 env,exp2left,exp2right),
			       elseCase=markexp(exp3 env,exp3left,exp3right)}
))
 in (LrTable.NT 19,(result,IF1left,exp3right),rest671) end
| (51,(_,(MlyValue.exp exp,expleft,expright as exp1right))::(_,(_,
RAISEleft as RAISE1left,_))::rest671) => let val result=MlyValue.exp((
fn env => markexp(markexp(RaiseExp(exp env),expleft,expright),
				   RAISEleft,expright)
))
 in (LrTable.NT 19,(result,RAISE1left,exp1right),rest671) end
| (52,(_,(MlyValue.aexp aexp,aexpleft as aexp1left,aexpright as 
aexp1right))::rest671) => let val result=MlyValue.app_exp((
fn env => exp_start(markexp(aexp env,aexpleft,aexpright),
				     NONfix, error (aexpleft,aexpright))
))
 in (LrTable.NT 20,(result,aexp1left,aexp1right),rest671) end
| (53,(_,(MlyValue.ident ident,identleft as ident1left,identright as 
ident1right))::rest671) => let val result=MlyValue.app_exp((
fn env => let val e = error(identleft,identright)
			       val (v,f) = var'n'fix ident
			   in exp_start(markexp(VarExp [v],
						identleft,identright),
					lookFIX (env,f), e)
			   end
))
 in (LrTable.NT 20,(result,ident1left,ident1right),rest671) end
| (54,(_,(MlyValue.aexp aexp,aexpleft,aexpright as aexp1right))::(_,(
MlyValue.app_exp app_exp,app_exp1left,_))::rest671) => let val result=
MlyValue.app_exp((
fn env => exp_parse(app_exp env, 
					markexp(aexp env, aexpleft,aexpright),
					NONfix,
					error (aexpleft,aexpright))
))
 in (LrTable.NT 20,(result,app_exp1left,aexp1right),rest671) end
| (55,(_,(MlyValue.ident ident,identleft,identright as ident1right))::
(_,(MlyValue.app_exp app_exp,app_exp1left,_))::rest671) => let val 
result=MlyValue.app_exp((
fn env => 
			   let val e = error(identleft,identright)
			       val (v,f) = var'n'fix ident
			   in exp_parse(app_exp env, 
					markexp(VarExp [v], 
						identleft,identright),
					lookFIX(env,f), e)
			   end
))
 in (LrTable.NT 20,(result,app_exp1left,ident1right),rest671) end
| (56,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.aexp((
fn env => VarExp [varSymbol ident]))
 in (LrTable.NT 21,(result,OP1left,ident1right),rest671) end
| (57,(_,(MlyValue.qid qid,_,qid1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => VarExp (strSymbol ID
					   :: qid varSymbol)))
 in (LrTable.NT 21,(result,ID1left,qid1right),rest671) end
| (58,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.aexp((fn env => IntExp int))
 in (LrTable.NT 21,(result,int1left,int1right),rest671) end
| (59,(_,(MlyValue.REAL REAL,REAL1left,REAL1right))::rest671) => let 
val result=MlyValue.aexp((fn env => RealExp REAL))
 in (LrTable.NT 21,(result,REAL1left,REAL1right),rest671) end
| (60,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.aexp((fn env => StringExp STRING))
 in (LrTable.NT 21,(result,STRING1left,STRING1right),rest671) end
| (61,(_,(MlyValue.selector selector,_,selector1right))::(_,(_,
HASH1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => SelectorExp selector))
 in (LrTable.NT 21,(result,HASH1left,selector1right),rest671) end
| (62,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.elabels 
elabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.aexp((
fn env => markexp(RecordExp(elabels env),
				   LBRACEleft,RBRACEright)
))
 in (LrTable.NT 21,(result,LBRACE1left,RBRACE1right),rest671) end
| (63,(_,(_,_,RBRACE1right))::(_,(_,LBRACE1left,_))::rest671) => let 
val result=MlyValue.aexp((fn env => RecordExp nil))
 in (LrTable.NT 21,(result,LBRACE1left,RBRACE1right),rest671) end
| (64,(_,(_,_,RPAREN1right))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.aexp((fn env => unitExp))
 in (LrTable.NT 21,(result,LPAREN1left,RPAREN1right),rest671) end
| (65,(_,(_,_,RPAREN1right))::(_,(MlyValue.exp_ps exp_ps,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => SeqExp(exp_ps env)))
 in (LrTable.NT 21,(result,LPAREN1left,RPAREN1right),rest671) end
| (66,(_,(_,_,RPAREN1right))::(_,(MlyValue.exp_2c exp_2c,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => TupleExp(exp_2c env)))
 in (LrTable.NT 21,(result,LPAREN1left,RPAREN1right),rest671) end
| (67,(_,(_,_,RBRACKET1right))::(_,(MlyValue.exp_list exp_list,_,_))::
(_,(_,LBRACKET1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => ListExp(exp_list env)))
 in (LrTable.NT 21,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (68,(_,(_,_,RBRACKET1right))::(_,(_,LBRACKET1left,_))::rest671) => 
let val result=MlyValue.aexp((fn env => nilExp))
 in (LrTable.NT 21,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (69,(_,(_,_,RBRACKET1right))::(_,(MlyValue.exp_list exp_list,_,_))::
(_,(_,VECTORSTART1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => VectorExp(exp_list env)))
 in (LrTable.NT 21,(result,VECTORSTART1left,RBRACKET1right),rest671)
 end
| (70,(_,(_,_,RBRACKET1right))::(_,(_,VECTORSTART1left,_))::rest671)
 => let val result=MlyValue.aexp((fn env => VectorExp nil))
 in (LrTable.NT 21,(result,VECTORSTART1left,RBRACKET1right),rest671)
 end
| (71,(_,(_,_,ENDright as END1right))::(_,(MlyValue.exp_ps exp_ps,_,_)
)::_::(_,(MlyValue.ldecs ldecs,ldecsleft,ldecsright))::(_,(_,LETleft
 as LET1left,_))::rest671) => let val result=MlyValue.aexp((
fn env => 
				    let val (d,f) = 
					markdec(ldecs env,ldecsleft,ldecsright)
				        val e = exp_ps (f env)
				    in markexp
					 (LetExp{dec=d,expr=SeqExp e},
					  LETleft,ENDright)
				    end
))
 in (LrTable.NT 21,(result,LET1left,END1right),rest671) end
| (72,(_,(MlyValue.AQID AQID,AQID1left,AQID1right))::rest671) => let 
val result=MlyValue.aexp((fn env => VarExp([varSymbol AQID])))
 in (LrTable.NT 21,(result,AQID1left,AQID1right),rest671) end
| (73,(_,(MlyValue.quote quote,quote1left,quote1right))::rest671) => 
let val result=MlyValue.aexp((fn env => ListExp (quote env)))
 in (LrTable.NT 21,(result,quote1left,quote1right),rest671) end
| (74,(_,(MlyValue.ENDQ ENDQ,_,ENDQ1right))::(_,(_,BEGINQ1left,_))::
rest671) => let val result=MlyValue.quote((fn env => [QuoteExp ENDQ]))
 in (LrTable.NT 24,(result,BEGINQ1left,ENDQ1right),rest671) end
| (75,(_,(MlyValue.ENDQ ENDQ,_,ENDQ1right))::(_,(MlyValue.ot_list 
ot_list,_,_))::(_,(_,BEGINQ1left,_))::rest671) => let val result=
MlyValue.quote((fn env => (ot_list env @ [QuoteExp ENDQ])))
 in (LrTable.NT 24,(result,BEGINQ1left,ENDQ1right),rest671) end
| (76,(_,(MlyValue.aexp aexp,_,aexp1right))::(_,(MlyValue.OBJL OBJL,
OBJL1left,_))::rest671) => let val result=MlyValue.ot_list((
fn env => 
				  [QuoteExp OBJL,AntiquoteExp (aexp env)]))
 in (LrTable.NT 25,(result,OBJL1left,aexp1right),rest671) end
| (77,(_,(MlyValue.ot_list ot_list,_,ot_list1right))::(_,(
MlyValue.aexp aexp,_,_))::(_,(MlyValue.OBJL OBJL,OBJL1left,_))::
rest671) => let val result=MlyValue.ot_list((
fn env => (QuoteExp OBJL ::
                                            AntiquoteExp (aexp env) ::
                                            ot_list env)
))
 in (LrTable.NT 25,(result,OBJL1left,ot_list1right),rest671) end
| (78,(_,(MlyValue.exp_2c exp_2c,_,exp_2c1right))::_::(_,(MlyValue.exp
 exp,exp1left,_))::rest671) => let val result=MlyValue.exp_2c((
fn env => exp env :: exp_2c env))
 in (LrTable.NT 23,(result,exp1left,exp_2c1right),rest671) end
| (79,(_,(MlyValue.exp exp2,_,exp2right))::_::(_,(MlyValue.exp exp1,
exp1left,_))::rest671) => let val result=MlyValue.exp_2c((
fn env => [exp1 env, exp2 env]))
 in (LrTable.NT 23,(result,exp1left,exp2right),rest671) end
| (80,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_list((fn env=> [exp env]))
 in (LrTable.NT 22,(result,exp1left,exp1right),rest671) end
| (81,(_,(MlyValue.exp_list exp_list,_,exp_list1right))::_::(_,(
MlyValue.exp exp,exp1left,_))::rest671) => let val result=
MlyValue.exp_list((fn env=> exp env :: exp_list env))
 in (LrTable.NT 22,(result,exp1left,exp_list1right),rest671) end
| (82,(_,(MlyValue.pat' pat',pat'1left,pat'1right))::rest671) => let 
val result=MlyValue.pat((pat'))
 in (LrTable.NT 26,(result,pat'1left,pat'1right),rest671) end
| (83,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat apat
,apat1left,_))::rest671) => let val result=MlyValue.pat((
fn env => make_app_pat(apat env ::apats env)))
 in (LrTable.NT 26,(result,apat1left,apats1right),rest671) end
| (84,(_,(MlyValue.pat pat2,_,pat2right))::_::(_,(MlyValue.pat pat1,
pat1left,pat1right))::rest671) => let val result=MlyValue.pat'((
fn env => layered(pat1 env, pat2 env,
						   error(pat1left,pat1right))
))
 in (LrTable.NT 27,(result,pat1left,pat2right),rest671) end
| (85,(_,(MlyValue.pat'' pat'',pat''1left,pat''1right))::rest671) => 
let val result=MlyValue.pat'((pat''))
 in (LrTable.NT 27,(result,pat''1left,pat''1right),rest671) end
| (86,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.apats apats,_,_
))::(_,(MlyValue.apat apat,apat1left,_))::rest671) => let val result=
MlyValue.pat''((
fn env => 
				   ConstraintPat
				     {pattern=
					make_app_pat(apat env ::apats env),
				      constraint=ty}
))
 in (LrTable.NT 28,(result,apat1left,ty1right),rest671) end
| (87,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.pat'' pat'',
pat''1left,_))::rest671) => let val result=MlyValue.pat''((
fn env => ConstraintPat{pattern=pat'' env,
							 constraint=ty}))
 in (LrTable.NT 28,(result,pat''1left,ty1right),rest671) end
| (88,(_,(MlyValue.apat' apat',apat'1left,apat'1right))::rest671) => 
let val result=MlyValue.apat((apat'))
 in (LrTable.NT 29,(result,apat'1left,apat'1right),rest671) end
| (89,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.pat pat,_,_)
)::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.apat((
fn env =>(pat env,NONfix,
					   error(LPARENleft,RPARENright))))
 in (LrTable.NT 29,(result,LPAREN1left,RPAREN1right),rest671) end
| (90,(_,(MlyValue.apat'' apat'',apat''left as apat''1left,apat''right
 as apat''1right))::rest671) => let val result=MlyValue.apat'((
fn env =>(apat'' env,NONfix,
					   error(apat''left,apat''right))))
 in (LrTable.NT 30,(result,apat''1left,apat''1right),rest671) end
| (91,(_,(MlyValue.id id,idleft as id1left,idright as id1right))::
rest671) => let val result=MlyValue.apat'((
fn env  =>
				 let val e = error(idleft,idright)
				     val (v,f) = var'n'fix id
				 in (VarPat [v], lookFIX(env,f), e) end
))
 in (LrTable.NT 30,(result,id1left,id1right),rest671) end
| (92,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.apat'((
fn _ =>(unitPat,NONfix,
					 error(LPARENleft,RPARENright))))
 in (LrTable.NT 30,(result,LPAREN1left,RPAREN1right),rest671) end
| (93,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.pat_list 
pat_list,_,_))::_::(_,(MlyValue.pat pat,_,_))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.apat'((
fn env =>(TuplePat(pat env :: pat_list env),
			   NONfix,error(LPARENleft,RPARENright))
))
 in (LrTable.NT 30,(result,LPAREN1left,RPAREN1right),rest671) end
| (94,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.apat''((
fn env => VarPat [varSymbol ident]))
 in (LrTable.NT 31,(result,OP1left,ident1right),rest671) end
| (95,(_,(MlyValue.qid qid,_,qid1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.apat''((
fn env => VarPat (strSymbol ID :: qid varSymbol)))
 in (LrTable.NT 31,(result,ID1left,qid1right),rest671) end
| (96,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.apat''((fn _ =>IntPat int))
 in (LrTable.NT 31,(result,int1left,int1right),rest671) end
| (97,(_,(MlyValue.REAL REAL,REAL1left,REAL1right))::rest671) => let 
val result=MlyValue.apat''((fn _ =>RealPat REAL))
 in (LrTable.NT 31,(result,REAL1left,REAL1right),rest671) end
| (98,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.apat''((fn _ =>StringPat STRING))
 in (LrTable.NT 31,(result,STRING1left,STRING1right),rest671) end
| (99,(_,(_,WILD1left,WILD1right))::rest671) => let val result=
MlyValue.apat''((fn _ =>WildPat))
 in (LrTable.NT 31,(result,WILD1left,WILD1right),rest671) end
| (100,(_,(_,_,RBRACKET1right))::(_,(_,LBRACKET1left,_))::rest671) => 
let val result=MlyValue.apat''((fn _ =>ListPat nil))
 in (LrTable.NT 31,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (101,(_,(_,_,RBRACKET1right))::(_,(MlyValue.pat_list pat_list,_,_))
::(_,(_,LBRACKET1left,_))::rest671) => let val result=MlyValue.apat''(
(fn env => ListPat(pat_list env)))
 in (LrTable.NT 31,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (102,(_,(_,_,RBRACKET1right))::(_,(_,VECTORSTART1left,_))::rest671)
 => let val result=MlyValue.apat''((fn _ => VectorPat nil))
 in (LrTable.NT 31,(result,VECTORSTART1left,RBRACKET1right),rest671)
 end
| (103,(_,(_,_,RBRACKET1right))::(_,(MlyValue.pat_list pat_list,_,_))
::(_,(_,VECTORSTART1left,_))::rest671) => let val result=
MlyValue.apat''((fn env => VectorPat(pat_list env)))
 in (LrTable.NT 31,(result,VECTORSTART1left,RBRACKET1right),rest671)
 end
| (104,(_,(_,_,RBRACE1right))::(_,(_,LBRACE1left,_))::rest671) => let 
val result=MlyValue.apat''((fn _ => unitPat))
 in (LrTable.NT 31,(result,LBRACE1left,RBRACE1right),rest671) end
| (105,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.plabels 
plabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.apat''((
fn env => let val (d,f) = plabels env 
                       in MarkPat(RecordPat{def=d,flexibility=f},
				  LBRACEleft,RBRACEright) end
))
 in (LrTable.NT 31,(result,LBRACE1left,RBRACE1right),rest671) end
| (106,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.plabel
((fn env => (selector,pat env)))
 in (LrTable.NT 32,(result,selector1left,pat1right),rest671) end
| (107,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.plabel((
fn env => 
				   (labSymbol ID, VarPat [varSymbol ID])))
 in (LrTable.NT 32,(result,ID1left,ID1right),rest671) end
| (108,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.plabel((
fn env => 
				   (labSymbol ID, 
				    LayeredPat{varPat=VarPat [varSymbol ID], 
				    	       expPat=pat env})
))
 in (LrTable.NT 32,(result,ID1left,pat1right),rest671) end
| (109,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ID ID,ID1left,
_))::rest671) => let val result=MlyValue.plabel((
fn env => (labSymbol ID,
			    ConstraintPat{pattern=VarPat [varSymbol ID],
					  constraint=ty})
))
 in (LrTable.NT 32,(result,ID1left,ty1right),rest671) end
| (110,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.ty ty,_,_))
::_::(_,(MlyValue.ID ID,ID1left,_))::rest671) => let val result=
MlyValue.plabel((
fn env => 
		   (labSymbol ID,
		    LayeredPat
		      {varPat=ConstraintPat{pattern=VarPat [varSymbol ID],
					    constraint=ty},
		       expPat=pat env})
))
 in (LrTable.NT 32,(result,ID1left,pat1right),rest671) end
| (111,(_,(MlyValue.plabels plabels,_,plabels1right))::_::(_,(
MlyValue.plabel plabel,plabel1left,_))::rest671) => let val result=
MlyValue.plabels((
fn env =>let val (a,(b,fx))=(plabel env,plabels env)
			  in (a::b, fx) end
))
 in (LrTable.NT 33,(result,plabel1left,plabels1right),rest671) end
| (112,(_,(MlyValue.plabel plabel,plabel1left,plabel1right))::rest671)
 => let val result=MlyValue.plabels((fn env => ([plabel env],false)))
 in (LrTable.NT 33,(result,plabel1left,plabel1right),rest671) end
| (113,(_,(_,DOTDOTDOT1left,DOTDOTDOT1right))::rest671) => let val 
result=MlyValue.plabels((fn _ => (nil, true)))
 in (LrTable.NT 33,(result,DOTDOTDOT1left,DOTDOTDOT1right),rest671)
 end
| (114,(_,(MlyValue.pat pat,pat1left,pat1right))::rest671) => let val 
result=MlyValue.pat_list((fn env => [pat env]))
 in (LrTable.NT 35,(result,pat1left,pat1right),rest671) end
| (115,(_,(MlyValue.pat_list pat_list,_,pat_list1right))::_::(_,(
MlyValue.pat pat,pat1left,_))::rest671) => let val result=
MlyValue.pat_list((fn env => pat env :: pat_list env))
 in (LrTable.NT 35,(result,pat1left,pat_list1right),rest671) end
| (116,(_,(MlyValue.vb vb2,_,vb2right))::_::(_,(MlyValue.vb vb1,
vb1left,_))::rest671) => let val result=MlyValue.vb((
fn env => vb1 env @ vb2 env))
 in (LrTable.NT 36,(result,vb1left,vb2right),rest671) end
| (117,(_,(MlyValue.exp exp,_,expright as exp1right))::_::(_,(
MlyValue.pat pat,patleft as pat1left,_))::rest671) => let val result=
MlyValue.vb((
fn env => 
		   [MarkVb(Vb{exp=exp env, pat=pat env},patleft,expright)]
))
 in (LrTable.NT 36,(result,pat1left,exp1right),rest671) end
| (118,rest671) => let val result=MlyValue.constraint((NONE))
 in (LrTable.NT 37,(result,defaultPos,defaultPos),rest671) end
| (119,(_,(MlyValue.ty ty,_,ty1right))::(_,(_,COLON1left,_))::rest671)
 => let val result=MlyValue.constraint((SOME ty))
 in (LrTable.NT 37,(result,COLON1left,ty1right),rest671) end
| (120,(_,(MlyValue.match match,_,matchright as match1right))::_::_::(
_,(MlyValue.constraint constraint,_,_))::(_,(MlyValue.opid opid,
opidleft as opid1left,_))::rest671) => let val result=MlyValue.rvb((
fn env =>[MarkRvb(Rvb{var=opid env,resultty=constraint,
			       exp=FnExp(match env)},opidleft,matchright)]
))
 in (LrTable.NT 38,(result,opid1left,match1right),rest671) end
| (121,(_,(MlyValue.rvb rvb2,_,rvb2right))::_::(_,(MlyValue.rvb rvb1,
rvb1left,_))::rest671) => let val result=MlyValue.rvb((
fn env => rvb1 env @ rvb2 env))
 in (LrTable.NT 38,(result,rvb1left,rvb2right),rest671) end
| (122,(_,(MlyValue.clause clause,clause1left,clause1right))::rest671)
 => let val result=MlyValue.fb'((fn env =>[clause env]))
 in (LrTable.NT 39,(result,clause1left,clause1right),rest671) end
| (123,(_,(MlyValue.fb' fb',_,fb'1right))::_::(_,(MlyValue.clause 
clause,clause1left,_))::rest671) => let val result=MlyValue.fb'((
fn env =>clause env :: fb' env))
 in (LrTable.NT 39,(result,clause1left,fb'1right),rest671) end
| (124,(_,(MlyValue.fb' fb',fb'left as fb'1left,fb'right as fb'1right)
)::rest671) => let val result=MlyValue.fb((
fn env => [(checkFB(fb' env,error(fb'left,fb'right)),
		     fb'left,fb'right)]
))
 in (LrTable.NT 40,(result,fb'1left,fb'1right),rest671) end
| (125,(_,(MlyValue.fb fb,_,fb1right))::_::(_,(MlyValue.fb' fb',
fb'left as fb'1left,fb'right))::rest671) => let val result=MlyValue.fb
((
fn env => (checkFB(fb' env,error(fb'left,fb'right)),fb'left,fb'right)
		   :: fb env
))
 in (LrTable.NT 40,(result,fb'1left,fb1right),rest671) end
| (126,(_,(MlyValue.apats apats2,_,apats2right))::_::(_,(
MlyValue.apats apats1,_,_))::(_,(MlyValue.apat apat,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.clause'((
fn env =>makecl(apat env :: apats1 env,apats2 env)))
 in (LrTable.NT 42,(result,LPAREN1left,apats2right),rest671) end
| (127,(_,(MlyValue.apats apats,_,apats1right))::(_,(_,_,RPARENright))
::(_,(MlyValue.pat' pat',_,_))::(_,(_,LPARENleft as LPAREN1left,_))::
rest671) => let val result=MlyValue.clause'((
fn env => makecl([],(pat' env, NONfix,
				    error(LPARENleft,RPARENright))
				   :: apats env)
))
 in (LrTable.NT 42,(result,LPAREN1left,apats1right),rest671) end
| (128,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat' 
apat',apat'1left,_))::rest671) => let val result=MlyValue.clause'((
fn env => makecl([],apat' env :: apats env)))
 in (LrTable.NT 42,(result,apat'1left,apats1right),rest671) end
| (129,rest671) => let val result=MlyValue.apats((fn _ =>nil))
 in (LrTable.NT 41,(result,defaultPos,defaultPos),rest671) end
| (130,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat 
apat,apat1left,_))::rest671) => let val result=MlyValue.apats((
fn env => apat env :: apats env))
 in (LrTable.NT 41,(result,apat1left,apats1right),rest671) end
| (131,(_,(MlyValue.exp exp,expleft,expright as exp1right))::_::(_,(
MlyValue.constraint constraint,_,_))::(_,(MlyValue.clause' clause',
clause'left as clause'1left,clause'right))::rest671) => let val result
=MlyValue.clause((
fn env => let val (id,pats) = clause' env
			   in {name=id,pats=pats,resultty=constraint,
			       exp=fn env => markexp(exp env,expleft,expright),
			       err=error(clause'left,clause'right)}
			   end
))
 in (LrTable.NT 43,(result,clause'1left,exp1right),rest671) end
| (132,(_,(MlyValue.ty ty,tyleft,tyright as ty1right))::_::(_,(
MlyValue.ID ID,_,_))::(_,(MlyValue.tyvars tyvars,tyvars1left,_))::
rest671) => let val result=MlyValue.tb((
[MarkTb(
				   Tb{tyvars=tyvars,tyc=tycSymbol ID,def=ty},
				   tyleft,tyright)]
))
 in (LrTable.NT 44,(result,tyvars1left,ty1right),rest671) end
| (133,(_,(MlyValue.tb tb2,_,tb2right))::_::(_,(MlyValue.tb tb1,
tb1left,_))::rest671) => let val result=MlyValue.tb((tb1 @ tb2))
 in (LrTable.NT 44,(result,tb1left,tb2right),rest671) end
| (134,(_,(MlyValue.TYVAR TYVAR,TYVARleft as TYVAR1left,TYVARright as 
TYVAR1right))::rest671) => let val result=MlyValue.tyvars((
[MarkTyv(Tyv(tyvSymbol TYVAR),
					 TYVARleft,TYVARright)]))
 in (LrTable.NT 45,(result,TYVAR1left,TYVAR1right),rest671) end
| (135,(_,(_,_,RPAREN1right))::(_,(MlyValue.tyvar_pc tyvar_pc,_,_))::(
_,(_,LPAREN1left,_))::rest671) => let val result=MlyValue.tyvars((
tyvar_pc))
 in (LrTable.NT 45,(result,LPAREN1left,RPAREN1right),rest671) end
| (136,rest671) => let val result=MlyValue.tyvars((nil))
 in (LrTable.NT 45,(result,defaultPos,defaultPos),rest671) end
| (137,(_,(MlyValue.TYVAR TYVAR,TYVARleft as TYVAR1left,TYVARright as 
TYVAR1right))::rest671) => let val result=MlyValue.tyvar_pc((
[MarkTyv(Tyv(tyvSymbol TYVAR), TYVARleft,TYVARright)]))
 in (LrTable.NT 46,(result,TYVAR1left,TYVAR1right),rest671) end
| (138,(_,(MlyValue.tyvar_pc tyvar_pc,_,tyvar_pc1right))::_::(_,(
MlyValue.TYVAR TYVAR,TYVARleft as TYVAR1left,TYVARright))::rest671)
 => let val result=MlyValue.tyvar_pc((
MarkTyv(Tyv(tyvSymbol TYVAR),TYVARleft,TYVARright)
		 :: tyvar_pc))
 in (LrTable.NT 46,(result,TYVAR1left,tyvar_pc1right),rest671) end
| (139,(_,(MlyValue.db db2,_,db2right))::_::(_,(MlyValue.db db1,
db1left,_))::rest671) => let val result=MlyValue.db((db1 @ db2))
 in (LrTable.NT 47,(result,db1left,db2right),rest671) end
| (140,(_,(MlyValue.constrs constrs,_,constrs1right))::_::(_,(
MlyValue.ident ident,_,_))::(_,(MlyValue.tyvars tyvars,tyvars1left,_))
::rest671) => let val result=MlyValue.db((
let val name = tycSymbol ident
					 in [Db{tyc=name,tyvars=tyvars,
					        def=constrs}] end
))
 in (LrTable.NT 47,(result,tyvars1left,constrs1right),rest671) end
| (141,(_,(MlyValue.constr constr,constr1left,constr1right))::rest671)
 => let val result=MlyValue.constrs(([constr]))
 in (LrTable.NT 48,(result,constr1left,constr1right),rest671) end
| (142,(_,(MlyValue.constrs constrs,_,constrs1right))::_::(_,(
MlyValue.constr constr,constr1left,_))::rest671) => let val result=
MlyValue.constrs((constr :: constrs))
 in (LrTable.NT 48,(result,constr1left,constrs1right),rest671) end
| (143,(_,(MlyValue.ident ident,_,ident1right))::(_,(MlyValue.op_op 
op_op,op_op1left,_))::rest671) => let val result=MlyValue.constr((
op_op ();(varSymbol ident,NONE)))
 in (LrTable.NT 49,(result,op_op1left,ident1right),rest671) end
| (144,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,_,
_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.constr((op_op ();(varSymbol ident, SOME ty)))
 in (LrTable.NT 49,(result,op_op1left,ty1right),rest671) end
| (145,(_,(MlyValue.ident ident,_,ident1right))::(_,(MlyValue.op_op 
op_op,op_op1left,_))::rest671) => let val result=MlyValue.eb((
op_op ();[EbGen{exn=(varSymbol ident),etype=NONE}]))
 in (LrTable.NT 50,(result,op_op1left,ident1right),rest671) end
| (146,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,_,
_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.eb((
op_op ();[EbGen{exn=(varSymbol ident),etype=SOME ty}]))
 in (LrTable.NT 50,(result,op_op1left,ty1right),rest671) end
| (147,(_,(MlyValue.qid qid,_,qid1right))::_::(_,(MlyValue.ident ident
,_,_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.eb((
op_op ();[EbDef{exn=varSymbol ident,edef=qid varSymbol}]))
 in (LrTable.NT 50,(result,op_op1left,qid1right),rest671) end
| (148,(_,(MlyValue.eb eb2,_,eb2right))::_::(_,(MlyValue.eb eb1,
eb1left,_))::rest671) => let val result=MlyValue.eb((eb1 @ eb2))
 in (LrTable.NT 50,(result,eb1left,eb2right),rest671) end
| (149,(_,(MlyValue.qid qid,qid1left,qid1right))::rest671) => let val 
result=MlyValue.qid_p(([qid strSymbol]))
 in (LrTable.NT 51,(result,qid1left,qid1right),rest671) end
| (150,(_,(MlyValue.qid_p qid_p,_,qid_p1right))::(_,(MlyValue.qid qid,
qid1left,_))::rest671) => let val result=MlyValue.qid_p((
qid strSymbol :: qid_p))
 in (LrTable.NT 51,(result,qid1left,qid_p1right),rest671) end
| (151,(_,(_,INFIX1left,INFIX1right))::rest671) => let val result=
MlyValue.fixity((fn _ => infixleft 0))
 in (LrTable.NT 52,(result,INFIX1left,INFIX1right),rest671) end
| (152,(_,(MlyValue.int int,intleft,intright as int1right))::(_,(_,
INFIX1left,_))::rest671) => let val result=MlyValue.fixity((
fn _ => infixleft (checkFix(int,error(intleft,intright)))))
 in (LrTable.NT 52,(result,INFIX1left,int1right),rest671) end
| (153,(_,(_,INFIXR1left,INFIXR1right))::rest671) => let val result=
MlyValue.fixity((fn _ => infixright 0))
 in (LrTable.NT 52,(result,INFIXR1left,INFIXR1right),rest671) end
| (154,(_,(MlyValue.int int,intleft,intright as int1right))::(_,(_,
INFIXR1left,_))::rest671) => let val result=MlyValue.fixity((
fn _ => infixright (checkFix(int,error(intleft,intright)))))
 in (LrTable.NT 52,(result,INFIXR1left,int1right),rest671) end
| (155,(_,(_,NONFIX1left,NONFIX1right))::rest671) => let val result=
MlyValue.fixity((fn _ => NONfix))
 in (LrTable.NT 52,(result,NONFIX1left,NONFIX1right),rest671) end
| (156,(_,(MlyValue.vb vb,_,vb1right))::(_,(_,VAL1left,_))::rest671)
 => let val result=MlyValue.ldec((fn env => (ValDec (vb env),identity)
))
 in (LrTable.NT 53,(result,VAL1left,vb1right),rest671) end
| (157,(_,(MlyValue.rvb rvb,_,rvb1right))::_::(_,(_,VAL1left,_))::
rest671) => let val result=MlyValue.ldec((
fn env => (ValrecDec(rvb env),identity)))
 in (LrTable.NT 53,(result,VAL1left,rvb1right),rest671) end
| (158,(_,(MlyValue.fb fb,_,fbright as fb1right))::(_,(_,FUNleft as 
FUN1left,_))::rest671) => let val result=MlyValue.ldec((
makeFUNdec(fb,error(FUNleft,fbright))))
 in (LrTable.NT 53,(result,FUN1left,fb1right),rest671) end
| (159,(_,(MlyValue.tb tb,_,tb1right))::(_,(_,TYPE1left,_))::rest671)
 => let val result=MlyValue.ldec((fn env => (TypeDec tb,identity)))
 in (LrTable.NT 53,(result,TYPE1left,tb1right),rest671) end
| (160,(_,(MlyValue.db db,_,db1right))::(_,(_,DATATYPE1left,_))::
rest671) => let val result=MlyValue.ldec((
fn env => (DatatypeDec{datatycs=db,withtycs=[]},identity)))
 in (LrTable.NT 53,(result,DATATYPE1left,db1right),rest671) end
| (161,(_,(MlyValue.tb tb,_,tb1right))::_::(_,(MlyValue.db db,_,_))::(
_,(_,DATATYPE1left,_))::rest671) => let val result=MlyValue.ldec((
fn env => (DatatypeDec{datatycs=db,withtycs=tb},identity)))
 in (LrTable.NT 53,(result,DATATYPE1left,tb1right),rest671) end
| (162,(_,(_,_,END1right))::(_,(MlyValue.ldecs ldecs,_,_))::_::(_,(
MlyValue.db db,_,_))::(_,(_,ABSTYPE1left,_))::rest671) => let val 
result=MlyValue.ldec((
fn env => let val (d,f) = ldecs env
                           in (AbstypeDec{abstycs=db,withtycs=[],
				          body=d},f)
			   end
))
 in (LrTable.NT 53,(result,ABSTYPE1left,END1right),rest671) end
| (163,(_,(_,_,END1right))::(_,(MlyValue.ldecs ldecs,_,_))::_::(_,(
MlyValue.tb tb,_,_))::_::(_,(MlyValue.db db,_,_))::(_,(_,ABSTYPE1left,
_))::rest671) => let val result=MlyValue.ldec((
fn env => let val (d,f) = ldecs env
                           in (AbstypeDec{abstycs=db,withtycs=tb,
				          body=d},f)
			   end
))
 in (LrTable.NT 53,(result,ABSTYPE1left,END1right),rest671) end
| (164,(_,(MlyValue.eb eb,_,eb1right))::(_,(_,EXCEPTION1left,_))::
rest671) => let val result=MlyValue.ldec((
fn env => (ExceptionDec eb, identity)))
 in (LrTable.NT 53,(result,EXCEPTION1left,eb1right),rest671) end
| (165,(_,(MlyValue.qid_p qid_p,_,qid_p1right))::(_,(_,OPEN1left,_))::
rest671) => let val result=MlyValue.ldec((
fn env => (OpenDec qid_p, identity)))
 in (LrTable.NT 53,(result,OPEN1left,qid_p1right),rest671) end
| (166,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.fixity fixity,
fixity1left,_))::rest671) => let val result=MlyValue.ldec((
makeFIXdec(fixity (), ops)))
 in (LrTable.NT 53,(result,fixity1left,ops1right),rest671) end
| (167,(_,(MlyValue.exp_pa exp_pa,_,exp_pa1right))::_::(_,(MlyValue.ty
 ty,_,_))::_::(_,(MlyValue.ident ident,_,_))::(_,(_,OVERLOAD1left,_))
::rest671) => let val result=MlyValue.ldec((
fn env => (OvldDec(varSymbol ident,ty,exp_pa env),identity)))
 in (LrTable.NT 53,(result,OVERLOAD1left,exp_pa1right),rest671) end
| (168,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_pa((fn env => [exp env]))
 in (LrTable.NT 54,(result,exp1left,exp1right),rest671) end
| (169,(_,(MlyValue.exp_pa exp_pa,_,exp_pa1right))::_::(_,(
MlyValue.exp exp,exp1left,_))::rest671) => let val result=
MlyValue.exp_pa((fn env => exp env :: exp_pa env))
 in (LrTable.NT 54,(result,exp1left,exp_pa1right),rest671) end
| (170,rest671) => let val result=MlyValue.ldecs((
fn env => (SeqDec nil,identity)))
 in (LrTable.NT 55,(result,defaultPos,defaultPos),rest671) end
| (171,(_,(MlyValue.ldecs ldecs,_,ldecs1right))::(_,(MlyValue.ldec 
ldec,ldecleft as ldec1left,ldecright))::rest671) => let val result=
MlyValue.ldecs((
makeSEQdec 
		   (fn env => markdec(ldec env,ldecleft,ldecright), ldecs)
))
 in (LrTable.NT 55,(result,ldec1left,ldecs1right),rest671) end
| (172,(_,(MlyValue.ldecs ldecs,_,ldecs1right))::(_,(_,SEMICOLON1left,
_))::rest671) => let val result=MlyValue.ldecs((ldecs))
 in (LrTable.NT 55,(result,SEMICOLON1left,ldecs1right),rest671) end
| (173,(_,(MlyValue.ldecs ldecs3,_,ldecs3right))::(_,(_,_,ENDright))::
(_,(MlyValue.ldecs ldecs2,ldecs2left,ldecs2right))::_::(_,(
MlyValue.ldecs ldecs1,ldecs1left,ldecs1right))::(_,(_,LOCALleft as 
LOCAL1left,_))::rest671) => let val result=MlyValue.ldecs((
makeSEQdec
 		   (fn env => 
 			markdec(makeLOCALdec
 			         (fn env => markdec(ldecs1 env,
 						    ldecs1left,ldecs1right),
 				  fn env => markdec(ldecs2 env,
 					            ldecs2left,ldecs2right))
 				       env,
    		     	              LOCALleft,ENDright),
 	            ldecs3)
))
 in (LrTable.NT 55,(result,LOCAL1left,ldecs3right),rest671) end
| (174,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.ops(([fixSymbol ident]))
 in (LrTable.NT 56,(result,ident1left,ident1right),rest671) end
| (175,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.ident ident,
ident1left,_))::rest671) => let val result=MlyValue.ops((
fixSymbol ident :: ops))
 in (LrTable.NT 56,(result,ident1left,ops1right),rest671) end
| (176,rest671) => let val result=MlyValue.spec_s(([]))
 in (LrTable.NT 57,(result,defaultPos,defaultPos),rest671) end
| (177,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(MlyValue.spec 
spec,spec1left,_))::rest671) => let val result=MlyValue.spec_s((
spec @ spec_s))
 in (LrTable.NT 57,(result,spec1left,spec_s1right),rest671) end
| (178,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(_,
SEMICOLON1left,_))::rest671) => let val result=MlyValue.spec_s((spec_s
))
 in (LrTable.NT 57,(result,SEMICOLON1left,spec_s1right),rest671) end
| (179,(_,(MlyValue.strspec strspec,_,strspec1right))::(_,(_,
STRUCTURE1left,_))::rest671) => let val result=MlyValue.spec((
[StrSpec strspec]))
 in (LrTable.NT 58,(result,STRUCTURE1left,strspec1right),rest671) end
| (180,(_,(MlyValue.fctspec fctspec,_,fctspec1right))::(_,(_,
FUNCTOR1left,_))::rest671) => let val result=MlyValue.spec((
[FctSpec fctspec]))
 in (LrTable.NT 58,(result,FUNCTOR1left,fctspec1right),rest671) end
| (181,(_,(MlyValue.db db,_,db1right))::(_,(_,DATATYPE1left,_))::
rest671) => let val result=MlyValue.spec(([DataSpec db]))
 in (LrTable.NT 58,(result,DATATYPE1left,db1right),rest671) end
| (182,(_,(MlyValue.tyspec tyspec,_,tyspec1right))::(_,(_,TYPE1left,_)
)::rest671) => let val result=MlyValue.spec(([TycSpec(tyspec,false)]))
 in (LrTable.NT 58,(result,TYPE1left,tyspec1right),rest671) end
| (183,(_,(MlyValue.tyspec tyspec,_,tyspec1right))::(_,(_,EQTYPE1left,
_))::rest671) => let val result=MlyValue.spec(([TycSpec(tyspec,true)])
)
 in (LrTable.NT 58,(result,EQTYPE1left,tyspec1right),rest671) end
| (184,(_,(MlyValue.valspec valspec,_,valspec1right))::(_,(_,VAL1left,
_))::rest671) => let val result=MlyValue.spec(([ValSpec valspec]))
 in (LrTable.NT 58,(result,VAL1left,valspec1right),rest671) end
| (185,(_,(MlyValue.exnspec exnspec,_,exnspec1right))::(_,(_,
EXCEPTION1left,_))::rest671) => let val result=MlyValue.spec((
[ExceSpec exnspec]))
 in (LrTable.NT 58,(result,EXCEPTION1left,exnspec1right),rest671) end
| (186,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.fixity fixity,
fixity1left,_))::rest671) => let val result=MlyValue.spec((
[FixSpec {fixity=fixity (),ops=ops}]))
 in (LrTable.NT 58,(result,fixity1left,ops1right),rest671) end
| (187,(_,(MlyValue.sharespec sharespec,_,sharespec1right))::(_,(_,
SHARING1left,_))::rest671) => let val result=MlyValue.spec((sharespec)
)
 in (LrTable.NT 58,(result,SHARING1left,sharespec1right),rest671) end
| (188,(_,(MlyValue.qid_p qid_p,_,qid_p1right))::(_,(_,OPEN1left,_))::
rest671) => let val result=MlyValue.spec(([OpenSpec qid_p]))
 in (LrTable.NT 58,(result,OPEN1left,qid_p1right),rest671) end
| (189,(_,(_,_,END1right))::(_,(MlyValue.spec_s spec_s2,_,_))::_::(_,(
MlyValue.spec_s spec_s1,_,_))::(_,(_,LOCAL1left,_))::rest671) => let 
val result=MlyValue.spec(([LocalSpec (spec_s1, spec_s2)]))
 in (LrTable.NT 58,(result,LOCAL1left,END1right),rest671) end
| (190,(_,(MlyValue.idents idents,_,idents1right))::(_,(_,INCLUDE1left
,_))::rest671) => let val result=MlyValue.spec((idents))
 in (LrTable.NT 58,(result,INCLUDE1left,idents1right),rest671) end
| (191,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.idents((
[IncludeSpec(FastSymbol.sigSymbol ident)]))
 in (LrTable.NT 59,(result,ident1left,ident1right),rest671) end
| (192,(_,(MlyValue.idents idents,_,idents1right))::(_,(MlyValue.ident
 ident,ident1left,_))::rest671) => let val result=MlyValue.idents((
IncludeSpec(FastSymbol.sigSymbol ident)
				 :: idents))
 in (LrTable.NT 59,(result,ident1left,idents1right),rest671) end
| (193,(_,(MlyValue.strspec strspec2,_,strspec2right))::_::(_,(
MlyValue.strspec strspec1,strspec1left,_))::rest671) => let val result
=MlyValue.strspec((strspec1 @ strspec2))
 in (LrTable.NT 60,(result,strspec1left,strspec2right),rest671) end
| (194,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ident 
ident,ident1left,_))::rest671) => let val result=MlyValue.strspec((
[(strSymbol ident,sign)]))
 in (LrTable.NT 60,(result,ident1left,sign1right),rest671) end
| (195,(_,(MlyValue.fctspec fctspec2,_,fctspec2right))::_::(_,(
MlyValue.fctspec fctspec1,fctspec1left,_))::rest671) => let val result
=MlyValue.fctspec((fctspec1 @ fctspec2))
 in (LrTable.NT 61,(result,fctspec1left,fctspec2right),rest671) end
| (196,(_,(MlyValue.fsig fsig,_,fsig1right))::(_,(MlyValue.ident ident
,ident1left,_))::rest671) => let val result=MlyValue.fctspec((
[(fctSymbol ident,fsig)]))
 in (LrTable.NT 61,(result,ident1left,fsig1right),rest671) end
| (197,(_,(MlyValue.tyspec tyspec2,_,tyspec2right))::_::(_,(
MlyValue.tyspec tyspec1,tyspec1left,_))::rest671) => let val result=
MlyValue.tyspec((tyspec1 @ tyspec2))
 in (LrTable.NT 62,(result,tyspec1left,tyspec2right),rest671) end
| (198,(_,(MlyValue.ID ID,_,ID1right))::(_,(MlyValue.tyvars tyvars,
tyvars1left,_))::rest671) => let val result=MlyValue.tyspec((
[(tycSymbol ID,tyvars)]))
 in (LrTable.NT 62,(result,tyvars1left,ID1right),rest671) end
| (199,(_,(MlyValue.valspec valspec2,_,valspec2right))::_::(_,(
MlyValue.valspec valspec1,valspec1left,_))::rest671) => let val result
=MlyValue.valspec((valspec1 @ valspec2))
 in (LrTable.NT 63,(result,valspec1left,valspec2right),rest671) end
| (200,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,_,
_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.valspec((op_op ();[(varSymbol ident,ty)]))
 in (LrTable.NT 63,(result,op_op1left,ty1right),rest671) end
| (201,(_,(MlyValue.exnspec exnspec2,_,exnspec2right))::_::(_,(
MlyValue.exnspec exnspec1,exnspec1left,_))::rest671) => let val result
=MlyValue.exnspec((exnspec1 @ exnspec2))
 in (LrTable.NT 64,(result,exnspec1left,exnspec2right),rest671) end
| (202,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.exnspec(([(varSymbol ident,NONE)]))
 in (LrTable.NT 64,(result,ident1left,ident1right),rest671) end
| (203,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,
ident1left,_))::rest671) => let val result=MlyValue.exnspec((
[(varSymbol ident,SOME ty)]))
 in (LrTable.NT 64,(result,ident1left,ty1right),rest671) end
| (204,(_,(MlyValue.sharespec sharespec2,_,sharespec2right))::_::(_,(
MlyValue.sharespec sharespec1,sharespec1left,_))::rest671) => let val 
result=MlyValue.sharespec((sharespec1 @ sharespec2))
 in (LrTable.NT 65,(result,sharespec1left,sharespec2right),rest671)
 end
| (205,(_,(MlyValue.patheqn patheqn,patheqnleft,patheqnright as 
patheqn1right))::(_,(_,TYPE1left,_))::rest671) => let val result=
MlyValue.sharespec((
[MarkSpec(ShatycSpec(patheqn tycSymbol),
				   patheqnleft,patheqnright)]
))
 in (LrTable.NT 65,(result,TYPE1left,patheqn1right),rest671) end
| (206,(_,(MlyValue.patheqn patheqn,patheqnleft as patheqn1left,
patheqnright as patheqn1right))::rest671) => let val result=
MlyValue.sharespec((
[MarkSpec (ShareSpec (patheqn strSymbol),
				    patheqnleft,patheqnright)]
))
 in (LrTable.NT 65,(result,patheqn1left,patheqn1right),rest671) end
| (207,(_,(MlyValue.qid qid2,_,qid2right))::_::(_,(MlyValue.qid qid1,
qid1left,_))::rest671) => let val result=MlyValue.patheqn((
fn kind => [qid1 kind, qid2 kind]))
 in (LrTable.NT 66,(result,qid1left,qid2right),rest671) end
| (208,(_,(MlyValue.patheqn patheqn,_,patheqn1right))::_::(_,(
MlyValue.qid qid,qid1left,_))::rest671) => let val result=
MlyValue.patheqn((fn kind => qid kind :: patheqn kind))
 in (LrTable.NT 66,(result,qid1left,patheqn1right),rest671) end
| (209,(_,(MlyValue.ID ID,IDleft as ID1left,IDright as ID1right))::
rest671) => let val result=MlyValue.sign((
MarkSig(VarSig (sigSymbol ID),IDleft,IDright)))
 in (LrTable.NT 67,(result,ID1left,ID1right),rest671) end
| (210,(_,(_,_,END1right))::(_,(MlyValue.spec_s spec_s,spec_sleft,
spec_sright))::(_,(_,SIG1left,_))::rest671) => let val result=
MlyValue.sign((MarkSig(SigSig spec_s,spec_sleft,spec_sright)))
 in (LrTable.NT 67,(result,SIG1left,END1right),rest671) end
| (211,rest671) => let val result=MlyValue.sigconstraint_op((NONE))
 in (LrTable.NT 68,(result,defaultPos,defaultPos),rest671) end
| (212,(_,(MlyValue.sign sign,_,sign1right))::(_,(_,COLON1left,_))::
rest671) => let val result=MlyValue.sigconstraint_op((SOME sign))
 in (LrTable.NT 68,(result,COLON1left,sign1right),rest671) end
| (213,rest671) => let val result=MlyValue.fsigconstraint_op((NONE))
 in (LrTable.NT 69,(result,defaultPos,defaultPos),rest671) end
| (214,(_,(MlyValue.ID ID,_,ID1right))::(_,(_,COLON1left,_))::rest671)
 => let val result=MlyValue.fsigconstraint_op((
SOME(VarFsig (fsigSymbol ID))))
 in (LrTable.NT 69,(result,COLON1left,ID1right),rest671) end
| (215,(_,(MlyValue.sigb sigb2,_,sigb2right))::_::(_,(MlyValue.sigb 
sigb1,sigb1left,_))::rest671) => let val result=MlyValue.sigb((
sigb1 @ sigb2))
 in (LrTable.NT 70,(result,sigb1left,sigb2right),rest671) end
| (216,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ident 
ident,ident1left,_))::rest671) => let val result=MlyValue.sigb((
[Sigb{name=sigSymbol ident,def=sign}]))
 in (LrTable.NT 70,(result,ident1left,sign1right),rest671) end
| (217,(_,(MlyValue.fsigb fsigb2,_,fsigb2right))::_::(_,(
MlyValue.fsigb fsigb1,fsigb1left,_))::rest671) => let val result=
MlyValue.fsigb((fsigb1 @ fsigb2))
 in (LrTable.NT 71,(result,fsigb1left,fsigb2right),rest671) end
| (218,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(
MlyValue.fparamList fparamList,_,_))::(_,(MlyValue.ident ident,
ident1left,_))::rest671) => let val result=MlyValue.fsigb((
[Fsigb{name=fsigSymbol ident,
			def=FsigFsig{param=fparamList,def=sign}}]
))
 in (LrTable.NT 71,(result,ident1left,sign1right),rest671) end
| (219,(_,(MlyValue.ID ID,_,ID1right))::(_,(_,COLON1left,_))::rest671)
 => let val result=MlyValue.fsig((VarFsig (fsigSymbol ID)))
 in (LrTable.NT 72,(result,COLON1left,ID1right),rest671) end
| (220,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(
MlyValue.fparamList fparamList,fparamList1left,_))::rest671) => let 
val result=MlyValue.fsig((FsigFsig{param=fparamList,def=sign}))
 in (LrTable.NT 72,(result,fparamList1left,sign1right),rest671) end
| (221,(_,(MlyValue.qid qid,qidleft as qid1left,qidright as qid1right)
)::rest671) => let val result=MlyValue.str((
fn env => (MarkStr(VarStr(qid strSymbol),qidleft,qidright))))
 in (LrTable.NT 73,(result,qid1left,qid1right),rest671) end
| (222,(_,(_,_,ENDright as END1right))::(_,(MlyValue.sdecs sdecs,_,_))
::(_,(_,STRUCTleft as STRUCT1left,_))::rest671) => let val result=
MlyValue.str((
fn env => let val (s,_) = sdecs env 
			   in MarkStr(StructStr s,STRUCTleft,ENDright) end
))
 in (LrTable.NT 73,(result,STRUCT1left,END1right),rest671) end
| (223,(_,(MlyValue.arg_fct arg_fct,_,arg_fctright as arg_fct1right))
::(_,(MlyValue.qid qid,qidleft as qid1left,_))::rest671) => let val 
result=MlyValue.str((
fn env => MarkStr(AppStr(qid fctSymbol,arg_fct env),
				   qidleft,arg_fctright)
))
 in (LrTable.NT 73,(result,qid1left,arg_fct1right),rest671) end
| (224,(_,(_,_,ENDright as END1right))::(_,(MlyValue.str str,_,_))::_
::(_,(MlyValue.sdecs sdecs,_,_))::(_,(_,LETleft as LET1left,_))::
rest671) => let val result=MlyValue.str((
fn env => MarkStr(makeLETstr(sdecs ,str) env,
				   LETleft,ENDright)
))
 in (LrTable.NT 73,(result,LET1left,END1right),rest671) end
| (225,(_,(MlyValue.arg_fct arg_fct,_,arg_fct1right))::_::(_,(
MlyValue.sdecs sdecs,sdecsleft,sdecsright))::(_,(_,LPAREN1left,_))::
rest671) => let val result=MlyValue.arg_fct((
fn env => 
			   let val arg = MarkStr(StructStr (#1 (sdecs env)),
	 					 sdecsleft,sdecsright)
			   in (arg,false) :: arg_fct env end
))
 in (LrTable.NT 74,(result,LPAREN1left,arg_fct1right),rest671) end
| (226,(_,(MlyValue.arg_fct arg_fct,_,arg_fct1right))::_::(_,(
MlyValue.str str,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.arg_fct((fn env => (str env,true) :: arg_fct env))
 in (LrTable.NT 74,(result,LPAREN1left,arg_fct1right),rest671) end
| (227,(_,(_,_,RPAREN1right))::(_,(MlyValue.str str,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.arg_fct((
fn env => [(str env,true)]))
 in (LrTable.NT 74,(result,LPAREN1left,RPAREN1right),rest671) end
| (228,(_,(_,_,RPAREN1right))::(_,(MlyValue.sdecs sdecs,sdecsleft,
sdecsright))::(_,(_,LPAREN1left,_))::rest671) => let val result=
MlyValue.arg_fct((
fn env => [(MarkStr(StructStr (#1 (sdecs env)),
					    sdecsleft,sdecsright),
				    false)]
))
 in (LrTable.NT 74,(result,LPAREN1left,RPAREN1right),rest671) end
| (229,(_,(MlyValue.sdecs sdecs,_,sdecs1right))::(_,(MlyValue.sdec 
sdec,sdecleft as sdec1left,sdecright))::rest671) => let val result=
MlyValue.sdecs((
makeSEQdec (fn env => markdec(sdec env,sdecleft,sdecright),
			     sdecs)
))
 in (LrTable.NT 75,(result,sdec1left,sdecs1right),rest671) end
| (230,(_,(MlyValue.sdecs sdecs,_,sdecs1right))::(_,(_,SEMICOLON1left,
_))::rest671) => let val result=MlyValue.sdecs((sdecs))
 in (LrTable.NT 75,(result,SEMICOLON1left,sdecs1right),rest671) end
| (231,rest671) => let val result=MlyValue.sdecs((
fn env => (SeqDec[],identity)))
 in (LrTable.NT 75,(result,defaultPos,defaultPos),rest671) end
| (232,(_,(MlyValue.sdecs' sdecs',_,sdecs'1right))::(_,(MlyValue.sdec 
sdec,sdecleft as sdec1left,sdecright))::rest671) => let val result=
MlyValue.sdecs'((
makeSEQdec (fn env => markdec(sdec env,sdecleft,sdecright),
			     sdecs')
))
 in (LrTable.NT 76,(result,sdec1left,sdecs'1right),rest671) end
| (233,(_,(MlyValue.sdec sdec,sdecleft as sdec1left,sdecright as 
sdec1right))::rest671) => let val result=MlyValue.sdecs'((
fn env => markdec(sdec env,sdecleft,sdecright)))
 in (LrTable.NT 76,(result,sdec1left,sdec1right),rest671) end
| (234,(_,(MlyValue.strb strb,_,strb1right))::(_,(_,STRUCTURE1left,_))
::rest671) => let val result=MlyValue.sdec((
fn env => (StrDec (strb env),identity)))
 in (LrTable.NT 77,(result,STRUCTURE1left,strb1right),rest671) end
| (235,(_,(MlyValue.strb strb,_,strb1right))::(_,(_,ABSTRACTION1left,_
))::rest671) => let val result=MlyValue.sdec((
fn env => (AbsDec (strb env),identity)))
 in (LrTable.NT 77,(result,ABSTRACTION1left,strb1right),rest671) end
| (236,(_,(MlyValue.sigb sigb,_,sigb1right))::(_,(_,SIGNATURE1left,_))
::rest671) => let val result=MlyValue.sdec((
fn env => (SigDec sigb,identity)))
 in (LrTable.NT 77,(result,SIGNATURE1left,sigb1right),rest671) end
| (237,(_,(MlyValue.fsigb fsigb,_,fsigb1right))::(_,(_,FUNSIG1left,_))
::rest671) => let val result=MlyValue.sdec((
fn env => (FsigDec fsigb,identity)))
 in (LrTable.NT 77,(result,FUNSIG1left,fsigb1right),rest671) end
| (238,(_,(MlyValue.fctb fctb,_,fctb1right))::(_,(_,FUNCTOR1left,_))::
rest671) => let val result=MlyValue.sdec((
fn env => (FctDec (fctb env),identity)))
 in (LrTable.NT 77,(result,FUNCTOR1left,fctb1right),rest671) end
| (239,(_,(_,_,END1right))::(_,(MlyValue.sdecs sdecs2,sdecs2left,
sdecs2right))::_::(_,(MlyValue.sdecs sdecs1,sdecs1left,sdecs1right))::
(_,(_,LOCAL1left,_))::rest671) => let val result=MlyValue.sdec((
makeLOCALdec
 		  (fn env => markdec(sdecs1 env,sdecs1left,sdecs1right),
 		   fn env => markdec(sdecs2 env,sdecs2left,sdecs2right))
))
 in (LrTable.NT 77,(result,LOCAL1left,END1right),rest671) end
| (240,(_,(MlyValue.ldec ldec,ldecleft as ldec1left,ldecright as 
ldec1right))::rest671) => let val result=MlyValue.sdec((
fn env => markdec(ldec env,ldecleft,ldecright)))
 in (LrTable.NT 77,(result,ldec1left,ldec1right),rest671) end
| (241,(_,(MlyValue.str str,_,strright as str1right))::_::(_,(
MlyValue.sigconstraint_op sigconstraint_op,_,_))::(_,(MlyValue.ident 
ident,identleft as ident1left,_))::rest671) => let val result=
MlyValue.strb((
fn env =>
	   let val d = Strb{name = strSymbol ident,def = str env, 
			    constraint=sigconstraint_op}
	   in [MarkStrb(d,identleft,strright)] end
))
 in (LrTable.NT 78,(result,ident1left,str1right),rest671) end
| (242,(_,(MlyValue.strb strb2,_,strb2right))::_::(_,(MlyValue.strb 
strb1,strb1left,_))::rest671) => let val result=MlyValue.strb((
fn env => strb1 env @ strb2 env))
 in (LrTable.NT 78,(result,strb1left,strb2right),rest671) end
| (243,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.fparam((
SOME(strSymbol ID),sign))
 in (LrTable.NT 79,(result,ID1left,sign1right),rest671) end
| (244,(_,(MlyValue.spec_s spec_s,spec_sleft as spec_s1left,
spec_sright as spec_s1right))::rest671) => let val result=
MlyValue.fparam((NONE,MarkSig(SigSig spec_s, spec_sleft,spec_sright)))
 in (LrTable.NT 79,(result,spec_s1left,spec_s1right),rest671) end
| (245,(_,(_,_,RPAREN1right))::(_,(MlyValue.fparam fparam,_,_))::(_,(_
,LPAREN1left,_))::rest671) => let val result=MlyValue.fparamList((
[fparam]))
 in (LrTable.NT 80,(result,LPAREN1left,RPAREN1right),rest671) end
| (246,(_,(MlyValue.fparamList fparamList,_,fparamList1right))::_::(_,
(MlyValue.fparam fparam,_,_))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.fparamList((fparam :: fparamList))
 in (LrTable.NT 80,(result,LPAREN1left,fparamList1right),rest671) end
| (247,(_,(MlyValue.str str,_,strright as str1right))::_::(_,(
MlyValue.sigconstraint_op sigconstraint_op,_,_))::(_,(
MlyValue.fparamList fparamList,_,_))::(_,(MlyValue.ident ident,
identleft as ident1left,_))::rest671) => let val result=MlyValue.fctb(
(
fn env => [MarkFctb(Fctb {name = fctSymbol ident,
					   def = FctFct{params=fparamList,
							body=str env,
					  		constraint=
							  sigconstraint_op}},
			   identleft,strright)]
))
 in (LrTable.NT 81,(result,ident1left,str1right),rest671) end
| (248,(_,(MlyValue.fct_exp fct_exp,_,fct_expright as fct_exp1right))
::_::(_,(MlyValue.fsigconstraint_op fsigconstraint_op,_,_))::(_,(
MlyValue.ident ident,identleft as ident1left,_))::rest671) => let val 
result=MlyValue.fctb((
fn env =>
		    [MarkFctb(Fctb {name=fctSymbol ident,
				    def=fct_exp (env,fsigconstraint_op)},
			      identleft,fct_expright)]
))
 in (LrTable.NT 81,(result,ident1left,fct_exp1right),rest671) end
| (249,(_,(MlyValue.fctb fctb2,_,fctb2right))::_::(_,(MlyValue.fctb 
fctb1,fctb1left,_))::rest671) => let val result=MlyValue.fctb((
sequence (fctb1,fctb2)))
 in (LrTable.NT 81,(result,fctb1left,fctb2right),rest671) end
| (250,(_,(MlyValue.qid qid,qid1left,qid1right))::rest671) => let val 
result=MlyValue.fct_exp((
fn (env,constraint) => VarFct(qid fctSymbol,constraint)))
 in (LrTable.NT 82,(result,qid1left,qid1right),rest671) end
| (251,(_,(MlyValue.arg_fct arg_fct,_,arg_fctright as arg_fct1right))
::(_,(MlyValue.qid qid,qidleft as qid1left,_))::rest671) => let val 
result=MlyValue.fct_exp((
fn (env,constraint) =>
		    MarkFct(AppFct(qid fctSymbol,arg_fct env,constraint),
			    qidleft,arg_fctright)
))
 in (LrTable.NT 82,(result,qid1left,arg_fct1right),rest671) end
| (252,(_,(_,_,ENDright as END1right))::(_,(MlyValue.fct_exp fct_exp,_
,_))::_::(_,(MlyValue.sdecs sdecs,_,_))::(_,(_,LETleft as LET1left,_))
::rest671) => let val result=MlyValue.fct_exp((
fn (env,constraint) =>
		   MarkFct(makeLETfct(sdecs, fct_exp) env constraint,
		   LETleft,ENDright)
))
 in (LrTable.NT 82,(result,LET1left,END1right),rest671) end
| (253,(_,(MlyValue.sdecs' sdecs',sdecs'left as sdecs'1left,
sdecs'right as sdecs'1right))::rest671) => let val result=
MlyValue.interdec((
fn env=>
		   let val (ast,f) = markdec(sdecs' env,sdecs'left,sdecs'right)
		   in (ast,f Env.empty) end
))
 in (LrTable.NT 83,(result,sdecs'1left,sdecs'1right),rest671) end
| (254,(_,(MlyValue.exp exp,expleft as exp1left,expright as exp1right)
)::rest671) => let val result=MlyValue.interdec((
fn env => markdec(toplevelexp(env,exp),expleft,expright)))
 in (LrTable.NT 83,(result,exp1left,exp1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.interdec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.ID i,p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.TYVAR i,p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.INT i,p1,p2))
fun INT0 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.INT0 i,p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.REAL i,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.STRING i,p1,p2))
fun ABSTRACTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun OVERLOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun WILD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNSIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun VECTORSTART (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
fun BEGINQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(
ParserData.MlyValue.VOID,p1,p2))
fun ENDQ (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.ENDQ i,p1,p2))
fun OBJL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.OBJL i,p1,p2))
fun AQID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.AQID i,p1,p2))
end
end
