(* special values - Definition v3 page 45 *)

(*
$File: Interpreter/SPECIALVALUE.sml $
$Date: 1991/08/26 12:23:18 $
$Revision: 1.4 $
$Locker:  $
*)

(*$SPECIAL_VALUE*)

signature SPECIAL_VALUE = 
  sig 
    type scon
    eqtype SVal

   (* constructors and destructors *)

    val mkSValInt: int  -> SVal
    and unSValInt: SVal -> int

    val mkSValString: string -> SVal
    and unSValString: SVal -> string

    val mkSValReal: real -> SVal
    and unSValReal: SVal -> real

   (* evaluation from special constants to special values (the function
     `val' - Definition V3 page 45) *)

    val mkSValSCon: scon -> SVal

   (* printing *)
    val pr_SVal : SVal -> string
  end;
