.. File: aluneed.t
.. CvR
..
.. Analysis of required code for given set of routines.
.. Given a list of wanted routines and ds definitions in the variable
.. 'wantdefs', construct a list of wanted types for each class of definitions
.. in the variables 'want_<classlist>', and 'want_<classlist>_list' where
.. <classlist> is an element from the list below. Deduce the contents of the
.. variables 'need_<classlist>'. Using knowledge about the definition of
.. the various routines, deduce the required definitions and set them
.. in the variables 'need_<classlist>'.
..
.. The variables 'need_<classlist>' are restricted to types occurring
.. in ${typelist} and $(otherlists).
..
.. If the variable 'alldefs' is set, all the variables are simply set to
.. ${typelist}.
..
.. Some initial checks
.set minvers 21
.if ${< $(tmvers) $(minvers)}
. error ${tplfilename}: at least tm version $(minvers) required.
. exit 1
.endif
.if ${not ${defined basename}}
. error '${tplfilename}': definition of basename required.
. exit 1
.endif
.if ${and ${not ${defined alldefs}} ${not ${defined wantdefs}}}
. error '${tplfilename}': no definitions specified.
. error At least one of 'alldefs' and 'wantdefs' must be set.
. exit 1
.endif
.if ${not ${defined otherlists}}
.set otherlists
.endif
.if ${not ${defined notwantdefs}}
.set notwantdefs
.endif
..
.. Define the list of definition classes
.set    class      ds cmp new fre rfre rdup print fprint fscan
.set    class_list ds cmp new fre rfre rdup print fprint fscan app room
.append class_list conc append concat ins del
.set misccode stat_$(basename) flush_$(basename)
..
.. Reset all want_<classlist> variables
.foreach v $(class)
.set want_$v
.endforeach
.foreach v $(class_list)
.set want_$v_list
.endforeach
.set want_misc
..
.if ${defined alldefs}
.. All classes want all types
. foreach v $(class)
.  set want_$v ${typelist}
. endforeach
. foreach v $(class_list)
.  set want_$v_list ${typelist} $(otherlists)
. endforeach
. set want_misc $(misccode)
.else
.. Extract the contents of the 'want_<classlist>' variables from the
.. 'wantdefs'.
. set wantdefs ${uniq $(wantdefs)}
. set gotdefs
. foreach v ${rmlist ds $(class)}
.  set fl ${comm ${prefix $v_ ${typelist}} "" $(wantdefs)}
.  append gotdefs $(fl)
.  set fl ${subs $v_(*) \1 $(fl)}
.  append want_$v $(fl)
. endforeach
. set gl ${comm ${typelist} "" wantdefs}
. append want_ds $(gl)
. append gotdefs $(gl)
. set lt ${suffix "_list" ${typelist} $(otherlists)}
. foreach v ${rmlist ds $(class_list)}
.  set fl ${comm ${prefix $v_ $(lt)} "" $(wantdefs)}
.  append gotdefs $(fl)
.  set fl ${subs $v_(*)_list \1 $(fl)}
.  append want_$v_list $(fl)
. endforeach
. set fl ${comm $(lt) "" $(wantdefs)}
. append gotdefs $(fl)
. set fl ${subs (*)_list \1 $(fl)}
. append want_ds_list $(fl)
.if 0
. foreach t ${typelist} $(otherlists)
.  if ${index $t_list $(wantdefs)}
.    append want_ds_list $t
.    append gotdefs $t_list
.  endif
. endforeach
.endif
. foreach f $(misccode)
.  if ${index $f $(wantdefs)}
.   append want_misc $f
.   append gotdefs $f
.  endif
. endforeach
. set gotdefs ${uniq $(gotdefs)}
. if ${!= ${len $(wantdefs)} ${len $(gotdefs)}}
.  foreach e $(gotdefs)
.   set wantdefs ${rmlist $e $(wantdefs)}
.  endforeach
.  error Can't handle definition: $(wantdefs)
.  exit 1
. endif
.endif
..
.. Initialize all need_<classlist> variables.
.foreach v $(class)
. set need_$v $(want_$v)
.endforeach
.foreach v $(class_list)
. set need_$v_list $(want_$v_list)
.endforeach
.set need_misc $(want_misc)
..
.. ** rdup **
.set need_rdup ${deptype single $(need_rdup_list) $(need_rdup)}
.set need_rdup_list ${uniq $(need_rdup_list) ${deptype list $(need_rdup)}}
.set need_new ${uniq $(need_new) $(need_rdup)}
.set need_new_list ${uniq $(need_new_list) $(need_rdup_list)}
.set need_room_list ${uniq $(need_room_list) $(need_rdup_list)}
.set need_append_list ${uniq $(need_append_list) $(need_rdup_list)}
..
.. ** fscan **
.set need_fscan ${deptype single $(need_fscan_list) $(need_fscan)}
.set need_fscan_list ${uniq $(need_fscan_list) ${deptype list $(need_fscan)}}
.set need_new ${uniq $(need_new) $(need_fscan)}
.set need_new_list ${uniq $(need_new_list) $(need_fscan_list)}
.set need_append_list ${uniq $(need_append_list) $(need_fscan_list)}
..
.. ** print **
.set need_print ${deptype single $(need_print_list) $(need_print)}
.set need_print_list ${uniq $(need_print_list) ${deptype list $(need_print)}}
.set need_ds ${uniq $(need_ds) $(need_print)}
.set need_ds_list ${uniq $(need_ds_list) $(need_print_list)}
..
.. ** fprint **
.set need_fprint ${deptype single $(need_fprint_list) $(need_fprint)}
.set need_fprint_list ${uniq $(need_fprint_list) ${deptype list $(need_fprint)}}
.set need_ds ${uniq $(need_ds) $(need_fprint)}
.set need_ds_list ${uniq $(need_ds_list) $(need_fprint_list)}
..
.. ** cmp **
.set need_cmp ${deptype single $(need_cmp_list) $(need_cmp)}
.set need_cmp_list ${uniq $(need_cmp_list) ${deptype list $(need_cmp)}}
.set need_ds ${uniq $(need_ds) $(need_cmp)}
.set need_ds_list ${uniq $(need_ds_list) $(need_cmp_list)}
..
.. ** app **
.set need_room_list ${uniq $(need_room_list) $(need_app_list)}
.set need_ds_list ${uniq $(need_ds_list) $(need_app_list)}
..
.. ** append **
.set need_room_list ${uniq $(need_room_list) $(need_append_list)}
.set need_ds_list ${uniq $(need_ds_list) $(need_append_list)}
..
.. ** conc **
.set need_fre_list ${uniq $(need_fre_list) $(need_conc_list)}
.set need_room_list ${uniq $(need_room_list) $(need_conc_list)}
..
.. ** concat **
.set need_fre_list ${uniq $(need_fre_list) $(need_concat_list)}
.set need_room_list ${uniq $(need_room_list) $(need_concat_list)}
..
.. ** ins **
.set need_room_list ${uniq $(need_room_list) $(need_ins_list)}
..
.. ** del **
.set need_rfre_list ${uniq $(need_rfre_list) $(need_del_list)}
.set need_room_list ${uniq $(need_room_list) $(need_del_list)}
..
.. ** room **
.set need_ds_list ${uniq $(need_ds_list) $(need_room_list)}
..
.. ** rfre **
.set need_rfre ${deptype single ${uniq $(need_rfre) $(need_rfre_list)}}
.set need_rfre_list ${uniq $(need_rfre_list) ${deptype list $(need_rfre)}}
.set need_fre ${uniq $(need_fre) $(need_rfre)}
.set need_fre_list ${uniq $(need_fre_list) $(need_rfre_list)}
..
.. ** fre **
.set need_ds ${uniq $(need_ds) $(need_fre)}
.set need_ds_list ${uniq $(need_ds_list) $(need_fre_list)}
..
.. ** new **
.set need_ds ${uniq $(need_ds) $(need_new)}
.set need_ds_list ${uniq $(need_ds_list) $(need_new_list)}
..
.. ** ds **
.set need_ds ${deptype single $(need_ds) $(need_ds_list)}
.set need_ds_list ${uniq $(need_ds_list) ${deptype list $(need_ds)}}
..
.. Enforce notwantdefs
.set notwantdefs ${uniq $(notwantdefs)}
.if ${len $(notwantdefs)}
. foreach v ${rmlist ds $(class)}
.  foreach t $(need_$v)
.   if ${index $v_$t $(fl)}
.    set need_$v ${rmlist $t $(need_$v)}
.    set want_$v ${rmlist $t $(want_$v)}
.   endif
.  endforeach
. endforeach
. foreach t $(need_ds)
.  if ${index $t $(notwantdefs)}
.   set need_ds ${rmlist $t $(need_ds)}
.   set want_ds ${rmlist $t $(want_ds)}
.  endif
. endforeach
. foreach v ${rmlist ds $(class_list)}
.  foreach t $(need_$v_list)
.   if ${index $v_$t_list $(notwantdefs)}
.    set need_$v_list ${rmlist $t $(need_$v_list)}
.    set want_$v_list ${rmlist $t $(want_$v_list)}
.   endif
.  endforeach
. endforeach
. foreach t $(need_$v_list)
.  if ${index $t_list $(notwantdefs)}
.   set need_ds_list ${rmlist $t $(need_ds_list)}
.   set want_ds_list ${rmlist $t $(want_ds_list)}
.  endif
. endforeach
. foreach f $(misccode)
.  if ${index $f $(notwantdefs)}
.   set need_misc ${rmlist $f $(need_misc)}
.   set want_misc ${rmlist $f $(want_misc)}
.  endif
. endforeach
.endif
..
.. ** derived definitions **
.if ${index stat_$(basename) $(need_misc)}
.set need_stat ${uniq $(need_new) $(need_fre)}
.set need_stat_list ${uniq $(need_new_list) $(need_fre_list)}
.set want_stat ${uniq $(want_new) $(want_fre)}
.set want_stat_list ${uniq $(want_new_list) $(want_fre_list)}
.else
.set need_stat
.set need_stat_list
.set want_stat
.set want_stat_list
.endif
