
# line 2 "tmgram.y"
/* file: tmgram.y
   A YACC grammar for Miranda algebraic datatypes
 */

#include "tmdefs.h"
#include <ctype.h>
#include <tmc.h>

#include "tmds.h"
#include "tmstring.h"
#include "debug.h"
#include "tmerror.h"
#include "tmglobal.h"
#include "tmlex.h"
#include "tmmisc.h"

extern void setlexfile();

#define YYDEBUG 1   /* allow compilation of debugging code */

ds_list ans;


# line 26 "tmgram.y"
typedef union  {
    ds pards;
    ds_list pardslist;
    constructor parcons;
    constructor_list parconslist;
    field parfield;
    field_list parfieldlist;
    char *parstring;
} YYSTYPE;
# define BAR 257
# define COLCOLEQ 258
# define EQEQ 259
# define COLON 260
# define COMMA 261
# define NAME 262
# define SEMI 263
# define LSBRAC 264
# define RSBRAC 265
# define LRBRAC 266
# define RRBRAC 267
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 141 "tmgram.y"


static void yyerror( s )
 char *s;
{
    s = s; /* to stop complaints about unused arguments */
    (void) sprintf( errpos, "%s(%d)", dsfilename, dslineno );
    error( SYNTAXERR );
}

/* Check a name on underscores and give an error message if one is found */
static void ckunderscore( s )
 char *s;
{
    if( index( s, '_' ) != NULL ){
	(void) sprintf( errpos, "%s(%d)", dsfilename, dslineno );
	(void) strcpy( errarg, s );
	error( NOUNDERSCORE );
    }
}

/* Ensure that name 's' is a proper constructor name. */
static void ckconsname( s )
 char *s;
{
    if( s[0] == '\0' ) return;
    ckunderscore( s );
    if( !isupper( s[0] ) ){
	(void) sprintf( errpos, "%s(%d)", dsfilename, dslineno );
	(void) strcpy( errarg, s );
	error( BADCONSNM );
    }
}

/* Ensure that name 's' is a proper type name. */
static void cktypename( s )
 char *s;
{
    if( s[0] == '\0' ) return;
    ckunderscore( s );
    if( !islower( s[0] ) ){
	(void) sprintf( errpos, "%s(%d)", dsfilename, dslineno );
	(void) strcpy( errarg, s );
	error( BADTYPENM );
    }
}

/* Ensure that name 's' is a proper element name. */
static void ckelmname( s )
 char *s;
{
    if( s[0] == '\0' ) return;
    ckunderscore( s );
}

/* Ensure that there are no double names in tuple with name 'nm'
 * and fields 'fields'.
 */
static void cktuple( nm, fields )
 string nm;
 field_list fields;
{
    register unsigned int ix;	/* index of currently checked field */
    register unsigned int iy;	/* index of searched subsequent fields */
    field fx;			/* checked field */
    field fy;			/* searched field */
    string fnm;			/* name of currently checked field */

    for( ix=0; ix<fields->sz; ix++ ){
	fx = fields->arr[ix];
	fnm = fx->sename;
	iy = ix+1;
	for( iy=ix+1; iy<fields->sz; iy++ ){
	    fy = fields->arr[iy];
	    if( strcmp( fy->sename, fnm ) == 0 ){
		(void) sprintf( errpos, "in type '%s'", nm );
		(void) sprintf( errarg, "'%s'", fnm );
		error( DOUBLEFIELD );
	    }
	}
    }
}

/* Ensure that there are no double names in each of the constructors of
 * constructor type with name 'nm' and constructors 'cons'.
 */
static void ckconstructor( nm, cons )
 string nm;
 constructor_list cons;
{
    constructor conx;
    constructor cony;
    field_list fields;
    register unsigned int cix;	/* index in constructor list */
    register unsigned int ix;	/* index of currently checked field */
    register unsigned int six;	/* index for searching of fields/constr. */
    field fx;			/* checked field */
    field fy;			/* searched field */
    string fnm;			/* name of currently checked field */
    string connm;		/* name of current constructor */

    for( cix=0; cix<cons->sz; cix++ ){
	conx = cons->arr[cix];
	fields = conx->confields;
	connm = conx->conname;
	for( six=cix+1; six<cons->sz; six++ ){
	    cony = cons->arr[six];
	    if( strcmp( cony->conname, connm ) == 0 ){
		(void) sprintf( errpos, "in type '%s'", nm );
		(void) sprintf( errarg, "'%s'", connm );
		error( DOUBLECONS );
	    }
	}
	for( ix=0; ix<fields->sz; ix++ ){
	    fx = fields->arr[ix];
	    fnm = fx->sename;
	    six = ix+1;
	    for( six=ix+1; six<fields->sz; six++ ){
		fy = fields->arr[six];
		if( strcmp( fy->sename, fnm ) == 0 ){
		    (void) sprintf(
			errpos,
			"in type '%s', constructor '%s'",
			nm,
			connm
		    );
		    (void) sprintf( errarg, "'%s'", fnm );
		    error( DOUBLEFIELD );
		}
	    }
	}
    }
}

/* top level of parser. */
ds_list parse( f )
 FILE *f;
{
    setlexfile( f );
    (void) yyparse();
    return( ans );
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 0,
	};
# define YYNPROD 19
# define YYLAST 45
yytabelem yyact[]={

    25,    14,    32,    29,    16,    30,    24,    27,     9,     5,
    15,    31,    21,    13,    26,     6,     7,     8,    19,    20,
    11,    12,     4,    17,    18,    10,     3,     2,     1,     0,
     0,     0,     0,     0,     0,     0,    23,    22,     0,     0,
     0,     0,     0,     0,    28 };
yytabelem yypact[]={

 -1000, -1000,  -247, -1000,  -242,  -255, -1000,  -249,  -265, -1000,
  -253, -1000, -1000, -1000,  -250, -1000,  -249,  -250,  -261, -1000,
  -246, -1000, -1000, -1000,  -256,  -250,  -259, -1000, -1000, -1000,
  -251,  -263, -1000 };
yytabelem yypgo[]={

     0,    28,    27,    26,    25,    20,    24,    23,    18,    22,
    21,    19 };
yytabelem yyr1[]={

     0,     1,     2,     2,     3,     3,     3,     6,     6,     4,
     4,     5,     7,     7,     8,     8,     9,    10,    11 };
yytabelem yyr2[]={

     0,     3,     1,     5,     9,    13,     5,     3,     7,     3,
     7,     5,     1,     5,     7,    11,     3,     3,     3 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    -9,   256,   262,   258,   259,   263,
    -4,    -5,   -10,   262,   266,   263,   257,    -7,    -6,    -8,
   -11,   262,    -5,    -8,   267,   261,   260,   263,    -8,   262,
   264,   262,   265 };
yytabelem yydef[]={

     2,    -2,    -2,     3,     0,     0,    16,     0,     0,     6,
     0,     9,    12,    17,     0,     4,     0,    11,     0,     7,
     0,    18,    10,    13,     0,     0,     0,     5,     8,    14,
     0,     0,    15 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"BAR",	257,
	"COLCOLEQ",	258,
	"EQEQ",	259,
	"COLON",	260,
	"COMMA",	261,
	"NAME",	262,
	"SEMI",	263,
	"LSBRAC",	264,
	"RSBRAC",	265,
	"LRBRAC",	266,
	"RRBRAC",	267,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"top : typelist",
	"typelist : /* empty */",
	"typelist : typelist type",
	"type : typename COLCOLEQ constructorlist SEMI",
	"type : typename EQEQ LRBRAC tuplebody RRBRAC SEMI",
	"type : error SEMI",
	"tuplebody : field",
	"tuplebody : tuplebody COMMA field",
	"constructorlist : constructor",
	"constructorlist : constructorlist BAR constructor",
	"constructor : consname fieldlist",
	"fieldlist : /* empty */",
	"fieldlist : fieldlist field",
	"field : elmname COLON NAME",
	"field : elmname COLON LSBRAC NAME RSBRAC",
	"typename : NAME",
	"consname : NAME",
	"elmname : NAME",
};
#endif /* YYDEBUG */
	/**********************************************************
 	* Copyright (C) Data General Corporation, 1984 - 1988	  *
 	* All Rights Reserved.					  *
 	* Licensed Material-Property of Data General Corporation. *
 	**********************************************************/
	    /**************************************************
 	    * This software is made available solely pursuant *
	    * to the terms of a DGC license		      *
 	    * agreement which governs its use.		      *
 	    **************************************************/

/*	$What: <@(#) yaccpar.c,v	2.1.1.1> $	*/

/* #ident	"@(#)yacc:yaccpar	1.10" */

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif	/*  #ifndef YYDEBUG  */

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if	YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif	/*  #if	YYDEBUG  */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if	YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif	/*  #if	YYDEBUG  */
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if	YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif	/*  #if	YYDEBUG  */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if	YYDEBUG
			yytmp = yychar < 0;
#endif	/*  #if	YYDEBUG  */
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if	YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif	/*  #if	YYDEBUG  */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if	YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif	/*  #if	YYDEBUG  */
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if	YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif	/*  #if	YYDEBUG  */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if	YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif	/*  #if	YYDEBUG  */
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 62 "tmgram.y"
{ ans = yypvt[-0].pardslist;                          } break;
case 2:
# line 65 "tmgram.y"
{ yyval.pardslist = new_ds_list();                } break;
case 3:
# line 66 "tmgram.y"
{ app_ds_list( yypvt[-1].pardslist, yypvt[-0].pards ); yyval.pardslist = yypvt[-1].pardslist;    } break;
case 4:
# line 71 "tmgram.y"
{
	    ckconstructor( yypvt[-3].parstring, yypvt[-1].parconslist );
	    yyval.pards = new_DsCons( yypvt[-3].parstring, yypvt[-1].parconslist );
	} break;
case 5:
# line 76 "tmgram.y"
{
	    cktuple( yypvt[-5].parstring, yypvt[-2].parfieldlist );
	    yyval.pards = new_DsTuple( yypvt[-5].parstring, yypvt[-2].parfieldlist );
	} break;
case 6:
# line 81 "tmgram.y"
{
	    yyval.pards = new_DsCons( new_string( "" ), new_constructor_list() );
	} break;
case 7:
# line 88 "tmgram.y"
{
	    yyval.parfieldlist = new_field_list();
	    app_field_list( yyval.parfieldlist, yypvt[-0].parfield );
	} break;
case 8:
# line 93 "tmgram.y"
{
	    app_field_list( yypvt[-2].parfieldlist, yypvt[-0].parfield );
	    yyval.parfieldlist = yypvt[-2].parfieldlist;
	} break;
case 9:
# line 101 "tmgram.y"
{
	      yyval.parconslist = new_constructor_list();
	      app_constructor_list( yyval.parconslist, yypvt[-0].parcons );
	  } break;
case 10:
# line 106 "tmgram.y"
{
	      app_constructor_list(yypvt[-2].parconslist, yypvt[-0].parcons);
	      yyval.parconslist = yypvt[-2].parconslist;
	  } break;
case 11:
# line 114 "tmgram.y"
{
	      yyval.parcons = new_constructor(yypvt[-1].parstring, yypvt[-0].parfieldlist);
	  } break;
case 12:
# line 120 "tmgram.y"
{ yyval.parfieldlist = new_field_list();            } break;
case 13:
# line 121 "tmgram.y"
{ app_field_list(yypvt[-1].parfieldlist, yypvt[-0].parfield); yyval.parfieldlist = yypvt[-1].parfieldlist;  } break;
case 14:
# line 125 "tmgram.y"
{ yyval.parfield = new_field( 0, yypvt[-2].parstring, yypvt[-0].parstring );       } break;
case 15:
# line 126 "tmgram.y"
{ yyval.parfield = new_field( 1, yypvt[-4].parstring, yypvt[-1].parstring );       } break;
case 16:
# line 130 "tmgram.y"
{ cktypename( yypvt[-0].parstring ); yyval.parstring = yypvt[-0].parstring;         } break;
case 17:
# line 134 "tmgram.y"
{ ckconsname( yypvt[-0].parstring ); yyval.parstring = yypvt[-0].parstring;         } break;
case 18:
# line 138 "tmgram.y"
{ ckelmname( yypvt[-0].parstring ); yyval.parstring = yypvt[-0].parstring;          } break;
	}
	goto yystack;		/* reset registers in driver code */
}
