
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* File: tctypes.h
   termcap routine related types
   key and character defines
*/

#define MAXKEYDEFS 25
#define BEEP      "\007"
#define FLASH     "\007"

/* KEYS means if the following constants are defined 
   by your curses implementation
*/
#ifndef KEY_RIGHT
#define KEY_RIGHT 256+1
#define KEY_LEFT  256+2
#define KEY_UP    256+3
#define KEY_DOWN  256+4
#endif


typedef
  struct strkeystrings {
    int n;                       /* number of key definitions stored */
    char *keystr[MAXKEYDEFS]; /* string received when key is pressed */
    int  keyid[MAXKEYDEFS];      /* id of key */
  };
typedef struct strkeystrings *keystrings;


typedef
  struct strattrstrings {
    char 
      *mb,      /* turn on blinking */
      *md,      /* enter bold mode */
      *me,      /* turn off all atributes */
      *mr;      /* enter reverse mode */
  };
typedef struct strattrstrings *attrstrings;

