
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* File: fscscharc
 * 
 * Handle 'fscan_<type>' for type 'char'.
 */

/* Standard libraries */
#include <ctype.h>
#include <stdio.h>

/* other standard UNIX functions */
extern char *strcpy();

#define TRUE 1
#define FALSE 0
typedef short int bool;

/* Header of the library this code is part of. */
#include "tmc.h"

bool IsDigit (c)
  char c;
{
  if ((c>='0') && (c<='9'))
    return(TRUE);
  else return(FALSE);
}

/* Try to read a character in the buffer 'buf'. Give an error
   message if this is not successful. A character may contain
   escape sequences with a '\', but no newlines. The '\''
   around the string are stripped.
 */
int fscan_char( f, c )
 FILE *f;
 char *c;
{
    register int brac;
    int quote;

    *c = (char)0;
    brac = fscanopenbrac( f );
    quote = fgetc( f );
    if( quote != '\'' )
    {	(void) strcpy( tmerrmsg, "character expected" );
	return( 1 );
    }
    *c = fgetc( f );
    if( *c == '\n' )
    {   (void) strcpy( tmerrmsg, "newline in character" );
        return( 1 );
    }
    if( *c == '\\' )
    {  *c = fgetc( f );
       switch( *c )
       { case 'b': *c = '\b'; break;
         case 'f': *c = '\f'; break;
         case 'n': *c = '\n'; break;
         case 'r': *c = '\r'; break;
         case 't': *c = '\t'; break;
         case 'v': *c = '\v'; break;
         default:
             if( IsDigit( *c ) )
   	     { int val;
    	       val = *c-'0';
    	       *c = fgetc( f );
    	       if( IsDigit( *c ) )
    	       {   val = val*8 + (*c-'0');
    	           *c = fgetc( f );
    	           if( IsDigit( *c ) )
    	 	   {  val = val*8 + (*c-'0');
    	           }
    	           else
    	 	      ungetc( *c, f );
               }
    	       else
    	           ungetc( *c, f );
    	       *c = val;
             }
             break;
       }
    }
/*    *(c+1)='\0';        */
    quote = fgetc(f);
    if( quote != '\'' )
    { 
      (void) strcpy( tmerrmsg, "character expected" );
      return( 1 );
    }
    return( fscanclosebrac( f, brac ) );
}
