%TEX
\documentstyle[11pt]{article}
\author{Eric Voss\\
University of Nijmegen. } 
\title{Tm Eag Trans \\ template file }
\parskip 0pt plus 1pt
\parindent 0pt
%

meta data structure description (rules+N+list rules+N+Constants>):
  layout,
  rules(list rules>,rules>).

rules (x+xx>,r+rr>):
   rule (x>,r>), ->,";", layout, rules (xx>, rr>);
rules (empty>,empty>):.

rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "::=", layout, ->,
  alts (>"trans "+left hand side,x>,alts>);
rule (x>,N+alts+N>):
  identifier(left hand side>), layout,
  "==", layout,
  synomym (>"trans "+left hand side,x>,alts>).

synomym (>l, x>, l+ " (> node,> "+struct+"):\n\t"+ trans+".\n\n">):
  member (x>,struct>,trans>).

alts (>l, x+xx>,alt+more alts>):
   alt (>l,x>,alt>), more alts(>l,xx>,more alts>).

more alts (>l, x+xx>,";\n"+alt+ more  alts>):
  "|", layout, alt (>l, x>,alt>), ->,
   more alts(>l,xx>,more alts>);
more alts (>l, empty>,".\n\n">):
  . 

alt (>l, x+xx>, 
      l+"(> node, > "+ constructor+" * "+struct+ more  struct + "): ->,\n\t" + 
      trans + more  trans>):
  identifier(constructor>),layout, 
  member (x>,struct>,trans>), ->,
  more members (xx>,more  struct >,more trans>);
alt (>l, empty>, 
         l+ " (> constant,> "+ constructor+"): ->">):
  identifier(constructor>),layout.

member (x>,struct>, trans+"(> "+struct+", >"+struct+")" >):
     identifier (struct>),layout, 
     ":", layout,
     type (x>,trans>);
member (x>,struct>, trans>):
     "(", layout, tupple els (x>, struct>, trans>) ,
     ")", layout.

tupple els ( x + xx + tupple def>, tupple name>, tupple trans>):
     member (x>, s>,  w>),
     more tupple els (xx>, ss>, ww>),
     tupple code (>s+ss,>w+ww,tupple def>, tupple name> , tupple trans>).

more tupple els (x +xx>, " * "+s + ss>,",\n\t"+w + ww>):
    "," , layout, ->,
    member (x>, s>, w>),
    more tupple els (xx>, ss>,ww>);
more tupple els (empty>, empty>, empty>):.


tupple code (>s,>w, tupple def>, n>, tupple trans>):
     some name (n>),
     where (>"trans "+n, trans>),
     where ( > trans +"(> node,> TUPPLE * "+s +"):\n\t"+ 
                 w+  ".\n\n", tupple def>),
     where (>trans +"(> "+n+", > "+n+")", tupple trans>).
    

more members (x+xx>, "* "+s + ss> ,",\n\t"+w+ww>):
    member (x>,s>,w>), ->,
    more members (xx>,ss>,ww>);
more members (empty>,empty>,empty>):.


type (empty>,type+" ">):
   identifier (tp>), layout, ->,
   where (>"trans "+tp, type>);
type (x>,type list>):
   "[",layout,
    identifier(tp>), layout,
    where (>"trans "+tp, type>),
    where (>type + " list ", type list>),
    where (>type + " els ", type els>),
   "]",layout,
    list code (>type,>type list, >type els, x>).

list code  (> type, >type list, >type els, list code >):
     excludes (>type list,>empty), ->,
     add to (>type list,>empty,>empty),
     where ( >"more "+type els, more type els>),
     where ( > type list+"(> node, >LIST * "+type els+ "):\n\t"+# 
                  type els+"(> "+type els+ ",> "+type els+").\n\n"+

       type els +"(> node,> "+type+" * "+type els+"):\n\t"+#
                type+"(> "+type+",> "+type+"),->,\n\t"+#
                type els+ "(> "+type els+ ",> "+type els +");\n"+
       type els +"(> constant, > empty):.\n\n", list code>);
list code  (> type, >type list, >type els, empty >):.

#
Open symbol  :: "\t\"(\", layout".
Close symbol :: ",\n\t\")\", layout".
N            :: nlcr.

Constants :: Inum+Fnum+String+Bool+Symbol.

Inum   :: "\ntrans i num (> node, > INUM * i num) : .\n\n".

Fnum   :: "trans f num (> node, > FNUM * f num) : .\n\n".


String   :: "trans string (> node, > STRING *string): .\n\n".

Symbol  :: "trans symbol (> node, >symbol) : trans string (> node, >symbol).\n\n".

Bool   :: "trans bool (> node, > BOOL * T or F) : .\n\n".


layout:
    !\n\t !*  (ig>),
    comment.

comment:
    "||", ->,
    ^!\n! * (ign>), layout;
comment: .
