/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* 
 *  file  : compute properties 
 *                  deterministic rules
 *                  empty
 *                  left recursive rules
 *                  which rules to (partly) memoize
 */

#include "gg1.h"
#include "gg2.h"
int             det_count=0,nondet_count = 0,memo_count=0,recursive_count=0;
int             last_alt = true, memo_gain;
int rec_count = 0;
init_builtins()
{
  int             rule, alt;

  equal = get_builtin("equal");
     if (meta_uniq_flag) 
        *(REPR(equal)) = 'f';
  notequal = get_builtin("notequal");
     if (meta_uniq_flag) 
        *(REPR(notequal)) = 'f';

  endofsentence = get_builtin("endofsentence");
  evalmeta = get_builtin("evalmeta");
  explintersect = get_builtin("explintersect_");
  falseip =get_builtin("falseip_");
  getip = get_builtin("getip_"); 
  initmeta = get_builtin("initmeta");
  initmint = get_builtin("initmint_");
  intersect = get_builtin("intersect_");
  metaterminal = get_builtin("metaterminal");
  nestaralt = get_builtin("nestaralt_");
  nestarset = get_builtin("nestarset");
  nlcr = get_builtin("nlcr");
  pair = get_builtin("pair");
  resetinputptr = get_builtin("resetinputptr_");
  restoreip = get_builtin("restoreip_");
  setinputptrto = get_builtin("setinputptrto_");
  skip = get_builtin("skip_");
  tltraditional =get_builtin("tltraditional_"); 
  tltraditionalterm =get_builtin("tltraditionalterm_"); 
  transformlattice = get_builtin("transformlattice_");
  transformlatticeterm =  get_builtin("transformlatticeterm_"); 
  unpair = get_builtin("unpair");
  where = get_builtin("where");
}

get_builtin(repr)
register char *repr;
{
  register int rule, rr;
  for (rule =laststdpred; (rule != nil)&&(!mystrcmp(REPR(rule), repr));
       rule = BROTHER(rule));
  if (rule == nil) {
    fprintf(stderr, "glammar: installation error: %s: not a builtin\n",repr);
    exit(12);
  }
  
  for (rr = root; rr != laststdpred; rr = BROTHER(rr))
    if (REPR(rule) == REPR(rr)) {
          if (input_from_partlist)
             fprintf(stderr, "In %s:\n",DEF(rule));
             fprintf(stderr, "line %d: %s: name already in use; do not redefine\n",
                                LINE(SON(rr)), REPR(rr));
             exit(12);
    }
  return rule;
}

determ()
{
   int rule;
   if (!lift_flag) {
      if (det_flag) {
         fprintf(stderr,"glammar: -d ignored because -f overrules\n");
         det_flag = false;
      }
      fprintf(stderr,"glammar: builtins nondeterministc\n");
      for (rule = root; rule != nil ; rule = BROTHER (rule))
         SET(rule, nondeterministic);
      UNSET(evalmeta, nondeterministic);
      UNSET(initmint, nondeterministic);
      UNSET(initmeta, nondeterministic);
      UNSET(pair, nondeterministic);
      UNSET(init_one_star, nondeterministic);
      SET(evalmeta, deterministic);
      SET(initmint, deterministic);
      SET(pair, deterministic);
      SET(initmeta, deterministic);
      SET(init_one_star, deterministic);
      return;
   }

/* 
 * builtins classification
 *    a:.        ----- deterministic
 *    a:;a:.     ----- deterministic if -d flag is on , else nondeterministic
 *    a:;a:;a:.  ----- nondeterministic 
 *
 */
   for (rule = laststdpred ; rule != nil ; rule = BROTHER(rule))
         if (BROTHER(SON(rule)) == nil)
            SET(rule,deterministic);
         else if (BROTHER(BROTHER(SON(rule))) == nil)
             if (det_flag)
                SET(rule,deterministic);
             else  SET(rule,nondeterministic);
         else  SET(rule,nondeterministic);

   compute_determ(root);
   check_determ();


   if ((det_flag) && (nondet_count > 0)) {
      exit (-1);
   }
   if ((MARKED (root,deterministic)) && (!det_flag)) {
     if (verbose_flag)
      fprintf(stderr, "glammar semantic compute: Grammar is deterministic.\n");
     det_flag = true;
   }
   if (verbose_flag)
      fprintf(stderr, "glammar semantic compute: Deterministic: (%d,%d)\n", det_count, nondet_count);
}

check_determ()
{
     int alt,rule,again,over = 0,mem; 
    do {
    again = 0;
    for (rule = root; rule != laststdpred ; rule = BROTHER (rule)) 
     if (MARKED(rule, deterministic))
      for (alt = SON(rule); alt != nil  ; alt = BROTHER(alt))
         for (mem = SON(alt); mem != nil  ; mem = BROTHER(mem))
              if (MARKED(DEF(mem), nondeterministic)) {
                again +=1; 
                SET(rule,nondeterministic);
                UNSET(rule,deterministic);
              }
    if (again > 0)
           over += 1;
    } while (again > 0);
   if (over >0)
    fprintf(stderr, "glammar semantic compute: deterministic: needed %d re-computations\n", over);
}
 
compute_determ(rule)
int rule; 
{
   if (rule == laststdpred)
      return;
   compute_determ(BROTHER(rule));
   if (determ_rule(rule))  {
       SET(rule,deterministic);
       det_count += 1;
   }
}

determ_rule(rule)
int rule;
{
  if (MARKED(rule, nondeterministic)) {
    return false;
  }
  if (MARKED(rule, processing)) {
    SET(rule, recursive);
    return true;
  }
  if (MARKED(rule, deterministic)) {
    return true;
  }
  SET(rule, processing);
  if (determ_alts(SON(rule))) {
    UNSET(rule, processing);
    if (!MARKED (rule, recursive)) {
       det_count += 1;
       SET(rule, deterministic); 
/*       fprintf(stderr, "line %d: `%s' deterministic.\n",DEF(rule),REPR(rule)); */
   }
   /* else    fprintf(stderr, "line %d: `%s' recursive.\n",DEF(rule),REPR(rule)); */
/* */
    return true;
  } else {
    UNSET(rule, processing);
    nondet_count += 1;
    if (det_flag) {
          if (input_from_partlist)
             fprintf(stderr, "In %s:\n",DEF(rule));
          fprintf(stderr, "line %d: `%s' nondeterministic.\n",LINE(SON(rule)),
                 REPR(rule));
/*          SET(rule, deterministic); */
          return true;
    }
    else SET(rule, nondeterministic);
    return false;
  }
}


determ_alts(alt)
  int             alt;
{
  for (; alt != nil; alt = BROTHER(alt)) {
    if (BROTHER(alt) == nil)
       last_alt=true;
    else 
       last_alt=false;
    
    if (!determ_mems(SON(alt)))
      return false;
  }
  return true;
}


determ_mems(member)
  int             member;
{
  int cut_in_alt = last_alt;
  register int  mem = member;
  if (!cut_in_alt)  
     for (; mem != nil; mem = BROTHER(mem))
             if (DEF(mem) == cut) cut_in_alt = true;
   
  if (!cut_in_alt)  
     return false;
 
  for (mem = member; mem != nil; mem = BROTHER(mem))
    if ( (TERMINAL(mem)) ) ;
    else if  (!determ_rule(DEF(mem))) {
      return false;
   }
  return true;
}


empty()
{
   set_nr_of_mems();
   decrease_mem_count(-99);
   set_notempty();
}

set_nr_of_mems()
{
   int rule,alt,mem;
   for (rule = root; rule != nil  ; rule = BROTHER(rule))
      for (alt = SON(rule); alt != nil  ; alt = BROTHER(alt)){
         int nr_mems = 0;
         for (mem = SON(alt); mem != nil  ; mem = BROTHER(mem), nr_mems +=1);
         if (TERMINAL(mem) ){
           SET(rule,notemptyrule);
           for (;BROTHER(alt) != nil  ; alt = BROTHER(alt));
           break; 
         }
         DEF(alt) = nr_mems;
      }
}

decrease_mem_count(rule)
int rule;
{
   int rl,alt,mem;
   for (rl = root; rl != nil ; rl = BROTHER(rl))
      if ((!MARKED(rl,emptyrule) ) && (!MARKED(rl, notemptyrule)) )
         for (alt = SON(rl); alt != nil  ; alt = BROTHER(alt)) {
            for (mem = SON(alt); mem != nil  ; mem = BROTHER(mem))
               if (TERMINAL(mem)) ;
               else if (DEF(mem) == rule)
                  DEF(alt) -=1;

            if (DEF(alt) == 0) {
               SET(rl,emptyrule);
               decrease_mem_count(rl);
               break;
            }
         }
}


int et = 0, net = 0;

set_notempty()
{
   int rule;
   for (rule = root; rule != nil  ; rule = BROTHER(rule))
      if (!MARKED(rule,emptyrule)) {
         SET(rule,notemptyrule);
         net +=1;
      } else et += 1;
      if (verbose_flag)
         fprintf(stderr, "empty: (%d,%d)\n", et, net);
}

adp_walk() {
    
   adp_clear();
   adp_stddefs();
   adp_rest();
   add_skip();

   if (verbose_flag) 
     fprintf(stderr,"%d productions memoized (table size = %dk)\n",
        memo_count, (memo_count*(runtime_input_size >>3))>>10);
    
   compute_memo_gain(); 
   if (verbose_flag)
     fprintf(stderr,"glammar: %d more productions memorized because of semantic computations\n", 
        memo_gain); 
   
}

add_skip() {
   register int rule,alt;
   for (rule = root; rule != laststdpred; rule = BROTHER(rule))
     if (MARKED(rule,nondeterministic))
      for (alt = SON(rule); alt != nil; alt  = BROTHER(alt)) 
       if ((AM_flag) || (no_iha(AFFIXDEF(alt))) ) 
        add_skip_in_alt(alt);
}

no_iha(afx) 
int afx;
{
   for (; afx != nil; afx = BROTHER(afx))
        if (INHERITED(afx))
            return false;
   return true;
}

add_skip_in_alt(alt)
int alt;
{
   register int afx,skip_mem, max_count = 10000,count,mem,prev_mem,af,tm;
   char *reprterm;
   int all_empty;
   for(mem = SON(alt);  mem != nil;  mem = BROTHER(mem))
               if  (TERMINAL(mem));
               else if  (MARKED(DEF(mem), nondeterministic)) break;
   
   for(;  mem != nil;  mem = BROTHER(mem))
         if  (TERMINAL(mem)) break;
         else if  (MARKED(DEF(mem), notemptyrule)) break;
    
   if (mem == nil) {
      DEF(alt) = -1;
      return;
   }

   if  ((BROTHER(mem) == nil) && (no_iha(AFFIXDEF(SON(DEF(mem))))) &&
         (SON(alt) == mem) ) {
      DEF(alt) = -1;
      return;
   }
   brother = nil;
   newdefnode(ntnode,nil,nil,skip,REPR(skip));
   skip_mem = brother;
   for (afx = AFFIXDEF(alt); afx != nil; afx = BROTHER(afx)){
      if ((NODENAME(afx) == inherited)  &&
          (MARKED_ADP(afx,affix_directed_parsing)) ) {
         reprterm = REPR(SON(afx));
         for(mem = SON(alt), count = 0; ((mem != nil) && 
                                  (MARKED(DEF(mem), deterministic))); 
                    mem = BROTHER(mem),count++);
         for(; mem != nil; mem = BROTHER(mem),count++)
               for(af = AFFIXTREE(mem); af != nil; af = BROTHER(af))
                  if (!DERIVED(af))
                     for(tm = SON(af); tm != nil; tm = BROTHER(tm))
                        if ((REPR(tm) == reprterm ) &&  (count < max_count))
                             max_count = count;

        }
      }
      all_empty = true;
      prev_mem = nil;
      for (mem = SON(alt); mem != nil; prev_mem = mem,mem = BROTHER(mem) ) 
        
         if ((max_count-- == 0) && (!all_empty)) {
           DEF(alt) = domemo;
           memo_count +=1;
           BROTHER(prev_mem) = skip_mem;
           BROTHER(skip_mem) = mem;
         }
         else if (TERMINAL(mem))
            all_empty = false;
         else if (( all_empty) && (MARKED(DEF(mem),notemptyrule)))
            all_empty = false;

     if ((max_count >0) && (prev_mem != nil) && (!all_empty)) {
           DEF(alt) = domemo;
           memo_count +=1;
           BROTHER(prev_mem) = skip_mem;
           BROTHER(skip_mem) = nil;
     }
       
}

adp_clear() {
   register int rule,afx,alt;

   for (rule = root; rule != nil; rule = BROTHER(rule)) 
     for (alt = SON(rule); alt != nil; alt  = BROTHER(alt)) {
       DEF(alt) = -1;
       for (afx = AFFIXDEF(alt); afx != nil; afx  = BROTHER(afx)) 
           DEF(afx) = 0;
     }
}
adp_stddefs() {
   register int rule,afx,alt;
   for (rule = laststdpred; rule != nil; rule = BROTHER(rule)) 
     for (alt = SON(rule); alt != nil; alt  = BROTHER(alt))
       for (afx = AFFIXDEF(alt); afx != nil; afx  = BROTHER(afx)) 
          if (INHERITED(afx)) 
            if (NODENAME(SON(afx)) == affixtm) 
               SET_ADP(afx,affix_directed_parsing);
            else
               SET_ADP(afx,no_affix_directed_parsing);
}

adp_rest() {
   register int rule,afx,alt,count;
   for (rule = root; rule != laststdpred; rule = BROTHER(rule)) 
         for(afx = AFFIXDEF(SON(rule)), count = 0; afx != nil; 
                         afx = BROTHER(afx),count++)
          if (INHERITED(afx)) 
             adp_rule(rule,count);
}
 
alt_adp(reprtrm,mem)
char  *reprtrm;
int  mem;
{
  int count = 0;
  register int trm,afx;
  for (; mem != nil; mem = BROTHER(mem))
    for (count = 0,afx = AFFIXTREE(mem); afx != nil; 
              afx  = BROTHER(afx), count +=1) 
      if (INHERITED(afx))
        for (trm = SON(afx); trm != nil; trm  = BROTHER(trm)) 
          if (REPR(trm) == reprtrm) 
            if (adp_rule(DEF(mem),count))
              return 1 ;
             else {
               int af;
               for ( af = AFFIXTREE(mem) ; af != nil; af = BROTHER(af))
               if (NODENAME(af) == derived) 
                 if (alt_adp(REPR(SON(af)),BROTHER(mem)))
                    return 1; 
             }
  return 0;
}

int adp_rule(rule,count)
int rule, count;
{
  int afx,alt;
  for (alt = SON(rule); alt != nil ; alt = BROTHER(alt) ) { 
   afx= get_affix(AFFIXDEF(alt),count);
   if (MARKED_ADP(afx,affix_directed_parsing))  
    return true;
   if (MARKED_ADP(afx,no_affix_directed_parsing))
    return false;
   else if (MARKED_ADP(afx,processing));
   else  {   
      SET_ADP(afx,processing);
      if (!alt_adp(REPR(SON(afx)),SON(alt))) {
        SET_ADP(afx,no_affix_directed_parsing);
        UNSET_ADP(afx,processing);

      } else { 
       UNSET_ADP(afx,processing);
      for (alt = SON(rule); alt != nil ; alt = BROTHER(alt) )
        for (afx = AFFIXDEF(alt); afx != nil ; afx = BROTHER(afx) )
         if (NODENAME(afx) == inherited) {
            UNSET_ADP(afx,no_affix_directed_parsing);
            SET_ADP(afx,affix_directed_parsing);
         }
       return true;
     }
  } 
 }
 return false;
}
int  get_affix(afx,count) 
int afx, count;
{
    for (; afx != nil ; afx  = BROTHER(afx),count -=1) 
        if (INHERITED(afx) )
           if (count == 0)
             return afx;
   fprintf(stderr,
       "glammar: fatal compiler error in adp.get_affix (count was %d)\n",
       count);
   exit(-1);
   return 0; /* Bypass compiler warning */
}

left_rec() {
   int rule; 
   left_rec_rule(root);
   for (rule = root; rule != laststdpred; rule = BROTHER(rule))  
     if (MARKED(rule, leftrec)) {
          if (input_from_partlist)
             fprintf(stderr, "In %s:\n",DEF(rule));
         fprintf(stderr, "line %d: `%s' left recursive\n", LINE(SON(rule)),
          REPR(rule));
         exit (-1);
     }
} 

left_rec_rule(rule)
{
  if (MARKED(rule, processing)) {
    SET(rule, leftrec);
    return ;
  }
  if (MARKED(rule, leftrec)) 
     return;
  if (MARKED(rule, notleftrec)) 
     return;
  SET(rule, processing);
  left_rec_alts(SON(rule));
  UNSET(rule, processing);
  if (!MARKED(rule, leftrec)) 
     SET(rule, notleftrec);
}


left_rec_alts(alt)
  int             alt;
{
  for (; alt != nil; alt = BROTHER(alt))
    left_rec_mem(SON(alt));
}


left_rec_mem(member)
 int             member;
{
  for (; member != nil; member = BROTHER(member)){
    int rule  = DEF(member);
    if (TERMINAL(member)) return ;
    else if (!MARKED(rule, emptyrule))  {
      left_rec_rule(rule);
      return ;
    }
   else
    left_rec_rule(rule);
  }
}


recursive_() {
   int rule; 
   recursive_rule(root);
   if (verbose_flag) {
      for (rule = root; rule != laststdpred; rule = BROTHER(rule))  
        if (MARKED(rule, recursive)) 
            recursive_count +=1;
     fprintf(stderr,"glammar semantic compute: %d rules are recursive\n",recursive_count);
  }
} 

recursive_rule(rule)
{
  if (MARKED(rule, processing)) {
    SET(rule, recursive);
    return ;
  }
  if (MARKED(rule, recursive)) 
     return;
  if (MARKED(rule, notrecursive)) 
     return;
  SET(rule, processing);
  recursive_alts(SON(rule));
  UNSET(rule, processing);
  if (!MARKED(rule, recursive)) 
     SET(rule, notrecursive);
}


recursive_alts(alt)
  int             alt;
{
  register member;
  for (; alt != nil; alt = BROTHER(alt)) 
   for (member = SON(alt) ; member != nil; member = BROTHER(member))
     if (TERMINAL(member));
     else recursive_rule(DEF(member));
}


compute_memo_gain()
{
  register int    rule,
                  alt;

  nr_of_memo_alts = memo_count;
  memo_gain = 0;
  for (rule = root; rule != laststdpred; rule = BROTHER(rule)) 
    for (alt = SON(rule); alt != nil; alt = BROTHER(alt)) 
        if (MEMOIZE(alt)) {
           if (inherited_afx(alt))
               memo_gain += 1;
         }
}



inherited_afx(alt)
  int             alt;
{
  int             afx;

  for (afx = AFFIXDEF(alt); afx != nil; afx = BROTHER(afx))
    if (NODENAME(afx) == inherited)
      return true;
  return false;
}

