/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* file  : transform defining affix expressions */
#include "gg1.h"
#include "gg2.h"
int             lastmem,
                prevmem,
                unique_eag_count = 0,
                total_eag_count = 0,
                unique_list_count = 0,
                total_list_count = 0,
                unique_empty_count = 0,
                where_count = 0,
                pair_count = 0,
                prev_source;

char           *gterm;

char * get_L();
char * get_G();
char * get_GG();

char small_L[10][4] = {
  "L_0",
  "L_1",
  "L_2",
  "L_3",
  "L_4",
  "L_5",
  "L_6",
  "L_7",
  "L_8",
  "L_9",
};

char small_GG[10][5] = {
  "GG_0",
  "GG_1",
  "GG_2",
  "GG_3",
  "GG_4",
  "GG_5",
  "GG_6",
  "GG_7",
  "GG_8",
  "GG_9",
};


char *get_L()  {
   if ( unique_list_count >9)  {
      char * name;
      name = &chartable[++charindex];
      (void) sprintf(&chartable[charindex], "L_%d", unique_list_count++);
      charindex += 10;
      if (charindex > maxchars)
         alloc_chartable();
      return name;
   }
   return small_L[unique_list_count++];
}
char *get_GG()  {
   if ( unique_eag_count >9)  {
      char * name;
      name = &chartable[++charindex];
      (void) sprintf(&chartable[charindex], "GG_%d", unique_eag_count++);
      charindex += 10;
      if (charindex > maxchars)
         alloc_chartable();
      return name;
   }
   return small_GG[unique_eag_count++];
}

eag()
{
  int             rule, alt;


  for (rule = root; rule != laststdpred; rule = BROTHER(rule))
    for (alt = SON(rule); alt != nil; alt = BROTHER(alt))
      alt_eag(alt);
  if (verbose_flag)
    fprintf(stderr, "glammar transformation fase: %d defining expressions resolved.\n",
      total_eag_count);
   delete_superaffix_productions(); 
}


alt_eag(alt)
  int             alt;
{
  int             member;

  unique_eag_count = 0,
  lefths_eag(alt);
  for (member = SON(alt); member != nil; member = BROTHER(member))
    rights_eag(member);
  total_eag_count += unique_eag_count;
}


lefths_eag(alt)
  int             alt;
{
  int             affix;

  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix))
    if (NODENAME(affix) == inherited)  {
      if ((BROTHER(SON(affix)) != nil) || 
          (NODENAME(SON(affix)) == superaffix)) {
        char           *name;
        int             lbrother,
                        llbrother;

        name = get_GG();
        gterm = name + 1;
        brother = SON(alt);
        defining_expr(SON(affix));
        REPR(SON(affix)) = name;
        LEFTDEF(SON(affix)) = -1;
        BROTHER(SON(affix)) = nil;
        NODENAME(SON(affix)) = affixnt;
        lbrother = brother;
        newnode(affixnt, nil, nil, name + 1);
        newnode(derived, nil, brother, "(nil)");
        llbrother = brother;
        newnode(affixnt, nil, nil, name);
        newnode(inherited, llbrother, brother, "(nil)");
        newdefnode(ntnode, lbrother, brother,
             setinputptrto, REPR(setinputptrto));
        SON(alt) = brother;
       }
            /* delete_superaffixes_on_applying_positions */
     }  else if (NODENAME(SON(affix)) == superaffix)  {
        LEFTDEF(SON(affix)) = -1;
        NODENAME(SON(affix)) = affixnt;
     }
}


rights_eag(mem)
  int             mem;
{
  int             affix;

  for (affix = AFFIXTREE(mem); affix != nil; affix = BROTHER(affix))
    if (NODENAME(affix) == derived) {
      if ((BROTHER(SON(affix)) != nil) || 
          (NODENAME(SON(affix)) == superaffix)) {
        char           *name;
        int             lbrother,
                        llbrother;

        name = get_GG();
        gterm = name + 1;
        brother = BROTHER(mem);
        defining_expr(SON(affix));
        REPR(SON(affix)) = name;
        LEFTDEF(SON(affix)) = -1;
        BROTHER(SON(affix)) = nil;
        NODENAME(SON(affix)) = affixnt;
        lbrother = brother;
        newnode(affixnt, nil, nil, name + 1);
        newnode(derived, nil, brother, "(nil)");
        llbrother = brother;
        newnode(affixnt, nil, nil, name);
        newnode(inherited, llbrother, brother, "(nil)");
        newdefnode(ntnode, lbrother, brother,
             setinputptrto, REPR(setinputptrto));
        BROTHER(mem) = brother;
        mem = lastmem;
      }
            /* delete_superaffixes_on_applying_positions */
    } else if (NODENAME(SON(affix)) == superaffix)  {
        LEFTDEF(SON(affix)) = -1;
        NODENAME(SON(affix)) = affixnt;
   }
}


defining_expr(term)
  int             term;
{
  if (term == nil)
    return;
  if (BROTHER(term) == nil) {
    if (NODENAME(term) == metaffix)
      last_meta_constant(term);
    else if (NODENAME(term) == superaffix)
      last_super_hyper(term);
    else if (NODENAME(term) == affixtm)
      last_constant(term);
    else
      last_free(term);
    return;
  }
  defining_expr(BROTHER(term));
  if (NODENAME(term) == metaffix)
    meta_constant(term);
  else if (NODENAME(term) == affixtm)
    constant(term);
  else if (NODENAME(term) == superaffix)
      super_hyper(term);
  else
    free_meta(term);
  return;
}


constant(term)
  int             term;
{
  newnode(tnode, brother, nil, REPR(term));
}


last_constant(term)
  int             term;
{
  int             lbrother = brother;

  newnode(affixnt, nil, nil, gterm);
  newnode(inherited, nil, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, resetinputptr, REPR(resetinputptr));
  lastmem = brother;
  newnode(tnode, brother, nil, REPR(term));
}


free_meta(term)
  int             term;
{
  int             lbrother = brother;

  newnode(affixnt, nil, nil, REPR(term));
  newnode(derived, nil, brother, REPR(term));
  newdefnode(ntnode, lbrother, brother, nestarset, REPR(nestarset));
}


last_free(term)
  int             term;
{
  int             lbrother = brother,
                  ab;

  newnode(affixnt, nil, nil, gterm);
  newnode(inherited, nil, brother, "(nil)");
  ab = brother;
  newnode(affixnt, nil, nil, REPR(term));
  newnode(derived, ab, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, nestaralt, REPR(nestaralt));
  lastmem = brother;
}


meta_constant(term)
  int             term;
{
  int             lbrother = brother;

  newnode(metaffix, nil, nil, REPR(term));
  newnode(inherited, nil, brother, REPR(term));
  newdefnode(ntnode, lbrother, brother, metaterminal, REPR(metaterminal));
}


last_meta_constant(term)
  int             term;
{
  int             lbrother = brother;

  newnode(affixnt, nil, nil, gterm);
  newnode(inherited, nil, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, resetinputptr, REPR(resetinputptr));
  lastmem = brother;
  lbrother = brother;
  newnode(metaffix, nil, nil, REPR(term));
  newnode(inherited, nil, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, metaterminal, REPR(metaterminal));
}

super_hyper(term)
  int             term;
{
  int             lbrother = brother;

  newnode(affixnt, nil, nil, REPR(term));
  newnode(derived, nil, brother, REPR(term));
  newdefnode(ntnode, lbrother, brother, DEF(term), REPR(DEF(term)));
  if (!MARKED(DEF(term), docompile )) 
    if (!MARKED(DEF(term), external )) { 
    fprintf(stderr, "%s: super meta-notion not defined as external.\n", 
           REPR(DEF(term)) );
    exit(-1);
  }
}

last_super_hyper(term)
  int             term;
{
  int             lbrother = brother;

  newnode(affixnt, nil, nil, gterm);
  newnode(inherited, nil, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, resetinputptr, REPR(resetinputptr));
  lastmem = brother;
  lbrother = brother;
  newnode(affixnt, nil, nil, REPR(term));
  newnode(derived, nil, brother, "(nil)");
  newdefnode(ntnode, lbrother, brother, DEF(term), REPR(DEF(term)));
  if (!MARKED(DEF(term), docompile )) 
    if (!MARKED(DEF(term), external )) { 
    fprintf(stderr, "%s: super meta-notion not defined as external.\n", 
           REPR(DEF(term)) );
    exit(-1);
  }
}

char * repr_empty;
list()
{
  int             rule,
                  alt;
  for (rule = lastmetarule; (rule != nil) && (!mystrcmp(REPR(rule),
                 "empty"));
      rule = BROTHER(rule));
  if (rule == nil) {
    fprintf(stderr, "glammar instalation error: empty missing\n"); 
   /* exit(12); */ 
   repr_empty = "-1";
    
  }
  else repr_empty = REPR(rule);

       
  for (rule = root; rule != laststdpred; rule = BROTHER(rule))
    for (alt = SON(rule); alt != nil; alt = BROTHER(alt))
      alt_list(alt);
  if (verbose_flag)
    fprintf(stderr, "glammar transformation fase: %d compositions resolved.\n", total_list_count);
  if (verbose_flag)
    fprintf(stderr, "glammar optimization fase: %d empty notions deleted.\n", unique_empty_count);
}


alt_list(alt)
  int             alt;
{
  int             member;

  unique_list_count = 0,
  lefths_list(alt);
  prevmem = nil;
  lastmem = alt;
  for (member = SON(alt); member != nil; member = BROTHER(member)) {
    rights_list(member);
    prevmem = member;
  }
  total_list_count += unique_list_count;
}


lefths_list(alt)
  int             alt;
{
  int             affix,last_mem,
                  term;

  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix)){
    delete_multiple_empty_terms(SON(affix));
    for (term = SON(affix); term != nil; term = BROTHER(term)) 
      if ((NODENAME(term) == factor) && (NODENAME(affix) == inherited)){
        NODENAME(term) = affixnt;
        REPR(term) = get_L();
        brother = SON(alt);
        resolve_list(SON(term), REPR(term), 1); 
        SON(alt) = brother;
      }
  }
  if (SON(alt) == nil)
      last_mem = nil;
  else  { int mem;
   for (mem = SON(alt); BROTHER(mem) != nil; mem = BROTHER(mem)); 
     last_mem = mem;
  }
  brother = nil; 
  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix))
    for (term = SON(affix); term != nil; term = BROTHER(term))
      if ((NODENAME(term) == factor) && (NODENAME(affix) == derived)){
        NODENAME(term) = affixnt;
        REPR(term) = get_L();
        resolve_list(SON(term), REPR(term), 0);
      }
  if (last_mem == nil)
        SON(alt) = brother;
  else 
        BROTHER(last_mem) = brother;
}

delete_multiple_empty_terms(prev) 
int prev ;
{
  int term  = BROTHER(prev), next;
  if (term == nil ) return;

  next = BROTHER (term);
  for (; next != nil; prev = term, term = next, next = BROTHER(next) )
    if (REPR(term) == repr_empty) {
      BROTHER(prev ) = next;
      unique_empty_count +=1;
      term = prev;
    }
}     

rights_list(mem)
  int             mem;
{
  int             affix,
                  term;

  for (affix = AFFIXTREE(mem); affix != nil; affix = BROTHER(affix))
    for (term = SON(affix); term != nil; term = BROTHER(term))
      if (NODENAME(term) == factor) {
        NODENAME(term) = affixnt;
        REPR(term) = get_L();
        if (NODENAME(affix) == derived)
          brother = BROTHER(mem);
        else
          brother = mem;
        resolve_list(SON(term), REPR(term), NODENAME(affix) == derived);
       if (NODENAME(affix) == derived)  {
          BROTHER(mem) = brother;
       } else {
          if (prevmem == nil)
            SON(lastmem) = brother;
          else 
            BROTHER(prevmem) = brother;
          for (prevmem = brother; BROTHER(prevmem) != mem; 
                 prevmem = BROTHER(prevmem)); 
          
       }
    } 
}


make_pair_node(fact, lterm, llterm)
  int             fact;
  char           *lterm,
                 *llterm;
{
  int             lbrother = brother,
                  ab;

  newnode(affixnt, nil, nil, lterm);
  newnode(inherited, nil, brother, "(nil)");
  ab = brother;
  newnode(NODENAME(fact), nil, nil, REPR(fact));
  newnode(inherited, ab, brother, "(nil)");
  ab = brother;
  newnode(affixnt, nil, nil, llterm);
  newnode(derived, ab, brother, "(nil)");
  newnode(ntnode, lbrother, brother, REPR(pair));
}


make_unpair_node(fact, lterm, llterm)
  int             fact;
  char           *lterm,
                 *llterm;
{
  int             lbrother = brother,
                  ab;

  newnode(affixnt, nil, nil, lterm);
  newnode(derived, nil, brother, "(nil)");
  ab = brother;
  newnode(NODENAME(fact), nil, nil, REPR(fact));
  newnode(derived, ab, brother, "(nil)");
  ab = brother;
  newnode(affixnt, nil, nil, llterm);
  newnode(inherited, ab, brother, "(nil)");
  newnode(ntnode, lbrother, brother, REPR(unpair));
}


make_last_pair_node(fact, bfact, lterm)
  int             fact,
                  bfact;
  char           *lterm;
{
  int             lbrother = brother,
                  ab;

  newnode(NODENAME(bfact), nil, nil, REPR(bfact));
  newnode(inherited, nil, brother, "(nil)");
  ab = brother;
  newnode(NODENAME(fact), nil, nil, REPR(fact));
  newnode(inherited, ab, brother, "(nil)");
  ab = brother;
  newnode(affixnt, nil, nil, lterm);
  newnode(derived, ab, brother, "(nil)");
  newnode(ntnode, lbrother, brother, REPR(pair));
}


make_last_unpair_node(fact, bfact, lterm)
  int             fact,
                  bfact;
  char           *lterm;
{
  int             lbrother = brother,
                  ab;

  newnode(NODENAME(bfact), nil, nil, REPR(bfact));
  newnode(derived, nil, brother, "(nil)");
  ab = brother;
  newnode(NODENAME(fact), nil, nil, REPR(fact));
  newnode(derived, ab, brother, "(nil)");
  ab = brother;
  newnode(affixnt, nil, nil, lterm);
  newnode(inherited, ab, brother, "(nil)");
  newnode(ntnode, lbrother, brother, REPR(unpair));
}


resolve_list(fact, lterm, defining)
  int             fact,
                  defining;
  char            *lterm;
{
  if (BROTHER(BROTHER(fact)) == nil) {
    if (defining)
      make_last_unpair_node(fact, BROTHER(fact), lterm);
    else
      make_last_pair_node(fact, BROTHER(fact), lterm);
  } else {
    char           *llterm;

    llterm = get_L();
    resolve_list(BROTHER(fact), llterm, defining);
    if (defining)
      make_unpair_node(fact, llterm, lterm);
    else
      make_pair_node(fact, llterm, lterm);
  }
}


wheres()
{
  int             rule,
                  alt;

  for (rule = root; rule != laststdpred; rule = BROTHER(rule))
    for (alt = SON(rule); alt != nil; alt = BROTHER(alt)) {
      alt_wheres(alt);
    }
  if (verbose_flag)
    fprintf(stderr, "glammar transformation fase: %d pairs re-arranged.\n", pair_count);
  if (verbose_flag)
    fprintf(stderr, "glammar optimization fase: %d wheres eliminated.\n", where_count);
}


alt_wheres(alt)
  int             alt;
{
  int             member;

  prevmem = nil;
  lastmem = alt;
  for (member = SON(alt); member != nil; member = BROTHER(member)) {
    if ((DEF(member) == where) &&
           (no_affix_expressions(AFFIXTREE(member)))) {
      resolve_where(alt, member);
      where_count += 1;
      if (prevmem == nil)
        SON(alt) = BROTHER(member);
      else
        BROTHER(prevmem) = BROTHER(member);
    } else
      prevmem = member;
  }
}


no_affix_expressions(affix)
  int             affix;
{
  return (BROTHER(SON(affix)) == nil) && (NODENAME(SON(affix)) ==
            affixnt) &&
    (BROTHER(SON(BROTHER(affix))) == nil);
}


resolve_where(alt, wher)
  int             alt,
                  wher;
{
  int             a1 = AFFIXTREE(wher);
  int             a2 = BROTHER(a1);

  char           *source = REPR(SON(a2));
  char           *destination = REPR(SON(a1));

  int             affix,
                  term,
                  mem;

  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix))
    for (term = SON(affix); term != nil; term = BROTHER(term))
      if (REPR(term) == source)
        REPR(term) = destination;
  for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
    for (affix = AFFIXTREE(mem); affix != nil; affix =
        BROTHER(affix))
      for (term = SON(affix); term != nil; term =
          BROTHER(term))
        if (REPR(term) == source)
          REPR(term) = destination;
}


alt_re_arrange(source, alt)
  int             source,
                  alt;
{
  if (source == nil)
    return;
  else {
    int             x = SON(alt);

    alt_re_arrange(BROTHER(source), alt);

    if (DEF(source) != pair)
      return;

    if (x == source)
      SON(alt) = BROTHER(source);
    else {
      for (; x != nil; x = BROTHER(x))
        if (BROTHER(x) == source)
          BROTHER(x) = BROTHER(source);
    }

    re_arrange_pair(source, alt);
  }
}


re_arrange_pair(between, alt)
  int             between,
                  alt;
{
  int             last,
                  first = nil;

    for (last = SON(alt); last != nil; last = BROTHER(last)) {
/*      if ((TERMINAL(last)) || (DEF(last) == equal) || (DEF(last) == notequal) ||
         (DEF(last) == pair) || (DEF(last) == cut))
 */
      if (DEF(last) != unpair)
        if ((!affix_is_needed(REPR(SON(AFFIXTREE(between))),
                AFFIXTREE(last))) || 
            (DEF(last) == pair))
          first = last;

         else
            break;
      else if ((DEF(last) == unpair) && 
               (affix_is_needed(REPR(SON(AFFIXTREE(last))),AFFIXDEF(alt))) 
              )
          first = last;
      else  break;
    }

  if (first != nil)
    last = BROTHER(first);
  else
    last = SON(alt);

  if (last == SON(alt)) {
    SON(alt) = between;
    BROTHER(between) = last;
  } else {
    BROTHER(first) = between;
    BROTHER(between) = last;
  }
}


int affix_is_needed(a, b)
  char           *a;
  int             b;
{
  int             t;

  for (; b != nil; b = BROTHER(b))
    if (NODENAME(b) == inherited)
      for (t = SON(b); t != nil; t = BROTHER(t))
        if (REPR(t) == a)
          return true;
  return false;
}


alt_add_affix_to_lifted_pair(alt)
  int             alt;
{
  int             member;
  char           *name;

  for (member = SON(alt); (member != nil); member = BROTHER(member))
    if (DEF(member) == pair) {
      int             big_brother = AFFIXTREE(member);
      int             small_brother = BROTHER(big_brother);

      name = &chartable[++charindex];
      (void) sprintf(&chartable[charindex], "P_%d", pair_count++);
      charindex += 10;
      if (charindex > maxchars) 
              alloc_chartable();
      newnode(affixnt, nil, nil, name);
      newnode(derived, small_brother, brother, "(nil)");
      BROTHER(big_brother) = brother;
    }
}


delete_superaffix_productions()
{
  int             this,prev,
                  super_rules = 0;


    for ( ;lastmetarule  != nil;  lastmetarule = BROTHER(lastmetarule)) 
      if (NODENAME(SON(lastmetarule)) != supernt) break;
    prev = lastmetarule;
    if (prev != nil)  
      for (this = BROTHER(prev); this != nil; this = BROTHER(prev)) {
         if (NODENAME(SON(this)) == supernt) {
           BROTHER(prev) = BROTHER(this);
             super_rules += 1;
          }
          else prev = this;
      }
    if (verbose_flag)
          fprintf(stderr, "glammar transformation fase: %d super affixes deleted\n", super_rules);
}

