/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*             fill in implied equals 
               fill in intersections for lattices
               compute affix usage 
               for each rule compute its "check sum"
                     used for separate compilation
*/
#include "gg1.h"
#include "gg2.h"
int             unique_e_count = 0,total_e_count= 0;
int             dc_count = 0;
char           *lran = "error_affiX";

char * hex_repr();
char * get_ie();

char small_ie[10][4] = {
  "E_0",
  "E_1",
  "E_2",
  "E_3",
  "E_4",
  "E_5",
  "E_6",
  "E_7",
  "E_8",
  "E_9",
};

ie()
{
  int             rule,
                  alt;

  for (rule = root; rule != laststdpred; rule = BROTHER(rule))
/*    if (MARKED(rule,docompile)) */
    for (alt = SON(rule); alt != nil; alt = BROTHER(alt))
      altie(alt);
  if (verbose_flag)
    fprintf(stderr, "glammar transformation fase: %d implied equals resolved\n", total_e_count);
}


altie(alt)
  int             alt;
{
  int             member,
                  affix;
  unique_e_count = 0;
  lefthsie(alt);
  for (member = SON(alt); member != nil; member = BROTHER(member))
    for (affix = AFFIXTREE(member); affix != nil; affix = BROTHER(affix))
      if (REPR(SON(affix)) == dont_care);
      else if (DERIVED(affix) )
        rightsie(alt, member, affix);
      else if (LATTICE(affix)) {
        if (!right_implicite_intersect(alt, member, affix))
          right_explicite_intersect( member, affix);
      }
  total_e_count += unique_e_count;
}


lefthsie(alt)
  int             alt;
{
  int             affix;

  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix)) {
    if (INHERITED(affix) && REPR(SON(affix)) != dont_care) 
      if (APPLY_BOUND_AFFIX(SON(affix)) ) {
        int             afx;

        for (afx = BROTHER(affix); afx != nil;
            afx = BROTHER(afx)) {
          if ((INHERITED(afx)) &&
              (REPR(SON(affix)) == REPR(SON(afx)))) {
            char           *name;

            name = get_ie();
            REPR(SON(afx)) = name;
            LEFTDEF(SON(afx)) = -1;
            newnode(inherited, nil, SON(afx), "(nil)");
            newnode(inherited, brother, SON(affix), "(nil)");
            newdefnode(ntnode, SON(alt), brother, equal, REPR(equal));
            SON(alt) = brother;
          }
        }
      } else {
        char           *name;
        int             term = SON(affix),
                        atype = NODENAME(term);
        name = get_ie();
        newnode(atype, BROTHER(term), nil, REPR(term));
        newnode(inherited, nil, brother, "(nil)");
        newnode(inherited, brother, term, "(nil)");
        newdefnode(ntnode, SON(alt), brother, equal, REPR(equal));
        SON(alt) = brother;
        NODENAME(term) = affixnt;
        BROTHER(term) = nil;
        REPR(term) = name;
        LEFTDEF(term) = -1;
      }
  }

}

char *get_ie()  {
   if ( unique_e_count >9)  {
      char * name;
      name = &chartable[++charindex];
      (void) sprintf(&chartable[charindex], "E_%d", unique_e_count++);
      charindex += 10;
      if (charindex > maxchars)
         alloc_chartable();
      return name;
   }
   return small_ie[unique_e_count++];
}

rightsie(alt, member, affix)
  int             alt,
                  member,
                  affix;
{
  int             mem,
                  afx;

  if (APPLY_BOUND_AFFIX(SON(affix)) ) {
    for (afx = AFFIXDEF(alt); afx != nil; afx = BROTHER(afx)) {
      if (INHERITED(afx))
        if (REPR(SON(afx)) == REPR(SON(affix))) {
          if (DEF(member) == nestarset) {
            DEF(member) = metaterminal;
            REPR(member) = REPR(metaterminal);
            NODENAME(affix) = inherited;
          } else {
            char           *name;
            name = get_ie();
            REPR(SON(affix)) = name;
            LEFTDEF(SON(affix)) =
              -1;
            newnode(inherited, nil, SON(afx), "(nil)");
            newnode(inherited, brother, SON(affix), "(nil)");
            newdefnode(ntnode, BROTHER(member), brother, equal, REPR(equal));
            BROTHER(member) = brother;
            return;
          }
        }
    }

    for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
      for (afx = AFFIXTREE(mem); afx != nil; afx = BROTHER(afx)) {
        if (afx == affix)
          return;
        if ((NODENAME(afx) == derived) && (NODENAME(SON(afx)) == affixnt) &&
          (REPR(SON(afx)) == REPR(SON(affix)))) {
          if (DEF(member) == nestarset) {
            DEF(member) = metaterminal;
            REPR(member) = REPR(metaterminal);
            NODENAME(affix) = inherited;
          } else {
            char           *name;
            name = get_ie();
            REPR(SON(affix)) = name;
            LEFTDEF(SON(affix)) = -1;
            newnode(inherited, nil, SON(afx), "(nil)");
            newnode(inherited, brother, SON(affix), "(nil)");
            newdefnode(ntnode, BROTHER(member), brother, equal, REPR(equal));
            BROTHER(member) = brother;
            return;
          }
        }
      }
  } else {
    char           *name;
    int             term = SON(affix),
                    atype = NODENAME(term);
    name = get_ie();
    newnode(atype, BROTHER(term), nil, REPR(term));
    newnode(inherited, nil, brother, "(nil)");
    newnode(inherited, brother, term, "(nil)");
    newdefnode(ntnode, BROTHER(member), brother, equal, REPR(equal));
    BROTHER(member) = brother;
    NODENAME(term) = affixnt;
    BROTHER(term) = nil;
    REPR(term) = name;
    LEFTDEF(term) = -1;
  }
}


int right_implicite_intersect(alt, member, affix)
int           alt, member, affix;
{
   int             mem, afx;
   for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
      for (afx = AFFIXTREE(mem); afx != nil; afx = BROTHER(afx)) {
         if (afx == affix)
            return false;
         if ((LATTICE(afx)) && (REPR(SON(afx)) == REPR(SON(affix)))) {
            char           *name;
            name = get_ie();
            REPR(SON(affix)) = name;
            LEFTDEF(SON(affix)) = -1;
            newnode(inherited, nil, SON(afx), "(nil)");
            newnode(inherited, brother, SON(affix), "(nil)");
            newdefnode(ntnode, BROTHER(member), brother, intersect, 
                REPR(intersect));
            BROTHER(member) = brother;
            return true;
         }
      }
   return false;
}

right_explicite_intersect(member, affix)
int member, affix;
{
   if (lattice_top(affix))
       return ;
    newnode(affixtm, nil,nil,hex_repr(NODENAME(LATTICE_DEF(SON(affix)))));
    newnode(inherited, nil, brother, "(nil)");
    newnode(inherited, brother, SON(affix), "(nil)");
    newdefnode(ntnode, BROTHER(member), brother, explintersect, 
        REPR(explintersect));
    BROTHER(member) = brother;
}

char * hex_repr(repr)
int repr;
{
    char           *name;
    name = &chartable[++charindex];
    (void) sprintf(&chartable[charindex], "%d", repr);
    charindex += 20;
    if (charindex > maxchars)
        alloc_chartable();
    return name;
}


affixuse()
{
   register int    term,
                   mem,
                   affix;
   int             rule,
                   alt,
                   count,
                   afx,
                   optimized = 0;
   for (rule = root; rule != laststdpred; rule = BROTHER(rule)) {
      sum = init_sum;
      for (alt = SON(rule); alt != nil; SUM_ALT, alt = BROTHER(alt)) {
	 count = 0;
	 for (afx = AFFIXDEF(alt); afx != nil; afx = BROTHER(afx)) {
	    register int    trm = SON(afx);
	    if (REPR(trm) == dont_care) {
	       DONTCARE(trm);
	       SUM_DC;
	       continue;
	    }
	    for (; trm != nil; trm = BROTHER(trm))
	       if (NODENAME(trm) == superaffix) {
		  NODENAME(trm) = affixnt;
		  LEFTDEF(trm) = -1;
	       }
	    trm = SON(afx);
	    if ((BROTHER(trm) == nil) && (NODENAME(trm) == affixnt)) {
	       if (INHERITED(afx))
		  LEFTDEF(trm) = count;
	       for (affix = AFFIXDEF(alt);
		     affix != nil; affix = BROTHER(affix)) {
		  term = SON(affix);
		  if (BROTHER(term) != nil) {
		     for (; term != nil; term = BROTHER(term))
			if ((NODENAME(trm) == affixnt)
			      && (REPR(term) == REPR(trm))
			      && (term != trm)) {
			   LEFTDEF(term) = count;
			   optimized += 1;
			   SUM_LD;
			}
		  } else if ((DERIVED(affix)) && (INHERITED(afx)) &&
			     (REPR(term) == REPR(trm))) {
		     LEFTDEF(term) = count;
		     optimized += 1;
		     SUM_LD;
		  }
	       }
	       for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
		  for (affix = AFFIXTREE(mem); affix != nil;
			affix = BROTHER(affix)) {
		     for (term = SON(affix); term != nil; term = BROTHER(term))
			if (NODENAME(term) == superaffix) {
			   NODENAME(term) = affixnt;
			   LEFTDEF(term) = -1;
			   SUM_NOLD;
			}
		     for (term = SON(affix); term != nil; term = BROTHER(term))
			if ((NODENAME(trm) == affixnt) && (REPR(term) == REPR(trm)))
			   if ((!IS_LEFTDEF(term)) || (INHERITED(afx))) {
			      LEFTDEF(term) = count;
			      optimized += 1;
			      SUM_LD;
			   }
		  }
	    }
	    count += 1;
	 };
	 mem_dont_care_affixes(SON(alt));
        alt_not_used_affixes(alt); 
	 alt_checksum_afx_terms(alt);
      }
   SUM(rule) = sum;
   sum = init_sum; 
   }
   if (verbose_flag) {
      fprintf(stderr, "glammar optimizer: %d left defined affixes used stand alone in right positions.\n", optimized);
      fprintf(stderr, "glammar optimizer: %d affixes marked don't care.\n", dc_count);
   }
}

static int a_s, m_s;

alt_checksum_afx_terms(alt)
int alt;
{
 int mem, affix, term;
  a_s = 0;
  for (affix = AFFIXDEF(alt); affix != nil; SUM_AFX,affix = BROTHER(affix)) 
    for (term = SON(affix); term != nil; SUM_TERM,term = BROTHER(term)) {
      a_s +=1;
      sum += affixtm_sum(REPR(term));
      if (NODENAME(term) == affixtm)  sum += 1124; 
    }
  m_s = 0;
  for (mem = SON(alt); mem != nil; SUM_MEM,mem = BROTHER(mem))  {
    m_s += 1;
    if (TERMINAL(mem))  sum += 321; 
    else if (MARKED(DEF(mem),deterministic)) 
       m_s += 10;
    sum -= affixtm_sum(REPR(mem));
    a_s =0;
    for (affix = AFFIXTREE(mem); affix != nil; SUM_AFX,affix = BROTHER(affix)) 
       for (term = SON(affix); term != nil; SUM_TERM,term = BROTHER(term)) {
          a_s +=1;
          sum += affixtm_sum(REPR(term));
          if (NODENAME(term) == affixtm)  sum += 871; 
       }
  }
}

affixtm_sum(repr)
register char * repr;
{
    register int r = m_s+ a_s, pos = r;
    while (*repr != '\0') 
        r += (*repr++ + m_s + a_s) << (pos++ & 15);
    return r & 32767;
}
   
mem_dont_care_affixes(mem)
register int mem;
{
   register int afx;
   for (; mem != nil; SUM_MEM,mem = BROTHER(mem))
     for (afx = AFFIXTREE(mem); afx != nil; SUM_AFX,afx = BROTHER(afx))
       if (REPR(SON(afx)) == dont_care)
          SUM_DC,DONTCARE(SON(afx));
} 

alt_not_used_affixes(alt)
register int alt;
{
   register int mem,afx,trm,term;
   for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
     if (TERMINAL(mem) || DEF(mem) <= laststdpred)
     for (afx = AFFIXTREE(mem); afx != nil; afx = BROTHER(afx))
       if (DERIVED(afx) && NOT_IS_LEFTDEF(SON(afx))) {
          term = SON(afx);
          if (affix_not_used_in_lhs(AFFIXDEF(alt),REPR(term)) &&  
            affix_not_used_in_rhs(SON(alt),REPR(term)) )  {
             DONTCARE(term); 
             dc_count +=1; 
             SUM_DC;
          }
       }
} 

affix_not_used_in_lhs(afx,repr)
register int afx;
register char *repr; 
{
    register int term;
   for (; afx != nil; afx = BROTHER (afx) )
      if (DERIVED(afx)) 
         for (term = SON(afx); term != nil; SUM_TERM,term = BROTHER (term) ) 
            if (REPR(term) == repr) return false;
   return true;
}

affix_not_used_in_rhs(mem,repr)
register int mem;
register char *repr; 
{
  register int afx,term;
  for (; mem != nil; mem = BROTHER (mem) )
    for (afx = AFFIXTREE(mem); afx != nil; afx = BROTHER (afx) )
      if (INHERITED(afx)) 
         for (term = SON(afx); term != nil; term = BROTHER (term) ) 
            if (REPR(term) == repr) return false;
   return true;
}

copyafx(afx)
  int             afx;
{
  if (afx == nil)
    return;
  copyafx(BROTHER(afx));
  if (INHERITED(afx)) {
    newnode(affixtm, brother, nil, ") ");
    copyterm(SON(afx));
    newnode(affixtm, brother, nil, " (");
  }
}

copyterm(term)
  int             term;
{
  if (term == nil)
    return;
  copyterm(BROTHER(term));
  newnode(NODENAME(term), brother, nil, REPR(term));
}
