/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* hash names */
#include "gg1.h"
#include "gg2.h"
int nr_names = 0;
initnametable()
{
   register int    count;
   count = 0;
   while (count < maxnt)
      nametable[count++] = NULL;
}


addname()
{
   int             count,
                   limit;
   count = hashindex;
   limit = (hashindex - 1) & (maxnt - 1);
   if (count > maxnt) {
     fprintf(stderr, "compiler error in `addname': index too high (max = %d)\n",
              maxnt);
      fprintf(stderr, "   count = %d, limit = %d, line = %d\n ",
              count, limit, line);
      exit(3);
   }
   while (nametable[count] != NULL && count != limit) {
      if (mystrcmp(&(chartable[prevcharindex]), nametable[count])) {
         string = nametable[count];
         charindex = prevcharindex;
         return;
      }
      name_clashes += 1;
      if (++count == maxnt)
         count = 0;
   }
   if (count == limit) {
      fprintf(stderr, "compiler error: nametable overflow\n");
      fprintf(stderr, " -- index = %d, name = `%s', line = %d\n",
              count, &(chartable[prevcharindex]), line);
      exit(18);
   }
   nr_names += 1;
   nametable[count] = &chartable[prevcharindex];
   string = nametable[count];
   chartable[charindex++] = '\0';
   prevcharindex = charindex;
   if (charindex >= maxchars -256)
       alloc_chartable();
   return;
}

mystrcmp(s1, s2)
   register char  *s1,
                  *s2;
{
   while (*s1 == *s2++) {
      if (*s1++ == '\0')
         return true;
   }
   return false;
}



#define TESTletter  (isalpha (thischar) )
#define TESTmorename  (isalnum (thischar) )

name()
{
   int             curchar;
   if (!TESTletter)
      return false;
   hashindex = 0;
   curchar = 0;
   do {
      chartable[charindex++] = thischar;
      hashindex += thischar << (++curchar & 7);
      getnextchar();
   } while (TESTmorename);
   if (thischar == '\'') {
      chartable[charindex++] = thischar;
      hashindex += thischar << (++curchar & 7);
      getnextchar();
   }
   hashindex &= (maxnt - 1);
   chartable[charindex++] = '\0';
   addname();
   return true;
}

#define USC  (underscore_allowed && (thischar == '_'))
#define ALFA  (isalpha(thischar))
#define ALNUM  (isalnum(thischar))
#define OPEN  (thischar == '(')
#define SEQ  (thischar == '*' || thischar == '+'  || thischar == '?'|| thischar == '\'')
#define TESTletter_open   (ALFA || OPEN || SEQ)
#define TESTmore_name_display   (ALNUM || OPEN || SEQ || USC)

name_display_mix()
{
   int             curchar=0,nmix=0,hashidx = 0;
   char nm[10000];

   if (!TESTletter_open )
      return false;
   lastaffixtree = nil;
   brother = nil;
   while (TESTmore_name_display)
      if (mdisplay());
      else if (thischar == '\'') {
         nm[nmix++] = '_';
         nm[nmix++] = '0';
         hashidx += '_' << (++curchar & 7);
         getnextchar();
      }
      else if (thischar == '*') {
         nm[nmix++] = '_';
         nm[nmix++] = '1';
         hashidx += '_' << (++curchar & 7);
         hashidx += '*' << (++curchar & 7);
         getnextchar();
      }
      else if (thischar == '+') {
         nm[nmix++] = '_';
         nm[nmix++] = '2';
         hashidx += '+' << (++curchar & 7);
         getnextchar();
      }
      else if (thischar == '?') {
         nm[nmix++] = '_';
         nm[nmix++] = '4';
         hashidx += '?' << (++curchar & 7);
         getnextchar();
      }

      else {
         nm[nmix++] = thischar;
         hashidx += thischar << (++curchar & 7);
         getnextchar();
      }
   hashidx &= (maxnt - 1);
   hashindex = hashidx;
   nm[nmix] = '\0';
   for (nmix = 0;nm [nmix] != '\0'; )
      chartable[charindex++] = nm[nmix++] ;
   chartable[charindex++] = '\0';
   addname();
   ntname = string;
   return true;
}


mdisplay()
{
   if (open_symbol()) {
      int first = lastaffixtree;
      brother = nil;
      affixes();
      if (first == nil)
        lastaffixtree = brother;
      else {
       int afx;
       for (afx=first; BROTHER (afx) != nil; afx = BROTHER(afx));
       BROTHER(afx) = brother;
       lastaffixtree = first;
       brother = first;
     } 
     if (close_symbol());
     else {
         errmsg("CLOSE symbol");
         skiptopoint_symbol();
         rules(rnode);
         usefullerrmsg = false;
      }
      return true;
   }
   return false;
}

/* name_display()
{
   if (name() ) {
     ntname = string;
     displayoption();
     return true;
   }
   return false;
}
*/

alloc_chartable() {
  chartable = (char *) malloc((maxchars + 32));
  charindex = 0;
  symbol_table_size += maxchars+32;
  prevcharindex = 0;
  if (ast == NULL) {
   fprintf(stderr,"glammar fatal msg: no %d bytes available for symbol table\n",
       maxchars);
   exit(1);
  }
  if (verbose_flag) 
   fprintf(stderr,"alloc sym: %d bytes available for sym space\n",maxchars);
}
