/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 * file: mp.c last modified: Fri May 18 09:57:36 MET DST 1990
 *
 */

#include <mp.h>
#include <stdio.h>
#include <ctype.h>

#define true 1
#define false 0

MINT * dectoint ();

#define MAX_SHORT 32767
#define MIN_SHORT -32768

typedef struct affix_struct {
  char           *t;
  struct affix_struct  *l, *r;
} affix,*AFFIX;

extern AFFIX first_meta,last_meta; 

typedef union {
  void             (*q) ();
  int           *i;
  char           *s;
  char          **l;
  AFFIX   a;
}               cont;


extern cont     words[],*q_top;
extern char    *input;
extern char    *cstore,*cstore_top;

extern cont    *q;
extern char *fast_list_acces;
extern char    *ip, *mip, *set_ip_start_pos, *limitip, *undefined, *empty, *c;

extern int      rcount, rmax, set_ip_start_num, cssize;
extern int      parsecount, nrofchars, level, eval_count, 
                interesting_level_number, backtrace;
extern char     in_file_name[256], out_file_name[256], current_file_name[256];
extern char    *thischar;
extern FILE    *inputfile,*output;
extern int             set_line_num;
extern char            *set_line_pos;
extern char            *set_file_name ;
extern char            *inputbuff;
extern int             change_line_file;


extern char *argv[11];

extern affix *af;

#define nil NULL
#define ASSIGN(x,tr,lf,rt) (*(x)).t = tr ;(*(x)).l = lf;(*(x)).r = rt
#define COPY(x,y) (x)->t = (y)->t ; (x)->l = (y)->l ; (x)->r = (y)->r
#define SAVE(x,y) x.t = (y)->t ; x.l = (y)->l ; x.r = (y)->r
#define RESTORE(x,y) (x)->t = y.t;  (x)->l = y.l;  (x)->r = y.r
#define SHARE(x,y) (x)->t = empty ; (x)->l = nil ; (x)->r = y
#define MAKE(x,y) if ( (y)->t == undefined) { SHARE(x,y);} else { COPY (x,y); }
#define CONTINUE  q -=1;(*(*(q+1)).q)()



#define GET_MINT_ADDR(mint,str)\
{ register char *d = (char *) & mint;\
   register char *rc = str; \
   if ( (rc[0] == '\002') && (rc[5] == '\002') && (rc[6] == '\000')) {\
   d [0] = rc [1] ; d[1] = rc [2]; d [2] = rc [3];\
      d[3] = rc[4];\
   } else mint = (MINT *) -1;\
}
                                

#define PUT_MINT_ADDR(mint)\
 { register unsigned long d = (unsigned long)  mint;\
   register char *rc = c; rc[0] = '\002' ; rc[1] = (char) (d >>24);\
   rc [2] = (char) (d>>16); rc [3] = (char) (d >>8); rc [4] = (char) d ;\
   rc [5] = '\002'; rc [6] = '\0'; c = rc+7;} 
                                


#ifdef DMP

short szero = 0;
MINT mzero_ = {1,&szero};
MINT *mzero = &mzero_;

/*  intplusintisint   */
int dintplusintisint(A,B,C)
register AFFIX A;
register AFFIX B;
register AFFIX C;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  m3 = itom(0);
  madd (m1,m2,m3);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  return true;

}

/*  intsubintisint   */
int dintsubintisint(A,B,C)
register AFFIX A;
register AFFIX B;
register AFFIX C;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }

  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  m3 = itom(0);
  msub (m1,m2,m3);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  return true;

}



/*  inttimesintisint   */
int dinttimesintisint(A,B,C)
register AFFIX A;
register AFFIX B;
register AFFIX C;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  m3 = itom(0);
  mult (m1,m2,m3);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  return true;

}


/*  intdividedbyintisintwithremainderint   */
int dintdividedbyintisintwithremainderint(A,B,C,D)
register AFFIX A;
register AFFIX B;
register AFFIX C;
register AFFIX D;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3,*m4;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  m3 = itom(0);
  m4 = itom(0);
  mdiv (m1,m2,m3,m4);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  D->t = c;
  D->l = nil;
  D->r = nil;
  PUT_MINT_ADDR(m4);
  return true;
}


/*  intisint   */
int dintisint(A,B,C)
register AFFIX A;
register AFFIX B;
register AFFIX C;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2;
  int i;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((C->r == nil) && (C->l == nil)) xs = C->t;
  else {
    sprinta(C);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  i = mcmp (m1,m2);
  if (i == 0)
     B->t = "0";
  else if (i < 0)
     B->t = "-1";
  else 
     B->t = "1";
  B->l = nil;
  B->r = nil;
  return true;

}

/*  intraisedbyintmodulointisint   */
int dintraisedbyintmodulointisint(A,B,C,D)
register AFFIX A;
register AFFIX B;
register AFFIX C;
register AFFIX D;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3,*m4;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  if ((C->r == nil) && (C->l == nil)) xs = C->t;
  else {
    sprinta(C);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m3,xs);
  if ( (int) m3 == -1)  return false;
  c = csave;
  m4 = itom(0);
  pow (m1,m2,m3,m4);
  D->t = c;
  D->l = nil;
  D->r = nil;
  PUT_MINT_ADDR(m4);
  return true;
}


/*  intisthegcdofintandint   */
int dintisthegcdofintandint(C,A,B)
register AFFIX C;
register AFFIX A;
register AFFIX B;
{
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  if ((B->r == nil) && (B->l == nil)) xs = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m2,xs);
  if ( (int) m2 == -1)  return false;
  c = csave;
  m3 = itom(0);
  gcd (m1,m2,m3);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  return true;

}

/*  intisthesquarerootofintwithremainderint   */
int dintisthesquarerootofintwithremainderint(C,A,B)
register AFFIX C;
register AFFIX A;
register AFFIX B;
{
 
  char           *xs = c, *csave = c;
  MINT   *m1,*m2,*m3;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = csave;
  m2 = itom(0);
  m3 = itom(0);
  msqrt (m1,m2,m3);
  B->t = c;
  B->l = nil;
  B->r = nil;
  PUT_MINT_ADDR(m2);
  C->t = c;
  C->l = nil;
  C->r = nil;
  PUT_MINT_ADDR(m3);
  return true;

}

int ddecisint(A,B)
register AFFIX A, B;
{
   MINT *M ;
   register char *xs =c, *csave =c;
   if ((A->r == nil) && (A->l == nil)) xs = A->t;
   else {
      sprinta(A);
      *c++ = '\0';
   }
   M = dectoint(xs);
   c = csave;
   B->t = c;
   B->l = nil;
   B->r = nil;
   PUT_MINT_ADDR(M); 
   return true;
}

int dinitmint_(A,B)
register AFFIX A, B;
{
   MINT *M ;
   register char *xs =c, *csave =c;
   if ((B->r == nil) && (B->l == nil)) xs = B->t;
   else {
      sprinta(B);
      *c++ = '\0';
   }
   M = dectoint(xs);
   c = csave;
   A->t = c;
   A->l = nil;
   A->r = nil;
   PUT_MINT_ADDR(M); 
   return true;
}
/*  intisdec   */
int dintisdec(A,B)
register AFFIX A, B;
{
   register char           *xs = c, *rc =c;
   MINT   *m1;
   if ((A->r == nil) && (A->l == nil)) xs = A->t;
   else {
      sprinta(A);
      *c++ = '\0';
   }
   B ->t = rc;
   B ->r = nil;
   B ->l = nil;
   if (*xs == '\002') { 
       MINT *cpy =  itom(0), *dmy = itom(0);
       
       GET_MINT_ADDR(m1,xs);
       madd (m1,dmy,cpy);
      inttodec(cpy);
      mfree(cpy);
      *c++ = '\0';
      return true;
   }
   return false;
}


#define Base 10000
inttodec(A)
MINT *A;
{
   int len = A -> len;
   short *val = A -> val;
   MINT *R;
   if (len < 0) {
      len = -len;
      A -> len = len;
      *c++ = '-';
   }
   if (len == 1) {
      register char * rc =c;
      sprintf(rc,"%d",(int) *val);
      while (*++rc !=  '\0') ;
      c = rc;
      return;
   }
   else if (len == 0) {
      *c++ =  '0';
      *c =  '\0';
      return;
   }
   R = itom(0);
   sdiv (A,Base,R,val);
   inttodec(R);
   mfree(R);
   {
      short v = *val;
      register char * rc =c;
      if (v < 1000)
         *rc++ = '0';
      if (v < 100)
         *rc++ = '0';
      if (v < 10)
         *rc++ = '0';
      sprintf(rc,"%d", (int) v);
      while (*++rc !=  '\0') ;
      c = rc;
      return;
   }
}

static MINT * Mint_10, *R; 

int first_time_dec_to_mint =1;

MINT * dectoint (str)
register  char *str;
{
  MINT * bignum;
  int negate;
  if (first_time_dec_to_mint) {
      Mint_10 = itom(10);
      R  = itom(0);
      first_time_dec_to_mint =0;
  }
  if (str[0] == '-') {
    str++;
    negate = 1;

  } else {
    negate = 0;
  }

  bignum = itom(0);
  while (*str) {
    if (*str < '0' || *str > '9')
      return bignum;
    mult(Mint_10,bignum,R);
    madd(R , itom(*str++ - '0'),bignum);
  }
  if (negate) bignum  -> len = - (bignum -> len);
  return (bignum);
}


/*  freeint   */
int dfreeint(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 != -1)  mfree(m1);
  c = rc;
  A->t = rc;
  A->l = nil;
  A->r = nil;
  PUT_MINT_ADDR(mzero);
  return true; 
}


/*  decrementint   */
int ddecrementsmallint(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  short *val;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  
  val = m1 -> val; 
  if (m1 -> len  == 1)  {
       if (*val == 0)  {
            *val = 1;
            m1 -> len = -1;
       }
       else  
          *val -= 1; 
  } else if (m1 -> len  == -1)  {
          *val += 1; 
  } else return false;
  
  c = rc;
  return true; 
}

   
/*  incrementint   */
int dincrementsmallint(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  short *val;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
 
  val = m1 -> val; 
  if (m1 -> len  == 1)  {
       if (*val == 0)  {
            *val = 1;
            m1 -> len = 1;
       }
       else  
          *val += 1; 
  } else if (m1 -> len  == -1)  {
       if (*val == 0)  {
            *val = 1;
            m1 -> len = 1;
       }
       else  
          m1 -> val -= 1; 
  } else return false;
  
  c = rc;
  return true; 
}

   

/*  smalldecisint   */
int dsmalldecisint(A,B)
register AFFIX A;
register AFFIX B;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  int i;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  c = rc;
  i = atoi(xs);
  if (i > MAX_SHORT)
        return false;
  if  (i < MIN_SHORT) 
        return false;
  sprintf(c,"%d",i);
  c += 6;
  m1 = itom((short) i);
  B -> t  = c;
  B -> r = nil;
  B -> l = nil;
  PUT_MINT_ADDR(m1);
  return true;
}

/*  intisnegative   */
int dintisnegative(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = rc;
  return (m1->len <0);
}


/*  negateint   */
int dnegateint(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = rc;
  m1->len = -m1->len;
  return true;
}



/*  intispositive   */
int dintispositive(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = rc;
  return (m1->len >0);
}



/*  intiszero   */
int dintiszero(A)
register AFFIX A;
{
  register char *rc = c,  *xs = rc;
  MINT   *m1;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_MINT_ADDR(m1,xs);
  if ( (int) m1 == -1)  return false;
  c = rc;
  return (m1->len == 1 && *(m1->val) == 0);
}
#endif

#ifdef UMP
void uintplusintisint () {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dintplusintisint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uintplusintisint;
   q = rq+1;
}

void uintsubintisint () {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dintsubintisint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uintsubintisint;
   q = rq+1;
}

void uinttimesintisint () {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dinttimesintisint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uinttimesintisint;
   q = rq+1;
}

void uintdividedbyintisintwithremainderint () {
   register cont *rq = q;
register AFFIX D = (rq+0)-> a;
register AFFIX C = (rq+-1)-> a;
register AFFIX B = (rq+-2)-> a;
register AFFIX A = (rq+-3)-> a;
   if (dintdividedbyintisintwithremainderint(A,B,C,D))
   {
      q=rq+-5;
      (*(rq+-4)->q)();
      rq=q- -4;
   }
   (rq+-3)->a = A;
   (rq+-2)->a = B;
   (rq+-1)->a = C;
   (rq+0)->a = D;
   (rq+1)-> q = uintdividedbyintisintwithremainderint;
   q = rq+1;
}

void uintisint () {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dintisint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uintisint;
   q = rq+1;
}

void uintraisedbyintmodulointisint () {
   register cont *rq = q;
register AFFIX D = (rq+0)-> a;
register AFFIX C = (rq+-1)-> a;
register AFFIX B = (rq+-2)-> a;
register AFFIX A = (rq+-3)-> a;
   if (dintraisedbyintmodulointisint(A,B,C,D))
   {
      q=rq+-5;
      (*(rq+-4)->q)();
      rq=q- -4;
   }
   (rq+-3)->a = A;
   (rq+-2)->a = B;
   (rq+-1)->a = C;
   (rq+0)->a = D;
   (rq+1)-> q = uintraisedbyintmodulointisint;
   q = rq+1;
}

void uintisthegcdofintandint () {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dintisthegcdofintandint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uintisthegcdofintandint;
   q = rq+1;
}


void uintisthesquarerootofintwithremainderint() {
   register cont *rq = q;
register AFFIX C = (rq+0)-> a;
register AFFIX B = (rq+-1)-> a;
register AFFIX A = (rq+-2)-> a;
   if (dintisthesquarerootofintwithremainderint(A,B,C))
   {
      q=rq+-4;
      (*(rq+-3)->q)();
      rq=q- -3;
   }
   (rq+-2)->a = A;
   (rq+-1)->a = B;
   (rq+0)->a = C;
   (rq+1)-> q = uintisthesquarerootofintwithremainderint;
   q = rq+1;
}

void udecisint () {
   register cont *rq = q;
register AFFIX B = (rq+0)-> a;
register AFFIX A = (rq+-1)-> a;
   if (ddecisint(A,B))
   {
      q=rq+-3;
      (*(rq+-2)->q)();
      rq=q- -2;
   }
   (rq+-1)->a = A;
   (rq+0)->a = B;
   (rq+1)-> q = udecisint;
   q = rq+1;
}
void uintisdec () {
   register cont *rq = q;
register AFFIX B = (rq+0)-> a;
register AFFIX A = (rq+-1)-> a;
   if (dintisdec(A,B))
   {
      q=rq+-3;
      (*(rq+-2)->q)();
      rq=q- -2;
   }
   (rq+-1)->a = A;
   (rq+0)->a = B;
   (rq+1)-> q = uintisdec;
   q = rq+1;
}

void ufreeint () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dfreeint(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = ufreeint; 
   q = rq+1; 
}

void udecrementsmallint () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (ddecrementsmallint(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = udecrementsmallint; 
   q = rq+1; 
}

void uincrementsmallint () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dincrementsmallint(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = uincrementsmallint; 
   q = rq+1; 
}

void usmalldecisint () { 
   register cont *rq = q;
register AFFIX B = (rq+0)-> a;
register AFFIX A = (rq+-1)-> a;
   if (dsmalldecisint(A,B))
   { 
      q=rq+-3;
      (*(rq+-2)->q)();
      rq=q- -2;
   }
   (rq+-1)->a = A;
   (rq+0)->a = B;
   (rq+1)-> q = usmalldecisint; 
   q = rq+1; 
}

void uintisnegative () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dintisnegative(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = uintisnegative; 
   q = rq+1; 
}

void unegateint () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dnegateint(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = unegateint; 
   q = rq+1; 
}

void uintispositive () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dintispositive(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = uintispositive; 
   q = rq+1; 
}

void uintiszero () { 
   register cont *rq = q;
register AFFIX A = (rq+0)-> a;
   if (dintiszero(A))
   { 
      q=rq+-2;
      (*(rq+-1)->q)();
      rq=q- -1;
   }
   (rq+0)->a = A;
   (rq+1)-> q = uintiszero; 
   q = rq+1; 
}
#endif
