/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef UEQUAL 

void uequal() {   /* equal */
register AFFIX B = q ->a;
register AFFIX A  = (q-1) ->a;
   affix x, y;
   char *csave = c;
   register char *xs = c,*ys;
   q -=2;
   SAVE (x,A);
   SAVE (y,B);
   if ( A==B ) {
      CONTINUE;
   }
   else { 
      if ( ( x.r == nil) && (x.l == nil ) )
           xs  = x.t;
      else {
         sprinta(A);
         A -> t = xs; A -> l = nil; A -> r = nil;
         *c++ = '\0';
       }
      ys = c;
      if ( ( y.r == nil) && (y.l == nil ) )
         ys  = y.t;
      else { 
         sprinta(B);
         B -> t = ys;
         B -> l = nil;
         B -> r = nil;
         *c++ = '\0';
       }
       if (afxcmp(xs,ys)==0) {
         CONTINUE;
       }
   }
   c = csave;
   RESTORE(A,x);
   RESTORE(B,y);
   (q+1) -> a = A;
   (q+2) -> a = B;
   (q+3) -> q = uequal;
   q +=3;
}
#endif

#ifdef UNOTEQUAL 
void unotequal() {   /* notequal */

register AFFIX B = (q) ->a;
register AFFIX A = (q-1) ->a;
   affix x,y;
   char *csave = c;
   register char *xs = c,*ys;
   q -=2;
   SAVE (x,A);
   SAVE (y,B);
   if (A == B) 
	  goto done;
   if ( ( x.r == nil) && (x.l == nil ) )
      xs  = x.t;
   else  {
      sprinta(A);
      A -> t = xs;
      A -> l = nil;
      A -> r = nil;
      *c++ = '\0';
   }
   ys = c;
   if ( ( y.r == nil) && (y.l == nil ) )
     ys  = y.t;
   else {
      sprinta(B);
      B -> t = ys;
      B -> l = nil;
      B -> r = nil;
      *c++ = '\0';
   }
   if (afxcmp(xs,ys)==0) 
         goto done;
go:
   CONTINUE;
done:
   RESTORE(A,x);
   RESTORE(B,y);
   (q+1) -> a = A;
   (q+2) -> a = B;
   (q+3) -> q = unotequal;
   q +=3;
   c = csave;
}
#endif

#ifdef UFQUAL 
void ufqual () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( ddfqual (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ufqual; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef UFOTEQUAL 
void ufotequal () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( ! ddfqual (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ufotequal; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef UCOMPARE 
void ucompare () 
{ 
   register cont *rq = q;
register AFFIX A_3 = rq->a;
register AFFIX A_2 = (rq -1)->a;
register AFFIX A_1 = (rq -2)->a;
register AFFIX A_0 = (rq -3)->a;
   char *rc = c; 
   if ( dcompare (A_0, A_1, A_2, A_3)) {
      q = rq -5;
      (*(rq -4)->q)(); 
      rq = q +4;
   }
   (rq -3)->a = A_0;
   (rq -2)->a = A_1;
   (rq -1)->a = A_2;
   rq->a = A_3;
   (rq + 1)->q = ucompare; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef UCONTENTSOF 
void ucontentsof () 
{ 
   register cont *rq = q;
register AFFIX A_3 = rq->a;
register AFFIX A_2 = (rq -1)->a;
register AFFIX A_1 = (rq -2)->a;
register AFFIX A_0 = (rq -3)->a;
   char *rc = c; 
   if ( dcontentsof (A_0, A_1, A_2, A_3)) {
      q = rq -5;
      (*(rq -4)->q)(); 
      rq = q +4;
   }
   (rq -3)->a = A_0;
   (rq -2)->a = A_1;
   (rq -1)->a = A_2;
   rq->a = A_3;
   (rq + 1)->q = ucontentsof; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef UCHARNUM 
void ucharnum () 
{ 
   register cont *rq = q;
register AFFIX A_0 = rq->a;
   char *rc = c; 
   if ( dcharnum (A_0)) {
      q = rq -2;
      (*(rq -1)->q)(); 
      rq = q +1;
   }
   rq->a = A_0;
   (rq + 1)->q = ucharnum; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef USETTABSTOP 
void usettabstop () 
{ 
   register cont *rq = q;
register AFFIX A_0 = rq->a;
   char *rc = c; 
   int tabstop_save = tabstop;
   if ( dsettabstop (A_0)) {
      q = rq -2;
      (*(rq -1)->q)(); 
      rq = q +1;
   }
   rq->a = A_0;
   (rq + 1)->q = usettabstop; 
   q = rq + 1; 
   c = rc;
   tabstop= tabstop_save ;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef USOMENAME 
void usomename () 
{ 
   register cont *rq = q;
register AFFIX A_0 = rq->a;
   char *rc = c; 
   if ( dsomename (A_0)) {
      q = rq -2;
      (*(rq -1)->q)(); 
      rq = q +1;
   }
   rq->a = A_0;
   (rq + 1)->q = usomename; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

