/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 * file: builtins.c last modified: Fri May 18 09:57:36 MET DST 1990
 *
 */

#include <ctype.h>
#include <stdio.h>

#define true 1
#define false 0


typedef struct affix_struct {
  char           *t;
  struct affix_struct  *l, *r;
} affix,*AFFIX;

extern AFFIX first_meta,last_meta; 

typedef union {
  void             (*q) ();
  int           *i;
  char           *s;
  char          **l;
  AFFIX   a;
}               cont;


extern affix fla;

extern struct eaglist {
  AFFIX   table;
  AFFIX   key;
  AFFIX   value;
  struct eaglist *left;
  struct eaglist *right;
  struct eaglist *next;
}       initial_l,*root;


extern cont     words[],*q_top;
extern char    *input;
extern char    *cstore,*cstore_top;

extern cont    *q;
extern char *fast_list_acces;
extern char    *ip, *mip, *set_ip_start_pos, *limitip, *undefined, *empty, *c;

extern int      rcount, rmax, set_ip_start_num, cssize;
extern int      parsecount, nrofchars, level, eval_count, emsg_count,
                interesting_level_number, backtrace;
extern char     in_file_name[256], out_file_name[256], current_file_name[256];
extern char    *thischar;
extern FILE    *inputfile,*output;
extern int             set_line_num;
extern int             tabstop;
extern char            *set_line_pos;
extern char            *set_file_name ;
extern char            *inputbuff;
extern int             change_line_file;


extern char *argv[11];

extern AFFIX af;

#define nil NULL
#define ASSIGN(x,tr,lf,rt) (*(x)).t = tr ;(*(x)).l = lf;(*(x)).r = rt
#define COPY(x,y) (x)->t = (y)->t ; (x)->l = (y)->l ; (x)->r = (y)->r
#define SAVE(x,y) x.t = (y)->t ; x.l = (y)->l ; x.r = (y)->r
#define RESTORE(x,y) (x)->t = y.t;  (x)->l = y.l;  (x)->r = y.r
#define SHARE(x,y) (x)->t = empty ; (x)->l = nil ; (x)->r = y
#define MAKE(x,y) if ( (y)->t == undefined) { SHARE(x,y);} else { COPY (x,y); }
#define CONTINUE  q -=1;(*(*(q+1)).q)()



#define GET_CELL_ADDR(cell,str)\
{ register char *d = (char *) & cell;\
   register char *rc = str; \
   if ( (rc[0] == '\001') && (rc[5] == '\001') && (rc[6] == '\000')) {\
   d [0] = rc [1] ; d[1] = rc [2]; d [2] = rc [3];\
      d[3] = rc[4];\
   } else cell = (AFFIX ) -1;\
}
                                

#define PUT_CELL_ADDR(cell)\
 { register char *d = (char *) & cell;\
   register char *rc = c; rc[0] = '\001' ; rc[1] = d [0]; rc [2] = d[1];\
rc [3] = d [2]; rc [4] = d [3]; rc [5] = '\001'; rc [6] = '\0'; c = rc+7;} 
                                
extern AFFIX   afx_top;
extern AFFIX   affix_heap;
extern cont *q_stack; 
extern int  runtime_input_size, abq_level;
extern int ll_mode, ll_count, output_to_stdout, input_from_stdin;
extern int afhsize, q_size;
extern int stack_bottum, report_stacksize;
extern char error_msg[256];
extern int exit_code;
