/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef DTYPEIN
int dtypein(A_0)            /* dumpaffix */
register AFFIX A_0;
{
  AFFIX   _affix = A_0;
  char *rc = c;
  if (feof(stdin))  return false;
  A_0 -> t = rc;
  A_0 -> r = nil;
  A_0 -> l = nil;
  while (!feof(stdin) ) {
      *rc = getc(stdin);
       if (*rc++ == '\n') {
             *(rc-1) = '\0'; 
             c = rc;
  if (rc > cstore_top ) cstore_overflow();
            return true;
       }
  }
  *rc++ = '\0'; 
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return true;
}
#endif

#ifdef DTYPEOUT
int dtypeout(I_0)            /* dumpaffix */
register AFFIX I_0;
{
  AFFIX   _affix = I_0;
  if ((interesting_level_number > level)||(interesting_level_number == -1))
    fprintf(stderr, "%d ", level);
  (void) printa(stderr, _affix);
  return true;
}
#endif

#ifdef DREALTOINT
int drealtoint(I_0,D_1)            /* real to int */
register AFFIX I_0,D_1;
{
  float           real = 0;
  char *expr = c;
  if ((I_0->r == nil) && (I_0->l == nil))
    expr = I_0 -> t;
  else {
    sprinta(I_0);
    *c++ = '\0';
  }
  D_1->t = c;
  D_1->l = nil;
  D_1->r = nil;
  sscanf(expr, "%f", &real);
  (void) sprintf(c, "%d\0", (int) real);
  c += 20;
  return true;
}
#endif

#ifdef DDECIMALTOUN
int ddecimaltounary(I_0,D_1)            /* decimal to unary */
register AFFIX I_0,D_1;
{
  int           dec ;
  char * rc = c;
  if ((I_0->r == nil) && (I_0->l == nil))
    rc = I_0 -> t;
  else {
    sprinta(I_0);
    *c++ = '\0';
  }
  dec = atoi(rc);
 
  D_1->t = rc;
  D_1->l = nil;
  D_1->r = nil;
  for (; dec-- >0 ;)
     *rc++ = '1'; 
  *rc++ ='\0';
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
}

#endif
#ifdef DKEYWORD
int dkeyword(I)
register AFFIX I;
{
  register char  *term, *rip = ip;
  term = I -> t;
  for (; *term != '\0'; rip++) {
    char x = *rip;
    if (islower(x))
      x = toupper(x);
    if (*term++ != x) {
      if (mip < rip) {
        mip = rip;
        change_line_file = true; 
        set_ip_start_pos = set_line_pos;
        set_ip_start_num = set_line_num;
      }
      return false;
    }
  }
  ip = rip;
  if (mip < rip) {
    mip = rip;
    change_line_file = true; 
    set_ip_start_pos = set_line_pos;
    set_ip_start_num = set_line_num;
  }
  return true;
}
#endif

#ifdef DUPPERCASE
int duppercase(I,D)            /* upper case */
register AFFIX I,D;
{
  register char *rs,*rd;
  char *dest;
  if ((I->r == nil) && (I->l == nil))
    rs = I->t;
  else {
    rs = c;
    sprinta(I);
    *c++ = '\0';
  }
  dest = c;
  for (rd = dest; *rs != '\0';) {
    char tc = *rs++;
    if (islower(tc))
      *rd++ = toupper(tc);
    else *rd++ = tc;
  }
  *rd ++ = '\0';
  c = rd;
  D->t = dest;
  D->l = nil;
  D->r = nil;
  return true;
}
#endif

#ifdef DLOWERCASE
int dlowercase(I,D)            /* upper case */
register AFFIX I,D;
{
  register char *rs,*rd;
  char *dest;
  if ((I->r == nil) && (I->l == nil))
    rs = I->t;
  else {
    rs = c;
    sprinta(I);
    *c++ = '\0';
  }
  dest = c;
  for (rd = dest; *rs != '\0';) {
    char tc = *rs++;
    if (isupper(tc))
      *rd++ = tolower(tc);
    else *rd++ = tc;
  }
  *rd ++ = '\0';
  c = rd;
  D->t = dest;
  D->l = nil;
  D->r = nil;
  return true;
}
#endif

