/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef    DDEQUAL
int             ddequal(A, B)         /* lifted equal */
register AFFIX A, B;
{
  register char  *xs = c, *ys;
  if (A == B)
    return true;
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  if (afxcmp(xs, ys) == 0)
    return true;
  return false;
}
#endif

#ifdef         DEQUAL
int             dequal(A, B)         /* lifted not equal */
register AFFIX A, B;
{
  register char *rc = c;
   if  (ddequal(A,B)) {
       c = rc;
  if (rc > cstore_top ) cstore_overflow();
       return true;
   }
   return false;
        
    
}
#endif

#ifdef DNOTEQUAL
int             dnotequal(A, B)         /* lifted not equal */
register AFFIX A, B;
{
  return !dequal(A,B);
}
#endif

#ifdef DDFQUAL
int             ddfqual(A, B)         /* lifted equal */
register AFFIX A, B;
{
  register char  *xs = c, *ys;
  if (A == B)
    return true;
  else if ((A >= first_meta) && (B >= first_meta)  &&
          (A <= last_meta) && (B <= last_meta) )  {
    return false;
  }
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  if (afxcmp(xs, ys) == 0)
    return true;
  return false;
}
#endif

#ifdef   DFQUAL
int             dfqual(A, B)         /* lifted not equal */
register AFFIX A, B;
{
  register char *rc = c;
   if  (ddfqual(A,B)) {
       c = rc;
  if (rc > cstore_top ) cstore_overflow();
       return true;
   }
   return false;
        
    
}
#endif

#ifdef DFOTEQUAL
int             dfotequal(A, B)         /* lifted not equal */
register AFFIX A, B;
{
  return !dfqual(A,B);
}
#endif

#ifdef DCOMPARE
int dcompare(A,B,tailx,taily)              /* compare */
register AFFIX A, B,tailx,taily;
{
    register char  *xs = c, *ys;
    if ((A -> r == nil) && (A -> l == nil))
      xs = A -> t;
    else {
      sprinta(A);
      *c++ = '\0';
    }
    ys = c;
    if ((B -> r == nil) && (B -> l == nil))
      ys = B -> t;
    else {
      sprinta(B);
      *c++ = '\0';
    }
    while ((*xs == *ys++))
      if (*xs++ == '\0') {
        ASSIGN(tailx, empty, nil, nil);
        ASSIGN(taily, empty, nil, nil);
        return true;
      }
    ASSIGN(tailx, xs, nil, nil);
    ASSIGN(taily, --ys, nil, nil);
  return true;
}
#endif

#ifdef ULINENUM
void ulinenum() {
  affix   *D_0 = (q--)->a;
  register char  *rip = set_line_pos;
  int             line = set_line_num;
  int             save_l = line;
  char             *save_p = rip;
  D_0->t = c;
  D_0->l = nil;
  D_0->r = nil;
  while (rip < ip)
    if (*rip++ == '\n')
      line += 1;
  (void)  sprintf(c, "%d\0", line);
  set_line_pos = ip;
  set_line_num = line;
  c += 8;
  q -= 1;
  (*(*(q + 1)).q) ();
  c -= 8;
  set_line_pos = save_p;
  set_line_num = save_l;
  (++q)->a = D_0;
  (++q)->q = ulinenum;
}
#endif

#ifdef DLINENUM
int dlinenum(D_0)
register affix   *D_0;
{
  register char  *rip = set_line_pos;
  int             line = set_line_num;
  D_0->t = c;
  D_0->l = nil;
  D_0->r = nil;
  while (rip < ip)
    if (*rip++ == '\n')
      line += 1;
  (void)  sprintf(c, "%d\0", line);
  set_line_pos = ip;
  set_line_num = line;
  c += 8;
  return true;
}
#endif

